/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import java.io.IOException;
import java.util.Date;
import org.mafait.thinknowlogy.AdminItem;
import org.mafait.thinknowlogy.Console;
import org.mafait.thinknowlogy.CreateAndAssignResultType;
import org.mafait.thinknowlogy.FileItem;
import org.mafait.thinknowlogy.FileResultType;
import org.mafait.thinknowlogy.GeneralizationItem;
import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.GrammarItem;
import org.mafait.thinknowlogy.GrammarResultType;
import org.mafait.thinknowlogy.InputOutput;
import org.mafait.thinknowlogy.JustificationItem;
import org.mafait.thinknowlogy.ReadWordResultType;
import org.mafait.thinknowlogy.SpecificationItem;
import org.mafait.thinknowlogy.WordItem;
import org.mafait.thinknowlogy.WordResultType;

class AdminReadFile {
    private boolean hasClosedFileDueToError_ = false;
    private boolean hasFoundDifferentTestResult_ = false;
    private boolean isDeveloperTheCurrentUser_ = false;
    private boolean isExpertTheCurrentUser_ = false;
    private boolean isPredefinedMultipleWord_ = false;
    private boolean wasLoginCommand_ = false;
    private short testFileNr_ = 0;
    private int firstSentenceNrOfCurrentUser_ = 0;
    long startTime_ = 0L;
    private WordItem currentUserWordItem_ = null;
    private WordItem predefinedAdjectiveBusyWordItem_ = null;
    private WordItem predefinedAdjectiveDoneWordItem_ = null;
    private WordItem predefinedAdjectiveInvertedWordItem_ = null;
    private WordItem predefinedNounDeveloperWordItem_ = null;
    private WordItem predefinedNounExpertWordItem_ = null;
    private WordItem predefinedNounLanguageWordItem_ = null;
    private WordItem predefinedNounPasswordWordItem_ = null;
    private WordItem predefinedNounSolveLevelWordItem_ = null;
    private WordItem predefinedNounSolveMethodWordItem_ = null;
    private WordItem predefinedNounSolveStrategyWordItem_ = null;
    private WordItem predefinedNounStartupLanguageWordItem_ = null;
    private WordItem predefinedNounUserWordItem_ = null;
    private WordItem predefinedVerbLoginWordItem_ = null;
    private String moduleNameString_ = this.getClass().getName();
    private AdminItem adminItem_ = null;

    private void cleanupDeletedItems() {
        int startRemoveSentenceNr = 0;
        if (!this.hasClosedFileDueToError_ && (GlobalVariables.hasDisplayedWarning || GlobalVariables.hasDisplayedIntegrityWarning || GlobalVariables.result != 1)) {
            this.adminItem_.deleteSentences(GlobalVariables.currentSentenceNr);
        }
        do {
            GlobalVariables.nDeletedItems = 0;
            GlobalVariables.removeSentenceNr = 0;
            GlobalVariables.removeStartItemNr = 0;
            this.adminItem_.removeFirstRangeOfDeletedItems();
            if (GlobalVariables.nDeletedItems <= 0) continue;
            this.decrementItemNrRange(GlobalVariables.removeSentenceNr, GlobalVariables.removeStartItemNr, GlobalVariables.nDeletedItems);
            startRemoveSentenceNr = GlobalVariables.removeSentenceNr;
        } while (GlobalVariables.nDeletedItems > 0 && this.firstSentenceNrOfCurrentUser() + 1 != startRemoveSentenceNr);
        if (GlobalVariables.hasDisplayedWarning) {
            GlobalVariables.hasDisplayedWarning = false;
        } else if (startRemoveSentenceNr > 0 && startRemoveSentenceNr != GlobalVariables.removeSentenceNr && this.adminItem_.highestFoundSentenceNr(false, true, startRemoveSentenceNr) < startRemoveSentenceNr) {
            this.adminItem_.decrementSentenceNrs(startRemoveSentenceNr);
            if (this.firstSentenceNrOfCurrentUser() == startRemoveSentenceNr) {
                this.adminItem_.decrementCurrentSentenceNr();
            } else {
                GlobalVariables.currentSentenceNr = this.adminItem_.highestFoundSentenceNr(false, false, GlobalVariables.currentSentenceNr);
                GlobalVariables.currentSentenceItemNr = this.adminItem_.highestCurrentSentenceItemNr();
            }
        }
    }

    private static void clearPredefinedMultipleWordNrInPredefinedWords() {
        WordItem lastPredefinedWordItem = GlobalVariables.lastPredefinedWordItem;
        WordItem currentPredefinedWordItem = GlobalVariables.firstPredefinedWordItem;
        if (currentPredefinedWordItem != null) {
            do {
                currentPredefinedWordItem.predefinedMultipleWordNr = 0;
            } while (currentPredefinedWordItem != lastPredefinedWordItem && (currentPredefinedWordItem = currentPredefinedWordItem.nextWordItem()) != null);
        }
    }

    private void decrementItemNrRange(int decrementSentenceNr, int startDecrementItemNr, int decrementOffset) {
        if (GlobalVariables.currentSentenceNr == decrementSentenceNr && GlobalVariables.currentSentenceItemNr > startDecrementItemNr) {
            GlobalVariables.currentSentenceItemNr -= decrementOffset;
        }
        this.adminItem_.decrementItemNrRange(decrementSentenceNr, startDecrementItemNr, decrementOffset);
    }

    private static boolean hasAnyUserSpecification() {
        WordItem currentSpecificationWordItem = GlobalVariables.firstSpecificationWordItem;
        if (currentSpecificationWordItem != null) {
            do {
                if (!currentSpecificationWordItem.hasAnyUserSpecification() || currentSpecificationWordItem.isAuthorizationRequiredForChanges()) continue;
                return true;
            } while ((currentSpecificationWordItem = currentSpecificationWordItem.nextSpecificationWordItem) != null);
        }
        return false;
    }

    private static boolean isGrammarChar(char grammarChar) {
        return grammarChar == '@' || grammarChar == ':' || grammarChar == '$';
    }

    /*
     * Enabled aggressive block sorting
     */
    private byte addGrammar(String grammarString) {
        ReadWordResultType readWordResult;
        boolean hasCreatedInterface = false;
        boolean hasFoundChoiceAlternatives = false;
        boolean hasFoundOnlyOptions = true;
        boolean hasFoundPipe = false;
        boolean hasGrammarWords = false;
        boolean hasParameter = false;
        boolean hasWordTypeNr = false;
        boolean isChoice = false;
        boolean isChoiceCheck = false;
        boolean isChoiceStart = false;
        boolean isEndOfLine = false;
        boolean isLastPartOfMultipleWord = false;
        boolean isMergedWord = false;
        boolean isMultipleWord = false;
        boolean isNewStart = true;
        boolean isOption = false;
        boolean isOptionCheck = false;
        boolean isOptionStart = false;
        boolean isSkipOptionForWriting = false;
        short grammarParameter = 0;
        short predefinedMultipleWordNr = 0;
        short wordTypeNr = 0;
        int firstCreationItemNr = 0;
        int grammarPosition = 0;
        GrammarItem definitionGrammarItem = null;
        if (grammarString == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given grammar string is undefined");
        }
        int grammarStringLength = grammarString.length();
        if (grammarStringLength == 0) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given grammar string is empty");
        }
        if (this.isPredefinedMultipleWord_) {
            this.isPredefinedMultipleWord_ = false;
            AdminReadFile.clearPredefinedMultipleWordNrInPredefinedWords();
        }
        do {
            readWordResult = this.adminItem_.readWordFromString(true, false, isMergedWord, false, 0, grammarString.substring(grammarPosition));
            if (readWordResult.result != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to read a word from the grammar string");
            }
            boolean hasFoundWordDefinitionInfo = false;
            readWordResult.offset += grammarPosition;
            block0 : switch (grammarString.charAt(grammarPosition)) {
                case '@': {
                    if (hasWordTypeNr) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "I found more than one word type parameters defined in a grammar definition line");
                    }
                    while (true) {
                        if (grammarPosition + 1 >= grammarStringLength || !Character.isDigit(grammarString.charAt(grammarPosition + 1))) {
                            if (hasWordTypeNr) break block0;
                            return this.adminItem_.startError(1, this.moduleNameString_, "I failed to get the word type number from a grammar definition line");
                        }
                        hasWordTypeNr = true;
                        wordTypeNr = (short)(wordTypeNr * 10 + grammarString.charAt(++grammarPosition) - 48);
                    }
                }
                case ':': {
                    if (hasParameter) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "I found more than one values parameters defined in a grammar definition line");
                    }
                    while (true) {
                        if (grammarPosition + 1 >= grammarStringLength || !Character.isDigit(grammarString.charAt(grammarPosition + 1))) {
                            if (hasParameter) break block0;
                            return this.adminItem_.startError(1, this.moduleNameString_, "I failed to get the grammar parameter from a grammar definition line");
                        }
                        hasParameter = true;
                        if ((grammarParameter = (short)((short)(grammarParameter * 10 + grammarString.charAt(++grammarPosition) - 48))) != 3005) continue;
                        isMergedWord = true;
                    }
                }
                case '$': {
                    if (hasCreatedInterface) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "Interface definition and grammar definitions can not be mixed");
                    }
                    if (firstCreationItemNr != 0) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "A grammar definition word must be the first word in the grammar definition");
                    }
                    readWordResult = this.adminItem_.readWordFromString(false, grammarParameter == 3006, isMergedWord, false, 0, grammarString.substring(++grammarPosition));
                    if (readWordResult.result != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to read a word definition from the grammar string");
                    }
                    readWordResult.offset += grammarPosition;
                    GrammarResultType grammarResult = this.adminItem_.findGrammarOfCurrentLanguage(grammarParameter >= 4000, grammarParameter, readWordResult.wordLength, grammarString.substring(grammarPosition));
                    if (grammarResult.result != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to find a grammar definition item");
                    }
                    hasFoundWordDefinitionInfo = true;
                    GrammarItem foundGrammarItem = grammarResult.grammarItem;
                    if (!hasWordTypeNr || foundGrammarItem == null || grammarParameter >= 4000) {
                        grammarResult = this.adminItem_.createGrammarItemForCurrentLanguage(true, hasParameter && grammarParameter < 4000, false, false, false, wordTypeNr, grammarParameter, readWordResult.wordLength, grammarString.substring(grammarPosition), null);
                        if (grammarResult.result != 1) {
                            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a grammar definition word item");
                        }
                        firstCreationItemNr = GlobalVariables.currentSentenceItemNr;
                        definitionGrammarItem = grammarResult.grammarItem;
                        break;
                    }
                    if (InputOutput.writeInterfaceText((short)4, (short)1103, foundGrammarItem.grammarParameter(), (short)1104, this.adminItem_.currentLanguageNameString(), (short)1105) == 1) break;
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write the 'grammar parameter defined more than once' interface notification");
                }
                case '(': {
                    isSkipOptionForWriting = true;
                }
                case '[': {
                    if (hasWordTypeNr && grammarParameter < 4000) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "A grammar definition can not have a value parameter lower than the grammar value");
                    }
                    if (GlobalVariables.currentSentenceItemNr <= 0) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "A grammar definition must start with a grammar definition word");
                    }
                    if (isOption) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "A grammar opion definition can not be nested");
                    }
                    if (hasFoundPipe) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "Pipes with different levels isn't allowed in the grammar definition");
                    }
                    isOption = true;
                    isNewStart = true;
                    isOptionStart = true;
                    isChoiceCheck = isChoice;
                    break;
                }
                case ')': {
                    isSkipOptionForWriting = false;
                }
                case ']': {
                    if (!isOption) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "I found an extra square bracket character in the grammar definition");
                    }
                    if (isChoiceCheck == isChoice) {
                        if (hasFoundPipe) {
                            return this.adminItem_.startError(1, this.moduleNameString_, "I found an extra pipe character before a square bracket in the grammar definition");
                        }
                        isOption = false;
                        isNewStart = true;
                        this.adminItem_.markGrammarOfCurrentLanguageAsOptionEnd();
                        break;
                    }
                    if (isChoice) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "Choices are started within an option");
                    }
                    return this.adminItem_.startError(1, this.moduleNameString_, "Choices are ended within an option");
                }
                case '{': {
                    if (hasWordTypeNr && grammarParameter < 4000) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "A grammar definition can not have a value parameter lower than the grammar value");
                    }
                    if (GlobalVariables.currentSentenceItemNr <= 0) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "A grammar definition must start with a grammar definition word");
                    }
                    if (isChoice) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "Nesting curved brackets isn't allowed");
                    }
                    if (hasFoundPipe) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "Pipes with different levels isn't allowed in the grammar definition");
                    }
                    isChoice = true;
                    isNewStart = true;
                    isChoiceStart = true;
                    isOptionCheck = isOption;
                    break;
                }
                case '}': {
                    if (!isChoice) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "I found an extra curved bracket character in the grammar definition");
                    }
                    if (isOptionCheck == isOption) {
                        if (hasFoundPipe) {
                            return this.adminItem_.startError(1, this.moduleNameString_, "I found an extra pipe character before a curved bracket in the grammar definition");
                        }
                        if (!hasFoundChoiceAlternatives) {
                            return this.adminItem_.startError(1, this.moduleNameString_, "A grammar definition choice must have alternatives");
                        }
                        isChoice = false;
                        isNewStart = true;
                        hasFoundChoiceAlternatives = false;
                        this.adminItem_.markGrammarOfCurrentLanguageAsChoiceEnd();
                        break;
                    }
                    if (isOption) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "An option is started within choices");
                    }
                    return this.adminItem_.startError(1, this.moduleNameString_, "An option is ended within choices");
                }
                case '|': {
                    if (hasWordTypeNr && grammarParameter < 4000) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "A grammar definition can not have a value parameter lower than the grammar value");
                    }
                    if (hasFoundPipe) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "I found an extra pipe character in the grammar definition");
                    }
                    if (!isChoice && !isOption) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "Pipes are only allowed within grammar definition options or choices");
                    }
                    hasFoundPipe = true;
                    if (!isChoice) break;
                    hasFoundChoiceAlternatives = true;
                    break;
                }
                case '\"': {
                    if (!isNewStart || hasGrammarWords || isChoice || isOption) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "Grammar definition and interface definitions can not be mixed");
                    }
                    if (definitionGrammarItem != null) break;
                    if (!hasParameter) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "An interface definition must have a parameter");
                    }
                    if (++grammarPosition >= grammarStringLength || grammarString.charAt(grammarStringLength - 1) != '\"') {
                        return this.adminItem_.startError(1, this.moduleNameString_, "I found a corrupted interface definition");
                    }
                    if (this.adminItem_.checkInterfaceOfCurrentLanguage(grammarParameter, grammarString.substring(grammarPosition)) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add an interface definition word item");
                    }
                    if (this.adminItem_.createInterfaceForCurrentLanguage(grammarParameter, grammarStringLength - grammarPosition - 1, grammarString.substring(grammarPosition)) != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add an interface definition word item");
                    }
                    hasCreatedInterface = true;
                    grammarPosition = grammarStringLength - 1;
                    break;
                }
                default: {
                    GrammarResultType grammarResult;
                    if (hasCreatedInterface) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "Interface definition and grammar definitions can not be mixed");
                    }
                    if (GlobalVariables.currentSentenceItemNr <= 0) {
                        return this.adminItem_.startError(1, this.moduleNameString_, "The first grammar word in a grammar definition is the grammar definition word and must start with a grammar character");
                    }
                    if (hasParameter && grammarParameter < 4000) {
                        if (grammarParameter <= 0) break;
                        if (isMergedWord || grammarParameter == 3004 || grammarParameter == 3000 || grammarParameter == 3001) {
                            if (definitionGrammarItem == null) {
                                return this.adminItem_.startError(1, this.moduleNameString_, "The grammar definition item is undefined");
                            }
                            grammarResult = this.adminItem_.createGrammarItemForCurrentLanguage(false, false, false, false, false, (short)0, grammarParameter, readWordResult.wordLength, grammarString.substring(grammarPosition), definitionGrammarItem);
                            if (grammarResult.result != 1) {
                                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a grammar definition word item");
                            }
                            if (definitionGrammarItem.nextDefinitionGrammarItem != null) {
                                return this.adminItem_.startError(1, this.moduleNameString_, "The next definition grammar item is already defined");
                            }
                            definitionGrammarItem.nextDefinitionGrammarItem = grammarResult.grammarItem;
                            break;
                        }
                        WordItem foundWordItem = null;
                        if (readWordResult.wordLength + grammarPosition < grammarStringLength) {
                            isMultipleWord = true;
                        } else {
                            isEndOfLine = true;
                            if (isMultipleWord) {
                                isLastPartOfMultipleWord = true;
                            }
                            foundWordItem = this.adminItem_.predefinedWordItem(grammarParameter);
                        }
                        if (isLastPartOfMultipleWord || foundWordItem == null) {
                            WordResultType wordResult = this.adminItem_.addWord(false, false, (short)0, (short)0, (short)0, grammarParameter, wordTypeNr, readWordResult.wordLength, grammarString.substring(grammarPosition));
                            if (wordResult.result != 1) {
                                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a grammar word");
                            }
                            WordItem createdWordItem = wordResult.createdWordItem;
                            if (createdWordItem == null) {
                                return this.adminItem_.startError(1, this.moduleNameString_, "I couldn't create a grammar word");
                            }
                            if (isMultipleWord) {
                                this.isPredefinedMultipleWord_ = true;
                                predefinedMultipleWordNr = (short)(predefinedMultipleWordNr + 1);
                                createdWordItem.predefinedMultipleWordNr = createdWordItem.predefinedMultipleWordNr;
                                if (isLastPartOfMultipleWord) {
                                    wordResult = this.addPredefinedMultipleWord(predefinedMultipleWordNr, grammarParameter, wordTypeNr, foundWordItem);
                                    if (wordResult.result != 1) {
                                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a predefined multiple grammar word");
                                    }
                                    createdWordItem = wordResult.createdWordItem;
                                    if (createdWordItem == null) {
                                        return this.adminItem_.startError(1, this.moduleNameString_, "I couldn't create a predefined multiple grammar word");
                                    }
                                }
                            }
                            if (!isEndOfLine || this.setPredefinedWord(grammarParameter, createdWordItem) == 1) break;
                            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to set a predefined word");
                        }
                        if (foundWordItem.addWordType((boolean)false, (boolean)false, (short)(this.adminItem_.isAdjectiveParameter((short)grammarParameter) ? grammarParameter : (short)0), (short)(this.adminItem_.isDefiniteArticleParameter((short)grammarParameter) ? grammarParameter : (short)0), (short)(this.adminItem_.isIndefiniteArticleParameter((short)grammarParameter) ? grammarParameter : (short)0), (short)wordTypeNr, (int)readWordResult.wordLength, (String)grammarString.substring((int)grammarPosition)).result != 1) {
                            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add another word type to grammar word \"" + foundWordItem.anyWordTypeString() + "\"");
                        }
                        if (grammarParameter != 101 || grammarString.charAt(grammarPosition) == '.') break;
                        this.adminItem_.setCurrentLanguageAsChinese();
                        break;
                    }
                    grammarResult = this.adminItem_.findGrammarOfCurrentLanguage(true, (short)0, readWordResult.wordLength, grammarString.substring(grammarPosition));
                    if (grammarResult.result != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to find a grammar definition word item");
                    }
                    GrammarItem foundGrammarItem = grammarResult.grammarItem;
                    if (this.adminItem_.createGrammarItemForCurrentLanguage((boolean)false, (boolean)(!hasFoundPipe && !isNewStart ? false : true), (boolean)isOptionStart, (boolean)isChoiceStart, (boolean)isSkipOptionForWriting, (short)0, (short)0, (int)readWordResult.wordLength, (String)grammarString.substring((int)grammarPosition), (GrammarItem)foundGrammarItem).result != 1) {
                        return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a grammar item");
                    }
                    isNewStart = false;
                    isOptionStart = false;
                    isChoiceStart = false;
                    hasFoundOnlyOptions = false;
                    hasFoundPipe = false;
                    hasGrammarWords = true;
                    if (foundGrammarItem == null || foundGrammarItem.hasCurrentCreationSentenceNr()) break;
                    foundGrammarItem.isGrammarItemInUse = true;
                }
            }
            if (!hasFoundWordDefinitionInfo && !readWordResult.hasFoundGrammarDefinition && readWordResult.offset < grammarStringLength) {
                readWordResult = this.adminItem_.readWordFromString(false, false, false, false, 0, grammarString.substring(grammarPosition));
                if (readWordResult.result != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to read a new word from the grammar string");
                }
                readWordResult.offset += grammarPosition;
            }
            grammarPosition = readWordResult.offset;
        } while (readWordResult.offset < grammarStringLength);
        if (isOption) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The grammar definition option isn't closed");
        }
        if (isChoice) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The grammar definition choice isn't closed");
        }
        if (hasFoundPipe) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The grammar definition ended with an open pipe");
        }
        if (definitionGrammarItem != null) {
            if (hasFoundOnlyOptions && (!hasWordTypeNr || grammarParameter >= 4000)) {
                if (hasGrammarWords) {
                    return this.adminItem_.startError(1, this.moduleNameString_, "The grammar definition only exists of options");
                }
                return this.adminItem_.startError(1, this.moduleNameString_, "The grammar definition only exists of a grammar definition word");
            }
            if (this.adminItem_.checkForDuplicateGrammarDefinitionInCurrentLanguage() != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to check for a duplicate grammar definition");
            }
            if (this.adminItem_.linkLaterDefinedGrammarWordsInCurrentLanguage() != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to link later defined grammar words");
            }
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private WordResultType addPredefinedMultipleWord(short nMultipleWords, short wordParameter, short wordTypeNr, WordItem multipleWordItem) {
        predefinedMultipleWordNr = 0;
        multipleWordStringBuffer = new StringBuffer();
        wordResult = new WordResultType();
        wordResult.createdWordItem = multipleWordItem;
        if (nMultipleWords > 0) ** GOTO lbl14
        return this.adminItem_.startWordResultError(1, this.moduleNameString_, "The given number of multiple words is undefined");
lbl-1000:
        // 1 sources

        {
            foundWordTypeItem = foundMultipleWordItem.activeWordTypeItem(wordTypeNr);
            if (foundWordTypeItem == null) continue;
            if (predefinedMultipleWordNr > 1) {
                multipleWordStringBuffer.append(" ");
            }
            multipleWordStringBuffer.append(foundWordTypeItem.itemString());
lbl14:
            // 3 sources

            ** while (predefinedMultipleWordNr < nMultipleWords && (foundMultipleWordItem = AdminReadFile.predefinedMultipleWordItem((short)(predefinedMultipleWordNr = (short)(predefinedMultipleWordNr + 1)))) != null)
        }
lbl15:
        // 1 sources

        if (multipleWordItem != null) {
            if (multipleWordItem.hasCurrentCreationSentenceNr()) {
                wordResult = this.adminItem_.addWord(false, true, (short)0, (short)0, (short)0, wordParameter, wordTypeNr, multipleWordStringBuffer.length(), multipleWordStringBuffer.toString());
                if (wordResult.result != 1) {
                    return this.adminItem_.addWordResultError(1, this.moduleNameString_, "I failed to add a predefined grammar word");
                }
            } else if (multipleWordItem.addWordType((boolean)true, (boolean)false, (short)0, (short)0, (short)0, (short)wordTypeNr, (int)multipleWordStringBuffer.length(), (String)multipleWordStringBuffer.toString()).result != 1) {
                return this.adminItem_.addWordResultError(1, this.moduleNameString_, "The given multiple word item is undefined");
            }
        }
        if (wordResult.createdWordItem == null) {
            return this.adminItem_.startWordResultError(1, this.moduleNameString_, "The multiple word item is undefined");
        }
        predefinedMultipleWordNr = 0;
        while (predefinedMultipleWordNr < nMultipleWords && (foundMultipleWordItem = AdminReadFile.predefinedMultipleWordItem(predefinedMultipleWordNr = (short)(predefinedMultipleWordNr + 1))) != null) {
            if (foundMultipleWordItem.addMultipleWord(nMultipleWords, wordTypeNr, wordResult.createdWordItem) == 1) continue;
            return this.adminItem_.addWordResultError(1, this.moduleNameString_, "I failed to add a multiple word");
        }
        return wordResult;
    }

    private byte authorizeWord(WordItem authorizationWordItem) {
        if (authorizationWordItem == null) {
            return this.adminItem_.startSystemError(1, this.moduleNameString_, "The given authorization word item is undefined");
        }
        if (!this.adminItem_.isSystemStartingUp()) {
            return this.adminItem_.startError(1, this.moduleNameString_, "You are not authorized to authorize the given word");
        }
        if (authorizationWordItem.assignChangePermissions(this.moduleNameString_) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to assign my authorization permissions to a word");
        }
        return 1;
    }

    private byte closeCurrentFileItem(FileItem closeFileItem) {
        boolean isTestFile = this.adminItem_.isCurrentFileTestFile();
        int testFileSentenceNr = this.adminItem_.currentFileSentenceNr();
        if (this.adminItem_.closeCurrentFile(closeFileItem) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to close a file");
        }
        if (isTestFile) {
            this.adminItem_.deleteSentences(testFileSentenceNr);
        } else if (GlobalVariables.hasDisplayedWarning || GlobalVariables.result != 1) {
            this.hasClosedFileDueToError_ = true;
            GlobalVariables.hasDisplayedWarning = false;
        }
        return 1;
    }

    private byte createLanguageSpecification(WordItem languageNounWordItem) {
        if (languageNounWordItem == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given language noun word item is undefined");
        }
        if (this.addSpecificationWithAuthorization((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (short)0, (short)0, (short)0, (short)5, (short)11, (short)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, null, (WordItem)GlobalVariables.currentLanguageWordItem, (WordItem)languageNounWordItem, null, null).result != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a new language specification");
        }
        return 1;
    }

    private byte createLanguageWord(String languageNameString) {
        WordResultType wordResult = this.findLanguageByName(languageNameString);
        if (wordResult.result != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to find the language");
        }
        if (wordResult.foundWordItem == null) {
            GlobalVariables.currentLanguageNr = (short)(GlobalVariables.currentLanguageNr + 1);
            wordResult = this.adminItem_.addWord(true, false, (short)0, (short)0, (short)0, (short)0, (short)5, languageNameString.length(), languageNameString);
            if (wordResult.result != 1) {
                GlobalVariables.currentLanguageNr = (short)(GlobalVariables.currentLanguageNr - 1);
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a language word");
            }
            WordItem languageWordItem = wordResult.createdWordItem;
            if (languageWordItem == null) {
                return this.adminItem_.startError(1, this.moduleNameString_, "The created language word item is undefined");
            }
            if (this.authorizeWord(languageWordItem) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to authorize the language word");
            }
            GlobalVariables.currentLanguageWordItem = languageWordItem;
        } else {
            GlobalVariables.currentLanguageWordItem = wordResult.foundWordItem;
        }
        return 1;
    }

    private byte executeLine(StringBuffer readStringBuffer) {
        boolean hasSwitchedLanguage = false;
        boolean wasQueryCommand = false;
        if (readStringBuffer == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given read string buffer is undefined");
        }
        if (readStringBuffer.length() > 0 && readStringBuffer.charAt(0) != '#') {
            GlobalVariables.hasDisplayedIntegrityWarning = false;
            GlobalVariables.hasDisplayedMessage = false;
            GlobalVariables.hasDisplayedWarning = false;
            GlobalVariables.isAssignmentChanged = false;
            GlobalVariables.isConflictingQuestion = false;
            if (!this.adminItem_.wasPreviousCommandUndoOrRedo()) {
                this.cleanupDeletedItems();
            }
            this.hasClosedFileDueToError_ = false;
            if (readStringBuffer.charAt(0) == '~') {
                if (Character.isLetter(readStringBuffer.charAt(1))) {
                    if (this.adminItem_.isSystemStartingUp()) {
                        if (this.readGrammarFileAndUserInterfaceFile(readStringBuffer.substring(1)) != 1) {
                            this.adminItem_.addError(1, this.moduleNameString_, "I failed to read the language");
                        }
                    } else if (this.assignLanguage(readStringBuffer.substring(1)) == 1) {
                        hasSwitchedLanguage = true;
                    } else {
                        this.adminItem_.addError(1, this.moduleNameString_, "I failed to assign the language");
                    }
                } else if (readStringBuffer.charAt(0) == '~') {
                    wasQueryCommand = true;
                    if (this.adminItem_.executeQuery((boolean)false, (boolean)true, (boolean)true, (short)8, (int)1, (String)readStringBuffer.toString()).result != 1) {
                        this.adminItem_.addError(1, this.moduleNameString_, "I failed to execute query: \"" + readStringBuffer + "\"");
                    }
                }
            } else {
                if (this.incrementCurrentSentenceNr() != 1) {
                    this.adminItem_.addError(1, this.moduleNameString_, "I failed to increment the current sentence number");
                }
                if (AdminReadFile.isGrammarChar(readStringBuffer.charAt(0))) {
                    if (this.addGrammar(readStringBuffer.toString()) != 1) {
                        this.adminItem_.addError(1, this.moduleNameString_, "I failed to add grammar: \"" + readStringBuffer + "\"");
                    }
                } else if (this.adminItem_.processReadSentence(readStringBuffer) != 1) {
                    this.adminItem_.addError(1, this.moduleNameString_, "I failed to process a read sentence");
                }
            }
            if (GlobalVariables.result != -1 && !this.adminItem_.hasRequestedRestart()) {
                boolean wasUndoOrRedoCommand = this.adminItem_.wasUndoOrRedoCommand();
                if (GlobalVariables.result == 1 && !GlobalVariables.hasDisplayedWarning) {
                    if (this.adminItem_.hasAnyChangeBeenMadeByThisSentence()) {
                        SpecificationItem userSpecificationItem;
                        if (!hasSwitchedLanguage && (wasUndoOrRedoCommand || !GlobalVariables.hasDisplayedMessage && (userSpecificationItem = this.adminItem_.userSpecificationItem()) != null && userSpecificationItem.isTriggeringExecutionOfSelections()) && this.adminItem_.executeSelections() != 1) {
                            this.adminItem_.addError(1, this.moduleNameString_, "I failed to execute selections after reading the sentence");
                        }
                    } else if (!(hasSwitchedLanguage || this.wasLoginCommand_ || GlobalVariables.hasDisplayedMessage || Console.isTestingCanceled() || InputOutput.writeInterfaceText(false, (short)4, (short)1604) == 1)) {
                        this.adminItem_.addError(1, this.moduleNameString_, "I failed to write the 'I know' interface notification");
                    }
                }
                this.adminItem_.clearTemporaryAdminLists();
                if (!wasQueryCommand && !wasUndoOrRedoCommand) {
                    this.cleanupDeletedItems();
                    if (!this.adminItem_.isSystemStartingUp() && (GlobalVariables.currentSentenceItemNr = this.adminItem_.highestCurrentSentenceItemNr()) == 0) {
                        this.adminItem_.decrementCurrentSentenceNr();
                    }
                }
            }
        }
        return 1;
    }

    private byte incrementCurrentSentenceNr() {
        if (GlobalVariables.currentSentenceNr >= Integer.MAX_VALUE) {
            return this.adminItem_.startSystemError(1, this.moduleNameString_, "Sentence number overflow! I can't except anymore input");
        }
        ++GlobalVariables.currentSentenceNr;
        GlobalVariables.currentSentenceItemNr = this.adminItem_.highestCurrentSentenceItemNr();
        return 1;
    }

    private byte readLanguageFile(boolean isGrammarFile, String languageNameString) {
        String defaultSubpathString;
        String string = defaultSubpathString = isGrammarFile ? "data/grammar/" : "data/interface/";
        if (languageNameString == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given language name is undefined");
        }
        FileResultType fileResult = this.adminItem_.openFile(true, false, false, false, defaultSubpathString, languageNameString, null, null);
        if (fileResult.result != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, String.valueOf(isGrammarFile ? "I failed to open the grammar file: \"" : "I failed to open the interface file: \"") + languageNameString + "\"");
        }
        FileItem openedLanguageFileItem = fileResult.createdFileItem;
        if (openedLanguageFileItem != null) {
            if (this.createLanguageWord(languageNameString) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to create language word: \"" + languageNameString + "\"");
            }
            if (this.predefinedNounLanguageWordItem_ != null && this.createLanguageSpecification(this.predefinedNounLanguageWordItem_) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to create a language specification");
            }
            if (this.readAndExecute() != 1) {
                this.adminItem_.addError(1, this.moduleNameString_, "I failed to read and execute the opened language file");
            }
            byte originalResult = GlobalVariables.result;
            if (this.closeCurrentFileItem(openedLanguageFileItem) != 1) {
                this.adminItem_.addError(1, this.moduleNameString_, "I failed to close the language file item");
            }
            if (originalResult != 1) {
                GlobalVariables.result = originalResult;
            }
        } else {
            return this.adminItem_.startError(1, this.moduleNameString_, String.valueOf(isGrammarFile ? "I couldn't open the grammar file: \"" : "I couldn't open the interface file: \"") + languageNameString + "\"");
        }
        return 1;
    }

    private byte readGrammarFileAndUserInterfaceFile(String readLanguageNameString) {
        WordItem currentLanguageWordItem;
        String startupLanguageNameString = this.adminItem_.startupLanguageNameString();
        if (readLanguageNameString == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given read language name string is undefined");
        }
        if (this.readLanguageFile(false, readLanguageNameString) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to read an interface file");
        }
        if (this.readLanguageFile(true, readLanguageNameString) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to read a grammar file");
        }
        if (startupLanguageNameString != null && this.predefinedNounStartupLanguageWordItem_ != null && (currentLanguageWordItem = GlobalVariables.currentLanguageWordItem) != null && startupLanguageNameString.equals(this.adminItem_.currentLanguageNameString())) {
            if (this.addSpecificationWithAuthorization((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (short)0, (short)0, (short)0, (short)11, (short)5, (short)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, null, (WordItem)this.predefinedNounStartupLanguageWordItem_, (WordItem)currentLanguageWordItem, null, null).result != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to add a predefined noun startup language specification");
            }
            if (this.assignSpecificationWithAuthorization((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (short)0, (short)0, (short)0, (short)0, (int)0, (int)0, (int)0, (int)0, null, (WordItem)this.predefinedNounStartupLanguageWordItem_, (WordItem)currentLanguageWordItem, null).result != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to assign the predefined noun startup language word");
            }
        }
        return 1;
    }

    private byte readLine(boolean isClearInputField, boolean isFirstLine, boolean isPassword, boolean isQuestion, int promptSentenceNr, String promptUserNameString, StringBuffer readStringBuffer) {
        StringBuffer promptStringBuffer = new StringBuffer();
        if (promptSentenceNr > 0) {
            promptStringBuffer.append(promptSentenceNr);
        }
        if (promptUserNameString != null) {
            if (promptStringBuffer.length() > 0) {
                promptStringBuffer.append(",");
            }
            promptStringBuffer.append(promptUserNameString);
        }
        if (InputOutput.readLine(isClearInputField, this.isDeveloperTheCurrentUser_, this.adminItem_.isDisplayingLine(), isFirstLine, isPassword, isQuestion, promptStringBuffer.toString(), readStringBuffer, this.adminItem_.currentReadFile()) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to read a line from a file or from input");
        }
        return 1;
    }

    private byte setPredefinedWord(short grammarParameter, WordItem createdWordItem) {
        if (createdWordItem == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The given created word item");
        }
        switch (grammarParameter) {
            case 601: {
                if (this.predefinedAdjectiveBusyWordItem_ == null) {
                    this.predefinedAdjectiveBusyWordItem_ = createdWordItem;
                    break;
                }
                if (this.predefinedAdjectiveBusyWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined busy adjective word");
            }
            case 603: {
                if (this.predefinedAdjectiveDoneWordItem_ == null) {
                    this.predefinedAdjectiveDoneWordItem_ = createdWordItem;
                    break;
                }
                if (this.predefinedAdjectiveDoneWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined done adjective word");
            }
            case 607: {
                if (this.predefinedAdjectiveInvertedWordItem_ == null) {
                    this.predefinedAdjectiveInvertedWordItem_ = createdWordItem;
                    break;
                }
                if (this.predefinedAdjectiveInvertedWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined inverted adjective word");
            }
            case 1100: {
                if (this.predefinedNounDeveloperWordItem_ == null) {
                    this.predefinedNounDeveloperWordItem_ = createdWordItem;
                    if (this.authorizeWord(this.predefinedNounDeveloperWordItem_) == 1) break;
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to authorize the predefined developer noun word");
                }
                if (this.predefinedNounDeveloperWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined developer noun word");
            }
            case 1101: {
                if (this.predefinedNounExpertWordItem_ == null) {
                    this.predefinedNounExpertWordItem_ = createdWordItem;
                    if (this.authorizeWord(this.predefinedNounExpertWordItem_) == 1) break;
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to authorize the predefined expert noun word");
                }
                if (this.predefinedNounExpertWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined expert noun word");
            }
            case 1105: {
                if (this.predefinedNounLanguageWordItem_ != null) break;
                this.predefinedNounLanguageWordItem_ = createdWordItem;
                GlobalVariables.predefinedNounLanguageWordItem = createdWordItem;
                if (this.createLanguageSpecification(createdWordItem) == 1) break;
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to create a language specification");
            }
            case 1108: {
                if (this.predefinedNounPasswordWordItem_ == null) {
                    this.predefinedNounPasswordWordItem_ = createdWordItem;
                    if (this.authorizeWord(this.predefinedNounPasswordWordItem_) == 1) break;
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to authorize the predefined password noun word");
                }
                if (this.predefinedNounPasswordWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined password noun word");
            }
            case 1109: {
                if (this.predefinedNounSolveLevelWordItem_ == null) {
                    this.predefinedNounSolveLevelWordItem_ = createdWordItem;
                    break;
                }
                if (this.predefinedNounSolveLevelWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined solve level noun word");
            }
            case 1110: {
                if (this.predefinedNounSolveMethodWordItem_ == null) {
                    this.predefinedNounSolveMethodWordItem_ = createdWordItem;
                    break;
                }
                if (this.predefinedNounSolveMethodWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined solve method noun word");
            }
            case 1111: {
                if (this.predefinedNounSolveStrategyWordItem_ == null) {
                    this.predefinedNounSolveStrategyWordItem_ = createdWordItem;
                    break;
                }
                if (this.predefinedNounSolveStrategyWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined solve strategy noun word");
            }
            case 1112: {
                if (this.predefinedNounStartupLanguageWordItem_ == null) {
                    this.predefinedNounStartupLanguageWordItem_ = createdWordItem;
                    break;
                }
                if (this.predefinedNounStartupLanguageWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined startup language word");
            }
            case 1115: {
                if (this.predefinedNounUserWordItem_ == null) {
                    this.predefinedNounUserWordItem_ = createdWordItem;
                    GlobalVariables.predefinedNounUserWordItem = createdWordItem;
                    if (this.authorizeWord(this.predefinedNounUserWordItem_) == 1) break;
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to authorize the predefined user noun word");
                }
                if (this.predefinedNounUserWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined user noun word");
            }
            case 2209: {
                if (this.predefinedVerbLoginWordItem_ == null) {
                    this.predefinedVerbLoginWordItem_ = createdWordItem;
                    if (this.authorizeWord(this.predefinedVerbLoginWordItem_) == 1) break;
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to authorize the predefined login verb word");
                }
                if (this.predefinedVerbLoginWordItem_ == createdWordItem) break;
                return this.adminItem_.startError(1, this.moduleNameString_, "I found a different predefined login verb word");
            }
        }
        return 1;
    }

    private WordResultType findLanguageByName(String languageNameString) {
        if (languageNameString != null) {
            return this.adminItem_.findWordTypeInAllWords(true, (short)5, languageNameString.toString(), null);
        }
        return this.adminItem_.startWordResultError(1, this.moduleNameString_, "The given language name string is undefined");
    }

    private static WordItem predefinedMultipleWordItem(short predefinedMultipleWordNr) {
        WordItem currentWordItem;
        if (predefinedMultipleWordNr > 0 && (currentWordItem = GlobalVariables.firstWordItem) != null) {
            do {
                if (currentWordItem.predefinedMultipleWordNr != predefinedMultipleWordNr) continue;
                return currentWordItem;
            } while ((currentWordItem = currentWordItem.nextWordItem()) != null);
        }
        return null;
    }

    protected AdminReadFile(AdminItem adminItem) {
        this.adminItem_ = adminItem;
        if (this.adminItem_ == null) {
            GlobalVariables.result = (byte)-1;
            Console.addError("\nClass:" + this.moduleNameString_ + "\nMethod:\t" + "<init>" + "\nError:\t\tThe given admin item is undefined.\n");
        }
    }

    protected void initializeAdminReadFileVariables() {
        this.wasLoginCommand_ = false;
    }

    protected boolean isDeveloperTheCurrentUser() {
        return this.isDeveloperTheCurrentUser_;
    }

    protected boolean isDeveloperOrExpertTheCurrentUser() {
        return this.isDeveloperTheCurrentUser_ || this.isExpertTheCurrentUser_;
    }

    protected boolean isExpertTheCurrentUser() {
        return this.isExpertTheCurrentUser_;
    }

    protected int firstSentenceNrOfCurrentUser() {
        return this.firstSentenceNrOfCurrentUser_ + 1;
    }

    protected byte assignLanguage(String languageNameString) {
        boolean hasFoundLanguage = false;
        WordResultType wordResult = this.findLanguageByName(languageNameString);
        if (wordResult.result != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to find the language");
        }
        WordItem foundLanguageWordItem = wordResult.foundWordItem;
        if (foundLanguageWordItem != null) {
            hasFoundLanguage = true;
            SpecificationItem languageSpecificationItem = foundLanguageWordItem.bestMatchingSpecificationWordSpecificationItem(false, false, false, (short)0, 0, this.predefinedNounLanguageWordItem_);
            if (languageSpecificationItem != null) {
                GlobalVariables.currentLanguageNr = languageSpecificationItem.languageNr();
            }
            if (GlobalVariables.currentLanguageWordItem != foundLanguageWordItem) {
                if (this.assignSpecificationWithAuthorization((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (short)0, (short)0, (short)0, (short)0, (int)0, (int)0, (int)0, (int)0, null, (WordItem)foundLanguageWordItem, (WordItem)this.predefinedNounLanguageWordItem_, null).result != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to assign the language");
                }
                GlobalVariables.currentLanguageWordItem = foundLanguageWordItem;
            }
            if (!hasFoundLanguage) {
                return this.adminItem_.startError(1, this.moduleNameString_, "The given name isn't a grammar nor an language");
            }
        } else if (!this.adminItem_.isSystemStartingUp()) {
            return this.adminItem_.startError(1, this.moduleNameString_, "I couldn't find the requested language");
        }
        return 1;
    }

    protected byte compareOutputFileAgainstReferenceFile(String testFileNameString) {
        boolean isStop = false;
        int lineNr = 0;
        String outputString = null;
        String referenceString = null;
        this.hasFoundDifferentTestResult_ = false;
        FileResultType fileResult = this.adminItem_.openFile(true, false, false, true, "data/regression/output/", testFileNameString, null, "data/regression/reference/");
        if (fileResult.result != 1) {
            return this.adminItem_.startError(1, this.moduleNameString_, "I failed to open a test file");
        }
        if (fileResult.outputFile == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The output file is undefined");
        }
        if (fileResult.referenceFile == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The reference file is undefined");
        }
        do {
            isStop = true;
            this.hasFoundDifferentTestResult_ = true;
            try {
                outputString = fileResult.outputFile.readLine();
                referenceString = fileResult.referenceFile.readLine();
            }
            catch (IOException exception) {
                return this.adminItem_.startError(1, this.moduleNameString_, "IOException: I couldn't read from the output file or the reference file");
            }
            if (outputString != null && referenceString != null) {
                if (!outputString.equals(referenceString)) {
                    return this.adminItem_.startError(1, this.moduleNameString_, "Line number " + lineNr + " is different:\n* test result:\t\t\"" + outputString + "\"\n* against reference:\t\"" + referenceString + "\"");
                }
                isStop = false;
                ++lineNr;
                continue;
            }
            if (outputString != null) {
                return this.adminItem_.startError(1, this.moduleNameString_, "The output file is longer than the reference file");
            }
            if (referenceString != null) {
                return this.adminItem_.startError(1, this.moduleNameString_, "The output file is shorter than the reference file");
            }
            this.hasFoundDifferentTestResult_ = false;
        } while (!isStop);
        try {
            if (fileResult.outputFile != null) {
                fileResult.outputFile.close();
            }
            if (fileResult.referenceFile != null) {
                fileResult.referenceFile.close();
            }
        }
        catch (IOException exception) {
            return this.adminItem_.startError(1, this.moduleNameString_, "IOException: I couldn't close the output file or the reference file");
        }
        return 1;
    }

    protected byte login(WordItem specificationWordItem) {
        WordItem currentGeneralizationWordItem;
        GeneralizationItem currentGeneralizationItem;
        boolean isAlreadyLoggedInAsGivenUser = false;
        boolean isCorrectPassword = false;
        boolean isNoPasswordRequired = false;
        SpecificationItem passwordAssignmentItem = null;
        WordItem foundUserWordItem = null;
        StringBuffer readPasswordStringBuffer = new StringBuffer();
        StringBuffer readUserNameStringBuffer = new StringBuffer();
        this.wasLoginCommand_ = false;
        if (this.predefinedNounPasswordWordItem_ == null) {
            return this.adminItem_.startSystemError(1, this.moduleNameString_, "The predefined password noun word item is undefined");
        }
        if (this.predefinedNounUserWordItem_ == null) {
            return this.adminItem_.startSystemError(1, this.moduleNameString_, "The predefined user noun word item is undefined");
        }
        if (specificationWordItem == null && (currentGeneralizationItem = this.predefinedNounPasswordWordItem_.firstSpecificationGeneralizationItem(true)) != null) {
            do {
                if ((currentGeneralizationWordItem = currentGeneralizationItem.generalizationWordItem()) == null) {
                    return this.adminItem_.startSystemError(1, this.moduleNameString_, "I found an undefined generalization word");
                }
                if (currentGeneralizationWordItem.activeWordTypeItem(false, (short)5) == null) continue;
                specificationWordItem = currentGeneralizationWordItem;
            } while (specificationWordItem == null && (currentGeneralizationItem = currentGeneralizationItem.nextSpecificationGeneralizationItem()) != null);
        }
        if (specificationWordItem == null) {
            if (this.readLine(true, false, false, true, 0, this.predefinedNounUserWordItem_.singularNounString(), readUserNameStringBuffer) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to read to user name");
            }
        } else {
            readUserNameStringBuffer.append(specificationWordItem.anyWordTypeString());
        }
        if (readUserNameStringBuffer.length() > 0 && (currentGeneralizationItem = this.predefinedNounUserWordItem_.firstSpecificationGeneralizationItem(false)) != null) {
            do {
                if ((currentGeneralizationWordItem = currentGeneralizationItem.generalizationWordItem()) == null) {
                    return this.adminItem_.startSystemError(1, this.moduleNameString_, "I found an undefined generalization word");
                }
                WordResultType wordResult = currentGeneralizationWordItem.findWordType(true, (short)5, readUserNameStringBuffer.toString());
                if (wordResult.result != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to find the user name");
                }
                if (wordResult.foundWordTypeItem == null) continue;
                foundUserWordItem = currentGeneralizationWordItem;
            } while (foundUserWordItem == null && (currentGeneralizationItem = currentGeneralizationItem.nextSpecificationGeneralizationItem()) != null);
        }
        if (foundUserWordItem != null && foundUserWordItem == this.currentUserWordItem_) {
            if (InputOutput.writeInterfaceText(false, (short)4, (short)1004, readUserNameStringBuffer.toString(), (short)1005) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write the 'already logged in' interface notification");
            }
            isAlreadyLoggedInAsGivenUser = true;
        } else {
            if (foundUserWordItem != null && (passwordAssignmentItem = this.predefinedNounPasswordWordItem_.firstNonPossessiveActiveAssignmentItem(foundUserWordItem)) == null) {
                if (foundUserWordItem.bestMatchingSpecificationWordSpecificationItem(false, false, false, false, true, true, 0, 0, 0, this.predefinedNounPasswordWordItem_) != null) {
                    isNoPasswordRequired = true;
                }
            } else {
                if (this.readLine(true, false, true, true, 0, this.predefinedNounPasswordWordItem_.singularNounString(), readPasswordStringBuffer) != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to read to password");
                }
                if (passwordAssignmentItem != null) {
                    WordItem passwordSpecificationWordItem = passwordAssignmentItem.specificationWordItem();
                    if (passwordSpecificationWordItem == null) {
                        return this.adminItem_.startSystemError(1, this.moduleNameString_, "The password assignment specification item is undefined");
                    }
                    if (passwordSpecificationWordItem.isCorrectHiddenWordType(passwordAssignmentItem.specificationWordTypeNr(), readPasswordStringBuffer.toString(), this.moduleNameString_)) {
                        isCorrectPassword = true;
                    }
                }
            }
            if ((isCorrectPassword || isNoPasswordRequired) && foundUserWordItem != null) {
                if (this.assignSpecificationWithAuthorization((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (short)0, (short)0, (short)0, (short)0, (int)0, (int)0, (int)0, (int)0, null, (WordItem)foundUserWordItem, (WordItem)this.predefinedNounUserWordItem_, null).result != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to assign the user");
                }
                this.firstSentenceNrOfCurrentUser_ = GlobalVariables.currentSentenceNr;
                this.currentUserWordItem_ = foundUserWordItem;
                GlobalVariables.currentUserNr = this.predefinedNounUserWordItem_.userNr(foundUserWordItem);
                this.isDeveloperTheCurrentUser_ = this.predefinedNounDeveloperWordItem_ != null && foundUserWordItem.bestMatchingSpecificationWordSpecificationItem(false, false, false, (short)0, 0, this.predefinedNounDeveloperWordItem_) != null;
                boolean bl = this.isExpertTheCurrentUser_ = this.predefinedNounExpertWordItem_ != null && foundUserWordItem.bestMatchingSpecificationWordSpecificationItem(false, false, false, (short)0, 0, this.predefinedNounExpertWordItem_) != null;
                if (this.isExpertTheCurrentUser_ && InputOutput.writeInterfaceText(false, (short)4, (short)1007) != 1) {
                    return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write the welcome message for experts");
                }
            }
        }
        if ((isAlreadyLoggedInAsGivenUser || isCorrectPassword || isNoPasswordRequired) && foundUserWordItem != null) {
            this.wasLoginCommand_ = true;
        } else if (InputOutput.writeInterfaceText(false, (short)4, (short)1006) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write the 'login failed' interface notification");
        }
        return 1;
    }

    protected byte readAndExecute() {
        boolean isLineExecuted;
        boolean isFirstLine = true;
        StringBuffer readStringBuffer = new StringBuffer();
        this.hasFoundDifferentTestResult_ = false;
        do {
            isLineExecuted = false;
            if (this.readLine(false, isFirstLine, false, false, GlobalVariables.currentSentenceNr + 1, this.currentUserWordItem_ != null ? this.currentUserWordItem_.anyWordTypeString() : null, readStringBuffer = new StringBuffer()) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to read a line");
            }
            if (!InputOutput.hasReadLine()) continue;
            if (this.executeLine(readStringBuffer) != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to execute the read line");
            }
            isFirstLine = false;
            isLineExecuted = true;
        } while (isLineExecuted && !this.hasFoundDifferentTestResult_ && !this.adminItem_.hasRequestedRestart() && !Console.isTestingCanceled() && (this.adminItem_.isCurrentlyTesting() || !GlobalVariables.hasDisplayedWarning));
        if (this.adminItem_.isSystemStartingUp() && GlobalVariables.hasDisplayedWarning) {
            GlobalVariables.result = (byte)-1;
        }
        return 1;
    }

    protected byte readExampleFile(String exampleFileNameString) {
        if (exampleFileNameString != null) {
            FileResultType fileResult = this.adminItem_.openFile(!this.adminItem_.isSystemStartingUp(), false, false, true, "data/examples/", exampleFileNameString, null, null);
            if (fileResult.result != 1) {
                return this.adminItem_.addError(1, this.moduleNameString_, "I failed to open an example file");
            }
            FileItem openedExampleFileItem = fileResult.createdFileItem;
            if (openedExampleFileItem != null) {
                if (this.readAndExecute() != 1) {
                    this.adminItem_.addError(1, this.moduleNameString_, "I failed to read and execute the opened example file");
                }
                byte originalResult = GlobalVariables.result;
                if (this.closeCurrentFileItem(openedExampleFileItem) != 1) {
                    this.adminItem_.addError(1, this.moduleNameString_, "I failed to close the example file item");
                }
                if (originalResult != 1) {
                    GlobalVariables.result = originalResult;
                }
            }
        } else if (InputOutput.writeInterfaceText(false, (short)5, (short)1215) != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write an interface warning");
        }
        return 1;
    }

    protected byte readStartupFile() {
        FileResultType fileResult = this.adminItem_.openFile(true, false, false, true, "data/startup/", "startup", null, null);
        if (fileResult.result != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to open an startup file");
        }
        FileItem openedStartupFileItem = fileResult.createdFileItem;
        if (openedStartupFileItem != null) {
            if (this.readAndExecute() != 1) {
                this.adminItem_.addError(1, this.moduleNameString_, "I failed to read and execute the opened startup file");
            }
            byte originalResult = GlobalVariables.result;
            if (this.closeCurrentFileItem(openedStartupFileItem) != 1) {
                this.adminItem_.addError(1, this.moduleNameString_, "I failed to close the startup file item");
            }
            if (originalResult != 1) {
                GlobalVariables.result = originalResult;
            }
        }
        return 1;
    }

    protected byte readTestFile(String testFileNameString) {
        long totalTime;
        byte originalResult;
        boolean isFirstTestFile;
        boolean bl = isFirstTestFile = this.isDeveloperTheCurrentUser_ && !this.adminItem_.isCurrentlyTesting() && (this.adminItem_.currentFileSentenceNr() == 0 || this.adminItem_.currentFileSentenceNr() == GlobalVariables.currentSentenceNr);
        if (AdminReadFile.hasAnyUserSpecification()) {
            return this.adminItem_.startError(1, this.moduleNameString_, "Some knowledge is already entered. It may disturb the test results. Please, use restart button before testing to ensure no knowledge is present");
        }
        if (isFirstTestFile) {
            this.testFileNr_ = 0;
            this.startTime_ = new Date().getTime();
        } else {
            this.testFileNr_ = (short)(this.testFileNr_ + 1);
        }
        FileResultType fileResult = this.adminItem_.openFile(true, false, true, true, "data/examples/", testFileNameString, "data/regression/output/", null);
        if (fileResult.result != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to open a test file");
        }
        FileItem testFileItem = fileResult.createdFileItem;
        if (testFileItem == null) {
            return this.adminItem_.startError(1, this.moduleNameString_, "The last created file item is undefined");
        }
        if (InputOutput.writeText(true, true, (short)4, 0, "Test file #" + this.testFileNr_ + ": " + testFileItem.readFileNameString() + "\n") != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write a text");
        }
        InputOutput.redirectOutputToTestFile(testFileItem.writeFile());
        if (this.readAndExecute() != 1) {
            this.adminItem_.addError(1, this.moduleNameString_, "I failed to read and execute the opened test file");
        }
        if ((originalResult = GlobalVariables.result) != 1) {
            GlobalVariables.result = 1;
        }
        if (this.closeCurrentFileItem(testFileItem) != 1) {
            this.adminItem_.addError(1, this.moduleNameString_, "I failed to close the test file item");
        }
        if (originalResult != 1) {
            GlobalVariables.result = originalResult;
        } else if (isFirstTestFile && !Console.isTestingCanceled() && InputOutput.writeText(true, true, (short)4, 0, "Done in: " + String.format("%.1f", (double)(totalTime = new Date().getTime() - this.startTime_) / 1000.0) + " sec.") != 1) {
            return this.adminItem_.addError(1, this.moduleNameString_, "I failed to write the test statistics text");
        }
        return 1;
    }

    protected WordItem predefinedAdjectiveBusyWordItem() {
        return this.predefinedAdjectiveBusyWordItem_;
    }

    protected WordItem predefinedAdjectiveDoneWordItem() {
        return this.predefinedAdjectiveDoneWordItem_;
    }

    protected WordItem predefinedAdjectiveInvertedWordItem() {
        return this.predefinedAdjectiveInvertedWordItem_;
    }

    protected WordItem predefinedNounSolveLevelWordItem() {
        return this.predefinedNounSolveLevelWordItem_;
    }

    protected WordItem predefinedNounSolveMethodWordItem() {
        return this.predefinedNounSolveMethodWordItem_;
    }

    protected WordItem predefinedNounSolveStrategyWordItem() {
        return this.predefinedNounSolveStrategyWordItem_;
    }

    protected CreateAndAssignResultType addSpecificationWithAuthorization(boolean isAssignment, boolean isCharacteristicFor, boolean isConditional, boolean isInactiveAssignment, boolean isArchivedAssignment, boolean isEveryGeneralization, boolean isExclusiveSpecification, boolean isNegative, boolean isPartOf, boolean isPossessive, boolean isSelection, boolean isSpecific, boolean isSpecificationGeneralization, boolean isUncountableGeneralizationNoun, boolean isUniqueUserRelation, boolean isValueSpecification, short assumptionLevel, short prepositionParameter, short questionParameter, short generalizationWordTypeNr, short specificationWordTypeNr, short relationWordTypeNr, int specificationCollectionNr, int generalizationContextNr, int specificationContextNr, int relationContextNr, int copiedRelationContextNr, int nContextRelations, JustificationItem firstJustificationItem, WordItem generalizationWordItem, WordItem specificationWordItem, WordItem relationWordItem, String specificationString) {
        if (generalizationWordItem == null) {
            return this.adminItem_.startCreateAndAssignResultError(1, this.moduleNameString_, "The given generalization word item is undefined");
        }
        if (specificationWordItem == null) {
            return this.adminItem_.startCreateAndAssignResultError(1, this.moduleNameString_, "The given specification word item is undefined");
        }
        if (generalizationWordItem.isNounPassword() && specificationWordItem.hideWordType(specificationWordTypeNr, this.moduleNameString_) != 1) {
            return this.adminItem_.addCreateAndAssignResultError(1, this.moduleNameString_, "I failed to hide a password");
        }
        CreateAndAssignResultType createAndAssignResult = generalizationWordItem.addSpecificationInWord(isAssignment, isInactiveAssignment, isArchivedAssignment, isCharacteristicFor, isConditional, isEveryGeneralization, true, isExclusiveSpecification, isNegative, isPartOf, isPossessive, isSelection, isSpecific, isSpecificationGeneralization, isUncountableGeneralizationNoun, isUniqueUserRelation, isValueSpecification, assumptionLevel, prepositionParameter, questionParameter, generalizationWordTypeNr, specificationWordTypeNr, relationWordTypeNr, specificationCollectionNr, generalizationContextNr, specificationContextNr, relationContextNr, copiedRelationContextNr, nContextRelations, firstJustificationItem, specificationWordItem, relationWordItem, specificationString, this.moduleNameString_);
        if (createAndAssignResult.result != 1) {
            return this.adminItem_.addCreateAndAssignResultError(1, this.moduleNameString_, "I failed to add a specification with authorization");
        }
        if (this.adminItem_.collectGeneralizationWordWithPreviousOne(isAssignment, isPossessive, generalizationWordTypeNr, specificationWordTypeNr, relationContextNr, generalizationWordItem, specificationWordItem) != 1) {
            return this.adminItem_.addCreateAndAssignResultError(1, this.moduleNameString_, "I failed to collect a generalization word with a previous one");
        }
        return createAndAssignResult;
    }

    protected CreateAndAssignResultType assignSpecificationWithAuthorization(boolean isAmbiguousRelationContext, boolean isAssignedOrClear, boolean isInactiveAssignment, boolean isArchivedAssignment, boolean isNegative, boolean isPossessive, boolean isSpecificationGeneralization, boolean isUniqueUserRelation, short assumptionLevel, short prepositionParameter, short questionParameter, short relationWordTypeNr, int generalizationContextNr, int specificationContextNr, int relationContextNr, int nContextRelations, JustificationItem firstJustificationItem, WordItem generalizationWordItem, WordItem specificationWordItem, String specificationString) {
        if (generalizationWordItem == null) {
            return this.adminItem_.startCreateAndAssignResultError(1, this.moduleNameString_, "The given generalization word item is undefined");
        }
        return generalizationWordItem.assignSpecification(isAmbiguousRelationContext, isAssignedOrClear, isInactiveAssignment, isArchivedAssignment, isNegative, isPossessive, isSpecificationGeneralization, isUniqueUserRelation, assumptionLevel, prepositionParameter, questionParameter, relationWordTypeNr, generalizationContextNr, specificationContextNr, relationContextNr, nContextRelations, firstJustificationItem, specificationWordItem, specificationString, this.moduleNameString_);
    }

    protected FileResultType readInfoFile(boolean isReportingErrorIfFileDoesNotExist, String infoFileNameString) {
        StringBuffer infoPathStringBuffer = new StringBuffer("data/info/");
        if (infoFileNameString == null) {
            return this.adminItem_.startFileResultError(1, this.moduleNameString_, "The given info file name string is undefined");
        }
        infoPathStringBuffer.append(String.valueOf(this.adminItem_.currentLanguageNameString()) + '/');
        FileResultType fileResult = this.adminItem_.openFile(true, true, false, isReportingErrorIfFileDoesNotExist, infoPathStringBuffer.toString(), infoFileNameString, null, null);
        if (fileResult.result != 1) {
            return this.adminItem_.addFileResultError(1, this.moduleNameString_, "I failed to open the info file");
        }
        FileItem openedInfoFileItem = fileResult.createdFileItem;
        if (openedInfoFileItem != null) {
            if (this.readAndExecute() != 1) {
                this.adminItem_.addError(1, this.moduleNameString_, "I failed to read and execute the opened info file");
            }
            byte originalResult = GlobalVariables.result;
            if (this.closeCurrentFileItem(openedInfoFileItem) != 1) {
                this.adminItem_.addError(1, this.moduleNameString_, "I failed to close the info file item");
            }
            if (originalResult != 1) {
                GlobalVariables.result = originalResult;
            }
        }
        return fileResult;
    }
}

