/*
 * Decompiled with CFR 0.152.
 */
package org.mafait.thinknowlogy;

import org.mafait.thinknowlogy.GlobalVariables;
import org.mafait.thinknowlogy.List;
import org.mafait.thinknowlogy.WordItem;
import org.mafait.thinknowlogy.WordResultType;

class WordList
extends List {
    private WordItem firstActiveWordItem() {
        return (WordItem)this.firstActiveItem();
    }

    protected WordList(WordItem myWordItem) {
        this.initializeListVariables('W', "WordList", myWordItem);
    }

    protected void decrementItemNrRangeInWordList(int decrementSentenceNr, int decrementItemNr, int decrementOffset) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (searchWordItem.highestSentenceNrInWord() >= decrementSentenceNr && searchWordItem.decrementItemNrRangeInWord(decrementSentenceNr, decrementItemNr, decrementOffset) != 1) {
                this.addError(1, "I failed to decrement item numbers in a word");
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
    }

    protected void decrementSentenceNrsInWordList(int startSentenceNr) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (searchWordItem.highestSentenceNrInWord() >= startSentenceNr && searchWordItem.decrementSentenceNrsInWord(startSentenceNr) != 1) {
                this.addError(1, "I failed to decrement the sentence numbers from the current sentence number in a word");
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
    }

    protected void deleteSentencesInWordList(int lowestSentenceNr) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (searchWordItem.highestSentenceNrInWord() >= lowestSentenceNr && searchWordItem.deleteSentencesInWord(lowestSentenceNr) != 1) {
                this.addError(1, "I failed to delete sentences in a word");
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
    }

    protected void removeFirstRangeOfDeletedItemsInWordList() {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null && GlobalVariables.nDeletedItems == 0) {
            if (searchWordItem.removeFirstRangeOfDeletedItemsInWord() != 1) {
                this.addError(1, "I failed to remove the first deleted items in a word");
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
    }

    protected int highestCurrentSentenceItemNrInWordList(int currentSentenceNr, int currentSentenceItemNr) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (searchWordItem.highestSentenceNrInWord() >= currentSentenceNr) {
                currentSentenceItemNr = searchWordItem.highestCurrentSentenceItemNrInWord(currentSentenceNr, currentSentenceItemNr);
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
        return currentSentenceItemNr;
    }

    protected int highestFoundSentenceNrInWordList(boolean isIncludingDeletedItems, boolean isIncludingTemporaryLists, int maxSentenceNr) {
        int highestFoundSentenceNr = 0;
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null && highestFoundSentenceNr < maxSentenceNr) {
            if (searchWordItem.highestSentenceNrInWord() > highestFoundSentenceNr) {
                highestFoundSentenceNr = searchWordItem.highestFoundSentenceNrInWord(isIncludingDeletedItems, isIncludingTemporaryLists, highestFoundSentenceNr, maxSentenceNr);
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
        return highestFoundSentenceNr;
    }

    protected byte redoCurrentSentenceInWordList() {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (searchWordItem.redoCurrentSentenceInWord() != 1) {
                return this.addError(1, "I failed to redo the current sentence in a word");
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
        return 1;
    }

    protected byte undoCurrentSentenceInWordList() {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (searchWordItem.undoCurrentSentenceInWord() != 1) {
                return this.addError(1, "I failed to undo the current sentence in a word");
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
        return 1;
    }

    protected void countQueryInWordList() {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            searchWordItem.countQuery();
            searchWordItem = searchWordItem.nextWordItem();
        }
    }

    protected void clearQuerySelectionsInWordList() {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            searchWordItem.clearQuerySelections();
            searchWordItem = searchWordItem.nextWordItem();
        }
    }

    protected void itemQueryInWordList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, boolean isReferenceQuery, int querySentenceNr, int queryItemNr) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            searchWordItem.itemQueryInWord(isSelectingOnFind, isSelectingActiveItems, isSelectingInactiveItems, isSelectingArchivedItems, isSelectingReplacedItems, isReferenceQuery, querySentenceNr, queryItemNr);
            searchWordItem = searchWordItem.nextWordItem();
        }
    }

    protected void listQueryInWordList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, StringBuffer queryListStringBuffer) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            searchWordItem.listQueryInWord(isSelectingOnFind, isSelectingActiveItems, isSelectingInactiveItems, isSelectingArchivedItems, isSelectingReplacedItems, queryListStringBuffer);
            searchWordItem = searchWordItem.nextWordItem();
        }
    }

    protected void parameterQueryInWordList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, int queryParameter) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (isSelectingOnFind && searchWordItem.hasParameter(queryParameter)) {
                searchWordItem.isSelectedByQuery = true;
            }
            searchWordItem.parameterQueryInWord(isSelectingOnFind, isSelectingActiveItems, isSelectingInactiveItems, isSelectingArchivedItems, isSelectingReplacedItems, queryParameter);
            searchWordItem = searchWordItem.nextWordItem();
        }
    }

    protected void wordTypeQueryInWordList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, short queryWordTypeNr) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            searchWordItem.wordTypeQueryInWord(isSelectingOnFind, isSelectingActiveItems, isSelectingInactiveItems, isSelectingArchivedItems, isSelectingReplacedItems, queryWordTypeNr);
            searchWordItem = searchWordItem.nextWordItem();
        }
    }

    protected byte displayQueryResultInWordList(boolean isOnlyDisplayingWords, boolean isOnlyDisplayingWordReferences, boolean isOnlyDisplayingStrings, boolean isReturnQueryToPosition, short promptTypeNr, short queryWordTypeNr, int queryWidth) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (searchWordItem.displayQueryResultInWord(isOnlyDisplayingWords, isOnlyDisplayingWordReferences, isOnlyDisplayingStrings, isReturnQueryToPosition, promptTypeNr, queryWordTypeNr, queryWidth) != 1) {
                return this.addError(1, "I failed to display the query result in a word");
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
        return 1;
    }

    protected byte stringQueryInWordList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, String queryString) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (searchWordItem.stringQueryInWord(isSelectingOnFind, isSelectingActiveItems, isSelectingInactiveItems, isSelectingArchivedItems, isSelectingReplacedItems, queryString) != 1) {
                return this.addError(1, "I failed to query strings in a word");
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
        return 1;
    }

    protected byte wordQueryInWordList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, String wordNameString) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (searchWordItem.wordQueryInWord(isSelectingOnFind, isSelectingActiveItems, isSelectingInactiveItems, isSelectingArchivedItems, isSelectingReplacedItems, wordNameString) != 1) {
                return this.addError(1, "I failed to query a word");
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
        return 1;
    }

    protected byte wordReferenceQueryInWordList(boolean isSelectingOnFind, boolean isSelectingActiveItems, boolean isSelectingInactiveItems, boolean isSelectingArchivedItems, boolean isSelectingReplacedItems, boolean isSelectingAttachedJustifications, boolean isSelectingJustificationSpecifications, String wordReferenceNameString) {
        WordItem searchWordItem = this.firstActiveWordItem();
        while (searchWordItem != null) {
            if (searchWordItem.wordReferenceQueryInWord(isSelectingOnFind, isSelectingActiveItems, isSelectingInactiveItems, isSelectingArchivedItems, isSelectingReplacedItems, isSelectingAttachedJustifications, isSelectingJustificationSpecifications, wordReferenceNameString) != 1) {
                return this.addError(1, "I failed to query word references in a word");
            }
            searchWordItem = searchWordItem.nextWordItem();
        }
        return 1;
    }

    protected WordResultType createWordItem(boolean isLanguageWord, short wordParameter) {
        WordResultType wordResult = new WordResultType();
        wordResult.createdWordItem = new WordItem(isLanguageWord, wordParameter, this);
        if (wordResult.createdWordItem == null) {
            return this.startWordResultError(1, "I failed to create a word item");
        }
        if (this.addItemToList('+', wordResult.createdWordItem) != 1) {
            return this.addWordResultError(1, "I failed to add an active word item");
        }
        return wordResult;
    }
}

