﻿/*	Class:			Constants
 *	Purpose:		Header file to define constants
 *	Version:		Thinknowlogy 2018r4 (New Science)
 *************************************************************************/
/*	Copyright (C) 2009-2018, Menno Mafait. Your suggestions, modifications,
 *	corrections and bug reports are welcome at http://mafait.org/contact/
 *************************************************************************/
/*	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License along
 *	with this program; if not, write to the Free Software Foundation, Inc.,
 *	51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *************************************************************************/

#ifndef CONSTANTS
#define CONSTANTS 1

// Constants header

	// Version constants
	#define PRODUCT_NAME												"Thinknowlogy"
	#define VERSION_NAME												"2018r4 (New Science)"

	// File constants
	#define	FILE_DATA_EXAMPLES_DIRECTORY_NAME_STRING					"data/examples/"
	#define	FILE_DATA_GRAMMAR_DIRECTORY_NAME_STRING						"data/grammar/"
	#define	FILE_DATA_INFO_DIRECTORY_NAME_STRING						"data/info/"
	#define	FILE_DATA_INTERFACE_DIRECTORY_NAME_STRING					"data/interface/"
	#define	FILE_DATA_STARTUP_DIRECTORY_NAME_STRING						"data/startup/"
	#define	FILE_DATA_REGRESSION_TEST_OUTPUT_DIRECTORY_NAME_STRING		"data/regression/output/"
	#define	FILE_DATA_REGRESSION_TEST_REFERENCE_DIRECTORY_NAME_STRING	"data/regression/reference/"

	#define	FILE_STARTUP_NAME_STRING									"startup"
	#define	FILE_EXTENSION_STRING										".txt"
	#define	FILE_ATTRIBUTES_READ_TEXT_UTF_8								"rt+, ccs=UTF-8"
	#define	FILE_ATTRIBUTES_WRITE_TEXT_UTF_8							"wt+, ccs=UTF-8"
	#define	FILE_UTF_8_BOM_LENGTH										3
	#define	FILE_UTF_8_BOM_CHAR_1										0xFFEF
	#define	FILE_UTF_8_BOM_CHAR_2										0xFFBB
	#define	FILE_UTF_8_BOM_CHAR_3										0xFFBF

	// Initialization constants
	#define	NO_ASSIGNMENT_LEVEL											0
	#define	NO_ASSUMPTION_LEVEL											0
	#define	NO_GRAMMAR_LEVEL											0
	#define	NO_SELECTION_LEVEL											0
	#define	NO_SOLVE_LEVEL												0
	#define	NO_WRITE_LEVEL												0
	#define	NO_LANGUAGE_NR												0
	#define	NO_ORDER_NR													0
	#define	NO_USER_NR													0

	#define	NO_ADJECTIVE_PARAMETER										0
	#define	NO_ANSWER_PARAMETER											0
	#define	NO_ASSIGNMENT_PARAMETER										0
	#define	NO_DEFINITE_ARTICLE_PARAMETER								0
	#define	NO_GRAMMAR_PARAMETER										0
	#define	NO_IMPERATIVE_PARAMETER										0
	#define	NO_INDEFINITE_ARTICLE_PARAMETER								0
	#define	NO_INTERFACE_PARAMETER										0
	#define	NO_PREPOSITION_PARAMETER									0
	#define	NO_QUESTION_PARAMETER										0
	#define	NO_SOLVE_STRATEGY_PARAMETER									0
	#define	NO_WORD_PARAMETER											0

	#define	NO_LIST_NR													USHRT_MAX
	#define	MAX_LEVEL													USHRT_MAX
	#define	MAX_ORDER_NR												USHRT_MAX
	#define	MAX_POSITION												USHRT_MAX

	#define	NO_CENTER_WIDTH												0
	#define	NO_COLLECTION_NR											0
	#define	NO_CONTEXT_NR												0
	#define	NO_ITEM_NR													0
	#define	NO_SCORE													0
	#define	NO_SENTENCE_NR												0

	#define	MAX_COLLECTION_NR											UINT_MAX
	#define	MAX_CONTEXT_NR												UINT_MAX
	#define	MAX_ITEM_NR													UINT_MAX
	#define	MAX_NUMBER													UINT_MAX
	#define	MAX_PROGRESS												UINT_MAX
	#define	MAX_QUERY_PARAMETER											UINT_MAX
	#define	MAX_SCORE													UINT_MAX
	#define	MAX_SENTENCE_NR												UINT_MAX
	#define	WINNING_SCORE												UINT_MAX

	// Error string constants

	#define	NO_INTERFACE_STRING_FOUND_STRING							"{no interface string found}"
	#define	NO_LANGUAGE_NAME_FOUND_STRING								"{no language name found}"
	#define	NO_LANGUAGE_WORD_FOUND_STRING								"{no language word found}"
	#define	NO_USER_NAME_FOUND_STRING									"{no user name found}"

	// Input-output error constants
	#define	INPUT_OUTPUT_ERROR_CONSTRUCTOR_FUNCTION_NAME				"<init>"
	#define	INPUT_OUTPUT_ERROR_CLASS_STRING								"\nClass: "
	#define	INPUT_OUTPUT_ERROR_PARENT_CLASS_STRING						" / parent class "
	#define	INPUT_OUTPUT_ERROR_FUNCTION_STRING							".\nFunction: "
	#define	INPUT_OUTPUT_ERROR_FUNCTION_WORD_START_STRING				" of word \""
	#define	INPUT_OUTPUT_ERROR_FUNCTION_WORD_END_STRING					"\""
	#define	INPUT_OUTPUT_ERROR_FUNCTION_LIST_START_STRING				" in list <"
	#define	INPUT_OUTPUT_ERROR_FUNCTION_LIST_END_STRING					">"
	#define	INPUT_OUTPUT_ERROR_STRING									".\nError: "

	// Input-output prompt constants
	#define INPUT_OUTPUT_PROMPT_READ									0
	#define INPUT_OUTPUT_PROMPT_WRITE									1
	#define INPUT_OUTPUT_PROMPT_WRITE_INDENTED							2
	#define	INPUT_OUTPUT_PROMPT_INFO									3
	#define	INPUT_OUTPUT_PROMPT_NOTIFICATION							4
	#define INPUT_OUTPUT_PROMPT_WARNING									5
	#define INPUT_OUTPUT_PROMPT_WARNING_INDENTED						6
	#define INPUT_OUTPUT_PROMPT_WARNING_INTEGRITY						7
	#define INPUT_OUTPUT_PROMPT_QUERY									8

	#define	INPUT_OUTPUT_PROMPT_READ_STRING								"> "
	#define	INPUT_OUTPUT_PROMPT_WRITE_STRING							"< "
	#define	INPUT_OUTPUT_PROMPT_WRITE_INDENTED_STRING					"<	- "
	#define	INPUT_OUTPUT_PROMPT_INFO_STRING								""
	#define	INPUT_OUTPUT_PROMPT_NOTIFICATION_STRING						"* "
	#define	INPUT_OUTPUT_PROMPT_WARNING_STRING							"! "
	#define	INPUT_OUTPUT_PROMPT_WARNING_INDENTED_STRING					"!	- "
	#define	INPUT_OUTPUT_PROMPT_QUERY_STRING							"? "
	#define	INPUT_OUTPUT_PROMPT_EMPTY_STRING							"  "

	#define	INPUT_OUTPUT_CPP_ACCEPT_TAG_STRING							"#C++#"
	#define	INPUT_OUTPUT_JAVA_SKIP_TAG_STRING							"#Java#"
	#define	INPUT_OUTPUT_DEVELOPER_TAG_STRING							"#Dev#"

	// Character constants
	#define	SPACE_CHAR													' '
	#define	BACK_SPACE_CHAR												'\b'
	#define	BELL_CHAR													'\a'
	#define	NEW_LINE_CHAR												'\n'
	#define	CARRIAGE_RETURN_CHAR										'\r'
	#define	TAB_CHAR													'\t'

	// Grammar constants
	#define	GRAMMAR_CHOICE_START										SYMBOL_OPEN_CURVED_BRACKET
	#define	GRAMMAR_CHOICE_END											SYMBOL_CLOSE_CURVED_BRACKET
	#define	GRAMMAR_OPTION_START										SYMBOL_OPEN_SQUARE_BRACKET
	#define	GRAMMAR_OPTION_END											SYMBOL_CLOSE_SQUARE_BRACKET
	#define	GRAMMAR_OPTION_READ_NOT_WRITE_START							SYMBOL_OPEN_ROUNDED_BRACKET
	#define	GRAMMAR_OPTION_READ_NOT_WRITE_END							SYMBOL_CLOSE_ROUNDED_BRACKET

	// Query constants
	#define	COMMENT_CHAR												SYMBOL_HASH
	#define	GRAMMAR_WORD_DEFINITION_CHAR								SYMBOL_DOLLAR

	#define	QUERY_CHAR													SYMBOL_SWUNG_DASH
	#define	QUERY_COUNT_CHAR											SYMBOL_HASH
	#define	QUERY_SELECTING_ATTACHED_JUSTIFICATIONS_CHAR				SYMBOL_ASTERISK
	#define	QUERY_NO_LIST_CHAR											SYMBOL_QUESTION_MARK
	#define	QUERY_WORD_TYPE_CHAR										SYMBOL_AT_SIGN
	#define	QUERY_PARAMETER_CHAR										SYMBOL_DOUBLE_COLON
	#define	QUERY_ACTIVE_CHAR											SYMBOL_PLUS
	#define	QUERY_INACTIVE_CHAR											SYMBOL_EQUALITY
	#define	QUERY_ARCHIVED_CHAR											SYMBOL_DOLLAR
	#define	QUERY_REPLACED_CHAR											SYMBOL_PERCENT
	#define	QUERY_DELETED_CHAR											SYMBOL_AMPERSAND
	#define	QUERY_SEPARATOR_CHAR										SYMBOL_COMMA
	#define	QUERY_ITEM_START_CHAR										SYMBOL_OPEN_ROUNDED_BRACKET
	#define	QUERY_ITEM_END_CHAR											SYMBOL_CLOSE_ROUNDED_BRACKET
	#define	QUERY_ITEM_SENTENCE_NR_START_CHAR							SYMBOL_OPEN_CURVED_BRACKET
	#define	QUERY_ITEM_SENTENCE_NR_END_CHAR								SYMBOL_CLOSE_CURVED_BRACKET
	#define	QUERY_REF_ITEM_START_CHAR									SYMBOL_OPEN_SQUARE_BRACKET
	#define	QUERY_REF_ITEM_END_CHAR										SYMBOL_CLOSE_SQUARE_BRACKET
	#define	QUERY_LIST_START_CHAR										SYMBOL_OPEN_HOOKED_BRACKET
	#define	QUERY_LIST_END_CHAR											SYMBOL_CLOSE_HOOKED_BRACKET
	#define	QUERY_WORD_START_CHAR										SYMBOL_QUOTE
	#define	QUERY_WORD_END_CHAR											SYMBOL_QUOTE
	#define	QUERY_WORD_REFERENCE_START_CHAR								SYMBOL_BACK_QUOTE
	#define	QUERY_WORD_REFERENCE_END_CHAR								SYMBOL_BACK_QUOTE
	#define	QUERY_STRING_START_CHAR										SYMBOL_DOUBLE_QUOTE
	#define	QUERY_STRING_END_CHAR										SYMBOL_DOUBLE_QUOTE

	#define	QUERY_SEPARATOR_SPACE_STRING								", "
	#define	QUERY_SEPARATOR_STRING										","

	#define	TEXT_BELL_CHAR												'a'
	#define	TEXT_BACK_SPACE_CHAR										'b'
	#define TEXT_NEW_LINE_CHAR											'n'
	#define	TEXT_TAB_CHAR												't'

	// Result constants
	#define	RESULT_OK													1
	#define	RESULT_ERROR												0
	#define	RESULT_SYSTEM_ERROR											-1

	// Screen constants
	#define	TAB_LENGTH													8
	#define	NUMBER_OF_CONSOLE_COLUMNS									80

	// String constants
	#define FUNCTION_NAME_STRING_LENGTH									80
	#define	SENTENCE_STRING_LENGTH										1500
	#define	EXTENDED_SENTENCE_STRING_LENGTH								1700
	#define	ERROR_STRING_LENGTH											EXTENDED_SENTENCE_STRING_LENGTH
	#define	LONG_SENTENCE_STRING_LENGTH									SENTENCE_STRING_LENGTH + EXTENDED_SENTENCE_STRING_LENGTH

	#define	ASTERISK_STRING												"*"
	#define	BELL_STRING													"\a"
	#define	CARRIAGE_RETURN_STRING										"\r"
	#define	COLON_STRING												"."
	#define	DOUBLE_QUOTE_STRING											"\""
	#define	EMPTY_STRING												""
	#define	EMPTY_WIDE_STRING											L""
	#define	NEW_LINE_STRING												"\n"
	#define	SLASH_STRING												"/"
	#define	SPACE_STRING												" "

	// Symbol constants
	#define	SYMBOL_COMMA												','
	#define	SYMBOL_COLON												'.'
	#define	SYMBOL_SEMI_COLON											';'
	#define	SYMBOL_DOUBLE_COLON											':'
	#define	SYMBOL_EXCLAMATION_MARK										'!'
//#ifdef _MSC_VER
	#define	SYMBOL_SPANISH_INVERTED_EXCLAMATION_MARK					'¡'
//#endif
	#define	SYMBOL_QUESTION_MARK										'?'
//#ifdef _MSC_VER
	#define	SYMBOL_SPANISH_INVERTED_QUESTION_MARK						'¿'
//#endif
	#define	SYMBOL_PLUS													'+'
	#define	SYMBOL_MINUS												'-'
	#define	SYMBOL_UNDERSCORE											'_'
	#define	SYMBOL_APOSTROPHE											'\''
	#define	SYMBOL_EQUALITY												'='
	#define	SYMBOL_PIPE													'|'
	#define	SYMBOL_AMPERSAND											'&'
	#define	SYMBOL_HASH													'#'
	#define	SYMBOL_SWUNG_DASH											'~'
	#define	SYMBOL_AT_SIGN												'@'
	#define	SYMBOL_ASTERISK												'*'
	#define	SYMBOL_PERCENT												'%'
	#define	SYMBOL_DOLLAR												'$'
	#define	SYMBOL_SLASH												'/'
	#define	SYMBOL_BACK_SLASH											'\\'
	#define	SYMBOL_QUOTE												'\''
	#define	SYMBOL_BACK_QUOTE											'`'
	#define	SYMBOL_DOUBLE_QUOTE											'"'
	#define	SYMBOL_OPEN_ROUNDED_BRACKET									'('
	#define	SYMBOL_CLOSE_ROUNDED_BRACKET								')'
	#define	SYMBOL_OPEN_CURVED_BRACKET									'{'
	#define	SYMBOL_CLOSE_CURVED_BRACKET									'}'
	#define	SYMBOL_OPEN_HOOKED_BRACKET									'<'
	#define	SYMBOL_CLOSE_HOOKED_BRACKET									'>'
	#define	SYMBOL_OPEN_SQUARE_BRACKET									'['
	#define	SYMBOL_CLOSE_SQUARE_BRACKET									']'


	// Administrator initialization constants

	#define	ADMIN_USER_NAME_STRING										"Admin"

	#define	ADMIN_FILE_LIST												0
	#define	ADMIN_READ_LIST												2
	#define	ADMIN_SCORE_LIST											3
	#define	ADMIN_WORD_LIST												4
	#define	ADMIN_CONDITION_LIST										5		// SelectionItem
	#define	ADMIN_ACTION_LIST											6		// SelectionItem
	#define	ADMIN_ALTERNATIVE_LIST										7		// SelectionItem
	#define	NUMBER_OF_ADMIN_LISTS										8

	#define	ADMIN_FILE_LIST_SYMBOL										'F'
	#define	ADMIN_READ_LIST_SYMBOL										'R'
	#define	ADMIN_SCORE_LIST_SYMBOL										'S'
	#define	ADMIN_WORD_LIST_SYMBOL										'W'
	#define	ADMIN_CONDITION_LIST_SYMBOL									'X'		// SelectionItem
	#define	ADMIN_ACTION_LIST_SYMBOL									'Y'		// SelectionItem
	#define	ADMIN_ALTERNATIVE_LIST_SYMBOL								'Z'		// SelectionItem

	// Word initialization constants

	#define	WORD_ASSIGNMENT_LIST										0		// SpecificationItem
	#define	WORD_COLLECTION_LIST										1
	#define	WORD_GENERALIZATION_LIST									2
	#define	WORD_INTERFACE_LIST											3
	#define	WORD_JUSTIFICATION_LIST										4
	#define	WORD_GRAMMAR_LIST											5
	#define	WORD_MULTIPLE_WORD_LIST										6
	#define	WORD_WRITE_LIST												7
	#define	WORD_SPECIFICATION_LIST										8
	#define	WORD_TYPE_LIST												9
	#define	WORD_CONTEXT_LIST											10
	#define	NUMBER_OF_WORD_LISTS										11

	#define	WORD_ASSIGNMENT_LIST_SYMBOL									'a'		// SpecificationItem
	#define	WORD_COLLECTION_LIST_SYMBOL									'c'
	#define	WORD_GENERALIZATION_LIST_SYMBOL								'g'
	#define	WORD_INTERFACE_LIST_SYMBOL									'i'
	#define	WORD_JUSTIFICATION_LIST_SYMBOL								'j'
	#define	WORD_GRAMMAR_LIST_SYMBOL									'l'
	#define	WORD_MULTIPLE_WORD_LIST_SYMBOL								'm'
	#define	WORD_WRITE_LIST_SYMBOL										'r'
	#define	WORD_SPECIFICATION_LIST_SYMBOL								's'
	#define	WORD_TYPE_LIST_SYMBOL										'w'
	#define	WORD_CONTEXT_LIST_SYMBOL									'x'

	// Other initialization constants
	#define MAX_GRAMMAR_LEVEL											50		// Maximum depth of grammar parsing
	#define MAX_REASONING_ITERATIONS									50		// Maximum number of reasoning iterations
	#define MAX_SELECTION_ITERATIONS									250		// Maximum number of selection iterations
	#define	MAX_WORD_LENGTH												100

	#define NUMBER_OF_ASSUMPTION_LEVELS									3		// Probably, possibly and maybe
	#define	NUMBER_OF_PHONETIC_VOWELS									4

	const char PHONETIC_VOWEL[NUMBER_OF_PHONETIC_VOWELS] =			{	'a',
																		'e',
																		'i',
																		'o' };

	// Justification types
	#define	NO_JUSTIFICATION_TYPE															USHRT_MAX

	#define	JUSTIFICATION_TYPE_GENERALIZATION_ASSUMPTION									0
	#define	JUSTIFICATION_TYPE_OPPOSITE_POSSESSIVE_CONDITIONAL_SPECIFICATION_ASSUMPTION		1
	#define	JUSTIFICATION_TYPE_EXCLUSIVE_SPECIFICATION_SUBSTITUTION_ASSUMPTION				2
	#define	JUSTIFICATION_TYPE_INDIRECTLY_ANSWERED_QUESTION_ASSUMPTION						3
	#define	JUSTIFICATION_TYPE_SUGGESTIVE_QUESTION_ASSUMPTION								4

	#define	JUSTIFICATION_TYPE_ONLY_OPTION_LEFT_ASSUMPTION									5
	#define	JUSTIFICATION_TYPE_REVERSIBLE_ASSUMPTION										6
	#define	JUSTIFICATION_TYPE_DEFINITION_PART_OF_ASSUMPTION								7
	#define	JUSTIFICATION_TYPE_NEGATIVE_ASSUMPTION											8
	#define	JUSTIFICATION_TYPE_SPECIFICATION_GENERALIZATION_SUBSTITUTION_ASSUMPTION			9
	#define	JUSTIFICATION_TYPE_SPECIFICATION_SUBSTITUTION_ASSUMPTION						10
	#define	JUSTIFICATION_TYPE_SPECIFICATION_SUBSTITUTION_PART_OF_ASSUMPTION				11
	#define	JUSTIFICATION_TYPE_UNIQUE_RELATION_ASSUMPTION									12

	#define	JUSTIFICATION_TYPE_ONLY_OPTION_LEFT_CONCLUSION									13
	#define	JUSTIFICATION_TYPE_REVERSIBLE_CONCLUSION										14
	#define	JUSTIFICATION_TYPE_DEFINITION_PART_OF_CONCLUSION								15
	#define	JUSTIFICATION_TYPE_NEGATIVE_CONCLUSION											16
	#define	JUSTIFICATION_TYPE_SPECIFICATION_GENERALIZATION_SUBSTITUTION_CONCLUSION			17
	#define	JUSTIFICATION_TYPE_SPECIFICATION_SUBSTITUTION_CONCLUSION						18
	#define	JUSTIFICATION_TYPE_SPECIFICATION_SUBSTITUTION_PART_OF_CONCLUSION				19
	#define	JUSTIFICATION_TYPE_UNIQUE_RELATION_CONCLUSION									20

	#define	JUSTIFICATION_TYPE_SPECIFICATION_SUBSTITUTION_QUESTION							21


	// Word types
	#define	NO_WORD_TYPE_NR											0
	#define	WORD_TYPE_SYMBOL										1
	#define	WORD_TYPE_NUMERAL										2
	#define	WORD_TYPE_LETTER_SMALL									3
	#define	WORD_TYPE_LETTER_CAPITAL								4
	#define	WORD_TYPE_PROPER_NOUN									5
	#define	WORD_TYPE_ADJECTIVE										6
	#define	WORD_TYPE_ADVERB										7
	#define	WORD_TYPE_ANSWER										8
	#define	WORD_TYPE_ARTICLE										9
	#define	WORD_TYPE_CONJUNCTION									10
	#define	WORD_TYPE_NOUN_SINGULAR									11
	#define	WORD_TYPE_NOUN_PLURAL									12
	#define	WORD_TYPE_PERSONAL_PRONOUN_SINGULAR_SUBJECTIVE			13
	#define	WORD_TYPE_PERSONAL_PRONOUN_SINGULAR_OBJECTIVE			14
	#define	WORD_TYPE_POSSESSIVE_DETERMINER_SINGULAR				15
	#define	WORD_TYPE_POSSESSIVE_PRONOUN_SINGULAR					16
	#define	WORD_TYPE_PERSONAL_PRONOUN_PLURAL_SUBJECTIVE			17
	#define	WORD_TYPE_PERSONAL_PRONOUN_PLURAL_OBJECTIVE				18
	#define	WORD_TYPE_POSSESSIVE_DETERMINER_PLURAL					19
	#define	WORD_TYPE_POSSESSIVE_PRONOUN_PLURAL						20
	#define	WORD_TYPE_PREPOSITION									21
	#define	WORD_TYPE_VERB_SINGULAR									22
	#define	WORD_TYPE_VERB_PLURAL									23
	#define	WORD_TYPE_SELECTION_WORD								24
	#define	WORD_TYPE_TEXT											25
	#define	NUMBER_OF_WORD_TYPES									26


	// Word Parameters

	// Symbols
	#define	WORD_PARAMETER_SYMBOL_COMMA												100
	#define	WORD_PARAMETER_SYMBOL_COLON												101
	#define	WORD_PARAMETER_SYMBOL_EXCLAMATION_MARK									102
	#define	WORD_PARAMETER_SYMBOL_QUESTION_MARK										103
	#define	WORD_PARAMETER_SYMBOL_CHINESE_NEGATIVE_SEPARATOR						104
	#define	WORD_PARAMETER_SYMBOL_CHINESE_QUESTION_SEPARATOR						105
	#define	WORD_PARAMETER_SYMBOL_SPANISH_INVERTED_EXCLAMATION_MARK					106
	#define	WORD_PARAMETER_SYMBOL_SPANISH_INVERTED_QUESTION_MARK					107

	// Numerals
	#define	WORD_PARAMETER_NUMERAL_BOTH												200
	#define	WORD_PARAMETER_NUMERAL_CHINESE_ALL										201

	// Small letters

	// Capital letters

	// Proper nouns

	// Adjectives
	#define	WORD_PARAMETER_ADJECTIVE_ASSIGNED										600
	#define	WORD_PARAMETER_ADJECTIVE_BUSY											601
	#define	WORD_PARAMETER_ADJECTIVE_DEFENSIVE										602
	#define	WORD_PARAMETER_ADJECTIVE_DONE											603
	#define	WORD_PARAMETER_ADJECTIVE_EMPTY											604
	#define	WORD_PARAMETER_ADJECTIVE_EXCLUSIVE										605
	#define	WORD_PARAMETER_ADJECTIVE_FEMININE										606
	#define	WORD_PARAMETER_ADJECTIVE_INVERTED										607
	#define	WORD_PARAMETER_ADJECTIVE_MASCULINE										608
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_BIGGER								609
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_EARLIER								610
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_EQUAL								611
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_HIGHER								612
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_LARGER								613
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_LATER								614
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_LESS								615
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_LOWER								616
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_MORE								617
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_SAME								618
	#define	WORD_PARAMETER_ADJECTIVE_COMPARISON_SMALLER								619
	#define	WORD_PARAMETER_ADJECTIVE_CALLED_NEUTRAL									620
	#define	WORD_PARAMETER_ADJECTIVE_CALLED_SINGULAR_FEMININE						621
	#define	WORD_PARAMETER_ADJECTIVE_CALLED_SINGULAR_MASCULINE						622
	#define	WORD_PARAMETER_ADJECTIVE_CHARACTERISTIC									623
	#define	WORD_PARAMETER_ADJECTIVE_CURRENT_NEUTRAL								624
	#define	WORD_PARAMETER_ADJECTIVE_CURRENT_FEMININE_MASCULINE						625
	#define	WORD_PARAMETER_ADJECTIVE_EVEN											626
	#define	WORD_PARAMETER_ADJECTIVE_EVERY_NEUTRAL									627
	#define	WORD_PARAMETER_ADJECTIVE_EVERY_FEMININE_MASCULINE						628
	#define	WORD_PARAMETER_ADJECTIVE_NEW_NEUTRAL									629
	#define	WORD_PARAMETER_ADJECTIVE_NEW_FEMININE_MASCULINE							630
//	#define	WORD_PARAMETER_ADJECTIVE_NEXT_NEUTRAL									631
//	#define	WORD_PARAMETER_ADJECTIVE_NEXT_FEMININE_MASCULINE						632
	#define	WORD_PARAMETER_ADJECTIVE_NO												633
	#define	WORD_PARAMETER_ADJECTIVE_ODD											634
	#define	WORD_PARAMETER_ADJECTIVE_PREVIOUS_NEUTRAL								635
	#define	WORD_PARAMETER_ADJECTIVE_PREVIOUS_FEMININE_MASCULINE					636
	#define	WORD_PARAMETER_ADJECTIVE_SPECIFIC										637
	#define	WORD_PARAMETER_ADJECTIVE_CHINESE_DRAW									638

	// Adverbs
	#define	WORD_PARAMETER_ADVERB_ASSUMPTION_MAYBE									700
	#define	WORD_PARAMETER_ADVERB_ASSUMPTION_POSSIBLY								701
	#define	WORD_PARAMETER_ADVERB_ASSUMPTION_PROBABLY								702
	#define	WORD_PARAMETER_ADVERB_ANYMORE											703
	#define	WORD_PARAMETER_ADVERB_AS												704
	#define	WORD_PARAMETER_ADVERB_NOT												705
	#define	WORD_PARAMETER_ADVERB_CHINESE_NEVER_AGAIN								706
	#define	WORD_PARAMETER_ADVERB_FRENCH_PAS										707

	// Interjections
	#define	WORD_PARAMETER_INTERJECTION_YES											800
	#define	WORD_PARAMETER_INTERJECTION_NO											801

	// Articles
	#define	WORD_PARAMETER_ARTICLE_INDEFINITE_PHONETIC_VOWEL_PLURAL_FEMININE		900
	#define	WORD_PARAMETER_ARTICLE_INDEFINITE_PHONETIC_VOWEL_PLURAL_MASCULINE		901
	#define	WORD_PARAMETER_ARTICLE_INDEFINITE_PHONETIC_VOWEL_SINGULAR_FEMININE		902
	#define	WORD_PARAMETER_ARTICLE_INDEFINITE_PHONETIC_VOWEL_SINGULAR_MASCULINE		903
	#define	WORD_PARAMETER_ARTICLE_INDEFINITE_PLURAL_FEMININE						904
	#define	WORD_PARAMETER_ARTICLE_INDEFINITE_PLURAL_MASCULINE						905
	#define	WORD_PARAMETER_ARTICLE_INDEFINITE_SINGULAR_FEMININE						906
	#define	WORD_PARAMETER_ARTICLE_INDEFINITE_SINGULAR_MASCULINE					907
	#define	WORD_PARAMETER_ARTICLE_DEFINITE_PLURAL_NEUTRAL							908
	#define	WORD_PARAMETER_ARTICLE_DEFINITE_PLURAL_FEMININE							909
	#define	WORD_PARAMETER_ARTICLE_DEFINITE_PLURAL_MASCULINE						910
	#define	WORD_PARAMETER_ARTICLE_DEFINITE_SINGULAR_NEUTRAL						911
	#define	WORD_PARAMETER_ARTICLE_DEFINITE_SINGULAR_FEMININE						912
	#define	WORD_PARAMETER_ARTICLE_DEFINITE_SINGULAR_MASCULINE						913

	// Conjunctions
	#define	WORD_PARAMETER_CONJUNCTION_AND											1000
	#define	WORD_PARAMETER_CONJUNCTION_OR											1001
//	#define	WORD_PARAMETER_CONJUNCTION_THAN											1002
//	#define	WORD_PARAMETER_CONJUNCTION_THAN											1003
	#define	WORD_PARAMETER_CONJUNCTION_DUTCH_ZOWEL									1004
	#define	WORD_PARAMETER_CONJUNCTION_DUTCH_ALS									1005

	// Singular / plural nouns
	#define	WORD_PARAMETER_NOUN_DEVELOPER											1100
	#define	WORD_PARAMETER_NOUN_EXPERT												1101
	#define	WORD_PARAMETER_NOUN_FILE												1102
	#define	WORD_PARAMETER_NOUN_HEAD												1103
	#define	WORD_PARAMETER_NOUN_JUSTIFICATION_REPORT								1104
	#define	WORD_PARAMETER_NOUN_LANGUAGE											1105
	#define	WORD_PARAMETER_NOUN_MIND												1106
	#define	WORD_PARAMETER_NOUN_NUMBER												1107
	#define	WORD_PARAMETER_NOUN_PASSWORD											1108
	#define	WORD_PARAMETER_NOUN_SOLVE_LEVEL											1109
	#define	WORD_PARAMETER_NOUN_SOLVE_METHOD										1110
	#define	WORD_PARAMETER_NOUN_SOLVE_STRATEGY										1111
	#define	WORD_PARAMETER_NOUN_STARTUP_LANGUAGE									1112
	#define	WORD_PARAMETER_NOUN_TAIL												1113
	#define	WORD_PARAMETER_NOUN_TEST_FILE											1114
	#define	WORD_PARAMETER_NOUN_USER												1115
	#define	WORD_PARAMETER_NOUN_INFORMATION											1116
	#define	WORD_PARAMETER_NOUN_PART												1117
	#define	WORD_PARAMETER_NOUN_VALUE												1118
	#define	WORD_PARAMETER_NOUN_CHINESE_IS_IT_TRUE									1119
	#define	WORD_PARAMETER_NOUN_CHINESE_MARSUPIAL									1120
	#define	WORD_PARAMETER_NOUN_CHINESE_SAILBOAT									1121
	#define	WORD_PARAMETER_NOUN_CHINESE_TURN										1122

	// Singular pronouns
	#define	WORD_PARAMETER_SINGULAR_PRONOUN_I_ME_MY_MINE							1300
	#define	WORD_PARAMETER_SINGULAR_PRONOUN_YOU_YOUR_YOURS_INFORMAL					1301
	#define	WORD_PARAMETER_SINGULAR_PRONOUN_YOU_YOUR_YOURS_FORMAL					1302
	#define	WORD_PARAMETER_SINGULAR_PRONOUN_HE_HIM_HIS_HIS							1303
	#define	WORD_PARAMETER_SINGULAR_PRONOUN_SHE_HER_HER_HERS						1304
	#define	WORD_PARAMETER_SINGULAR_PRONOUN_IT_ITS_ITS_ITS							1305

	// Plural pronouns
	#define	WORD_PARAMETER_PLURAL_PRONOUN_WE_US_OUR_OURS_FEMININE					1700
	#define	WORD_PARAMETER_PLURAL_PRONOUN_WE_US_OUR_OURS_MASCULINE					1701
	#define	WORD_PARAMETER_PLURAL_PRONOUN_YOU_YOUR_YOURS_FEMININE					1702
	#define	WORD_PARAMETER_PLURAL_PRONOUN_YOU_YOUR_YOURS_MASCULINE					1703
	#define	WORD_PARAMETER_PLURAL_PRONOUN_YOU_ALL									1704
	#define	WORD_PARAMETER_PLURAL_PRONOUN_THEY_THEM_THEIR_THEIRS_FEMININE			1705
	#define	WORD_PARAMETER_PLURAL_PRONOUN_THEY_THEM_THEIR_THEIRS_MASCULINE			1706

	// Prepositions
	#define	WORD_PARAMETER_PREPOSITION_ABOUT										2100
	#define	WORD_PARAMETER_PREPOSITION_FROM											2101
	#define	WORD_PARAMETER_PREPOSITION_IN											2102
	#define	WORD_PARAMETER_PREPOSITION_TO											2103
	#define	WORD_PARAMETER_PREPOSITION_FOR											2104
	#define	WORD_PARAMETER_PREPOSITION_OF											2105
	#define	WORD_PARAMETER_PREPOSITION_CHINESE_VERB_ADD								2106
	#define	WORD_PARAMETER_PREPOSITION_CHINESE_VERB_MOVE							2107
	#define	WORD_PARAMETER_PREPOSITION_CHINESE_VERB_REMOVE							2108
	#define	WORD_PARAMETER_PREPOSITION_FRENCH_A										2109

	// Singular verbs
	#define	WORD_PARAMETER_SINGULAR_VERB_IS											2200
	#define	WORD_PARAMETER_SINGULAR_VERB_WAS										2201
	#define	WORD_PARAMETER_SINGULAR_VERB_CAN_BE										2202
	#define	WORD_PARAMETER_SINGULAR_VERB_HAS										2203
	#define	WORD_PARAMETER_SINGULAR_VERB_HAD										2204
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_ADD								2205
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_CLEAR							2206
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_DISPLAY							2207
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_HELP							2208
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_LOGIN							2209
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_MOVE							2210
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_READ							2211
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_REDO							2212
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_REMOVE							2213
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_RESTART							2214
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_SOLVE							2215
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_UNDO							2216
	#define	WORD_PARAMETER_SINGULAR_VERB_IMPERATIVE_CHINESE_PUT						2217

	// Plural verbs
	#define	WORD_PARAMETER_PLURAL_VERB_ARE											2300
	#define	WORD_PARAMETER_PLURAL_VERB_WERE											2301
	#define	WORD_PARAMETER_PLURAL_VERB_CAN_BE										2302
	#define	WORD_PARAMETER_PLURAL_VERB_HAVE											2303
	#define	WORD_PARAMETER_PLURAL_VERB_HAD											2304

	// Selection words
	#define	WORD_PARAMETER_SELECTION_IF												2400
	#define	WORD_PARAMETER_SELECTION_THEN											2401
	#define	WORD_PARAMETER_SELECTION_ELSE											2402

	// Text

	// Feminine proper noun ending
	#define	WORD_FEMININE_PROPER_NOUN_ENDING										3000

	// Masculine proper noun ending
	#define	WORD_MASCULINE_PROPER_NOUN_ENDING										3001

	// Feminine singular noun ending
	#define	WORD_FEMININE_SINGULAR_NOUN_ENDING										3002

	// Masculine singular noun ending
	#define	WORD_MASCULINE_SINGULAR_NOUN_ENDING										3003

	// Plural noun ending
	#define	WORD_PLURAL_NOUN_ENDING													3004

	// Merged words
	#define	WORD_MERGED_WORD														3005

	// Assignment nouns
	#define	WORD_CHINESE_EXCLUSIVE_NOUN											3006


	// Grammar parameters
	#define GRAMMAR_SENTENCE														4000
	#define GRAMMAR_STATEMENT														4010
	#define	GRAMMAR_STATEMENT_ANSWER												4011
	#define GRAMMAR_STATEMENT_ASSIGNMENT											4012
	#define GRAMMAR_STATEMENT_SPECIFICATION											4013
	#define GRAMMAR_STATEMENT_SPECIFICATION_GENERALIZATION							4014
	#define GRAMMAR_QUESTION														4020
	#define GRAMMAR_QUESTION_SPECIFICATION											4021
	#define GRAMMAR_QUESTION_SPECIFICATION_GENERALIZATION							4022
	#define	GRAMMAR_SELECTION														4030
	#define	GRAMMAR_IMPERATIVE														4040
	#define	GRAMMAR_GENERALIZATION_SPECIFICATION									5000
	#define	GRAMMAR_GENERALIZATION_PART												5010
	#define	GRAMMAR_GENERALIZATION_WORD												5011
	#define	GRAMMAR_LINKED_GENERALIZATION_CONJUNCTION								5012
	#define	GRAMMAR_SPECIFICATION_PART												5020
	#define	GRAMMAR_ASSIGNMENT_PART													5021
	#define	GRAMMAR_SPECIFICATION_WORD												5022
	#define	GRAMMAR_EXCLUSIVE_SPECIFICATION_CONJUNCTION								5023
	#define	GRAMMAR_RELATION_PART													5030
	#define	GRAMMAR_RELATION_WORD													5031
	#define	GRAMMAR_TEXT															5040
	#define	GRAMMAR_GENERALIZATION_ASSIGNMENT										5100
	#define	GRAMMAR_SPECIFICATION_ASSIGNMENT										5101
	#define	GRAMMAR_RELATION_ASSIGNMENT												5102
	#define	GRAMMAR_SENTENCE_CONJUNCTION											5110
	#define	GRAMMAR_VERB															5120
	#define	GRAMMAR_QUESTION_VERB													5121
	#define	GRAMMAR_SPECIFICATION_GENERALIZATION_VERB								5122
	#define	GRAMMAR_SPECIFICATION_GENERALIZATION_QUESTION_VERB						5123

	// Console (common)
	#define	INTERFACE_CONSOLE_INITIAL_MESSAGE														1000
	#define	INTERFACE_CONSOLE_ALREADY_LOGGED_IN_START												1004
	#define	INTERFACE_CONSOLE_LOGIN_END																1005
	#define	INTERFACE_CONSOLE_LOGIN_FAILED															1006
	#define	INTERFACE_CONSOLE_WELCOME_MESSAGE_EXPERT												1007

	// Console (progress and status)
	#define	INTERFACE_CONSOLE_I_AM_EXECUTING_SELECTIONS_START										1010
	#define	INTERFACE_CONSOLE_I_AM_EXECUTING_SELECTIONS_END											1011

	// Grammar
	#define	INTERFACE_GRAMMAR_DEFINITION_IS_NOT_USED_START											1100
	#define	INTERFACE_GRAMMAR_DEFINITION_IS_NOT_USED_MIDDLE											1101
	#define	INTERFACE_GRAMMAR_DEFINITION_IS_NOT_USED_END											1102
	#define	INTERFACE_GRAMMAR_PARAMETER_DEFINED_MORE_THAN_ONCE_START								1103
	#define	INTERFACE_GRAMMAR_PARAMETER_DEFINED_MORE_THAN_ONCE_MIDDLE								1104
	#define	INTERFACE_GRAMMAR_PARAMETER_DEFINED_MORE_THAN_ONCE_END									1105
	#define	INTERFACE_GRAMMAR_WORD_TYPE_DEFINITION_MISSING_START									1106
	#define	INTERFACE_GRAMMAR_WORD_TYPE_DEFINITION_MISSING_MIDDLE									1107
	#define	INTERFACE_GRAMMAR_WORD_TYPE_DEFINITIONS_MISSING_START									1108
	#define	INTERFACE_GRAMMAR_WORD_TYPE_DEFINITIONS_MISSING_TO										1109
	#define	INTERFACE_GRAMMAR_WORD_TYPE_DEFINITIONS_MISSING_MIDDLE									1110
	#define	INTERFACE_GRAMMAR_WORD_TYPE_DEFINITION_MISSING_END										1111
	#define	INTERFACE_GRAMMAR_UNKNOWN_PLURAL_NOUN_START												1112
	#define	INTERFACE_GRAMMAR_UNKNOWN_PLURAL_NOUN_ENDING											1113

	// Imperative (notifications)
	#define	INTERFACE_IMPERATIVE_NOTIFICATION_MY_MIND_IS_CLEAR										1200
	#define	INTERFACE_IMPERATIVE_NOTIFICATION_NO_SENTENCES_TO_UNDO									1201
	#define	INTERFACE_IMPERATIVE_NOTIFICATION_NO_SENTENCES_TO_REDO									1202
	#define	INTERFACE_IMPERATIVE_NOTIFICATION_I_HAVE_UNDONE_SENTENCE_NR_START						1203
	#define	INTERFACE_IMPERATIVE_NOTIFICATION_I_HAVE_UNDONE_SENTENCE_NR_END							1204
	#define	INTERFACE_IMPERATIVE_NOTIFICATION_I_HAVE_REDONE_SENTENCE_NR_START						1205
	#define	INTERFACE_IMPERATIVE_NOTIFICATION_I_HAVE_REDONE_SENTENCE_NR_END							1206
	#define	INTERFACE_IMPERATIVE_NOTIFICATION_I_DONT_HAVE_THE_REQUESTED_INFO						1207

	// Imperative (warnings)
	#define	INTERFACE_IMPERATIVE_WARNING_I_COULD_NOT_FIND_ANY_SELECTION_TO_SOLVE_INFO_START			1210
	#define	INTERFACE_IMPERATIVE_WARNING_I_COULD_NOT_FIND_ANY_SELECTION_TO_SOLVE_INFO_END			1211
	#define	INTERFACE_IMPERATIVE_WARNING_I_DONT_KNOW_HOW_TO_EXECUTE_IMPERATIVE_VERB_START			1212
	#define	INTERFACE_IMPERATIVE_WARNING_I_DONT_KNOW_HOW_TO_EXECUTE_IMPERATIVE_VERB_END				1213
	#define	INTERFACE_IMPERATIVE_WARNING_I_DONT_KNOW_TO_DO_WITH_RELATION							1214
	#define	INTERFACE_IMPERATIVE_WARNING_I_DONT_KNOW_WHICH_FILE_TO_READ								1215
	#define	INTERFACE_IMPERATIVE_WARNING_NEEDS_A_LIST_TO_BE_SPECIFIED								1216
	#define	INTERFACE_IMPERATIVE_WARNING_PREPOSITION_NOT_USED_FOR_THIS_ACTION						1217
	#define	INTERFACE_IMPERATIVE_WARNING_WORD_ALREADY_SOLVED_START									1218
	#define	INTERFACE_IMPERATIVE_WARNING_WORD_ALREADY_SOLVED_END									1219

	// Listing (conflicts)
	#define	INTERFACE_LISTING_QUESTION_IN_CONFLICT_WITH_DEFINITION									1300
	#define	INTERFACE_LISTING_SENTENCE_IN_CONFLICT_WITH_DEFINITION									1301
	#define	INTERFACE_LISTING_SENTENCE_DOESNT_LEAVE_ANY_OPTION_OPEN									1302
	#define	INTERFACE_LISTING_SENTENCE_DEFINITION_SPECIFICATION_IS_ALREADY_ASSIGNED					1303
	#define	INTERFACE_LISTING_SENTENCE_ASSIGNMENT_IN_CONFLICT_WITH_DEFINITION_SPECIFICATION			1304

	// Listing (current information)
	#define	INTERFACE_LISTING_YOUR_INFORMATION														1310
	#define	INTERFACE_LISTING_YOUR_QUESTIONS														1311
	#define	INTERFACE_LISTING_MY_INFORMATION														1312
	#define	INTERFACE_LISTING_MY_CONCLUSIONS														1313
	#define	INTERFACE_LISTING_MY_ASSUMPTIONS														1314
	#define	INTERFACE_LISTING_MY_ASSUMPTIONS_THAT_ARE_ADJUSTED										1315
	#define	INTERFACE_LISTING_MY_ASSUMPTIONS_THAT_ARE_CONCLUDED										1316
	#define	INTERFACE_LISTING_MY_CONCLUSIONS_THAT_ARE_UPDATED										1317
	#define	INTERFACE_LISTING_MY_CONCLUSIONS_THAT_ARE_NOT_HIDDEN_ANYMORE							1318
	#define	INTERFACE_LISTING_MY_ASSUMPTIONS_THAT_ARE_NOT_HIDDEN_ANYMORE							1319
	#define	INTERFACE_LISTING_MY_QUESTIONS															1320
	#define	INTERFACE_LISTING_MY_ADJUSTED_QUESTIONS													1321
	#define	INTERFACE_LISTING_MY_ANSWER																1322
	#define	INTERFACE_LISTING_I_ONLY_KNOW															1323
	#define	INTERFACE_LISTING_SPECIFICATIONS														1324
	#define	INTERFACE_LISTING_RELATED_INFORMATION													1325
	#define	INTERFACE_LISTING_RELATED_QUESTIONS														1326

	// Listing (old information)
	#define	INTERFACE_LISTING_CONFIRMED_SPECIFICATION_OF_MY_ASSUMPTION_BUT_NOT_ITS_RELATION			1330
	#define	INTERFACE_LISTING_CONFIRMED_SPECIFICATION_OF_MY_CONCLUSION_BUT_NOT_ITS_RELATION			1331
	#define	INTERFACE_LISTING_CONFIRMED_SPECIFICATION_AND_AT_LEAST_ONE_RELATION_OF_MY_ASSUMPTION	1332
	#define	INTERFACE_LISTING_CONFIRMED_SPECIFICATION_AND_AT_LEAST_ONE_RELATION_OF_MY_CONCLUSION	1333
	#define	INTERFACE_LISTING_MY_ASSUMPTIONS_THAT_ARE_CONFIRMED										1334
	#define	INTERFACE_LISTING_MY_CONCLUSIONS_THAT_ARE_CONFIRMED										1335
	#define	INTERFACE_LISTING_MY_EARLIER_ASSUMPTIONS_THAT_HAVE_RELATION_WORDS_NOW					1336
	#define	INTERFACE_LISTING_MY_EARLIER_CONCLUSIONS_THAT_HAVE_RELATION_WORDS_NOW					1337
	#define	INTERFACE_LISTING_YOUR_INFO_IS_MORE_SPECIFIC_THAN_MY_ASSUMPTION							1338
	#define	INTERFACE_LISTING_YOUR_INFO_IS_MORE_SPECIFIC_THAN_MY_CONCLUSION							1339
	#define	INTERFACE_LISTING_YOUR_QUESTION_IS_MORE_SPECIFIC_THAN_MY_QUESTION						1340
	#define	INTERFACE_LISTING_THIS_INFO_IS_MORE_SPECIFIC_THAN_YOUR_EARLIER_INFO						1341
	#define	INTERFACE_LISTING_THIS_QUESTION_IS_MORE_SPECIFIC_THAN_YOUR_QUESTION						1342
	#define	INTERFACE_LISTING_YOUR_QUESTIONS_THAT_ARE_ANSWERED										1343
	#define	INTERFACE_LISTING_MY_QUESTIONS_THAT_ARE_ANSWERED										1344
	#define	INTERFACE_LISTING_MY_CORRECTED_ASSUMPTIONS_BY_KNOWLEDGE									1345
	#define	INTERFACE_LISTING_MY_CORRECTED_ASSUMPTIONS_BY_OPPOSITE_SUGGESTIVE_QUESTION				1346

	// Listing (justification report)
	#define	INTERFACE_JUSTIFICATION_BECAUSE															1350
	#define	INTERFACE_JUSTIFICATION_AND																1351
	#define	INTERFACE_JUSTIFICATION_FEMININE_OR_MASCULINE_PROPER_NOUN_ENDING						1352
	#define	INTERFACE_JUSTIFICATION_FEMININE_PROPER_NOUN_ENDING										1353
	#define	INTERFACE_JUSTIFICATION_MASCULINE_PROPER_NOUN_ENDING									1354
	#define	INTERFACE_JUSTIFICATION_LEARNED_FROM_USER_START											1355
	#define	INTERFACE_JUSTIFICATION_LEARNED_FROM_USER_END											1356

	// Query
	#define	INTERFACE_QUERY_NO_ITEM_WAS_FOUND														1400
	#define	INTERFACE_QUERY_NO_REFERENCE_ITEM_WAS_FOUND												1401
	#define	INTERFACE_QUERY_INVALID_CHARACTER_IN_LIST												1402
	#define	INTERFACE_QUERY_NO_LIST_WAS_FOUND														1403
	#define	INTERFACE_QUERY_NO_WORD_WAS_FOUND														1404
	#define	INTERFACE_QUERY_NO_WORD_REFERENCE_WAS_FOUND												1405
	#define	INTERFACE_QUERY_NO_STRING_WAS_FOUND														1406
	#define	INTERFACE_QUERY_NO_WORD_TYPE_WAS_FOUND													1407
	#define	INTERFACE_QUERY_NO_PARAMETER_WAS_FOUND													1408

	#define	INTERFACE_QUERY_NO_ITEMS_WERE_FOUND														1409
	#define	INTERFACE_QUERY_NO_WORDS_WERE_FOUND														1410
	#define	INTERFACE_QUERY_NO_WORD_REFERENCES_WERE_FOUND											1411
	#define	INTERFACE_QUERY_NO_STRINGS_WERE_FOUND													1412

	#define	INTERFACE_QUERY_EMPTY_WORD_SPECIFICATION												1413
	#define	INTERFACE_QUERY_EMPTY_WORD_REFERENCE													1414
	#define	INTERFACE_QUERY_EMPTY_STRING_SPECIFICATION												1415

	#define	INTERFACE_QUERY_ERROR																	1499

	// Response (questions)
	#define	INTERFACE_QUESTION_YOU_HAD_THE_SAME_QUESTION_BEFORE										1500
	#define	INTERFACE_QUESTION_I_HAD_THE_SAME_QUESTION_BEFORE										1501
	#define	INTERFACE_QUESTION_YOU_HAD_A_SIMILAR_QUESTION_BEFORE									1502
	#define	INTERFACE_QUESTION_I_HAD_A_SIMILAR_QUESTION_BEFORE										1503
	#define	INTERFACE_QUESTION_YOU_HAD_A_RELATED_QUESTION_BEFORE									1504
	#define	INTERFACE_QUESTION_I_HAD_A_RELATED_QUESTION_BEFORE										1505
	#define	INTERFACE_QUESTION_I_DONT_KNOW_ANYTHING_ABOUT_WORD_START								1506
	#define	INTERFACE_QUESTION_I_DONT_KNOW_ANYTHING_ABOUT_WORD_END									1507
	#define	INTERFACE_QUESTION_IS_ALREADY_ANSWERED													1508
	#define	INTERFACE_QUESTION_I_DONT_KNOW_THE_ANSWER_TO_THIS_QUESTION								1509

	// Sentence (notifications)
	#define	INTERFACE_SENTENCE_NOTIFICATION_I_EXPECTED_PROPER_NOUN_TO_BE							1600
	#define	INTERFACE_SENTENCE_NOTIFICATION_I_EXPECTED_SINGULAR_NOUN_TO_BE							1601
	#define	INTERFACE_SENTENCE_NOTIFICATION_I_EXPECTED_FEMININE										1602
	#define	INTERFACE_SENTENCE_NOTIFICATION_I_EXPECTED_MASCULINE									1603
	#define	INTERFACE_SENTENCE_NOTIFICATION_I_KNOW													1604
	#define	INTERFACE_SENTENCE_NOTIFICATION_I_NOTICED_SEMANTIC_AMBIGUITY_START						1605
	#define	INTERFACE_SENTENCE_NOTIFICATION_STATIC_SEMANTIC_AMBIGUITY_END							1606
	#define	INTERFACE_SENTENCE_NOTIFICATION_DYNAMIC_SEMANTIC_AMBIGUITY_END							1607
	#define	INTERFACE_SENTENCE_NOTIFICATION_AMBIGUOUS_QUESTION_MISSING_RELATION						1608
	#define	INTERFACE_SENTENCE_NOTIFICATION_MISSING_RELATION_I_ASSUME_YOU_MEAN						1609
	#define	INTERFACE_SENTENCE_NOTIFICATION_USED_DIFFERENT_ADJECTIVE_WITH_NOUN_START				1610
	#define	INTERFACE_SENTENCE_NOTIFICATION_USED_DIFFERENT_DEFINITE_ARTICLE_WITH_NOUN_START			1611
	#define	INTERFACE_SENTENCE_NOTIFICATION_USED_DIFFERENT_INDEFINITE_ARTICLE_WITH_NOUN_START		1612
	#define	INTERFACE_SENTENCE_NOTIFICATION_USED_DIFFERENT_ADJECTIVE_OR_ARTICLE_WITH_NOUN_END		1613
	#define	INTERFACE_SENTENCE_NOTIFICATION_YOU_ENTERED_UNKNOWN_PLURAL_OF_SINGULAR_NOUN_START		1614
	#define	INTERFACE_SENTENCE_NOTIFICATION_YOU_ENTERED_UNKNOWN_PLURAL_OF_SINGULAR_NOUN_END			1615

	// Sentence (warnings)
	#define	INTERFACE_SENTENCE_WARNING_NOT_CONFORM_GRAMMAR											1620
	#define	INTERFACE_SENTENCE_WARNING_DONT_UNDERSTAND_FROM_WORD_POSITION_START						1621
	#define	INTERFACE_SENTENCE_WARNING_DONT_UNDERSTAND_FROM_WORD_POSITION_END						1622
	#define	INTERFACE_SENTENCE_WARNING_WORD_CAN_ONLY_BE_USED_IN_CONDITION_OF_SELECTION_START		1623
	#define	INTERFACE_SENTENCE_WARNING_WORD_CAN_ONLY_BE_USED_IN_CONDITION_OF_SELECTION_POSITION		1624
	#define	INTERFACE_SENTENCE_WARNING_WORD_CAN_ONLY_BE_USED_IN_CONDITION_OF_SELECTION_END			1625
	#define	INTERFACE_SENTENCE_WARNING_WORD_IS_GENERALIZATION_AS_WELL_AS_RELATION_START				1626
	#define	INTERFACE_SENTENCE_WARNING_WORD_IS_GENERALIZATION_AS_WELL_AS_RELATION_END				1627
	#define	INTERFACE_SENTENCE_WARNING_NOT_ABLE_TO_LINK_YES_NO_TO_QUESTION							1628
	#define	INTERFACE_SENTENCE_WARNING_AMBIGUOUS_SENTENCE_MISSING_RELATION							1629
	#define	INTERFACE_SENTENCE_WARNING_AMBIGUOUS_SENTENCE_MULTIPLE_SPECIFICATIONS_RELATIONS			1630

	// Sentence (errors)
	#define	INTERFACE_SENTENCE_ERROR_GRAMMAR_INTEGRITY_STORE_OR_RETRIEVE							1640
	#define	INTERFACE_SENTENCE_ERROR_GRAMMAR_INTEGRITY_THIS_SENTENCE								1641
	#define	INTERFACE_SENTENCE_ERROR_GRAMMAR_INTEGRITY_THIS_SENTENCE_DUE_TO_WORDS					1642
	#define	INTERFACE_SENTENCE_ERROR_GRAMMAR_INTEGRITY_SENTENCE_START								1643
	#define	INTERFACE_SENTENCE_ERROR_GRAMMAR_INTEGRITY_SENTENCE										1644
	#define	INTERFACE_SENTENCE_ERROR_GRAMMAR_INTEGRITY_SENTENCE_DUE_TO_WORDS						1645
	#define	INTERFACE_SENTENCE_ERROR_GRAMMAR_INTEGRITY_I_RETRIEVED_FROM_MY_SYSTEM_START				1646
	#define	INTERFACE_SENTENCE_ERROR_GRAMMAR_INTEGRITY_I_RETRIEVED_FROM_MY_SYSTEM_END				1647

#endif

/*************************************************************************
 *	"He will bless those who fear the Lord,
 *	both great and lowly." (Psalm 115:13)
 *************************************************************************/
