<?php
/*----------------------------------------------------

  ListRendererClass For ThreadWiki

  ThreadWiki : WikiEngine with Namespace
    Copyright(C) 2004 by FLATz Co , LTd.

------------------------------------------------------*/

require_once( 'Wiki/WikiCommonLib.php' );


class ListRenderer
{

var $config;
var $wiki_renderer;
var $message_manager;

//////////////////////////////////////////
// 󥹥ȥ饯
function ListRenderer( &$config,&$wiki_renderer,&$message_manager )
{
	$this->config          = &$config;
	$this->wiki_renderer   = &$wiki_renderer;
	$this->message_manager = &$message_manager;
}

//////////////////////////////////////////
// ǡHTML
function render($list_data,$list_page_url)
{
	$html_data = "";
	$now_initial = "";
	$two_byte_flag = 0;
	$symbol_flag = 0;
	$number_flag = 0;
	
	$use_initial_list = array();

	$text_symbol  = $this->message_manager->get('TEXT_SYMBOL');
	$text_numeral = $this->message_manager->get('TEXT_NUMERAL');
	$text_other   = $this->message_manager->get('TEXT_OTHER');
	
	reset( $list_data );
	while (list ($key_name, $page_data) = each ($list_data)) {
		$initial = substr($key_name,0,1);
		if($initial != $now_initial){
			if(preg_match("/[A-Za-z]/",$initial)){
				$html_data .= "<p><a href=\"" . $list_page_url ."#list:${initial}\" name=\"list:${initial}\"><strong>&lt;${initial}&gt;</strong></a></p>\n";
				$use_initial_list[] = $initial;
			}
			elseif(preg_match("/[\!\-\+\&\%\*]/",$initial) && $symbol_flag == 0){
				$html_data .= "<p><a href=\"" . $list_page_url ."#list:Symbol\" name=\"list:Symbol\"><strong>&lt;$text_symbol&gt;</strong></p>\n";
				$use_initial_list[] = $text_symbol;
				$symbol_flag = 1;
			}
			elseif(preg_match("/[0-9]/",$initial) && $number_flag == 0){
				$html_data .= "<p><a href=\"" . $list_page_url ."#list:Number\" name=\"list:Number\"><strong>&lt;$text_numeral&gt;</strong></p>\n";
				$use_initial_list[] = $text_numeral;
				$number_flag = 1;
			}
			else{
				if($two_byte_flag == 0){
					$html_data .= "<p><a href=\"" . $list_page_url ."#list:Other\" name=\"list:Other\"><strong>&lt;$text_other&gt;</strong></a></p>\n";
					$two_byte_flag = 1;
					$use_initial_list[] = $text_other;
				}
			}
			$now_initial = $initial;
		}
		$html_data .= $this->render_list_page_name_html($page_data);
	}
	
	$link_index_html = "";
	for($i=0;$i<count($use_initial_list);$i++){
		$link_index_html .= "<a href=\"" . $list_page_url ."#list:" . $use_initial_list[$i] . "\" name=\"list:". $use_initial_list[$i] ."\"><b>&nbsp;" . $use_initial_list[$i] . "&nbsp;</b></a>|";
	}
	$link_index_html = preg_replace("/\|$/","",$link_index_html);
	return "<div style=\"text-align:center\"><p>" .$link_index_html ."</p></div>". $html_data;
}

//////////////////////////////////////////
// ꥹѥڡ̾HTML
function render_list_page_name_html(&$page_data)
{
	$wiki_name_data = array();
	$wiki_name_data['pagename'] = $page_data->data['name'];
	$wiki_name_data['namespace'] = $page_data->data['name_space'];
	
	$hit_type = "";
	if($page_data->data['name'] == "" && $page_data->data['name_space']){
		$wiki_name_data['alias'] = $page_data->data['name_space'];
		$hit_type = "hit_index_page";
	}
	else{
		$wiki_name_data['alias']  = $page_data->data['name'];
		$hit_type = "hit";
	}
	$wiki_link = WikiCommonLib::make_wikiname_html($wiki_name_data['alias'],$wiki_name_data,$hit_type);

	return "<li>${wiki_link}</li>\n";
	
}


}
?>
