# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from flask import Flask
from linkpair.exporter.JSON import JsonExporter

app = Flask(__name__)
util = None
collect_func = None


def parse_linkpair_records():
    linkpairs = collect_func()
    exporter = JsonExporter(util, linkpairs)
    return exporter.run() + "\n"


def start_app(listen='localhost:23456', debug=True):
    app.config.update(
        DEBUG=debug,
        SERVER_NAME=listen
    )
    app.run()


@app.route("/")
def index():
    return parse_linkpair_records()
