# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import re
import os
from linkpair.device import Device
from linkpair.port import Port
from linkpair.collect.agent.base_agent import BaseAgent


class LinuxVlanAgent(BaseAgent):

    '''
    Linux VLAN Collector Agent
    '''

    def run(self):
        self.pick_vlan_configuration()

    def pick_vlan_configuration(self):
        vlan_config_file = "/proc/net/vlan/config"
        vlan_configs = self._runner.exec_cmd("cat " + vlan_config_file)
        for if_line in vlan_configs[2:]:
            if_line = if_line.rstrip()
            if self._u.d_push(re.match(r'^(\S+)\s*\|\s*(\S+)\s*\|\s*(\S+)', if_line)) is not None:
                match = self._u.d_pop()
                vlan_if_name = match.group(1)
                vlan_vid = match.group(2)
                vlan_master_if = match.group(3)
                port_meta = {
                    "vlan_vid": vlan_vid, "vlan_master_if": vlan_master_if}
                self._cu.add_port(Port(
                    vlan_if_name, Port.DEFAULT_TYPE, port_meta))
