# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

import re
from linkpair.device import Device
from linkpair.port import Port
from linkpair.linkpair import LinkPair
from linkpair.collect.agent.base_agent import BaseAgent


class NamespaceAgent(BaseAgent):

    '''network Namespace

    This class gets the network namespace information from ip command
    '''

    def run(self):
        self.map_port_to_namespace()

    def map_port_to_namespace(self):
        result = self._runner.exec_cmd("ip netns")
    # if result....
        for ns in result:
            ns = ns.rstrip()
            result2 = self._runner.exec_cmd(
                "ip netns exec " + ns + " ip link show")
            for linkpair_out in result2:
                linkpair_out = linkpair_out.rstrip()
                match = re.match(r'\d+: (.*?): ', linkpair_out)
                if match is not None and match.group(1) != 'lo':
                    self._iface_to_nss[match.group(1).rstrip()] = ns
