# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from linkobject import LinkObject


class Device(LinkObject):
    DEFAULT_TYPE = 1
    VM_TYPE = 2
    BR_TYPE = 3
    OS_ROUTE_TYPE = 4
    PHYNET_TYPE = 5
    NAMESPACE_TYPE = 6
    NOT_CONNECTED_TYPE = 7

    def __init__(self, label, device_type=DEFAULT_TYPE, metadata={}):
        self.label = label
        self.device_type = device_type
        self.metadata = metadata

    def __repr__(self):
        return "{\"label\":\"" + self.label + \
            "\",\"device_type\":\"" + repr(self.device_type) + \
            "\",\"meta\":" + self._blank_dict(self.metadata) + "}"
