# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#


class LinkObject(object):
    DEFAULT_TYPE = 1

    def __init__(self, label, metadata={}):
        self.label = label
        self.metadata = metadata

    @apply
    def label():
        def get(label):
            return self.label

        def set(self, label):
            self.label = label

    @apply
    def metadata():
        def get(self):
            return self.metadata

        def set(self, metadata):
            self.metadata = metadata

    @apply
    def attr():
        def get(self, attr):
            return self.metadata[attr]

        def set(self, attr, attr_value):
            self.metadata[attr] = attr_value

    def __str__(self):
        return self.label

    def __repr__(self):
        return "{\"label\":\"" + self.label + \
            "\",\"meta\":" + self._blank_dict(self.metadata) + "}"

    def _blank_dict(self, dict_object):
        if len(dict_object) > 0:
            return self._dict_to_json(dict_object)
        else:
            return "{ \"NOT_SPECIFIED\":\"1\" }"

    def _dict_to_json(self, dict_object):
        json_strings = "{"
        for dict_key in dict_object.keys():
            json_strings += "\"" + dict_key + \
                "\":\"" + dict_object[dict_key] + "\","
        json_strings = json_strings.rstrip(",") + "}"
        return json_strings

    def __add__(self, label):
        return self.label + label
