# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from linkobject import LinkObject


class Port(LinkObject):
    DEFAULT_TYPE = 1

    def __init__(self, label, port_type=DEFAULT_TYPE, metadata={}):
        self.label = label
        self.port_type = port_type
        self.metadata = metadata

    def __repr__(self):
        return "{\"label\":\"" + self.label + \
            "\",\"port_type\":\"" + repr(self.port_type) + \
            "\",\"meta\":" + self._blank_dict(self.metadata) + "}"
