# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

from __future__ import print_function
import re
import sys


class CommonUtils(object):

    def __init__(self):
        self._tmp_stack = []

    def set_opts(self, opts):
        self._opts = opts

    def d_push(self, x):
        self._tmp_stack.append(x)
        return x

    def d_pop(self):
        return self._tmp_stack.pop()

    def verbose_out(self, msg):
        if hasattr(self, '_opts') and self._opts.verbose is True:
            print("[verbose]: " + msg, file=sys.stderr)

    def debug_out(self, msg):
        if hasattr(self, '_opts') and self._opts.debug is True:
            print("[debug]: " + msg, file=sys.stderr)

    def warn_out(self, msg):
        print("[warn]: " + msg, file=sys.stderr)

    def error_out(self, msg):
        print("[error]: " + msg, file=sys.stderr)

    def message_out(self, msg):
        print(msg)

    def parse_remote_desc(self, remote_desc):
        ssh_username = ""
        ssh_hostname = ""
        ssh_hostport = 22

        if remote_desc is not None:
            if self.d_push(re.match(r'(.+?)@(.+?):(.+)', remote_desc)):
                user_info = self.d_pop()
                ssh_username = user_info.group(1)
                ssh_hostname = user_info.group(2)
                ssh_hostport = int(user_info.group(3))
            elif self.d_push(re.match(r'(.+?)@(.+)', remote_desc)):
                user_info = self.d_pop()
                ssh_username = user_info.group(1)
                ssh_hostname = user_info.group(2)
                ssh_hostport = 22
        return [ssh_username, ssh_hostname, ssh_hostport]

    def str_join(self, base, added, sep):
        if base is None or base == "":
            return added
        else:
            return base + sep + added
