<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  2013 NPO CCC-TIES <info@cccties.org>
 * @author Codia <system.info@codia.co.jp>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
**/

    require_once("../../config.php");
// edit by Codia (2013/05/31)
    require_once($CFG->dirroot."/auth/shibboleth_ties/auth.php");
// end

    //initialize variables
    $errormsg = '';

/// Check for timed out sessions
    if (!empty($SESSION->has_timed_out)) {
        $session_has_timed_out = true;
        $SESSION->has_timed_out = false;
    } else {
        $session_has_timed_out = false;
    }


//HTTPS is required in this page when $CFG->loginhttps enabled
$PAGE->https_required();

/// Define variables used in page
    $site = get_site();

    $loginsite = get_string("loginsite");

    $loginurl = (!empty($CFG->alternateloginurl)) ? $CFG->alternateloginurl : '';


    if (!empty($CFG->registerauth) or is_enabled_auth('none') or !empty($CFG->auth_instructions)) {
        $show_instructions = true;
    } else {
        $show_instructions = false;
    }

    // Set SAML domain cookie
// edit by Codia (2013/05/31)
    $config = get_config('auth/shibboleth_ties');

    $organizationSelection = (isset($config->organization_selection)) ? $config->organization_selection: '';
    
    $IdPs = get_idp_list4shibboleth_ties($organizationSelection);
    if (isset($_POST['idp']) && isset($IdPs[$_POST['idp']])){
        $selectedIdP = $_POST['idp'];
        set_saml_cookie4shibboleth_ties($selectedIdP);

        // Redirect to SessionInitiator with entityID as argument
        if (isset($IdPs[$selectedIdP][1]) && !empty($IdPs[$selectedIdP][1])) {
            // For Shibbolet 1.x Service Providers
            header('Location: '.$IdPs[$selectedIdP][1].'?providerId='. urlencode($selectedIdP) .'&target='. urlencode($CFG->httpswwwroot.'/auth/shibboleth_ties/index.php'));

            // For Shibbolet 2.x Service Providers
            // header('Location: '.$IdPs[$selectedIdP][1].'?entityID='. urlencode($selectedIdP) .'&target='. urlencode($CFG->httpswwwroot.'/auth/shibboleth_ties/index.php'));

        } else {
            // For Shibbolet 1.x Service Providers
            header('Location: /Shibboleth.sso?providerId='. urlencode($selectedIdP) .'&target='. urlencode($CFG->httpswwwroot.'/auth/shibboleth_ties/index.php'));

            // For Shibboleth 2.x Service Providers
            // header('Location: /Shibboleth.sso/DS?entityID='. urlencode($selectedIdP) .'&target='. urlencode($CFG->httpswwwroot.'/auth/shibboleth_ties/index.php'));
        }
    } elseif (isset($_POST['idp']) && !isset($IdPs[$_POST['idp']]))  {
        $errormsg = get_string('auth_shibboleth_ties_errormsg', 'auth_shibboleth_ties');
    }

    $loginsite = get_string("loginsite");

    $PAGE->set_url('/auth/shibboleth_ties/login.php');
    $PAGE->navbar->add($loginsite);
    @$PAGE->set_title("$site->fullname: $loginsite");
    $PAGE->set_heading($site->fullname);
    $PAGE->set_pagelayout('login');
// end

    echo $OUTPUT->header();
    include("index_form.html");
    echo $OUTPUT->footer();


