/*
    mdi
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MISC_MDI_H__
#define __MISC_MDI_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MISC_TYPE_MDI            (misc_mdi_get_type ())
#define MISC_MDI(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MISC_TYPE_MDI, MiscMdi))
#define MISC_MDI_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), MISC_TYPE_MDI, MiscMdiClass))
#define MISC_IS_MDI(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MISC_TYPE_MDI))
#define MISC_IS_MDI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MISC_TYPE_MDI))
#define MISC_MDI_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MISC_TYPE_MDI, MiscMdiClass))


typedef struct _MiscMdi      MiscMdi;
typedef struct _MiscMdiClass MiscMdiClass;
typedef struct _MiscMdiTab   MiscMdiTab;

struct _MiscMdi
{
  /*< private >*/
  GtkNotebook parent_instance;

  /*< public >*/

  /*< private >*/
  GtkTooltips *tooltips;
};

struct _MiscMdiClass
{
  GtkNotebookClass parent_class;

  /* -- signals -- */
  void (*add_window) (MiscMdi  *notebook,
			          guint     page_num,
                      gpointer *page_data);
  void (*change_window) (MiscMdi  *notebook,
			             guint     page_num,
                         gpointer *page_data);
  void (*close_window) (MiscMdi  *notebook,
			            guint     page_num,
                        gpointer *page_data);
  void (*remove_window) (MiscMdi  *notebook,
			             guint     page_num,
                         gpointer *page_data);
  void (*switch_window) (MiscMdi  *notebook,
			             guint     page_num,
                         gpointer *page_data);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
misc_mdi_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:更新関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
misc_mdi_new (void);


/*  ja:ページを最後に追加する
          mdi,ウィジェット
        child,内容
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
          RET,ページ(0...,-1:エラー)                                        */
#define misc_mdi_append_page(mdi,child,file,created,page_data)              \
            misc_mdi_insert_page_menu(mdi,child,NULL,-1,file,created,page_data)


/*  ja:ページを最後に追加する
          mdi,ウィジェット
        child,内容
         menu,メニュー
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
          RET,ページ(0...,-1:エラー)                                        */
#define misc_mdi_append_page_menu(mdi,child,menu,file,created,page_data)    \
            misc_mdi_insert_page_menu(mdi,child,menu,-1,file,created,page_data)


/*  ja:ページを最初に追加する
          mdi,ウィジェット
        child,内容
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
          RET,ページ(0...,-1:エラー)                                        */
#define misc_mdi_prepend_page(mdi,child,file,created,page_data)             \
            misc_mdi_insert_page_menu(mdi,child,NULL,0,file,created,page_data)


/*  ja:ページを最初に追加する
          mdi,ウィジェット
        child,内容
         menu,メニュー
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
          RET,ページ(0...,-1:エラー)                                        */
#define misc_mdi_prepend_page_menu(mdi,child,menu,file,created,page_data)   \
            misc_mdi_insert_page_menu(mdi,child,menu,0,file,created,page_data)


/*  ja:ページを挿入する
          mdi,ウィジェット
        child,内容
     position,位置(0...)
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
       RET,ページ(0...,-1:エラー)                                           */
#define misc_mdi_insert_page(mdi,child,position,file,created,page_data)     \
    misc_mdi_insert_page_menu(mdi,child,NULL,position,file,created,page_data)


/*  ja:ページを挿入する
          mdi,ウィジェット
        child,内容
         menu,メニュー
     position,位置(0...)
         file,ファイル名
      created,TRUE:新規作成,FALSE:既存ファイル
    page_data,ページデータ
       RET,ページ(0...,-1:エラー)                                           */
gint
misc_mdi_insert_page_menu (MiscMdi     *mdi,
                           GtkWidget   *child,
                           GtkWidget   *menu,
                           gint         position,
                           const gchar *file,
                           gboolean     created,
                           gpointer     page_data);


/*  ja:ページ数を取得する
    mdi,ウィジェット
    RET,ページ数                                                            */
#if GLIB_CHECK_VERSION(2,2,0)
# define misc_mdi_get_n_pages(mdi) gtk_notebook_get_n_pages(GTK_NOTEBOOK(mdi))
#else /* not GLIB_CHECK_VERSION(2,2,0) */
gint
misc_mdi_get_n_pages (MiscMdi *mdi);
#endif /* not GLIB_CHECK_VERSION(2,2,0) */


/*  ja:ページをデータから取得する
          mdi,ウィジェット
    page_data,ページデータ
          RET,ページ(0...),-1:なし                                          */
gint
misc_mdi_get_page_from_data (MiscMdi  *mdi,
                             gpointer  page_data);


/*  ja:ページデータを取得する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
         RET,ページデータ                                                   */
gpointer
misc_mdi_get_data (MiscMdi *mdi,
                   gint     page_num);


/*  ja:ページデータを設定する
           mdi,ウィジェット
      page_num,ページ(0...),-1:カレント
     page_data,ページデータ
           RET,TRUE:正常終了,FALSE:エラー                                   */
gboolean
misc_mdi_set_data (MiscMdi *mdi,
                   gint     page_num,
                   gpointer page_data);


/*  ja:ページのファイル名を取得する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
         RET,ファイル名,NULL:エラー                                         */
const gchar *
misc_mdi_get_file (MiscMdi *mdi,
                   gint     page_num);


/*  ja:ページのファイル名を設定する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
        file,ファイル名
         RET,TRUE:正常終了,FALSE:エラー                                     */
gboolean
misc_mdi_set_file (MiscMdi     *mdi,
                   gint         page_num,
                   const gchar *file);


/*  ja:ページの作成状態を取得する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
         RET,TRUE:新規作成,FALSE:既存ファイル                               */
gboolean
misc_mdi_get_created (MiscMdi *mdi,
                      gint     page_num);


/*  ja:ページの作成状態を設定する
          mdi,ウィジェット
     page_num,ページ(0...),-1:カレント
    is_create,TRUE:新規作成,FALSE:既存ファイル
          RET,TRUE:正常終了,FALSE:エラー                                    */
gboolean
misc_mdi_set_created (MiscMdi  *mdi,
                      gint      page_num,
                      gboolean  is_create);


/*  ja:ページの編集状態を取得する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
         RET,TRUE:編集済み,FALSE:未編集                                     */
gboolean
misc_mdi_get_edited (MiscMdi *mdi,
                     gint     page_num);


/*  ja:ページの編集状態を設定する
         mdi,ウィジェット
    page_num,ページ(0...),-1:カレント
     is_edit,TRUE:編集済み,FALSE:未編集
         RET,TRUE:正常終了,FALSE:エラー                                     */
gboolean
misc_mdi_set_edited (MiscMdi  *mdi,
                     gint      page_num,
                     gboolean  is_edit);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MISC_MDI_H__ */
