/*
    Text maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "abort.h"


gboolean userbreak;


/******************************************************************************
*                                                                             *
* ja:中断関数群                                                               *
*                                                                             *
******************************************************************************/
/* ja:中断ボタンが押された */
static void
abort_dialog_clicked (GtkWidget *widget,
                      gpointer   user_data)
{
  userbreak = FALSE;
}


/*  ja:中断ダイアログ表示
    label,説明文                                                            */
GtkWidget *
abort_dialog (const gchar *label)
{
  GtkWidget *dialog,*button;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Abort"));
  g_signal_connect (G_OBJECT (dialog), "delete-event",
                                                G_CALLBACK (gtk_true), NULL);
  /* ja:ボタン */
  button = gtk_button_new_with_label (label);
  g_signal_connect (G_OBJECT (button), "clicked",
                                    G_CALLBACK (abort_dialog_clicked), NULL);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

  /* ja:フレームとボックス */
  gtk_container_set_border_width (GTK_CONTAINER (button), SPACING);
  gtk_container_add (GTK_CONTAINER (dialog), button);

  /* ja:表示 */
  gtk_widget_grab_focus (button);

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);

  return dialog;
}
