/*
    history
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <tchar.h>
#include "dialog.h"
#include "fndir.h"
#include "history.h"
#include <commctrl.h>


#define IDC_EDIT1           101
#define IDC_UPDOWN1         102


/******************************************************************************
*                                                                             *
* ja:t@C̗֐                                                       *
*                                                                             *
******************************************************************************/
static BOOL CALLBACK
HistoryDlgProc (HWND   hDlg,
                UINT   uMsg,
                WPARAM wParam,
                LPARAM lParam)
{
  static int *lpnHistory;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        lpnHistory = (LPINT)lParam;
        /* ja:GfBgRg[̐ݒ */
        SendDlgItemMessage (hDlg, IDC_EDIT1, EM_LIMITTEXT, 2, 0);
        if (!SetDlgItemInt (hDlg, IDC_EDIT1, *lpnHistory, TRUE))
          {
            EndDialog (hDlg, IDCANCEL);
            return TRUE;
          }
        /* ja:Abv_ERg[̐ݒ */
        SendDlgItemMessage (hDlg, IDC_UPDOWN1, UDM_SETRANGE,
                                                        0, MAKELPARAM (9, 0));
        if (!EnableDlgItem (hDlg, IDOK, FALSE))
          EndDialog (hDlg, IDCANCEL);
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              *lpnHistory = GetDlgItemInt (hDlg, IDC_EDIT1, NULL, TRUE);
            case IDCANCEL:
              EndDialog (hDlg, LOWORD (wParam));
              return TRUE;
            case IDC_EDIT1:
              {
                int s;

                if (HIWORD (wParam) != EN_CHANGE)
                  return TRUE;
                s = GetDlgItemInt (hDlg, IDC_EDIT1, NULL, TRUE);
                EnableDlgItem (hDlg, IDOK, 0 <= s && s <= 9);
              }
          }
        return TRUE;
    }
  return FALSE;
}


/*  ja:t@C̗ɉ
     lpszFile,t@C
         hWnd,EChE
     nHistory,ő嗚
     nMenuTop,gbvj[̍ڐ
    nMenuFile,t@C̍ڂ̐
          RET,TRUE:I,FALSE:G[                                    */
BOOL
SetHistory (LPCTSTR   lpszFile,
            HWND      hWnd,
            const int nHistory,
            const int nMenuTop,
            const int nMenuFile)
{
  int i, s;
  HMENU hMenu;
  TCHAR szName[MAXPATH + 3];

  if (nHistory <= 0)
    return TRUE;
  hMenu = GetMenu (hWnd);
  if (!hMenu || !(hMenu = GetSubMenu (hMenu,
                                        GetMenuItemCount (hMenu) != nMenuTop)))
    return FALSE;
  s = GetMenuItemCount (hMenu);
  for (i = 0; i < s - nMenuFile - 1; i++)
    {
      GetMenuString (hMenu, i + nMenuFile - 1,
                                        szName, MAXPATH + 2, MF_BYPOSITION);
      if (CompareString (LOCALE_USER_DEFAULT, NORM_IGNORECASE,
                                            lpszFile, -1, szName + 3, -1) == 2)
        {
          if (!DeleteMenu (hMenu, i + nMenuFile - 1, MF_BYPOSITION))
            return FALSE;
          s--;
          break;
        }
      szName[1] = (TCHAR)(i + '2');
      if (!ModifyMenu (hMenu, i + nMenuFile - 1,
                                            MF_BYPOSITION, i + 201, szName))
        return FALSE;
    }
  lstrcpy (szName, _T("&1 "));
  lstrcat (szName, lpszFile);
  return (InsertMenu (hMenu, nMenuFile - 1, MF_BYPOSITION, 200, szName)
                            && (s != nMenuFile || InsertMenu (hMenu, nMenuFile,
                                        MF_BYPOSITION | MF_SEPARATOR, 0, NULL))
                            && (s != nHistory + nMenuFile + 1
                                || DeleteMenu (hMenu, s - 2, MF_BYPOSITION))
                            && DrawMenuBar (hWnd));
}


/*  ja:t@C̗擾
    lpszFile,t@C
        hWnd,EChE
       uItem,R}h
         RET,TRUE:I,FALSE:G[                                     */
BOOL
GetHistory (LPTSTR lpszFile,
            HWND   hWnd,
            UINT   uItem)
{
  HMENU hMenu;
  TCHAR szName[MAXPATH + 3];

  hMenu = GetMenu (hWnd);
  if (!hMenu)
    return FALSE;
  GetMenuString (hMenu, uItem, szName, MAXPATH + 2, 0);
  lstrcpy (lpszFile, szName + 3);
  return TRUE;
}


/*  ja:ő嗚𐔂ύX
         hWnd,eEChE
     nHistory,ő嗚
     nMenuTop,gbvj[̍ڐ
    nMenuFile,t@C̍ڂ̐
          RET,TRUE:I,FALSE:G[                                    */
BOOL
ModifyHistory (HWND      hWnd,
               const int nHistory,
               const int nMenuTop,
               const int nMenuFile)
{
  int i, s;
  HMENU hMenu;

  hMenu = GetMenu (hWnd);
  if (!hMenu || !(hMenu = GetSubMenu (hMenu,
                                        GetMenuItemCount (hMenu) != nMenuTop)))
    return FALSE;
  s = GetMenuItemCount (hMenu);
  for (i = s - 3; i > nHistory - (nHistory == 0) + nMenuFile - 2; i--)
    if (!DeleteMenu (hMenu, i, MF_BYPOSITION))
      return FALSE;
  return DrawMenuBar (hWnd);
}


/*  ja:ő嗚𐔂ύX
             hInst,CX^Xnh
    lpTemplateName,ev[g
              hWnd,eEChE
        lpnHistory,ő嗚
          nMenuTop,gbvj[̍ڐ
         nMenuFile,t@C̍ڂ̐
               RET,TRUE:I,FALSE:G[                               */
BOOL
ModifyHistoryDlg (HINSTANCE  hInst,
                  LPCTSTR    lpTemplateName,
                  HWND       hWnd,
                  int       *lpnHistory,
                  const int  nMenuTop,
                  const int  nMenuFile)
{
  int nHistory;

  nHistory = *lpnHistory;
  if (DialogBoxParamGUI (hInst, lpTemplateName,
                            hWnd, HistoryDlgProc, (LPARAM)&nHistory) == IDOK)
    {
      *lpnHistory = nHistory;
      return ModifyHistory (hWnd, *lpnHistory, nMenuTop, nMenuFile);
    }
  return TRUE;
}
