/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __GENERAL_H__
#define __GENERAL_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:ʊ֐Q                                                               *
*                                                                             *
******************************************************************************/
/*  ja:Lbg̕`
    hWnd,EChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
DrawCaret (HWND hWnd);


/*  ja:j[ݒ肷
    ptw,TXTEChE
    RET,TRUE:I,FALSE:G[                                          */
BOOL
SetMenuBar (LPTEXTWND ptw);


/*  ja:w͈͂ĕ`悷
         hWnd,EChE
    lpptStart,Jn
      lpptEnd,I
          RET,TRUE:I,FALSE:G[                                    */
BOOL
ClearSel (HWND    hWnd,
          LPPOINT lpptStart,
          LPPOINT lpptEnd);


/*  ja:ړ
       hWnd,EChE
    lpptTop,Â̍W
        RET,TRUE:I,FALSE:G[                                      */
BOOL
MoveTextWindow (HWND    hWnd,
                LPPOINT lpptTop);


/*  ja:LbgʒuɃf[^}/㏑
        hWnd,EChE
    lpszText,f[^i[|C^
     nLength,f[^̃oCg
      fCaret,TRUE:ړ,FALSE:ړȂ
     fSelect,TRUE:I,FALSE:IȂ
         RET,t̑sDOING\,NULL:G[                          */
LPDOING
EditOperation (HWND  hWnd,
               LPSTR lpszText,
               int   nLength,
               BOOL  fCaret,
               BOOL  fSelect);


/*  ja:Xg폜
    lpDo,Xg̐擪
     RET,폜Xg̐                                                 */
int
DeleteList (DOING **lpDo);


/*  ja:E}[WŐ܂Ԃ
    ptw,TXTEChE
    RET,TRUE:I,FALSE:G[                                          */
BOOL
ModifyMargin (LPTEXTWND ptw);


/*  ja:vpeBύX
       hWnd,EChE
    lpFType,t@C^Cv
        RET,TRUE:I,FALSE:G[                                      */
BOOL
ChangeProperty (HWND       hWnd,
                LPFILETYPE lpFType);


BOOL CALLBACK
PropertyEnumProc (HWND   hWnd,
                  LPARAM lParam);


/*  ja:WXg֏                                                 */
VOID
RegWrite (VOID);


/******************************************************************************
*                                                                             *
* ja:x֐Q                                                           *
*                                                                             *
******************************************************************************/
/*  ja:ҏW𑀍
     hWnd,EChE
    fKind,TRUE:redo,FALSE:undo
      RET,TRUE:I,FALSE:G[                                        */
BOOL
HistoryOperation (HWND hWnd,
                  BOOL fKind);


/*  ja:E}[Wŉs
    hWnd,EChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
MarginOperation (HWND hWnd);


/*  ja:^uXy[Xɕϊ
    hWnd,EChE
     RET,TRUE:I,FALSE:G[                                         */
BOOL
TabOperation (HWND hWnd);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GENERAL_H__ */
