/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "version.h"
#include "dialog.h"
#include "license.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:o[W֐Q                                                     *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
HelpDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  if (uMsg == WM_COMMAND)
    {
      switch (LOWORD (wParam))
        {
          case IDCANCEL:
            if (!EndDialog (hDlg, LOWORD (wParam)))
              MessageBox (hDlg, _T("EndDialog"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            return TRUE;
          case IDC_PUSHBUTTONF1:
            DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_1),
                                        hDlg, LicensedDlgProc, (LPARAM)hInst);
        }
      return TRUE;
    }
  return FALSE;
}
