/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "ftype.h"


/******************************************************************************
*                                                                             *
* ե륿פؿ                                                  *
*                                                                             *
******************************************************************************/
static gboolean ftype_clicked_ok;
static gint ftpos;
static GtkWidget *button0;


static void ftype_dialog_select(GtkWidget *widget,gint pos)
{
	ftpos=pos;
	gtk_widget_set_sensitive(button0,TRUE);
}


static void ftype_dialog_deselect(GtkWidget *widget,gint pos)
{
	if (!ftype_clicked_ok) {
		ftpos=-1;
		gtk_widget_set_sensitive(button0,FALSE);
	}
}


static void ftype_dialog_clicked_ok(GtkWidget *widget,GtkWidget *dialog)
{
	ftype_clicked_ok=TRUE;
    gtk_widget_destroy(dialog);
}


/* ESC줿 */
static gboolean ftype_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean ftype_dialog(gint *pos)
{
	gint i;
	GtkWidget *dialog,*label,*list,*item,*scroll,*hbox,*vbox,*button1;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("ե륿פɤ߹"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(ftype_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* ܥ */
	button0=gtk_button_new_with_label(_("λ"));
	button1=gtk_button_new_with_label(_(""));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
											ftype_dialog_clicked_ok,dialog);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* ٥ */
	label=gtk_label_new(_("ϿƤե륿"));
	gtk_misc_set_alignment(GTK_MISC(label),0,.5);/*  */
	/* ꥹȥܥå */
	list=gtk_list_new();
	for (i=0;i<ftnum;i++) {
		item=gtk_list_item_new_with_label(ftype[i].text);
		gtk_container_add(GTK_CONTAINER(list),item);
		gtk_signal_connect(GTK_OBJECT(item),"select",
											ftype_dialog_select,(gpointer)i);
		gtk_signal_connect(GTK_OBJECT(item),"deselect",
											ftype_dialog_deselect,(gpointer)i);
	}
	/* 륦ɥ */
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
									GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll),list);
	/* ܥå */
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),scroll,TRUE,TRUE,0);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox,TRUE,TRUE,8);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,8);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_grab_focus(button1);
	ftpos=-1;
	ftype_clicked_ok=FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	if (ftype_clicked_ok)
		*pos=ftpos;
	return ftype_clicked_ok;
}
