/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __TMAID_H__
#define __TMAID_H__


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <gtk/gtk.h>
#include "intl.h"


#define MENUFILE 10
#define iskanji(ch) (((ch)&0x80)!=0)


typedef struct ftype {
	gchar *text,*ext,*fontname;
	gboolean backup,code,crlf,eof,grid,limit,overwrite,space,mline,uline,vline;
	gint margin,tab;
	GdkColor color[12];
} FTYPE;
typedef struct doing {
	gint length;					/*  */
	gboolean caret;
	gchar *text;
	GdkPoint cursor,select;
	struct doing *next;
} DOING;
typedef struct linebuf {
	gboolean margin;			/* TRUE:E}[W,FALSE:ʏ̉s */
	gchar *text;
	gint length;				/*  */
	struct linebuf *prev,*next;
} LINEBUF;
typedef struct textwnd {
	gchar *file;
	gchar *fontname;
	gboolean create;
	gboolean edit;
	gboolean backup,code,crlf,eof,grid,limit,overwrite,space,mline,uline,vline;
	gint fontsize;
	gint fontascent;
	gint margin;				/* E}[W̐ */
	gint max;
	gint off;
	gint same;
	gint tab;					/* ^u̐ */
	guint timer_id;				/* XN[p^C} */
	DOING *undo,*redo;
	LINEBUF *start;
	GdkIC *ic;
	GdkICAttr *ic_attr;
	GdkPoint top;				/* EChE̐擪 */
	GdkPoint cursor;			/* Lbg̈ʒu */
	GdkPoint select;			/* IJnʒu,-1:IȂ */
	GtkWidget *drawing;
	GtkWidget *hscroll;
	GtkWidget *vscroll;
	GtkWidget *menu_item;
	GdkColor color[12];
	GdkFont *font;
	GtkItemFactory *item_factory;	/* j[(ANZ[^[p) */
} TEXTWND;


enum {
	TARGET_STRING,
	TARGET_TEXT,
	TARGET_COMPOUND_TEXT
};


extern gboolean newfile;				/* TRUE:VKt@C,FALSE:Ȃ */
extern gboolean caret;					/* Lbǧ` */
extern gboolean ins;					/* TRUE:},FALSE:㏑ */
extern gboolean has_selection;			/* TRUE:L,FALSE:Ȃ */
extern gchar *clipboard_text;			/* Nbv{[h̃eLXg */
extern gchar *hisfile[10];				/* t@C̗ */
extern gint ftnum;						/* t@C^Cv̐ */
extern gint history;					/* t@C̗ */
extern gint def_width,def_height;		/* ftHg̃EChẼTCY */
extern guint timer_id;					/* ^C}ID */
extern FTYPE *ftype;					/* t@C^Cv */
extern GdkAtom clipboard_atom;			/* Nbv{[h */
extern GtkWidget *window;				/* EChE */
extern GtkWidget *notebook;				/* m[gubN */
extern GtkWidget *status;				/* Xe[^XEChE */
extern GtkItemFactory *item_factory;	/* j[ */


#endif
