/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <string.h>
#include "abort.h"
#include "command.h"
#include "edit.h"
#include "fileop.h"
#include "find.h"
#include "general.h"
#include "jump.h"
#include "other.h"
#include "prop.h"
#include "replace.h"
#include "repinfo.h"
#include "signal.h"
#include "valchr.h"


/******************************************************************************
*                                                                             *
* ˥塼ؿ                                                              *
*                                                                             *
******************************************************************************/
void command_new(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	open_edit_file(NULL);
}


static gchar *command_open_file;


static void command_open_ok(GtkWidget *widget,GtkWidget *dialog)
{
	command_open_file=g_strdup(gtk_file_selection_get_filename(
												GTK_FILE_SELECTION(dialog)));
    gtk_widget_destroy(dialog);
}


void command_open(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	GtkWidget *dialog;

	command_open_file=NULL;
	dialog=gtk_file_selection_new(_("ե򳫤"));
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(dialog)->ok_button),
										"clicked",command_open_ok,dialog);
	gtk_signal_connect_object(
						GTK_OBJECT(GTK_FILE_SELECTION(dialog)->cancel_button),
							"clicked",gtk_widget_destroy,GTK_OBJECT(dialog));
	gtk_widget_show(dialog);
	gtk_grab_add(dialog);
	gtk_main();
	if (command_open_file!=NULL) {
		open_edit_file(command_open_file);
		g_free(command_open_file);
	}
}


void command_save(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *text;
	TEXTWND *ptw;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	if (ptw->create) {
		command_saveas(callback_data,callback_action,widget);
	} else {
		text=g_strdup_printf(
				_("%s\nΥեϤǤ¸ߤޤ\n\n񤭤ޤ?"),
																	ptw->file);
		if ((!ptw->overwrite || !isfile(ptw->file)
			|| message_box("Text maid",text,1,_("Ϥ"),_(""),NULL)==0)
											&& save_text_file(ptw->file,ptw)) {
			ptw->edit=FALSE;
			if (delete_list(&ptw->undo)+delete_list(&ptw->redo)>0)
				set_menu_bar(ptw);
		}
	}
}


void command_saveas(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *text,*label;
	GList *glist;
	TEXTWND *ptw;
	GtkWidget *dialog,*sub_menu,*menu_item,*child;

	child=gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)));
	ptw=gtk_object_get_user_data(GTK_OBJECT(child));
	command_open_file=NULL;
	dialog=gtk_file_selection_new(_("̾դ¸"));
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(dialog)->ok_button),
										"clicked",command_open_ok,dialog);
	gtk_signal_connect_object(
						GTK_OBJECT(GTK_FILE_SELECTION(dialog)->cancel_button),
							"clicked",gtk_widget_destroy,GTK_OBJECT(dialog));
	if (!ptw->create)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(dialog),ptw->file);
	gtk_widget_show(dialog);
	gtk_grab_add(dialog);
	gtk_main();
	if (command_open_file!=NULL) {
		text=g_strdup_printf(
				_("%s\nΥեϤǤ¸ߤޤ\n\n񤭤ޤ?"),
															command_open_file);
		if ((!ptw->overwrite || !isfile(command_open_file)
			|| message_box("Text maid",text,1,_("Ϥ"),_(""),NULL)==0)
									&& save_text_file(command_open_file,ptw)) {
			/* ե̾Ĵ٤ */
			delete_edit_file(ptw->file);
			ptw->file[0]='\0';
			label=add_edit_file(command_open_file,&ptw->same);
			gtk_notebook_set_tab_label_text(GTK_NOTEBOOK(notebook),
																child,label);
			g_free(label);
			/* ɥ˥塼 */
			menu_item=gtk_menu_item_new_with_label(command_open_file);
			sub_menu=gtk_item_factory_get_widget(item_factory,
													_("<main>/ɥ(W)"));
			glist=gtk_container_children(GTK_CONTAINER(sub_menu));
			gtk_menu_insert(GTK_MENU(sub_menu),menu_item,
										g_list_index(glist,ptw->menu_item));
			g_list_free(glist);
			gtk_container_remove(GTK_CONTAINER(sub_menu),ptw->menu_item);
			ptw->menu_item=menu_item;
			gtk_widget_show(ptw->menu_item);
			/*  */
			ptw->create=ptw->edit=FALSE;
			g_free(ptw->file);
			ptw->file=g_strdup(command_open_file);
			delete_list(&ptw->undo);
			delete_list(&ptw->redo);
			set_menu_bar(ptw);
			set_history(ptw->file);
		}
		g_free(command_open_file);
	}
}


void command_reload(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *text;
	gint result=0;
	LINEBUF *p;
	TEXTWND *ptw;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	if (ptw->edit) {
		text=g_strdup_printf(_("ե %s ƤѹƤޤ\n"
								"¸Ƥ֤ᤷޤ?"),ptw->file);
		result=message_box("Text maid",text,1,_("Ϥ"),_(""),NULL);
		g_free(text);
	}
	if (result==0) {
		/* Хåե */
		while (ptw->start->prev!=NULL)
			ptw->start=ptw->start->prev;
		while (ptw->start!=NULL) {
			p=ptw->start->next;
			if (ptw->start->text!=NULL)
				g_free(ptw->start->text);
			g_free(ptw->start);
			ptw->start=p;
		}
		/* ɤ߹ */
		open_text_file(ptw);
		delete_list(&ptw->undo);
		delete_list(&ptw->redo);
		ptw->cursor.x=ptw->cursor.y=ptw->top.x=ptw->top.y=0;
		ptw->edit=FALSE;
		set_scroll_bar(ptw->hscroll,signal_value_changed_hscroll,ptw,
					0,get_width_max(ptw),
					MAX(ptw->drawing->allocation.width/ptw->fontsize,1),
																ptw->top.x);
		set_scroll_bar(ptw->vscroll,signal_value_changed_vscroll,ptw,
					0,ptw->max-1,
					MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1),
																ptw->top.y);
		set_menu_bar(ptw);
		draw_caret(ptw,NULL);
		gtk_widget_draw(ptw->drawing,NULL);
	}
}


void command_property(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gboolean modify;
	gint i,fontsize,lbearing,rbearing,width,ascent,descent;
	gint max,sx,sy;
	FTYPE ft;
	GdkRectangle rc;
	TEXTWND *ptw;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	ft.margin=ptw->margin;
	ft.tab=ptw->tab;
	ft.code=ptw->code;
	ft.crlf=ptw->crlf;
	ft.eof=ptw->eof;
	ft.limit=ptw->limit;
	ft.overwrite=ptw->overwrite;
	ft.space=ptw->space;
	ft.gline=ptw->gline;
	ft.mline=ptw->mline;
	ft.uline=ptw->uline;
	ft.vline=ptw->vline;
	ft.fontname=g_strdup(ptw->fontname);
	memcpy(ft.color,ptw->color,sizeof(GdkColor)*12);
	ft.text=ft.ext=NULL;
	if (property_dialog(&ft)) {
		if (ptw->limit!=ft.limit || ptw->tab!=ft.tab
									|| (ptw->code && ptw->margin!=ft.margin)) {
			/* ޤ֤ѹֿѹ */
			delete_list(&ptw->undo);
			delete_list(&ptw->redo);
		}
		modify=ptw->limit!=ft.limit || (ptw->limit
							&& (ptw->tab!=ft.tab || ptw->margin!=ft.margin));
		ptw->margin=ft.margin;
		ptw->tab=ft.tab;
		ptw->code=ft.code;
		ptw->crlf=ft.crlf;
		ptw->eof=ft.eof;
		ptw->limit=ft.limit;
		ptw->overwrite=ft.overwrite;
		ptw->space=ft.space;
		ptw->gline=ft.gline;
		ptw->mline=ft.mline;
		ptw->uline=ft.uline;
		ptw->vline=ft.vline;
		g_free(ptw->fontname);
		ptw->fontname=ft.fontname;
		memcpy(ptw->color,ft.color,sizeof(GdkColor)*12);
		ptw->select.x=-1;
		if (modify) {
			/* ޤ֤ѹޤ֤ͭǥֿѹ */
			ptw->cursor.x=ptw->cursor.y=ptw->top.x=ptw->top.y=0;
			modify_margin(ptw);
		}
		/* ե */
		gdk_font_unref(ptw->font);
		ptw->font=gdk_fontset_load(ptw->fontname);
		ptw->fontascent=ptw->fontsize=0;
		for (i=0x20;i<=0x7e;i++) {
			gdk_text_extents(ptw->font,(gchar *)&i,1,
								&lbearing,&rbearing,&width,&ascent,&descent);
			if (ptw->fontascent<ascent)
				ptw->fontascent=ascent;
			fontsize=(gdk_char_height(ptw->font,i)+1)/2;
			if (ptw->fontsize<fontsize)
				ptw->fontsize=fontsize;
		}
		/* С */
		sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
		sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
		if (ptw->top.y>ptw->max-sy)
			ptw->top.y=MAX(ptw->max-sy,0);
		max=get_width_max(ptw);
		if (ptw->top.x>max-sx+1)
			ptw->top.x=MAX(max-sx+1,0);
#ifdef USE_XIM
		if (gdk_im_ready() && ptw->ic!=NULL
					&& (gdk_ic_get_style(ptw->ic)&GDK_IM_PREEDIT_POSITION)) {
			ptw->ic_attr->preedit_fontset=ptw->font;
			gdk_ic_set_attr(ptw->ic,ptw->ic_attr,GDK_IC_PREEDIT_FONTSET);
		}
#endif
		set_scroll_bar(ptw->hscroll,signal_value_changed_hscroll,ptw,
												0,max,sx,ptw->top.x);
		set_scroll_bar(ptw->vscroll,signal_value_changed_vscroll,ptw,
												0,ptw->max-1,sy,ptw->top.y);
		/*  */
		rc.x=rc.y=0;
		rc.width=ptw->drawing->allocation.width;
		rc.height=ptw->drawing->allocation.height;
		gtk_widget_draw(ptw->drawing,&rc);
		draw_caret(ptw,NULL);
	} else {
		g_free(ft.fontname);
	}
}


void command_close(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint page;
	TEXTWND *ptw;

	if ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		ptw=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
		if (prompt_close(ptw))
			gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),page);
	}
}


void command_exit(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint page;
	TEXTWND *ptw;

	while ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		ptw=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
		if (!prompt_close(ptw))
			return;
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),page);
	}
	gtk_object_destroy(GTK_OBJECT(window));
}


void command_undo(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	TEXTWND *ptw;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	history_operation(ptw,FALSE);
}


void command_redo(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	TEXTWND *ptw;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	history_operation(ptw,TRUE);
}


void command_cut(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	command_copy(callback_data,callback_action,widget);
	command_delete(callback_data,callback_action,widget);
}


void command_copy(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint length;
	TEXTWND *ptw;

	if (gtk_selection_owner_set(window,clipboard_atom,GDK_CURRENT_TIME)) {
		ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
		g_free(clipboard_text);
		length=get_sel_byte(&ptw->start,&ptw->off,
										&ptw->select,&ptw->cursor,ptw->tab);
		clipboard_text=g_malloc((length+1)*sizeof(gchar));
		cpy_sel_mem(&ptw->start,&ptw->off,
							&ptw->select,&ptw->cursor,ptw->tab,clipboard_text);
		clipboard_text[length]='\0';
	}
}


void command_paste(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
    gtk_selection_convert(window,clipboard_atom,
					gdk_atom_intern("COMPOUND_TEXT",FALSE),GDK_CURRENT_TIME);
}


void command_delete(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	DOING *d;
	TEXTWND *ptw;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	d=edit_operation(ptw,NULL,0,TRUE,FALSE);
	d->next=ptw->undo;
	ptw->undo=d;
	set_menu_bar(ptw);
	ptw->edit=TRUE;
}


void command_margin(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	TEXTWND *ptw;

	if (message_box("Text maid",_("ޡǲԤޤ?"),1,
											_("Ϥ"),_(""),NULL)==0) {
		ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
		margin_operation(ptw);
	}
}


void command_tab(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	TEXTWND *ptw;

	if (message_box("Text maid",_("֤򥹥ڡѴޤ?"),1,
											_("Ϥ"),_(""),NULL)==0) {
		ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
		tab_operation(ptw);
	}
}


void command_valchr(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar valchr;
	DOING *d;
	TEXTWND *ptw;
	GdkPoint select;

	if (valchr_dialog(&valchr)) {
		ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
		select=ptw->select;
		d=edit_operation(ptw,&valchr,1,TRUE,FALSE);
		d->next=ptw->undo;
		ptw->undo=d;
		if (delete_list(&ptw->redo)>0 || d->next==NULL || select.x>=0)
			set_menu_bar(ptw);
		ptw->edit=TRUE;
	}
}


void command_jump(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint sx,sy;
	JMPDLG jmp;
	TEXTWND *ptw;
	GdkPoint cursor,select,top;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	jmp.max=ptw->max-1;
	jmp.cursor=ptw->cursor.y;
	if (jump_dialog(&jmp) && ptw->cursor.y!=jmp.cursor) {
		cursor=ptw->cursor;
		select=ptw->select;
		top=ptw->top;
		sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
		sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
		ptw->cursor.y=jmp.cursor;
		if (ptw->cursor.x<ptw->top.x)
			ptw->top.x=ptw->cursor.x;
		else if (ptw->cursor.x-sx+1>ptw->top.x)
			ptw->top.x=ptw->cursor.x-sx+1;
		if (ptw->cursor.y<ptw->top.y)
			ptw->top.y=ptw->cursor.y;
		else if (ptw->cursor.y-sy+1>ptw->top.y)
			ptw->top.y=ptw->cursor.y-sy+1;
		move_text_window(ptw,&top);
		if (ptw->select.x>=0) {
			if (ptw->select.y==ptw->cursor.y
						&& ptw->select.x==get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE)) {
				ptw->select.x=-1;
				clear_sel(ptw,&select,&cursor);
				set_menu_bar(ptw);
			} else {
				clear_sel(ptw,&ptw->cursor,&cursor);
			}
		}
		draw_caret(ptw,&cursor);
	}
}


void command_all(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint sx,sy;
	GdkPoint top;
	TEXTWND *ptw;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	if (ptw->max<=1 && ptw->start->length<=0)
		return;
	top=ptw->top;
	sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
	sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
	ptw->select.x=ptw->select.y=0;
	ptw->cursor.x=get_width(&ptw->start,&ptw->off,
											ptw->cursor.y=ptw->max-1,ptw->tab);
	if (ptw->cursor.x<ptw->top.x)
		ptw->top.x=ptw->cursor.x;
	else if (ptw->cursor.x-sx+1>ptw->top.x)
		ptw->top.x=ptw->cursor.x-sx+1;
	if (ptw->cursor.y<ptw->top.y)
		ptw->top.y=ptw->cursor.y;
	else if (ptw->cursor.y-sy+1>ptw->top.y)
		ptw->top.y=ptw->cursor.y-sy+1;
	set_menu_bar(ptw);
	if (ptw->top.x!=top.x)
		set_scroll_bar(ptw->hscroll,signal_value_changed_hscroll,ptw,
										0,get_width_max(ptw),sx,ptw->top.x);
	if (ptw->top.y!=top.y)
		set_scroll_bar(ptw->vscroll,signal_value_changed_vscroll,ptw,
										0,ptw->max-1,sy,ptw->top.y);
	gtk_widget_draw(ptw->drawing,NULL);
}


void command_find(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *text;
	gint i;
	FIND fd;
	TEXTWND *ptw;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	fd.text=NULL;
	fd.arrow=find_arrow;
	fd.ignorecase=find_ignorecase;
	if (ptw->select.x>=0) {
		if (ptw->select.y<ptw->cursor.y
			|| (ptw->select.y==ptw->cursor.y && ptw->select.x<ptw->cursor.x))
				fd.arrow=FALSE;
			else
				fd.arrow=TRUE;
	}
	if (find_dialog(&fd)) {
		set_menu_bar(ptw);
		find_arrow=fd.arrow;
		find_ignorecase=fd.ignorecase;
		for (i=0;i<find_num;i++)
			if (strcmp(fd.text,find_text[i])==0)
					break;
		if (i==find_num) {
			if (find_num>=32)
				g_free(find_text[31]);
			else
				find_num++;
			memmove(find_text+1,find_text,(find_num-1)*sizeof(gchar *));
			find_text[0]=fd.text;
		} else {
			g_free(fd.text);
			text=find_text[i];
			memmove(find_text+1,find_text,i*sizeof(gchar *));
			find_text[0]=text;
		}
		command_next(callback_data,callback_action,widget);
	}
}


void command_next(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *text;
	TEXTWND *ptw;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	find_operation(ptw,&ptw->cursor,&ptw->select,find_text[0],
					callback_action==0?find_arrow:!find_arrow,find_ignorecase);
	if (userbreak && ptw->select.x<0) {
		text=g_strdup_printf(_("'%s'Ĥޤ"),find_text[0]);
		message_box("Text maid",text,0,_("λ"),NULL);
		g_free(text);
		set_menu_bar(ptw);
	}
}


void command_replace(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gboolean replace=FALSE;
	gchar *text;
	gint i,bytes,count=0,datapos,result;
	DOING *d;
	TEXTWND *ptw;
	REPINFO ri;
	REPLACE rp;
	GdkPoint select;

	ptw=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	rp.src=rp.dst=NULL;
	rp.arrow=replace_arrow;
	rp.ignorecase=replace_ignorecase;
	if (ptw->select.x>=0) {
		if (ptw->select.y<ptw->cursor.y
			|| (ptw->select.y==ptw->cursor.y && ptw->select.x<ptw->cursor.x))
				rp.arrow=FALSE;
			else
				rp.arrow=TRUE;
	}
	result=replace_dialog(&rp);
	if (result>=0) {
		set_menu_bar(ptw);
		replace_arrow=rp.arrow;
		replace_ignorecase=rp.ignorecase;
		for (i=0;i<find_num;i++)
			if (strcmp(rp.src,find_text[i])==0)
					break;
		if (i==find_num) {
			if (find_num>=32)
				g_free(find_text[31]);
			else
				find_num++;
			memmove(find_text+1,find_text,(find_num-1)*sizeof(gchar *));
			find_text[0]=rp.src;
		} else {
			g_free(rp.src);
			text=find_text[i];
			memmove(find_text+1,find_text,i*sizeof(gchar *));
			find_text[0]=text;
		}
		if (rp.dst[0]!='\0') {
			for (i=0;i<replace_num;i++)
				if (strcmp(rp.dst,replace_text[i])==0)
						break;
			if (i==replace_num) {
				if (replace_num>=32)
					g_free(replace_text[31]);
				else
					replace_num++;
				memmove(replace_text+1,replace_text,
											(replace_num-1)*sizeof(gchar *));
				replace_text[0]=rp.dst;
			} else {
				g_free(rp.dst);
				text=replace_text[i];
				memmove(replace_text+1,replace_text,i*sizeof(gchar *));
				replace_text[0]=text;
			}
		}
		select=ptw->select;
		ri.arrow=replace_arrow;
		ri.ignorecase=replace_ignorecase;
		ri.dst=replace_text[0];
		do {
			find_operation(ptw,&ptw->cursor,&ptw->select,find_text[0],
											replace_arrow,replace_ignorecase);
			if (ptw->select.x<0)
				break;
			replace=TRUE;
			bytes=get_sel_byte(&ptw->start,&ptw->off,
										&ptw->select,&ptw->cursor,ptw->tab);
			if (result<=1) {
				ri.src=g_malloc(bytes+1);
				cpy_sel_mem(&ptw->start,&ptw->off,
									&ptw->select,&ptw->cursor,ptw->tab,ri.src);
				ri.src[bytes]='\0';
				ri.start=ptw->select;
				ri.end=ptw->cursor;
				result=repinfo_dialog(&ri);
				g_free(ri.src);
				if (result<=0)
					continue;
			}
			if (select.x>=0 && ptw->cursor.y==select.y && replace_arrow)
				datapos=get_data_pos(&ptw->start,&ptw->off,
											select.x,select.y,ptw->tab,FALSE);
			else
				datapos=-1;
			d=edit_operation(ptw,replace_text[0],strlen(replace_text[0]),
														replace_arrow,TRUE);
			if (datapos>=0)
				select.x=get_screen_pos(&ptw->start,&ptw->off,
							datapos+strlen(rp.dst)-bytes,select.y,ptw->tab);
			if (result>1)
				count++;
			d->next=ptw->undo;
			ptw->undo=d;
			if (delete_list(&ptw->redo)>0 || d->next==NULL)
				set_menu_bar(ptw);
			ptw->edit=TRUE;
		} while (result>=0);
		if (!replace) {
			text=g_strdup_printf(_("'%s'Ĥޤ"),find_text[0]);
			message_box("Text maid",text,0,_("λ"),NULL);
			g_free(text);
		} else if (result>1) {
			text=g_strdup_printf(_("%dĤʸִޤ"),count);
			message_box("Text maid",text,0,_("λ"),NULL);
			g_free(text);
		}
		set_menu_bar(ptw);
	}
}
