/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <ctype.h>
#include <locale.h>
#include <stdlib.h>
#include "tmaid.h"
#include "command.h"
#include "conf.h"
#include "fileop.h"
#include "find.h"
#include "format.h"
#include "general.h"
#include "other.h"
#include "profile.h"
#include "replace.h"
#include "signal.h"
#include "toolbar.h"
#include "version.h"


gboolean caret=FALSE;				/* åȤη */
gboolean ins=TRUE;					/* TRUE:,FALSE: */
gboolean has_selection=FALSE;		/* TRUE:ͭ,FALSE:ʤ */
gboolean newfile=FALSE;				/* TRUE:ե,FALSE:ʤ */
gchar *hisfile[10];					/* ե */
gchar *clipboard_text=NULL;			/* åץܡɤΥƥ */
gint ftnum=0;						/* ե륿פο */
gint history=4;						/* ե */
gint def_width,def_height;			/* ǥեȤΥɥΥ */
guint timer_id=0;					/* ID */
FTYPE *ftype=NULL;					/* ե륿 */
GdkAtom clipboard_atom;				/* åץܡ */
GtkWidget *window;					/* ɥ */
GtkWidget *notebook;				/* Ρȥ֥å */
GtkWidget *status;					/* ơɥ */
GtkItemFactory *item_factory_menu;	/* ˥塼 */
GtkItemFactory *item_factory_popup;	/* ݥåץå */


GtkItemFactoryEntry menu_items[]={
{N_("/ե(_F)"),                               NULL,         NULL,            0,"<Branch>"},
{N_("/ե(F)/(_N)"),                   "<control>N", command_new,     0,"<Item>"},
{N_("/ե(F)/(_O)..."),                    "<control>O", command_open,    0,"<Item>"},
{N_("/ե(F)/Ĥ(_C)"),                     "<control>W", command_close,   0,"<Item>"},
{N_("/ե(F)/¸(_S)"),                 "<control>S", command_save,    0,"<Item>"},
{N_("/ե(F)/̾Ĥ¸(_A)..."),        NULL,         command_saveas,  0,"<Item>"},
{N_("/ե(F)/¸Ƥ֤᤹(_R)..."),"<control>R", command_reload,  0,"<Item>"},
{N_("/ե(F)/Sep1"),                           NULL,         NULL,            0,"<Separator>"},
{N_("/ե(F)/ץѥƥ(_I)..."),              "<alt>Return",command_property,0,"<Item>"},
{N_("/ե(F)/Sep2"),                           NULL,         NULL,            0,"<Separator>"},
{N_("/ե(F)/λ(_X)"),                       "<control>Q", command_exit,    0,"<Item>"},
{N_("/Խ(_E)"),                                   NULL,         NULL,            0,"<Branch>"},
{N_("/Խ(E)/᤹(_U)"),                       "<control>Z", command_undo,    0,"<Item>"},
{N_("/Խ(E)/ľ(_R)"),                       "F4",         command_redo,    0,"<Item>"},
{N_("/Խ(E)/Sep1"),                               NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/ڤ(_T)"),                       "<control>X", command_cut,     0,"<Item>"},
{N_("/Խ(E)/ԡ(_C)"),                         "<control>C", command_copy,    0,"<Item>"},
{N_("/Խ(E)/Žդ(_P)"),                       "<control>V", command_paste,   0,"<Item>"},
{N_("/Խ(E)/(_L)"),                           NULL,         command_delete,  0,"<Item>"},
{N_("/Խ(E)/Sep2"),                               NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/ޡǲԤ(_M)"),           NULL,         command_margin,  0,"<Item>"},
{N_("/Խ(E)/֤򥹥ڡѴ(_B)"),       NULL,         command_tab,     0,"<Item>"},
{N_("/Խ(E)/Sep3"),                               NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/ʸ(_W)..."),              NULL,         command_valchr,  0,"<Item>"},
{N_("/Խ(E)/Ԥذư(_J)..."),                "<control>J", command_jump,    0,"<Item>"},
{N_("/Խ(E)/Sep4"),                               NULL,         NULL,            0,"<Separator>"},
{N_("/Խ(E)/٤(_A)"),                     "<control>A", command_all,     0,"<Item>"},
{N_("/(_S)"),                                   NULL,         NULL,            0,"<Branch>"},
{N_("/(S)/(_F)..."),                        "<control>F", command_find,    0,"<Item>"},
{N_("/(S)/򸡺(_N)"),                       "F3",         command_next,    0,"<Item>"},
{N_("/(S)/դ򸡺(_B)"),                       "<shift>F3",  command_next,    1,"<Item>"},
{N_("/(S)/ִ(_R)..."),                        "<control>H", command_replace, 0,"<Item>"},
{N_("/ץ(_O)"),                             NULL,         NULL,            0,"<Branch>"},
{N_("/ץ(O)/(_C)..."),                  NULL,         conf_dialog,     0,"<Item>"},
{N_("/ץ(O)/ե륿(_T)..."),        NULL,         format_dialog,   0,"<Item>"},
{N_("/ɥ(_W)"),                             NULL,         NULL,            0,"<Branch>"},
{N_("/إ(_H)"),                                 NULL,         NULL,            0,"<Branch>"},
{N_("/إ(H)/С(_A)..."),            NULL,         version_dialog,  0,"<Item>"}};


/******************************************************************************
*                                                                             *
* ᥤؿ                                                                  *
*                                                                             *
******************************************************************************/
int main(int argc,char *argv[])
{
	gboolean *arg_files;
	gchar *arg,*endptr,*str,*section=NULL,*key=NULL;
	gint i,j,k,opt;
	gint init_line=0;					/* ΥåȰ */
	PROFILE *profile;
	TEXTWND *ptw;
	GdkBitmap *mask;
	GdkPixmap *pixmap;
	GtkAccelGroup *accel_group;
	GtkWidget *menubar,*toolbar,*sub_menu,*menu_item,*vbox;
	GdkColor color[12]={{0,0x0000,0x0000,0x0000},{0,0xffff,0xffff,0xffff},
						{0,0x8000,0x8000,0x8000},{0,0x8000,0x8000,0x8000},
						{0,0x8000,0x8000,0x8000},{0,0x8000,0x8000,0x8000},
						{0,0x8000,0x8000,0x8000},{0,0xa000,0xa000,0xa000},
						{0,0xffff,0xffff,0xffff},{0,0x0000,0x0000,0x8000},
						{0,0x0000,0x0000,0x0000},{0,0x8000,0x8000,0x8000}};
	GtkItemFactoryEntry popup_items[]={
		{N_("/᤹(_U)"),  "<control>Z",command_undo,  0,"<Item>"},
		{N_("/Sep1"),          NULL,        NULL,          0,"<Separator>"},
		{N_("/ڤ(_T)"),  "<control>X",command_cut,   0,"<Item>"},
		{N_("/ԡ(_C)"),    "<control>C",command_copy,  0,"<Item>"},
		{N_("/Žդ(_P)"),  "<control>V",command_paste, 0,"<Item>"},
		{N_("/(_L)"),      NULL,        command_delete,0,"<Item>"},
		{N_("/Sep2"),          NULL,        NULL,          0,"<Separator>"},
		{N_("/٤(_A)"),"<control>A",command_all,   0,"<Item>"}};
	GtkTargetEntry drag_types[1]={{"text/uri-list",0,0}};
	/* Text maid󶡲ǽʥ쥯 */
	GtkTargetEntry targets[]={
	{"STRING",       0,TARGET_STRING},
	{"TEXT",         0,TARGET_TEXT}, 
	{"COMPOUND_TEXT",0,TARGET_COMPOUND_TEXT}};
	/* ޥɥ饤  */
	struct arg_opt {
		const char *name;
		const int key;
		const char *arg;
		const char *doc;
	};
	const struct arg_opt arg_opts[]={
	{"history",'h',"NUM",         N_("ե")},
	{"line",   'l',"NUM",         N_("ΥåȰ")},
	{"new",    'n',"ON/OFF",      N_("ե򳫤")},
	{"size",   's',"WIDTH,HEIGHT",N_("ɥΥ")},
	{"version",'v',NULL,          N_("С")},
	{"help",   '?',NULL,          N_("إ")},
	{NULL,     0,  NULL,          NULL}};

	/*  */
	setlocale(LC_ALL,"");
	bindtextdomain(PACKAGE,LOCALEDIR);
	textdomain(PACKAGE);
	gtk_set_locale();
	gtk_init(&argc,&argv);

	def_width=gdk_screen_width()*2/3;
	def_height=gdk_screen_height()*2/3;
	memset(hisfile,0,sizeof(gchar *)*10);
	/* 쥸ȥ꤫ɤ߽Ф */
	if ((profile=profile_open(".tmaid"))!=NULL) {
		if (!profile_get_value(profile,"tmaid","ftnum",
				(gpointer)&ftnum,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			ftnum=0;
		if (!profile_get_value(profile,"tmaid","history",
				(gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			history=4;
		if (!profile_get_value(profile,"tmaid","newfile",
				(gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
			newfile=FALSE;
		if (!profile_get_value(profile,"tmaid","def_width",
				(gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			def_width=gdk_screen_width()*2/3;
		if (!profile_get_value(profile,"tmaid","def_height",
				(gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			def_height=gdk_screen_height()*2/3;
		/* ե */
		for (i=0;i<history;i++) {
			key=g_strdup_printf("history%d",i);
			hisfile[i]=profile_get_string(profile,"tmaid",key);
			g_free(key);
			if (hisfile[i]==NULL)
				break;
			if (*hisfile[i]=='\0') {
				g_free(hisfile[i]);
				hisfile[i]=NULL;
				break;
			}
		}
		/*  */
		if (!profile_get_value(profile,"tmaid","find_arrow",
								(gpointer)&find_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			find_arrow=TRUE;
		if (!profile_get_value(profile,"tmaid","find_ignorecase",
								(gpointer)&find_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			find_ignorecase=FALSE;
		if (!profile_get_value(profile,"tmaid","find_num",
					(gpointer)&find_num,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			find_num=0;
		for (i=0;i<find_num;i++) {
			key=g_strdup_printf("find%02d",i);
			find_text[i]=profile_get_string(profile,"tmaid",key);
			g_free(key);
			if (find_text[i]==NULL)
				break;
		}
		find_num=i;
		/* ִ */
		if (!profile_get_value(profile,"tmaid","replace_arrow",
								(gpointer)&replace_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			replace_arrow=TRUE;
		if (!profile_get_value(profile,"tmaid","replace_ignorecase",
								(gpointer)&replace_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			replace_ignorecase=FALSE;
		if (!profile_get_value(profile,"tmaid","replace_num",
				(gpointer)&replace_num,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			replace_num=0;
		for (i=0;i<replace_num;i++) {
			key=g_strdup_printf("replace%02d",i);
			replace_text[i]=profile_get_string(profile,"tmaid",key);
			g_free(key);
			if (replace_text[i]==NULL)
				break;
		}
		replace_num=i;
		/* ե륿 */
		if (ftnum>0)
			ftype=g_malloc(ftnum*sizeof(FTYPE));
		for (i=0;i<ftnum;i++) {
			section=g_strdup_printf("filetype%04d",i);
			if ((ftype[i].text
							=profile_get_string(profile,section,"text"))==NULL)
				ftype[i].text=g_strdup("UNKNOW");
			if ((ftype[i].ext
							=profile_get_string(profile,section,"ext"))==NULL)
				ftype[i].ext=g_strdup("*");
			if (!profile_get_value(profile,section,"margin",
								(gpointer)&ftype[i].margin,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
				ftype[i].margin=80;
			if (!profile_get_value(profile,section,"tab",
								(gpointer)&ftype[i].tab,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
				ftype[i].tab=8;
			if (!profile_get_value(profile,section,"code",
								(gpointer)&ftype[i].code,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].code=FALSE;
			if (!profile_get_value(profile,section,"crlf",
								(gpointer)&ftype[i].crlf,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].crlf=FALSE;
			if (!profile_get_value(profile,section,"eof",
								(gpointer)&ftype[i].eof,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].eof=FALSE;
			if (!profile_get_value(profile,section,"limit",
								(gpointer)&ftype[i].limit,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].limit=FALSE;
			if (!profile_get_value(profile,section,"overwrite",
								(gpointer)&ftype[i].overwrite,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].overwrite=FALSE;
			if (!profile_get_value(profile,section,"space",
								(gpointer)&ftype[i].space,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].space=FALSE;
			if (!profile_get_value(profile,section,"gline",
								(gpointer)&ftype[i].gline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].gline=FALSE;
			if (!profile_get_value(profile,section,"mline",
								(gpointer)&ftype[i].mline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].mline=FALSE;
			if (!profile_get_value(profile,section,"uline",
								(gpointer)&ftype[i].uline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].uline=FALSE;
			if (!profile_get_value(profile,section,"vline",
								(gpointer)&ftype[i].vline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].vline=FALSE;
			/* ե */
			if ((ftype[i].fontname
							=profile_get_string(profile,section,"font"))==NULL)
				ftype[i].fontname=g_strdup(
							"-*-*-*-r-normal-*-16-*-*-*-*-*-iso8859-1,"
							"-*-*-*-r-normal-*-16-*-*-*-*-*-jisx0208.1983-0");
			/*  */
			if (!profile_get_value(profile,section,"color",
								(gpointer)&ftype[i].color,sizeof(GdkColor)*12,
													PROFILE_VALUE_TYPE_ARRAY))
				memcpy(ftype[i].color,color,sizeof(GdkColor)*12);
			g_free(section);
		}
		profile_close(profile);
	}

	/* ޥɥ饤β */
	arg_files=g_malloc(argc*sizeof(gboolean));
	memset(arg_files,0,argc*sizeof(gboolean));
	for (i=1;i<argc;i++) {
		if ((argv[i])[0]=='-') {/* ץ */
			if ((argv[i])[1]=='-') {	/* Ĺץ */
				opt=0;
				for (j=0;arg_opts[j].name!=NULL;j++)
					if (g_strncasecmp(argv[i]+2,arg_opts[j].name,
						MIN(strlen(argv[i])-2,strlen(arg_opts[j].name)))==0) {
						opt=arg_opts[j].key;
						break;
					}
			} else {					/* ûץ */
				opt=tolower((argv[i])[1]);
			}
			arg=NULL;
			for (j=0;arg_opts[j].name!=NULL;j++)
				if (arg_opts[j].key==opt && arg_opts[j].arg!=NULL) {
					for (k=2;(argv[i])[k]!='\0' && (argv[i])[k]!='=';k++);
					arg=(argv[i])[k]=='\0'?argv[++i]:argv[i]+k+1;
					if (arg==NULL || *arg=='\0')
						opt='?';
					break;
				}
			switch (opt) {
				case 'h':
					strval(&history,arg,10,TRUE);
					if (history<0)
						history=0;
					else if (history>10)
						history=10;
					break;
				case 'l':
					strval(&init_line,arg,10,TRUE);
					break;
				case 'n':
					newfile=g_strcasecmp(arg,"OK")==0
												|| g_strcasecmp(arg,"TRUE")==0
												|| g_strcasecmp(arg,"YES")==0;
					break;
				case 's':
					def_height=strtol(arg,&endptr,0);
					def_width=strtol(++endptr,&endptr,0);
					break;
				case 'v':
					g_print(
"Text maid "VERSION"\n"
"Copyright (C) 1998-2002 Iwamoto,Kazuki\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"
					);
					g_free(arg_files);
					return 0;
				default:
					g_print(
"Copyright (c) 1998-2002 Iwamoto,Kazuki\n\n"
"Usage: %s [OPTION...] [FILE...]\n\n",argv[0]);
					for (i=0;arg_opts[i].name;i++) {
						if (arg_opts[i].arg!=NULL)
							str=g_strdup_printf("  -%c, --%s=%s",
											arg_opts[i].key,arg_opts[i].name,
															arg_opts[i].arg);
						else
							str=g_strdup_printf("  -%c, --%s",
											arg_opts[i].key, arg_opts[i].name);
						g_print("%-26s %s\n",str,arg_opts[i].doc);
						g_free(str);
					}
					g_print("\n");
					g_free(arg_files);
					return 0;
			}
		} else {/* ե */
			arg_files[i]=TRUE;
		}
	}

	/* ե륿 */
	if (ftnum<=0) {
		ftnum=2;
		ftype=g_malloc(ftnum*sizeof(FTYPE));
		ftype[0].text=g_strdup(_("ƥȥե"));
		ftype[0].ext=g_strdup(".txt");
		ftype[1].text=g_strdup(_("٤ƤΥե"));
		ftype[1].ext=g_strdup("*");
		ftype[0].margin=ftype[1].margin=80;
		ftype[0].tab=ftype[1].tab=8;
		ftype[0].code=ftype[1].code=FALSE;
		ftype[0].crlf=ftype[1].crlf=FALSE;
		ftype[0].eof=ftype[1].eof=FALSE;
		ftype[0].limit=ftype[1].limit=FALSE;
		ftype[0].overwrite=ftype[1].overwrite=FALSE;
		ftype[0].space=ftype[1].space=FALSE;
		ftype[0].gline=ftype[1].gline=FALSE;
		ftype[0].mline=ftype[1].mline=FALSE;
		ftype[0].uline=ftype[1].uline=FALSE;
		ftype[0].vline=ftype[1].vline=FALSE;
		/* ե */
		ftype[0].fontname=g_strdup("-*-*-*-r-normal-*-16-*-*-*-*-*-iso8859-1,"
							"-*-*-*-r-normal-*-16-*-*-*-*-*-jisx0208.1983-0");
		ftype[1].fontname=g_strdup("-*-*-*-r-normal-*-16-*-*-*-*-*-iso8859-1,"
							"-*-*-*-r-normal-*-16-*-*-*-*-*-jisx0208.1983-0");
		/*  */
		memcpy(ftype[0].color,color,sizeof(GdkColor)*12);
		memcpy(ftype[1].color,color,sizeof(GdkColor)*12);
	}

	/* ᥤ󥦥ɥ */
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window),"Text maid");
	gtk_window_set_default_size(GTK_WINDOW(window),def_width,def_height);
	gtk_signal_connect(GTK_OBJECT(window),"delete-event",
										GTK_SIGNAL_FUNC(signal_delete),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"destroy",
												signal_destroy_window,NULL);
	gtk_widget_show(window);
	/* Drag and Drop */
	gtk_drag_dest_set(window,GTK_DEST_DEFAULT_MOTION
						| GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
												drag_types,1,GDK_ACTION_COPY);
	gtk_signal_connect(GTK_OBJECT(window),"drag_data_received",
						    GTK_SIGNAL_FUNC(signal_drag_data_received),NULL);
	/* åץܡ */
	clipboard_atom=gdk_atom_intern("CLIPBOARD",FALSE);
	gtk_selection_add_targets(window,GDK_SELECTION_PRIMARY,
							targets,sizeof(targets)/sizeof(GtkTargetEntry));
	gtk_selection_add_targets(window,clipboard_atom,
							targets,sizeof(targets)/sizeof(GtkTargetEntry));
	gtk_signal_connect(GTK_OBJECT(window),"selection-clear-event",
								GTK_SIGNAL_FUNC(signal_selection_clear),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"selection-get",
											signal_selection_get,NULL);
	gtk_signal_connect(GTK_OBJECT(window),"selection-received",
											signal_selection_received,NULL);
	/* Ρȥ֥å */
	notebook=gtk_notebook_new();
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook),TRUE);
	gtk_signal_connect(GTK_OBJECT(notebook),"switch-page",
								GTK_SIGNAL_FUNC(signal_switch_page),NULL);
	gtk_signal_connect(GTK_OBJECT(notebook),"destroy",
								GTK_SIGNAL_FUNC(signal_destroy_notebook),NULL);
	/* ݥåץå */
	accel_group=gtk_accel_group_new();
	item_factory_popup=gtk_item_factory_new(GTK_TYPE_MENU,"<main>",accel_group);
	gtk_item_factory_create_items(item_factory_popup,
			sizeof(popup_items)/sizeof(GtkItemFactoryEntry),popup_items,NULL);
	/* ˥塼 */
	accel_group=gtk_accel_group_new();
	item_factory_menu=gtk_item_factory_new(GTK_TYPE_MENU_BAR,
														"<main>",accel_group);
	gtk_item_factory_create_items(item_factory_menu,
			sizeof(menu_items)/sizeof(GtkItemFactoryEntry),menu_items,NULL);
	gtk_accel_group_attach(accel_group,GTK_OBJECT(window));
	menubar=gtk_item_factory_get_widget(item_factory_menu,"<main>");
	/* ġС */
	toolbar=gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_ICONS);
	for (i=0;i<18;i++)
		if (toolbar_items[i].name==NULL) {
			gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
		} else {
			pixmap=gdk_pixmap_create_from_xpm_d(window->window,
											&mask,NULL,toolbar_items[i].xpm);
			toolbar_items[i].item=gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
						NULL,toolbar_items[i].name,NULL,
						gtk_pixmap_new(pixmap,mask),
						toolbar_items[i].callback,toolbar_items[i].user_data);
		}
	/* ơС */
	status=gtk_statusbar_new();
	/* ľܥå */
	vbox=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	gtk_box_pack_start(GTK_BOX(vbox),menubar,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),toolbar,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),notebook,TRUE,TRUE,0);
	gtk_box_pack_end(GTK_BOX(vbox),status,FALSE,FALSE,0);
	/* ե */
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,
													_("<main>/ե(F)"));
	for (i=0;i<history && hisfile[i]!=NULL;i++) {
		menu_item=gtk_menu_item_new_with_label(hisfile[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),"activate",
					GTK_SIGNAL_FUNC(signal_activate_menu_history),hisfile[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),"destroy",
					GTK_SIGNAL_FUNC(signal_destroy_menu_history),hisfile[i]);
		gtk_object_set_user_data(GTK_OBJECT(menu_item),hisfile[i]);
		gtk_menu_insert(GTK_MENU(sub_menu),menu_item,i+MENUFILE-1);
	}
	if (i!=0)
		gtk_menu_insert(GTK_MENU(sub_menu),gtk_menu_item_new(),i+MENUFILE-1);
	/*  */
	timer_id=gtk_timeout_add(500,signal_timeout,NULL);

	/* ˥塼ɽ */
	set_menu_bar(NULL);

	/* ɽ */
	gtk_widget_show_all(window);
	gtk_window_set_policy(GTK_WINDOW(window),TRUE,TRUE,TRUE);

	/* ɥ */
	for (i=1;i<argc;i++)
		if (arg_files[i]) {
			ptw=open_edit_file(argv[i]);
			if (init_line!=0)	/* Ԥ˰ư */
				jump_operation(ptw,init_line);
			newfile=FALSE;
		}
	g_free(arg_files);
	if (newfile)
		open_edit_file(NULL);

	gtk_main();

	/* 쥸ȥ˽񤭹 */
	if ((profile=profile_open(".tmaid"))!=NULL) {
		profile_set_value(profile,"tmaid","ftnum",
				(gpointer)&ftnum,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","history",
				(gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","newfile",
				(gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","def_width",
				(gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","def_height",
				(gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		/* ե */
		for (i=0;i<history && hisfile[i]!=NULL;i++) {
			key=g_strdup_printf("history%d",i);
			profile_set_value(profile,"tmaid",key,(gpointer)hisfile[i],
										(strlen(hisfile[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<10) {
			key=g_strdup_printf("history%d",i++);
			profile_set_value(profile,"tmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		/*  */
		profile_set_value(profile,"tmaid","find_arrow",
								(gpointer)&find_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","find_ignorecase",
								(gpointer)&find_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","find_num",
				(gpointer)&find_num,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		for (i=0;i<find_num;i++) {
			key=g_strdup_printf("find%02d",i);
			profile_set_value(profile,"tmaid",key,(gpointer)find_text[i],
										(strlen(find_text[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<32) {
			key=g_strdup_printf("find%02d",i++);
			profile_set_value(profile,"tmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		/* ִ */
		profile_set_value(profile,"tmaid","replace_arrow",
								(gpointer)&replace_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","replace_ignorecase",
								(gpointer)&replace_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","replace_num",
				(gpointer)&replace_num,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		for (i=0;i<replace_num;i++) {
			key=g_strdup_printf("replace%02d",i);
			profile_set_value(profile,"tmaid",key,(gpointer)replace_text[i],
									(strlen(replace_text[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<32) {
			key=g_strdup_printf("replace%02d",i++);
			profile_set_value(profile,"tmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		/* ե륿 */
		for (i=0;i<ftnum;i++) {
			section=g_strdup_printf("filetype%04d",i);
			profile_set_value(profile,section,"text",(gpointer)ftype[i].text,
									(strlen(ftype[i].text)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			profile_set_value(profile,section,"ext",(gpointer)ftype[i].ext,
									(strlen(ftype[i].ext)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			profile_set_value(profile,section,"margin",
								(gpointer)&ftype[i].margin,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
			profile_set_value(profile,section,"tab",
								(gpointer)&ftype[i].tab,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
			profile_set_value(profile,section,"code",
								(gpointer)&ftype[i].code,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"crlf",
								(gpointer)&ftype[i].crlf,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"eof",
								(gpointer)&ftype[i].eof,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"limit",
								(gpointer)&ftype[i].limit,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"overwrite",
								(gpointer)&ftype[i].overwrite,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"space",
								(gpointer)&ftype[i].space,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"gline",
								(gpointer)&ftype[i].gline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"mline",
								(gpointer)&ftype[i].mline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"uline",
								(gpointer)&ftype[i].uline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"vline",
								(gpointer)&ftype[i].vline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			/* ե */
			profile_set_value(profile,section,"font",
								(gpointer)ftype[i].fontname,
								(strlen(ftype[i].fontname)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			/*  */
			profile_set_value(profile,section,"color",
								(gpointer)&ftype[i].color,sizeof(GdkColor)*12,
													PROFILE_VALUE_TYPE_ARRAY);
		}
		do {
			g_free(section);
			section=g_strdup_printf("filetype%04d",i++);
		} while (profile_delete_section(profile,section));
		g_free(section);
		profile_close(profile);
	}
	for (i=0;i<find_num;i++)
		g_free(find_text[i]);
	for (i=0;i<replace_num;i++)
		g_free(replace_text[i]);
	for (i=0;i<history;i++)
		g_free(hisfile[i]);
	for (i=0;i<ftnum;i++) {
		g_free(ftype[i].text);
		g_free(ftype[i].ext);
		g_free(ftype[i].fontname);
	}
	g_free(ftype);
	g_free(clipboard_text);

	return 0;
}
