/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "command.h"
#include "edit.h"
#include "find.h"
#include "general.h"
#include "other.h"
#include "signal.h"
#include "toolbar.h"


/******************************************************************************
*                                                                             *
* ̴ؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	åȤä
	ptw,TXTɥ													*/
void hide_caret(TEXTWND *ptw)
{
	GdkRectangle rc;

	gtk_timeout_remove(timer_id);
	caret=FALSE;
	timer_id=0;
	rc.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
	rc.y=ptw->cursor.y;
	rc.x=(rc.x-ptw->top.x)*ptw->fontsize;
	rc.y=(rc.y-ptw->top.y)*ptw->fontsize*2;
	rc.width=ptw->fontsize;
	rc.height=ptw->fontsize*2;
	gtk_widget_draw(ptw->drawing,&rc);
}


/*	åȤ
	   ptw,TXTɥ
	cursor,ŤåȰ												*/
void draw_caret(TEXTWND *ptw,GdkPoint *cursor)
{
	gchar *text;
	gint x,y;
	guint context_id;
	GdkRectangle rc;

	if (cursor!=NULL
				&& (ptw->cursor.x!=cursor->x || ptw->cursor.y!=cursor->y)) {
		/* ޺ */
		gtk_timeout_remove(timer_id);
		timer_id=0;
		/* ŤåȤõ */
		rc.x=get_align_pos(&ptw->start,&ptw->off,
										cursor->x,cursor->y,ptw->tab,FALSE);
		rc.y=cursor->y;
		rc.x=(rc.x-ptw->top.x)*ptw->fontsize;
		rc.y=(rc.y-ptw->top.y)*ptw->fontsize*2;
		rc.width=ptw->fontsize;
		rc.height=ptw->fontsize*2;
		gtk_widget_draw(ptw->drawing,&rc);
	}
	/* åȤ */
	if (timer_id==0)
		caret=TRUE;
	x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
	y=ptw->cursor.y;
	rc.x=(x-ptw->top.x)*ptw->fontsize;
	rc.y=(y-ptw->top.y)*ptw->fontsize*2;
	rc.width=ptw->fontsize;
	rc.height=ptw->fontsize*2;
	gtk_widget_draw(ptw->drawing,&rc);
	if (timer_id==0)
		timer_id=gtk_timeout_add(500,signal_timeout,NULL);
	text=g_strdup_printf(ptw->select.x<0
			?_("%d,%d"):_("%d,%d  ϰ(%d,%d)-(%d,%d)"),
							x+1,y+1,ptw->select.x+1,ptw->select.y+1,x+1,y+1);
	context_id=gtk_statusbar_get_context_id(GTK_STATUSBAR(status),"Status");
	gtk_statusbar_pop(GTK_STATUSBAR(status),context_id);
	gtk_statusbar_push(GTK_STATUSBAR(status),context_id,text);
	g_free(text);
#ifdef USE_XIM
	if (GTK_WIDGET_HAS_FOCUS(ptw->drawing) && gdk_im_ready() && ptw->ic!=NULL
					&& (gdk_ic_get_style(ptw->ic)&GDK_IM_PREEDIT_POSITION)) {
		ptw->ic_attr->spot_location.x=rc.x;
		ptw->ic_attr->spot_location.y=rc.y+ptw->fontascent;
		ptw->ic_attr->preedit_foreground=ptw->color[0];
		ptw->ic_attr->preedit_background=ptw->color[1];
		gdk_ic_set_attr(ptw->ic,ptw->ic_attr,GDK_IC_SPOT_LOCATION
					| GDK_IC_PREEDIT_FOREGROUND | GDK_IC_PREEDIT_BACKGROUND);

	}
#endif
}


/*	˥塼ꤹ
	ptw,TXTɥ													*/
void set_menu_bar(TEXTWND *ptw)
{
	GList *glist;
	GtkWidget *menu;

	if (ptw!=NULL) {
		gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/Խ(E)")))),TRUE);
		gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/(S)")))),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/ե(F)/Ĥ(C)")),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/ե(F)/¸(S)")),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/ե(F)/̾Ĥ¸(A)...")),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/ե(F)/¸Ƥ֤᤹(R)...")),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/ե(F)/ץѥƥ(I)...")),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/Խ(E)/᤹(U)")),ptw->undo!=NULL);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/Խ(E)/ľ(R)")),ptw->redo!=NULL);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/Խ(E)/ڤ(T)")),ptw->select.x>=0);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/Խ(E)/ԡ(C)")),ptw->select.x>=0);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/Խ(E)/(L)")),ptw->select.x>=0);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/(S)/򸡺(N)")),find_num>0);
		gtk_widget_set_sensitive(toolbar_items[ 2].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[ 4].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[ 6].item,ptw->select.x>=0);
		gtk_widget_set_sensitive(toolbar_items[ 7].item,ptw->select.x>=0);
		gtk_widget_set_sensitive(toolbar_items[ 8].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[ 9].item,ptw->select.x>=0);
		gtk_widget_set_sensitive(toolbar_items[11].item,ptw->undo!=NULL);
		gtk_widget_set_sensitive(toolbar_items[12].item,ptw->redo!=NULL);
		gtk_widget_set_sensitive(toolbar_items[14].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[15].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[17].item,TRUE);
	} else {
		gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/Խ(E)")))),FALSE);
		gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/(S)")))),FALSE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/ե(F)/Ĥ(C)")),FALSE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/ե(F)/¸(S)")),FALSE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/ե(F)/̾Ĥ¸(A)...")),FALSE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/ե(F)/¸Ƥ֤᤹(R)...")),FALSE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
				_("<main>/ե(F)/ץѥƥ(I)...")),FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 2].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 4].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 6].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 7].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 8].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 9].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[11].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[12].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[14].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[15].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[17].item,FALSE);
	}
	menu=gtk_item_factory_get_widget(item_factory_menu,
													_("<main>/ɥ(W)"));
	glist=gtk_container_children(GTK_CONTAINER(menu));
	gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(menu)),
													g_list_length(glist)>0);
	g_list_free(glist);
}


/*	ϰϤ褹
	ptw,TXTɥ
	start,
	  end,λ																*/
void clear_sel(TEXTWND *ptw,GdkPoint *start,GdkPoint *end)
{
	gint st,ed;
	GdkRectangle rc;

	if (start->y==end->y) {
		/* Ʊ */
		st=get_align_pos(&ptw->start,&ptw->off,
								MIN(start->x,end->x),start->y,ptw->tab,FALSE);
		ed=get_align_pos(&ptw->start,&ptw->off,
								MAX(start->x,end->x),start->y,ptw->tab,TRUE);
		rc.x=(st-ptw->top.x)*ptw->fontsize;
		rc.y=(start->y-ptw->top.y)*ptw->fontsize*2;
		rc.width=(ed-st+1)*ptw->fontsize;
		rc.height=ptw->fontsize*2;
	} else {
		/* 㤦 */
		rc.x=0;
		rc.y=(MIN(start->y,end->y)-ptw->top.y)*ptw->fontsize*2;
		rc.width=ptw->drawing->allocation.width;
		rc.height=(ABS(start->y-end->y)+1)*ptw->fontsize*2;
	}
	gtk_widget_draw(ptw->drawing,&rc);
}


/*	ư
	ptw,TXTɥ
	top,Ťκɸ														*/
void move_text_window(TEXTWND *ptw,GdkPoint *top)
{
	gint sx,sy;

	sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
	sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
	if (ptw->top.x!=top->x || ptw->top.y!=top->y) {
		set_scroll_bar(ptw->hscroll,signal_value_changed_hscroll,ptw,
										0,get_width_max(ptw),sx,ptw->top.x);
		set_scroll_bar(ptw->vscroll,signal_value_changed_vscroll,ptw,
										0,ptw->max-1,sy,ptw->top.y);
		scroll_window(ptw->drawing,	(top->x-ptw->top.x)*ptw->fontsize,
									(top->y-ptw->top.y)*ptw->fontsize*2,
									0,0,
									ptw->drawing->allocation.width,
									ptw->drawing->allocation.height);
	}
}


/*	åȰ֤˥ǡ/񤭤
	   ptw,TXTɥ
	  text,ǡǼݥ
	length,ǡΥХȿ
	 caret,TRUE:ư,FALSE:ưʤ
	select,TRUE:򤹤,FALSE:򤷤ʤ
	   RET,դԤDOING¤,NULL:顼							*/
DOING *edit_operation(TEXTWND *ptw,gchar *text,gint length,
												gboolean caret,gboolean select)
{
	gint i,j,sx,sy,max,delete,put;
	DOING *d;
	LINEBUF *p,*q;
	GdkPoint cursor_old,cursor_new,top;
	GdkRectangle rc;

	hide_caret(ptw);
	ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
	top=ptw->top;
	sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
	sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
	d=g_malloc(sizeof(DOING));
	if (ptw->select.x<0) {
		d->text=NULL;
		d->length=0;
		d->caret=FALSE;
	} else {
		/*  */
		d->length=get_sel_byte(&ptw->start,&ptw->off,
										&ptw->cursor,&ptw->select,ptw->tab);
		d->text=g_malloc(d->length*sizeof(gchar));
		cpy_sel_mem(&ptw->start,&ptw->off,
								&ptw->cursor,&ptw->select,ptw->tab,d->text);
		delete=del_sel_mem(&ptw->start,&ptw->off,
				&ptw->cursor,&ptw->select,ptw->tab,ptw->limit?ptw->margin:0);
		ptw->max-=delete;/* Կ */
		/* ϰϲȥåȰư */
		if (ptw->select.y<ptw->cursor.y || (ptw->select.y==ptw->cursor.y
											&& ptw->select.x<ptw->cursor.x)) {
			ptw->cursor=ptw->select;
			d->caret=TRUE;
		} else {
			ptw->cursor=ptw->cursor;
			d->caret=FALSE;
		}
		ptw->select.x=-1;
		/* Ԥκ걦(ޡΤ1¿) */
		rc.x=(ptw->cursor.x-ptw->top.x-1)*ptw->fontsize;
		rc.y=(ptw->cursor.y-ptw->top.y)*ptw->fontsize*2;
		rc.width=ptw->drawing->allocation.width-rc.x;
		rc.height=ptw->fontsize*2;
		gtk_widget_draw(ptw->drawing,&rc);
		/* äԿʬ */
		scroll_window(ptw->drawing,0,-delete*ptw->fontsize*2,
							0,
							(ptw->cursor.y-ptw->top.y+1)*ptw->fontsize*2,
							ptw->drawing->allocation.width,
							ptw->drawing->allocation.height
								-(ptw->cursor.y-ptw->top.y+1)*ptw->fontsize*2);
		/* 򽪤֤鱦ޡαƶΤԿ */
		for (i=0,p=get_line_buf(&ptw->start,&ptw->off,ptw->cursor.y);
														p!=NULL;i++,p=p->next)
			if (!p->margin)
				break;
		if (i>0) {
			rc.x=0;
			rc.y=(ptw->cursor.y-ptw->top.y+1)*ptw->fontsize*2;
			rc.width=ptw->drawing->allocation.width;
			rc.height=i*ptw->fontsize*2;
			gtk_widget_draw(ptw->drawing,&rc);
		}
	}
	if (length<=0 || text==NULL) {
		d->cursor=ptw->cursor;
		d->select.x=-1;
	} else {
		/*  */
		ptw->cursor.x=get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE);
		put=put_mem(&ptw->start,&ptw->off,&ptw->cursor,&cursor_new,
								ptw->tab,text,length,ptw->limit?ptw->margin:0);
		ptw->max+=put;/* Կ */
		cursor_old=ptw->cursor;
		if (caret) {
			/* åȰư */
			d->cursor=cursor_new;
			d->select=cursor_old;
			ptw->cursor=cursor_new;
		} else {
			/* åȰưʤ */
			d->cursor=cursor_old;
			d->select=cursor_new;
		}
		if (select)/* 򤹤 */
			ptw->select=d->select;
		/* Ԥ걦 */
		rc.x=(cursor_old.x-ptw->top.x)*ptw->fontsize;
		rc.y=(cursor_old.y-ptw->top.y)*ptw->fontsize*2;
		rc.width=ptw->drawing->allocation.width;
		rc.height=ptw->fontsize*2;
		gtk_widget_draw(ptw->drawing,&rc);
		/* Կʬ */
		scroll_window(ptw->drawing,0,put*ptw->fontsize*2,
							0,
							(cursor_old.y-ptw->top.y+1)*ptw->fontsize*2,
							ptw->drawing->allocation.width,
							ptw->drawing->allocation.height
								-(cursor_old.y-ptw->top.y+1)*ptw->fontsize*2);
		/* 򽪤֤鱦ޡαƶΤԿ */
		p=q=get_line_buf(&ptw->start,&ptw->off,cursor_new.y);
		for (i=cursor_new.y,j=0;
						p->prev!=NULL && p->prev->margin && cursor_old.y<i;
															i--,j++,p=p->prev);
		while (q->next!=NULL && q->margin)
			j++,q=q->next;
		if (j>0) {
			rc.x=0;
			rc.y=(i-ptw->top.y+1)*ptw->fontsize*2;
			rc.width=ptw->drawing->allocation.width;
			rc.height=j*ptw->fontsize*2;
			gtk_widget_draw(ptw->drawing,&rc);
		}
	}
	if (ptw->cursor.x<ptw->top.x)
		ptw->top.x=ptw->cursor.x;
	else if (ptw->cursor.x-sx+1>ptw->top.x)
		ptw->top.x=ptw->cursor.x-sx+1;
	if (ptw->cursor.y<ptw->top.y)
		ptw->top.y=ptw->cursor.y;
	else if (ptw->cursor.y-sy+1>ptw->top.y)
		ptw->top.y=ptw->cursor.y-sy+1;
	if (ptw->top.y>ptw->max-sy)
		ptw->top.y=MAX(ptw->max-sy,0);
	max=get_width_max(ptw);
	if (ptw->top.x>max-sx+1)
		ptw->top.x=MAX(max-sx+1,0);
	set_scroll_bar(ptw->hscroll,signal_value_changed_hscroll,ptw,
												0,max,sx,ptw->top.x);
	set_scroll_bar(ptw->vscroll,signal_value_changed_vscroll,ptw,
												0,ptw->max-1,sy,ptw->top.y);
	move_text_window(ptw,&top);
	draw_caret(ptw,NULL);
	return d;
}


/*	ޡޤ֤
	ptw,TXTɥ													*/
void modify_margin(TEXTWND *ptw)
{
	int datapos,screenpos;
	LINEBUF *p,*q;

	/* 饤ХåեƬذư */
	while (ptw->start->prev!=NULL)
		ptw->start=ptw->start->prev;
	ptw->off=0;
	p=ptw->start;
	if (ptw->limit)
		/* ޡˤԤ */
		while (p!=NULL) {
			datapos=screenpos=0;
			while (datapos<p->length)
				if (p->text[datapos]=='\t') {
					screenpos=(screenpos/ptw->tab+1)*ptw->tab;
					if (ptw->margin<screenpos)
						break;
					datapos++;
				} else if (datapos==p->length-1
											|| !iskanji(p->text[datapos])) {
					screenpos++;
					if (ptw->margin<screenpos)
						break;
					datapos++;
				} else {
					screenpos+=2;
					if (ptw->margin<screenpos)
						break;
					datapos+=2;
				}
			if (ptw->margin<screenpos) {
				/* ޡĶƤȤԤ */
				q=g_malloc(sizeof(LINEBUF));
				q->length=p->length-datapos;
				q->margin=p->margin;
				q->text=g_malloc(q->length*sizeof(gchar));
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				memcpy(q->text,p->text+datapos,q->length*sizeof(gchar));
				p->length=datapos;
				p->margin=TRUE;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				p=q;
				ptw->max++;
			} else if (screenpos<ptw->margin && p->margin && p->next!=NULL) {
				/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
				datapos=p->length;
				q=p->next;
				if (q->next!=NULL)
					q->next->prev=p;
				p->next=q->next;
				p->length+=q->length;
				p->margin=q->margin;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				memcpy(p->text+datapos,q->text,q->length*sizeof(gchar));
				g_free(q->text);
				g_free(q);
				ptw->max--;
			} else {
				p=p->next;
			}
		}
	else
		/* ޡˤԤʤ */
		while (p!=NULL)
			if (p->margin) {
				/* ԤΤȤιԤȤ碌 */
				datapos=p->length;
				q=p->next;
				if (q->next!=NULL)
					q->next->prev=p;
				p->next=q->next;
				p->length+=q->length;
				p->margin=q->margin;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				memcpy(p->text+datapos,q->text,q->length*sizeof(gchar));
				g_free(q->text);
				g_free(q);
				ptw->max--;
			} else {
				p=p->next;
			}
}


/******************************************************************************
*                                                                             *
* ٥ؿ                                                              *
*                                                                             *
******************************************************************************/
/*	ե¸䤤碌
	ptw,TXTɥ
	RET,TRUE:եĤ,FALSE:եĤʤ						*/
gboolean prompt_close(TEXTWND *ptw)
{
	gchar *text;

	if (ptw->edit) {
		text=g_strdup_printf(
					_("ե %s ƤѹƤޤ\n¸ޤ?"),
																	ptw->file);
		switch (message_box("Text maid",text,0,
								_("Ϥ"),_(""),_("󥻥"),NULL)) {
			case 0:
				command_save(NULL,0,NULL);
				if (!ptw->edit)
					break;
			case 2:
			case -1:
				g_free(text);
				return FALSE;
		}
		g_free(text);
	}
	return TRUE;
}


/*	ꥹȤ
	  d,ꥹȤƬ
	RET,ꥹȤο													*/
gint delete_list(DOING **d)
{
	gint count=0;
	DOING *d0,*d1;

	for (d0=*d;d0!=NULL;d0=d1) {
		g_free(d0->text);
		d1=d0->next;
		g_free(d0);
		count++;
	}
	*d=NULL;
	return count;
}


/*	Խ
	 ptw,TXTɥ
	kind,TRUE:redo,FALSE:undo												*/
void history_operation(TEXTWND *ptw,gboolean kind)
{
	DOING *d0,*d1;
	GdkPoint cursor,select;

	if (kind) {
		d0=ptw->redo;
		ptw->redo=d0->next;
	} else {
		d0=ptw->undo;
		ptw->undo=d0->next;
	}
	cursor=ptw->cursor;
	select=ptw->select;
	ptw->cursor=d0->cursor;
	ptw->select=d0->select;
	if (select.x>=0)
		clear_sel(ptw,&select,&cursor);
	d1=edit_operation(ptw,d0->text,d0->length,d0->caret,TRUE);
	if (kind) {
		d1->next=ptw->undo;
		ptw->undo=d1;
	} else {
		d1->next=ptw->redo;
		ptw->redo=d1;
	}
	g_free(d0->text);
	g_free(d0);
	set_menu_bar(ptw);
}


/*	ޡǲԤ
	 ptw,TXTɥ													*/
void margin_operation(TEXTWND *ptw)
{
	gboolean limit;
	LINEBUF *p;

	delete_list(&ptw->undo);
	delete_list(&ptw->redo);
	limit=ptw->limit;
	ptw->limit=TRUE;
	modify_margin(ptw);
	for (p=ptw->start;p->prev!=NULL;p=p->prev);
	while (p!=NULL) {
		p->margin=FALSE;
		p=p->next;
	}
	ptw->limit=limit;
	ptw->edit=TRUE;
	ptw->cursor.x=ptw->cursor.y=ptw->top.x=ptw->top.y=0;
	ptw->select.x=-1;
	set_scroll_bar(ptw->hscroll,signal_value_changed_hscroll,ptw,
		0,get_width_max(ptw),
		MAX(ptw->drawing->allocation.width/ptw->fontsize,1),ptw->top.x);
	set_scroll_bar(ptw->vscroll,signal_value_changed_vscroll,ptw,
		0,ptw->max-1,
		MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1),ptw->top.y);
	set_menu_bar(ptw);
	gtk_widget_draw(ptw->drawing,NULL);
}


/*	֤򥹥ڡѴ
	 ptw,TXTɥ													*/
void tab_operation(TEXTWND *ptw)
{
	gchar *temp;
	gint datapos,screenpos;
	LINEBUF *p;

	delete_list(&ptw->undo);
	delete_list(&ptw->redo);
	for (p=ptw->start;p->prev!=NULL;p=p->prev);
	while (p!=NULL) {
		datapos=screenpos=0;
		while (datapos<p->length)
			if (p->text[datapos]=='\t') {
				screenpos=(screenpos/ptw->tab+1)*ptw->tab;
				datapos++;
			} else if (datapos==p->length-1 || !iskanji(p->text[datapos])) {
				screenpos++;
				datapos++;
			} else {
				screenpos+=2;
				datapos+=2;
			}
		if (screenpos>datapos) {
			temp=g_malloc(screenpos*sizeof(gchar));
			memset(temp,' ',screenpos*sizeof(gchar));
			datapos=screenpos=0;
			while (datapos<p->length)
				if (p->text[datapos]=='\t') {
					screenpos=(screenpos/ptw->tab+1)*ptw->tab;
					datapos++;
				} else if (datapos==p->length-1
											|| !iskanji(p->text[datapos])) {
					temp[screenpos]=p->text[datapos];
					screenpos++;
					datapos++;
				} else {
					temp[screenpos]=p->text[datapos];
					screenpos++;
					datapos++;
					temp[screenpos]=p->text[datapos];
					screenpos++;
					datapos++;
				}
			g_free(p->text);
			p->length=screenpos;
			p->text=temp;
		}
		p=p->next;
	}
	ptw->edit=TRUE;
	ptw->select.x=-1;
	set_menu_bar(ptw);
	gtk_widget_draw(ptw->drawing,NULL);
}


/*	Ԥذư
	 ptw,TXTɥ
	line,(1...)														*/
void jump_operation(TEXTWND *ptw,gint line)
{
	gint sx,sy;
	GdkPoint cursor,select,top;

	cursor=ptw->cursor;
	select=ptw->select;
	top=ptw->top;
	sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
	sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
	ptw->cursor.y=line<0?ptw->max+line:line-1;
	if (ptw->cursor.y<0)
		ptw->cursor.y=0;
	else if (ptw->cursor.y>ptw->max-1)
		ptw->cursor.y=ptw->max-1;
	if (ptw->cursor.x<ptw->top.x)
		ptw->top.x=ptw->cursor.x;
	else if (ptw->cursor.x-sx+1>ptw->top.x)
		ptw->top.x=ptw->cursor.x-sx+1;
	if (ptw->cursor.y<ptw->top.y)
		ptw->top.y=ptw->cursor.y;
	else if (ptw->cursor.y-sy+1>ptw->top.y)
		ptw->top.y=ptw->cursor.y-sy+1;
	move_text_window(ptw,&top);
	if (ptw->select.x>=0) {
		if (ptw->select.y==ptw->cursor.y
						&& ptw->select.x==get_align_pos(&ptw->start,&ptw->off,
								ptw->cursor.x,ptw->cursor.y,ptw->tab,FALSE)) {
			ptw->select.x=-1;
			clear_sel(ptw,&select,&cursor);
			set_menu_bar(ptw);
		} else {
			clear_sel(ptw,&ptw->cursor,&cursor);
		}
	}
	draw_caret(ptw,&cursor);
}


/*	ץѥƥѹ
	ptw,TXTɥ
	 ft,ե륿														*/
void change_property(TEXTWND *ptw,FTYPE *ft)
{
	gboolean modify;
	gint i,fontsize,lbearing,rbearing,width,ascent,descent;
	gint max,sx,sy;
	GdkRectangle rc;

	if (ptw->limit!=ft->limit || ptw->tab!=ft->tab
								|| (ptw->code && ptw->margin!=ft->margin)) {
		/* ޤ֤ѹֿѹ */
		delete_list(&ptw->undo);
		delete_list(&ptw->redo);
	}
	modify=ptw->limit!=ft->limit || (ptw->limit
							&& (ptw->tab!=ft->tab || ptw->margin!=ft->margin));
	ptw->ft_id=ft->ft_id;
	ptw->margin=ft->margin;
	ptw->tab=ft->tab;
	ptw->code=ft->code;
	ptw->crlf=ft->crlf;
	ptw->eof=ft->eof;
	ptw->limit=ft->limit;
	ptw->overwrite=ft->overwrite;
	ptw->space=ft->space;
	ptw->gline=ft->gline;
	ptw->mline=ft->mline;
	ptw->uline=ft->uline;
	ptw->vline=ft->vline;
	g_free(ptw->fontname);
	ptw->fontname=g_strdup(ft->fontname);
	memcpy(ptw->color,ft->color,sizeof(GdkColor)*12);
	ptw->select.x=-1;
	if (modify) {
		/* ޤ֤ѹޤ֤ͭǥֿѹ */
		ptw->cursor.x=ptw->cursor.y=ptw->top.x=ptw->top.y=0;
		modify_margin(ptw);
	}
	/* ե */
	gdk_font_unref(ptw->font);
	ptw->font=gdk_fontset_load(ptw->fontname);
	ptw->fontascent=ptw->fontsize=0;
	for (i=0x20;i<=0x7e;i++) {
		gdk_text_extents(ptw->font,(gchar *)&i,1,
								&lbearing,&rbearing,&width,&ascent,&descent);
		if (ptw->fontascent<ascent)
			ptw->fontascent=ascent;
		fontsize=(gdk_char_height(ptw->font,i)+1)/2;
		if (ptw->fontsize<fontsize)
			ptw->fontsize=fontsize;
	}
	/* С */
	sx=MAX(ptw->drawing->allocation.width/ptw->fontsize,1);
	sy=MAX(ptw->drawing->allocation.height/(ptw->fontsize*2),1);
	if (ptw->top.y>ptw->max-sy)
		ptw->top.y=MAX(ptw->max-sy,0);
	max=get_width_max(ptw);
	if (ptw->top.x>max-sx+1)
		ptw->top.x=MAX(max-sx+1,0);
#ifdef USE_XIM
	if (gdk_im_ready() && ptw->ic!=NULL
					&& (gdk_ic_get_style(ptw->ic)&GDK_IM_PREEDIT_POSITION)) {
		ptw->ic_attr->preedit_fontset=ptw->font;
		gdk_ic_set_attr(ptw->ic,ptw->ic_attr,GDK_IC_PREEDIT_FONTSET);
	}
#endif
	set_scroll_bar(ptw->hscroll,signal_value_changed_hscroll,ptw,
												0,max,sx,ptw->top.x);
	set_scroll_bar(ptw->vscroll,signal_value_changed_vscroll,ptw,
												0,ptw->max-1,sy,ptw->top.y);
	/*  */
	rc.x=rc.y=0;
	rc.width=ptw->drawing->allocation.width;
	rc.height=ptw->drawing->allocation.height;
	gtk_widget_draw(ptw->drawing,&rc);
	draw_caret(ptw,NULL);
}
