/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <string.h>
#include <gdk/gdkkeysyms.h>
#include "format.h"
#include "general.h"
#include "prop.h"


/******************************************************************************
*                                                                             *
* ե륿״ؿ                                                        *
*                                                                             *
******************************************************************************/
static gint ftpos;
static GtkWidget *button0,*button1,*button2,*button3,*button4;


/* ꥹȥܥå */
static void format_dialog_select_row(GtkWidget *widget,
				gint row,gint column,GdkEventButton *event,gpointer user_data)
{
	ftpos=row;
	gtk_widget_set_sensitive(button0,TRUE);
	gtk_widget_set_sensitive(button1,ftnum>1);
	gtk_widget_set_sensitive(button2,ftpos>0);
	gtk_widget_set_sensitive(button3,ftpos<ftnum-1);
	gtk_widget_set_sensitive(button4,TRUE);
}


/* ꥹȥܥå */
static void format_dialog_unselect_row(GtkWidget *widget,
				gint row,gint column,GdkEventButton *event,gpointer user_data)
{
	ftpos=-1;
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_set_sensitive(button1,FALSE);
	gtk_widget_set_sensitive(button2,FALSE);
	gtk_widget_set_sensitive(button3,FALSE);
	gtk_widget_set_sensitive(button4,FALSE);
}


/*  */
static void format_dialog_clicked_new(GtkWidget *widget,GtkWidget *clist)
{
	ftype=g_realloc(ftype,++ftnum*sizeof(FTYPE));
	memmove(ftype+ftpos+2,ftype+ftpos+1,(ftnum-ftpos-2)*sizeof(FTYPE));
	ftype[ftpos+1]=ftype[ftpos];
	ftype[ftpos+1].ft_id=tcount++;
	ftype[ftpos+1].text=g_strdup(ftype[ftpos].text);
	ftype[ftpos+1].ext=g_strdup(ftype[ftpos].ext);
	ftype[ftpos+1].fontname=g_strdup(ftype[ftpos].fontname);
	gtk_clist_insert(GTK_CLIST(clist),ftpos+1,&ftype[ftpos+1].text);
}


/*  */
static void format_dialog_clicked_remove(GtkWidget *widget,GtkWidget *clist)
{
	g_free(ftype[ftpos].text);
	g_free(ftype[ftpos].ext);
	g_free(ftype[ftpos].fontname);
	ftnum--;
	memmove(ftype+ftpos,ftype+ftpos+1,(ftnum-ftpos)*sizeof(FTYPE));
	ftype=g_realloc(ftype,ftnum*sizeof(FTYPE));
	gtk_clist_remove(GTK_CLIST(clist),ftpos);
}


/*  */
static void format_dialog_clicked_up(GtkWidget *widget,GtkWidget *clist)
{
	FTYPE ft;

	ft=ftype[ftpos];
	ftype[ftpos]=ftype[ftpos-1];
	ftype[ftpos-1]=ft;
	gtk_clist_set_text(GTK_CLIST(clist),ftpos-1,0,ftype[ftpos-1].text);
	gtk_clist_set_text(GTK_CLIST(clist),ftpos,0,ftype[ftpos].text);
	gtk_clist_select_row(GTK_CLIST(clist),--ftpos,0);
}


/*  */
static void format_dialog_clicked_down(GtkWidget *widget,GtkWidget *clist)
{
	FTYPE ft;

	ft=ftype[ftpos];
	ftype[ftpos]=ftype[ftpos+1];
	ftype[ftpos+1]=ft;
	gtk_clist_set_text(GTK_CLIST(clist),ftpos,0,ftype[ftpos].text);
	gtk_clist_set_text(GTK_CLIST(clist),ftpos+1,0,ftype[ftpos+1].text);
	gtk_clist_select_row(GTK_CLIST(clist),++ftpos,0);
}


/* Խ */
static void format_dialog_clicked_edit(GtkWidget *widget,GtkWidget *clist)
{
	gint i;
	GList *glist;
	TEXTWND *ptw;

	property_dialog(ftype+ftpos);
	gtk_clist_set_text(GTK_CLIST(clist),ftpos,0,ftype[ftpos].text);
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	for (i=g_list_length(glist)-1;i>=0;i--) {
		ptw=gtk_object_get_user_data(GTK_OBJECT(g_list_nth_data(glist,i)));
		if (ptw->ft_id==ftype[ftpos].ft_id)
			change_property(ptw,&ftype[ftpos]);
	}
	g_list_free(glist);
}


/* ESC줿 */
static gboolean format_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


void format_dialog(void)
{
	gint i;
	GtkWidget *dialog,*button5,*clist,*scroll,*hbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dialog),_("ե륿"));
	gtk_window_set_default_size(GTK_WINDOW(dialog),320,240);
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(format_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* ꥹȥܥå */
	clist=gtk_clist_new(1);
	gtk_clist_set_column_title(GTK_CLIST(clist),0,
											_("ϿƤե륿"));
	gtk_clist_column_titles_show(GTK_CLIST(clist));
	gtk_clist_column_titles_passive(GTK_CLIST(clist));
	for (i=0;i<ftnum;i++)
		gtk_clist_append(GTK_CLIST(clist),&ftype[i].text);
	gtk_clist_set_column_width(GTK_CLIST(clist),0,
						gtk_clist_optimal_column_width(GTK_CLIST(clist),0));
	gtk_signal_connect(GTK_OBJECT(clist),"select-row",
											format_dialog_select_row,NULL);
	gtk_signal_connect(GTK_OBJECT(clist),"unselect-row",
											format_dialog_unselect_row,NULL);
	/* 륦ɥ */
	scroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
										GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroll),clist);
	/* ܥ */
	button0=gtk_button_new_with_label(_(""));
	button1=gtk_button_new_with_label(_(""));
	button2=gtk_button_new_with_label(_(""));
	button3=gtk_button_new_with_label(_(""));
	button4=gtk_button_new_with_label(_("Խ"));
	button5=gtk_button_new_with_label(_("Ĥ"));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
										format_dialog_clicked_new,clist);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
										format_dialog_clicked_remove,clist);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
										format_dialog_clicked_up,clist);
	gtk_signal_connect(GTK_OBJECT(button3),"clicked",
										format_dialog_clicked_down,clist);
	gtk_signal_connect(GTK_OBJECT(button4),"clicked",
										format_dialog_clicked_edit,clist);
	gtk_signal_connect_object(GTK_OBJECT(button5),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button2,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button3,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button4,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button5,GTK_CAN_DEFAULT);
	/* ܥå */
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),scroll,TRUE,TRUE,8);
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),button0,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),button1,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),button2,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),button3,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),button4,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button5,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,8);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_set_sensitive(button1,FALSE);
	gtk_widget_set_sensitive(button2,FALSE);
	gtk_widget_set_sensitive(button3,FALSE);
	gtk_widget_set_sensitive(button4,FALSE);
	gtk_widget_grab_focus(button5);
	ftpos=-1;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();
}
