/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "print.h"
#ifdef USE_GDKPIXBUF


PRNCFG printer;						/*  */


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
static gboolean print_clicked_ok;
static GtkWidget *dialog,*button0,*button1,*entry0,*entry1,*radio0;
static GtkWidget *label1,*label2,*label3;
static GtkWidget *spin0,*spin1,*spin2,*spin3,*spin4,*spin5,*spin6;
static struct {
	gchar *name;
	gint width,height;
} paper[]={	{"A3",840,1188},{"A4",594,840},{"A5",420,594},
			{"B4",730,1030},{"B5",515,730},{NULL,0,0}};


/* OKܥɽ/ɽȽ */
static void print_dialog_ok_sensitive(GtkWidget *widget,gpointer user_data)
{
	gint left,top,right,bottom;

	top=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
	left=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4));
	right=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin5));
	bottom=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin6));
	gtk_widget_set_sensitive(button1,
	strlen(gtk_entry_get_text(GTK_ENTRY(gtk_toggle_button_get_active(
								GTK_TOGGLE_BUTTON(radio0))?entry0:entry1)))>0
	&& gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0))>=2
	&& left>=0 && top>=0 && right>=0 && bottom>=0
	&& gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1))>left+right
	&& gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2))>top+bottom);
}


/* ܥܥå */
static void print_dialog_changed(GtkWidget *widget,gpointer user_data)
{
	gchar *name;
	gint i;

	name=gtk_entry_get_text(GTK_ENTRY(widget));
	for (i=0;paper[i].name!=NULL;i++)
		if (strcmp(paper[i].name,name)==0)
			break;
	if (paper[i].name==NULL) {
		/* 桼 */
		gtk_widget_set_sensitive(label2,TRUE);
		gtk_widget_set_sensitive(label3,TRUE);
		gtk_widget_set_sensitive(spin1,TRUE);
		gtk_widget_set_sensitive(spin2,TRUE);
	} else {
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin1),paper[i].width);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin2),paper[i].height);
		gtk_widget_set_sensitive(label2,FALSE);
		gtk_widget_set_sensitive(label3,FALSE);
		gtk_widget_set_sensitive(spin1,FALSE);
		gtk_widget_set_sensitive(spin2,FALSE);
	}
	print_dialog_ok_sensitive(widget,user_data);
}


/* 饸ܥ */
static void print_dialog_toggled(GtkWidget *widget,gpointer user_data)
{
	gboolean result;

	result=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio0));
	gtk_widget_set_sensitive(entry0,result);
	gtk_widget_set_sensitive(entry1,!result);
	gtk_widget_set_sensitive(button0,!result);
	print_dialog_ok_sensitive(widget,user_data);
}


/* OKܥ󤬲줿 */
static void print_dialog_clicked_ok(GtkWidget *widget,PRNCFG *prncfg)
{
	prncfg->mode=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio0));
	if (prncfg->mode) {
		g_free(prncfg->printer);
		prncfg->printer=g_strdup(gtk_entry_get_text(GTK_ENTRY(entry0)));
	} else {
		g_free(prncfg->file);
		prncfg->file=g_strdup(gtk_entry_get_text(GTK_ENTRY(entry1)));
	}
	prncfg->column=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
	prncfg->width=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
	prncfg->height=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
	prncfg->top=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
	prncfg->left=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4));
	prncfg->right=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin5));
	prncfg->bottom=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin6));
	print_clicked_ok=TRUE;
}


static gchar *print_open_file;


/* եλȤOKܥ󤬲줿 */
static void print_open_ok(GtkWidget *widget,GtkWidget *dialog_open)
{
	print_open_file=g_strdup(gtk_file_selection_get_filename(
											GTK_FILE_SELECTION(dialog_open)));
    gtk_widget_destroy(dialog_open);
}


/* ȥܥ󤬲줿 */
static void print_dialog_clicked_file(GtkWidget *widget,PRNCFG *prncfg)
{
	GtkWidget *dialog_open;

	print_open_file=NULL;
	dialog_open=gtk_file_selection_new(_("̾դ¸"));
	gtk_signal_connect(GTK_OBJECT(dialog_open),"destroy",gtk_main_quit,NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(dialog_open)->ok_button),
										"clicked",print_open_ok,dialog_open);
	gtk_signal_connect_object(
					GTK_OBJECT(GTK_FILE_SELECTION(dialog_open)->cancel_button),
						"clicked",gtk_widget_destroy,GTK_OBJECT(dialog_open));
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(dialog_open),
										gtk_entry_get_text(GTK_ENTRY(entry1)));
	gtk_widget_show(dialog_open);
	gtk_grab_add(dialog_open);
	gtk_main();
	if (print_open_file!=NULL) {
		gtk_entry_set_text(GTK_ENTRY(entry1),print_open_file);
		g_free(print_open_file);
	}
}


/* ԥܥǥ꥿󤬲줿 */
static void print_dialog_activate(GtkWidget *widget,PRNCFG *prncfg)
{
	gint left,top,right,bottom;

	top=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
	left=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4));
	right=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin5));
	bottom=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin6));
	if (strlen(gtk_entry_get_text(GTK_ENTRY(gtk_toggle_button_get_active(
								GTK_TOGGLE_BUTTON(radio0))?entry0:entry1)))>0
		&& gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0))>=2
		&& left>=0 && top>=0 && right>=0 && bottom>=0
		&& gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1))>left+right
		&& gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2))>top+bottom)
		print_dialog_clicked_ok(widget,prncfg);
}


/* ESC줿 */
static gboolean print_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean print_dialog(PRNCFG *prncfg)
{
	gint i;
	guint key;
	GList *glist=NULL;
	GtkAccelGroup *accel;
	GtkWidget *button2,*combo,*radio1;
	GtkWidget *frame0,*frame1,*hbox0,*hbox1,*vbox;
	GtkWidget *label0,*label4,*label5,*label6,*label7;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dialog),_(""));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(print_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	/* ܥ */
	button0=gtk_button_new_with_label(_("..."));
	button1=gtk_button_new_with_label(_(""));
	button2=gtk_button_new_with_label(_(""));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",
											print_dialog_clicked_file,dialog);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
											print_dialog_clicked_ok,prncfg);
	gtk_signal_connect_object(GTK_OBJECT(button2),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button2,GTK_CAN_DEFAULT);
	/* ȥ꡼ */
	entry0=gtk_entry_new();
	entry1=gtk_entry_new();
	if (prncfg->printer!=NULL)
		gtk_entry_set_text(GTK_ENTRY(entry0),prncfg->printer);
	if (prncfg->file!=NULL)
		gtk_entry_set_text(GTK_ENTRY(entry1),prncfg->file);
	gtk_signal_connect(GTK_OBJECT(entry0),"activate",
											print_dialog_clicked_ok,prncfg);
	gtk_signal_connect(GTK_OBJECT(entry1),"activate",
											print_dialog_clicked_ok,prncfg);
	gtk_signal_connect(GTK_OBJECT(entry0),"changed",
											print_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(entry1),"changed",
											print_dialog_ok_sensitive,NULL);
	/* ԥܥ */
	spin0=gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(prncfg->column,
													2,G_MAXINT,1,5,0)),0,0);
	spin1=gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(prncfg->width,
													1,G_MAXINT,1,5,0)),0,0);
	spin2=gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(prncfg->height,
													1,G_MAXINT,1,5,0)),0,0);
	spin3=gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(prncfg->top,
													0,G_MAXINT,1,5,0)),0,0);
	spin4=gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(prncfg->left,
													0,G_MAXINT,1,5,0)),0,0);
	spin5=gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(prncfg->right,
													0,G_MAXINT,1,5,0)),0,0);
	spin6=gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(prncfg->bottom,
													0,G_MAXINT,1,5,0)),0,0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin0),TRUE);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1),TRUE);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2),TRUE);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin3),TRUE);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin4),TRUE);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin5),TRUE);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin6),TRUE);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin0),GTK_SHADOW_IN);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin1),GTK_SHADOW_IN);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin2),GTK_SHADOW_IN);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin3),GTK_SHADOW_IN);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin4),GTK_SHADOW_IN);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin5),GTK_SHADOW_IN);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin6),GTK_SHADOW_IN);
	gtk_signal_connect(GTK_OBJECT(spin0),"activate",
												print_dialog_activate,prncfg);
	gtk_signal_connect(GTK_OBJECT(spin1),"activate",
												print_dialog_activate,prncfg);
	gtk_signal_connect(GTK_OBJECT(spin2),"activate",
												print_dialog_activate,prncfg);
	gtk_signal_connect(GTK_OBJECT(spin3),"activate",
												print_dialog_activate,prncfg);
	gtk_signal_connect(GTK_OBJECT(spin4),"activate",
												print_dialog_activate,prncfg);
	gtk_signal_connect(GTK_OBJECT(spin5),"activate",
												print_dialog_activate,prncfg);
	gtk_signal_connect(GTK_OBJECT(spin6),"activate",
												print_dialog_activate,prncfg);
	gtk_signal_connect(GTK_OBJECT(spin0),"changed",
											print_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(spin1),"changed",
											print_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(spin2),"changed",
											print_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(spin3),"changed",
											print_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(spin4),"changed",
											print_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(spin5),"changed",
											print_dialog_ok_sensitive,NULL);
	gtk_signal_connect(GTK_OBJECT(spin6),"changed",
											print_dialog_ok_sensitive,NULL);
	/* 饸ܥ */
	radio0=gtk_radio_button_new_with_label(NULL,NULL);
	radio1=gtk_radio_button_new_with_label_from_widget(
												GTK_RADIO_BUTTON(radio0),NULL);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio0)->child),
															_("ץ(_P)"));
	gtk_widget_add_accelerator(radio0,"clicked",accel,key,
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio1)->child),
															_("ե(_F)"));
	gtk_widget_add_accelerator(radio1,"clicked",accel,key,
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	gtk_signal_connect(GTK_OBJECT(radio0),"toggled",print_dialog_toggled,NULL);
	gtk_signal_connect(GTK_OBJECT(radio1),"toggled",print_dialog_toggled,NULL);
	if (!prncfg->mode)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio1),TRUE);
	/* ٥ */
	label0=gtk_label_new(NULL);
	label1=gtk_label_new(_(""));
	label2=gtk_label_new(NULL);
	label3=gtk_label_new(NULL);
	label4=gtk_label_new(NULL);
	label5=gtk_label_new(NULL);
	label6=gtk_label_new(NULL);
	label7=gtk_label_new(NULL);
	key=gtk_label_parse_uline(GTK_LABEL(label0),_("(_C)"));
	gtk_widget_add_accelerator(spin0,"grab-focus",accel,key,
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(label2),_("(_W)"));
	gtk_widget_add_accelerator(spin1,"grab-focus",accel,key,
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(label3),_("⤵(_H)"));
	gtk_widget_add_accelerator(spin2,"grab-focus",accel,key,
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(label4),_("(_T)"));
	gtk_widget_add_accelerator(spin3,"grab-focus",accel,key,
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(label5),_("(_L)"));
	gtk_widget_add_accelerator(spin4,"grab-focus",accel,key,
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(label6),_("(_R)"));
	gtk_widget_add_accelerator(spin5,"grab-focus",accel,key,
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(label7),_("(_B)"));
	gtk_widget_add_accelerator(spin6,"grab-focus",accel,key,
									GDK_MOD1_MASK|GDK_MOD2_MASK|GDK_MOD3_MASK
											|GDK_MOD4_MASK|GDK_MOD5_MASK,0);
	/* ܥܥå */
	for (i=0;paper[i].name!=NULL;i++)
		glist=g_list_append(glist,paper[i].name);
	glist=g_list_append(glist,_("桼"));
	combo=gtk_combo_new();
	gtk_combo_set_popdown_strings(GTK_COMBO(combo),glist);
	gtk_combo_set_value_in_list(GTK_COMBO(combo),TRUE,FALSE);
	gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(combo)->entry),FALSE);
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry),"changed",
													print_dialog_changed,NULL);
	for (i=0;paper[i].name!=NULL;i++)
		if (paper[i].width==prncfg->width && paper[i].height==prncfg->height)
			break;
	if (paper[i].name==NULL) {
	} else {
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),paper[i].name);
	}

	/* ե졼ȥܥå */
	frame0=gtk_frame_new(_("ѻ"));
	vbox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),combo,TRUE,TRUE,8);
	hbox0=gtk_hbox_new(FALSE,0);
	hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),label2,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),spin1,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),hbox1,TRUE,TRUE,8);
	hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),label3,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),spin2,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),hbox1,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,8);
	hbox0=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),vbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(frame0),hbox0);

	frame1=gtk_frame_new(_("ޡ"));
	vbox=gtk_vbox_new(FALSE,0);
	hbox0=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),label4,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),spin3,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,8);
	hbox0=gtk_hbox_new(FALSE,8);
	hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),label5,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),spin4,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),hbox1,TRUE,TRUE,0);
	hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),label6,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),spin5,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),hbox1,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,0);
	hbox0=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),label7,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),spin6,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,8);
	hbox0=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),vbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(frame1),hbox0);

	vbox=gtk_vbox_new(FALSE,0);

	hbox0=gtk_hbox_new(FALSE,0);
	hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),spin0,TRUE,TRUE,0);
	gtk_box_pack_end(GTK_BOX(hbox1),label0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),hbox1,TRUE,TRUE,8);
	gtk_box_pack_end(GTK_BOX(hbox0),label1,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,8);

	hbox0=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),radio0,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox0),entry0,TRUE,TRUE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,8);

	hbox0=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),radio1,FALSE,FALSE,8);
	hbox1=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),entry1,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox1),button0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),hbox1,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox0,FALSE,FALSE,8);

	gtk_box_pack_start(GTK_BOX(vbox),frame0,FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),frame1,FALSE,FALSE,8);

	hbox0=gtk_hbox_new(FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox0),button2,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox0),button1,FALSE,FALSE,8);
	gtk_box_pack_end(GTK_BOX(vbox),hbox0,FALSE,FALSE,8);

	hbox0=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox0),vbox,TRUE,TRUE,8);
	gtk_container_add(GTK_CONTAINER(dialog),hbox0);

	/* ɽ */
	gtk_widget_set_sensitive(entry0,prncfg->mode);
	gtk_widget_set_sensitive(entry1,!prncfg->mode);
	gtk_widget_set_sensitive(button0,!prncfg->mode);
	gtk_widget_grab_focus(button1);
	print_dialog_ok_sensitive(NULL,NULL);
	print_clicked_ok=FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return print_clicked_ok;
}
#endif
