/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "version.h"


/******************************************************************************
*                                                                             *
* Сؿ                                                        *
*                                                                             *
******************************************************************************/
static gchar *tmaid_xpm[] = {
"32 32 11 1",
" 	c None",
"+	c #000000",
"@	c #FF0000",
"#	c #FFFF00",
"$	c #008000",
"%	c #F304F3",
"&	c #F30404",
"*	c #0404F3",
"=	c #04F7F3",
"-	c #F3F704",
";	c #04F704",
"               +                ",
"              +++               ",
"             +++++              ",
"            +++++++             ",
"           +@#@#@#@+            ",
"          +@#@#@#@#@+           ",
"         +@#@#@#@#@#@+          ",
"        +@#@#@#@#@#@#@+         ",
"       +@#@#@#@#@#@#@#@+        ",
"      +@#@#@#@#@#@#@#@#@+       ",
"     +@#@#@#@#@#@#@#@#@#@+      ",
"    +@#@#@#+++#@#@#@#@#@+++     ",
"   +@#@#@#+$$$+#@#@#@#@+$$$+    ",
"  +@#@#@#+$$$$$+#@#@#@+$$$$$+   ",
"  ++@#@#+$$$$$$$+#@#@++$$$$$+   ",
"  +$+@#++$$$$$$%$+#@+$+$$$$$+   ",
"  +$$++$+$$$$$%%$$++$$+$$$$$+   ",
"  +$$$$$+$$$$%%%$$$$$$+$$$$$+   ",
"  +$$$$$+$$$$%%%$$$$$$+$$$$$+   ",
"  +$$$$$+&$$%%%%******+$$$$$+   ",
"  +$$$$$+&&&%%%%****$$+$$$$$+   ",
"  +$$$$$+$&&&&%%***=$$+$$$$$+   ",
"  +$$$$$+$&&&&&%*===$$+$$$$$+   ",
"  +$$$$$+$$&&&-;=====$+$$$$$+   ",
"  +$$$$$+$$&---;;====$+$$$$$+   ",
"  +$$$$$+$-----;;;;===+$$$$$+   ",
"  +$$$$$+------;;;;$$=+$$$$$+   ",
"  +$$$$$+$$$$$$;;;$$$$+$$$$$+   ",
"  +$$$$$+$$$$$$;;;$$$$+$$$$$+   ",
"  +$$$$$+$$$$$$;;$$$$$+$$$$$+   ",
"  +$$$$$+$$$$$$;$$$$$$+$$$$$+   ",
"  +$$$$$+$$$$$$$$$$$$$+$$$$$+   "};


/* ESC줿 */
static gboolean version_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


void version_dialog(void)
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkWidget *dialog,*button,*hbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Text maid ΥС"));
	gtk_signal_connect(GTK_OBJECT(dialog),"key-press-event",
							GTK_SIGNAL_FUNC(version_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* ܥ */
	button=gtk_button_new_with_label(_("λ"));
	gtk_signal_connect_object(GTK_OBJECT(button),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
	/* ԥޥå */
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&mask,NULL,tmaid_xpm);

	/* ե졼ȥܥå */
	vbox=gtk_vbox_new(FALSE,0);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),
									gtk_pixmap_new(pixmap,mask),FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),gtk_label_new("Text maid version "VERSION
				"\ncopyright (c) 1998-2002 by Iwamoto,Kazuki"),FALSE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,FALSE,8);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,8);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_grab_focus(button);

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();
}
