/*
    Text maid
    copyright (c) 1998-2002 Iwamoto,Kazuki http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <string.h>
#include "charset.h"
#include "edit.h"
#include "other.h"


/******************************************************************************
*                                                                             *
* Խؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	饤Хåե
	start,饤Хåե
	  off,ߤyɸ
	    y,yɸ
	  RET,饤Хåե													*/
LINEBUF *get_line_buf(LINEBUF **start,gint *off,gint y)
{
	while (y<*off && (*start)->prev!=NULL) {
		*start=(*start)->prev;
		(*off)--;
	}
	while (*off<y && (*start)->next!=NULL) {
		*start=(*start)->next;
		(*off)++;
	}
	return *off==y?*start:NULL;
}


/*	
	ptw,TXTɥ
	  y,
	RET,																*/
gint get_width(TEXTWND *ptw,gint y)
{
	gint datapos=0,width=0;
	LINEBUF *p;

	p=get_line_buf(&ptw->start,&ptw->off,y);
	if (p->margin)
		while (datapos<p->length-1)
			if (p->text[datapos]=='\t') {
				width=(width/ptw->tab+1)*ptw->tab;
				datapos++;
			} else if (datapos+charset_length(p->text[datapos])<=p->length) {
				if (datapos+charset_length(p->text[datapos])==p->length)
					break;
				width+=charset_width(ptw->font,p->text+datapos,ptw->fontwidth);
				datapos+=charset_length(p->text[datapos]);
			} else {
				width++;
				datapos++;
			}
	else
		while (datapos<p->length)
			if (p->text[datapos]=='\t') {
				width=(width/ptw->tab+1)*ptw->tab;
				datapos++;
			} else if (datapos+charset_length(p->text[datapos])<=p->length) {
				width+=charset_width(ptw->font,p->text+datapos,ptw->fontwidth);
				datapos+=charset_length(p->text[datapos]);
			} else {
				width++;
				datapos++;
			}
	return width;
}


/*	
	ptw,TXTɥ
	RET,																*/
gint get_width_max(TEXTWND *ptw)
{
	gint y,datapos,width,max=0;
	LINEBUF *p;

	for (y=0,p=get_line_buf(&ptw->start,&ptw->off,ptw->top.y);
								y<ptw->drawing->allocation.height && p!=NULL;
												y+=ptw->fontheight,p=p->next) {
		width=0;
		datapos=0;
		while (datapos<p->length)
			if (p->text[datapos]=='\t') {
				width=(width/ptw->tab+1)*ptw->tab;
				datapos++;
			} else if (datapos+charset_length(p->text[datapos])>p->length) {
				width+=charset_width(ptw->font,p->text+datapos,ptw->fontwidth);
				datapos+=charset_length(p->text[datapos]);
			} else {
				width++;
				datapos++;
			}
		if (width>max)
			max=width;
	}
	return max;
}


/*	åȤΥ饤Ȥ줿xɸ
	  ptw,TXTɥ
	    x,xɸ
	    y,yɸ
	align,TRUE:˴󤻤,FALSE:˴󤻤
	  RET,ɸ																*/
gint get_align_pos(TEXTWND *ptw,gint x,gint y,gboolean align)
{
	gint datapos=0,screenpos=0;
	LINEBUF *p;

	p=get_line_buf(&ptw->start,&ptw->off,y);
	if (p->margin)
		while (screenpos<x && datapos<p->length-1)
			if (p->text[datapos]=='\t') {
				if (x<(screenpos/ptw->tab+1)*ptw->tab)
					return align?(screenpos/ptw->tab+1)*ptw->tab:screenpos;
				screenpos=(screenpos/ptw->tab+1)*ptw->tab;
				datapos++;
			} else if (datapos+charset_length(p->text[datapos])>p->length) {
				screenpos++;
				datapos++;
			} else if (datapos+charset_length(p->text[datapos])==p->length) {
				break;
			} else if (x<screenpos+charset_width(ptw->font,
											p->text+datapos,ptw->fontwidth)) {
				return align?screenpos+charset_width(ptw->font,
									p->text+datapos,ptw->fontwidth):screenpos;
			} else {
				screenpos+=charset_width(ptw->font,
											p->text+datapos,ptw->fontwidth);
				datapos+=charset_length(p->text[datapos]);
			}
	else
		while (screenpos<x && datapos<p->length)
			if (p->text[datapos]=='\t') {
				if (x<(screenpos/ptw->tab+1)*ptw->tab)
					return align?(screenpos/ptw->tab+1)*ptw->tab:screenpos;
				screenpos=(screenpos/ptw->tab+1)*ptw->tab;
				datapos++;
			} else if (datapos+charset_length(p->text[datapos])>p->length) {
				screenpos++;
				datapos++;
			} else if (x<screenpos+charset_width(ptw->font,
											p->text+datapos,ptw->fontwidth)) {
				return align?screenpos+charset_width(ptw->font,
									p->text+datapos,ptw->fontwidth):screenpos;
			} else {
				screenpos+=charset_width(ptw->font,
											p->text+datapos,ptw->fontwidth);
				datapos+=charset_length(p->text[datapos]);
			}
	return screenpos;
}


/*	̾κɸ饤ХåեΥɥ쥹
	  ptw,TXTɥ
	    x,xɸ
	    y,yɸ
	align,TRUE:˴󤻤,FALSE:˴󤻤
	  RET,ɥ쥹															*/
gint get_data_pos(TEXTWND *ptw,gint x,gint y,gboolean align)
{
	gint datapos=0,screenpos=0;
	LINEBUF *p;

	p=get_line_buf(&ptw->start,&ptw->off,y);
	while (screenpos<x && datapos<p->length)
		if (p->text[datapos]=='\t') {
			screenpos=(screenpos/ptw->tab+1)*ptw->tab;
			if (x<screenpos)
				return align?datapos+1:datapos;
			datapos++;
		} else if (datapos+charset_length(p->text[datapos])>p->length) {
			screenpos++;
			datapos++;
		} else if (x<screenpos+charset_width(ptw->font,
											p->text+datapos,ptw->fontwidth)) {
			return align?datapos+charset_length(p->text[datapos]):datapos;
		} else {
			screenpos+=charset_width(ptw->font,p->text+datapos,ptw->fontwidth);
			datapos+=charset_length(p->text[datapos]);
		}
	return MIN(datapos,p->length);
}


/*	饤ХåեΥɥ쥹̾κɸ
	ptw,TXTɥ
	  x,xɸ
	  y,yɸ
	RET,ɸ																*/
gint get_screen_pos(TEXTWND *ptw,gint x,gint y)
{
	gint datapos=0,screenpos=0;
	LINEBUF *p;

	p=get_line_buf(&ptw->start,&ptw->off,y);
	while (datapos<x)
		if (p->text[datapos]=='\t') {
			screenpos=(screenpos/ptw->tab+1)*ptw->tab;
			datapos++;
		} else if (datapos+charset_length(p->text[datapos])<=x) {
			screenpos+=charset_width(ptw->font,p->text+datapos,ptw->fontwidth);
			datapos+=charset_length(p->text[datapos]);
		} else {
			break;
		}
	return screenpos;
}


/*	ʸʬ
	  text,ʸ
	length,ʸ
	   RET,ʬ																*/
guint get_char_type(gchar *text,gint length)
{
	return charset_type(text,length)&~(CS_CONTROL|CS_SPACE|CS_PUNCT|CS_SYMBOL);
}


/*	ڤ
	 ptw,TXTɥ
	   x,xɸ
	   y,yɸ
	move,TRUE:˰ư,FALSE:˰ư
	 RET,ɸ																*/
gint get_move_pos(TEXTWND *ptw,gint x,gint y,gboolean move)
{
	gint i,j,datapos,length,*type;/* 1ʸΥХȿ */
	guint ct,ctype;
	LINEBUF *p;

	p=get_line_buf(&ptw->start,&ptw->off,y);
	if (move) {
		/* ذư */
		datapos=get_data_pos(ptw,x,y,FALSE);
		length=datapos+charset_length(p->text[datapos])<=p->length
										?charset_length(p->text[datapos]):1;
		ctype=get_char_type(p->text+datapos,length);
		datapos+=length;
		while (datapos<p->length) {
			length=datapos+charset_length(p->text[datapos])<=p->length
										?charset_length(p->text[datapos]):1;
			ct=get_char_type(p->text+datapos,length);
			if ((ctype&ct)==0) {
				if (ct!=0)
					break;
				ctype=0;
			}
			datapos+=length;
		}
	} else {
		/* ذư */
		datapos=get_data_pos(ptw,x,y,FALSE);
		if (datapos<=0)
			return 0;
		type=g_malloc(datapos*sizeof(gint));
		i=0;
		while (i<datapos)
			if (i+charset_length(p->text[i])<=datapos) {
				for (j=0;j<charset_length(p->text[i]);j++)
					type[i+j]=j+1;
				i+=charset_length(p->text[i]);
			} else {
				type[i++]=1;
			}
		length=type[datapos-1];
		datapos-=length;
		ctype=get_char_type(p->text+datapos,length);
		while (datapos>0 && (datapos-=length=type[datapos-1])>=0) {
			ct=get_char_type(p->text+datapos,length);
			if ((ctype&ct)==0) {
				if (ctype!=0) {
					datapos+=length;
					break;
				}
				ctype=ct;
			}
		}
		g_free(type);
	}
	return get_screen_pos(ptw,datapos,y);
}


/*	ϰϤΥХȿ
	     ptw,TXTɥ
	 start_p,ϰ
	   end_p,ϰ
	     RET,Хȿ														*/
gint get_sel_bytes(TEXTWND *ptw,GdkPoint *start_p,GdkPoint *end_p)
{
	gint i,stpos,edpos,length;
	LINEBUF *p;
	GdkPoint st,ed;

	if (start_p->y<end_p->y || (start_p->y==end_p->y && start_p->x<end_p->x)) {
		st=*start_p;
		ed=*end_p;
	} else {
		st=*end_p;
		ed=*start_p;
	}
	stpos=get_data_pos(ptw,st.x,st.y,FALSE);
	edpos=get_data_pos(ptw,ed.x,ed.y,FALSE);
	if (st.y==ed.y) {
		/* Ʊ */
		length=edpos-stpos;
	} else {
		/* 㤦 */
		p=get_line_buf(&ptw->start,&ptw->off,st.y);
		length=p->length-stpos+edpos+(p->margin?0:1);
		for (i=st.y+1,p=p->next;i<ed.y && p!=NULL;i++,p=p->next)
			length+=p->length+(p->margin?0:1);
	}
	return length;
}


/*	ϰϤ˥ԡ
	    ptw,TXTɥ
	start_p,ϰ
	  end_p,ϰ
	   text,															*/
void cpy_sel_mem(TEXTWND *ptw,GdkPoint *start_p,GdkPoint *end_p,gchar *text)
{
	gint i,stpos,edpos,length;
	LINEBUF *p;
	GdkPoint st,ed;

	if (start_p->y<end_p->y || (start_p->y==end_p->y && start_p->x<end_p->x)) {
		st=*start_p;
		ed=*end_p;
	} else {
		st=*end_p;
		ed=*start_p;
	}
	stpos=get_data_pos(ptw,st.x,st.y,FALSE);
	edpos=get_data_pos(ptw,ed.x,ed.y,FALSE);
	p=get_line_buf(&ptw->start,&ptw->off,st.y);
	if (st.y==ed.y) {
		/* Ʊ */
		memcpy(text,p->text+stpos,(edpos-stpos)*sizeof(gchar));
	} else {
		/* 㤦 */
		length=p->length-stpos;
		memcpy(text,p->text+stpos,length*sizeof(gchar));
		if (!p->margin) {
			memcpy(text+length,"\n",sizeof(gchar));
			length++;
		}
		for (i=st.y+1,p=p->next;i<ed.y && p!=NULL;i++,p=p->next) {
			memcpy(text+length,p->text,p->length*sizeof(gchar));
			length+=p->length;
			if (!p->margin) {
				/*  */
				memcpy(text+length,"\n",sizeof(gchar));
				length++;
			}
		}
		memcpy(text+length,p->text,edpos*sizeof(gchar));
	}
}


/*	ƤŽդ
	   ptw,TXTɥ
	   put,Žդɸ
	   new,ɸ
	  text,
	length,Хȿ
	   RET,줿Կ													*/
gint put_mem(TEXTWND *ptw,GdkPoint *put,GdkPoint *new,gchar *text,gint length)
{
	gint i=0,temp_leng,insert=0,datapos,screenpos;
	LINEBUF *p,*q;
	gchar *temp;

	datapos=get_data_pos(ptw,put->x,put->y,FALSE);
	p=get_line_buf(&ptw->start,&ptw->off,put->y);
	if (datapos<=0 && p->prev!=NULL && p->prev->margin && length>=1
									&& memcmp(text,"\n",sizeof(gchar))==0) {
		/* ƬؤιԤޤ֤ƤꡢʸԤΤȤ */
		p=p->prev;
		datapos=p->length;
		put->x=get_screen_pos(ptw,p->length,--put->y);
		/* ιԤαüذư */
	}
	if (datapos<p->length) {
		/* ְʹߤʸХåե¸ */
		temp_leng=p->length-datapos;
		temp=g_malloc(temp_leng*sizeof(gchar));
		memcpy(temp,p->text+datapos,temp_leng*sizeof(gchar));
		p->length=datapos;
	} else {
		temp_leng=0;
		temp=NULL;
	}
	if (ptw->limit) {
		/* ޡޤ֤ */
		screenpos=0;
		for (datapos=0;datapos<p->length;datapos++)
			if (p->text[datapos]=='\t')
				screenpos=(screenpos/ptw->tab+1)*ptw->tab;
			else if (datapos+charset_length(text[datapos])<=length)
				screenpos+=charset_width(ptw->font,
											p->text+datapos,ptw->fontwidth);
			else
				screenpos++;
		while (i<length) {
			datapos=i;
			while (datapos<length && text[datapos]!='\n')
				if (text[datapos]=='\t') {
					screenpos=(screenpos/ptw->tab+1)*ptw->tab;
					if (ptw->margin<screenpos)
						break;
					datapos++;
				} else if (datapos+charset_length(text[datapos])<=length) {
					screenpos+=charset_width(ptw->font,
											p->text+datapos,ptw->fontwidth);
					if (ptw->margin<screenpos)
						break;
					datapos+=charset_length(text[datapos]);
				} else {
					screenpos++;
					if (ptw->margin<screenpos)
						break;
					datapos++;
				}
			if (p->length>0 || i!=datapos)
				p->text=g_realloc(p->text,(p->length+datapos-i)*sizeof(gchar));
			memcpy(p->text+p->length,text+i,(datapos-i)*sizeof(gchar));
			p->length+=datapos-i;
			if (length<=datapos) {
				i=datapos;
			} else {
				q=g_malloc(sizeof(LINEBUF));
				q->length=0;
				q->margin=p->margin;
				q->text=NULL;
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				if (datapos<=length-1 && text[datapos]=='\n') {
					/*  */
					i=datapos+1;
					p->margin=FALSE;
				} else {
					/*  */
					i=datapos;
					p->margin=TRUE;
				}
				p=q;
				screenpos=0;
				insert++;
			}
		}
	} else {
		/* ޡޤ֤ʤ */
		while (i<length) {
			for (datapos=i;datapos<length && text[datapos]!='\n';datapos++);
			if (p->length>0 || i!=datapos)
				p->text=g_realloc(p->text,(p->length+datapos-i)*sizeof(gchar));
			memcpy(p->text+p->length,text+i,(datapos-i)*sizeof(gchar));
			p->length+=datapos-i;
			if (length<=datapos) {
				i=datapos;
			} else {
				i=datapos+1;
				q=g_malloc(sizeof(LINEBUF));
				q->length=0;
				q->margin=FALSE;
				q->text=NULL;
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				p=q;
				insert++;
			}
		}
	}
	if (new!=NULL) {
		new->x=0;
		datapos=0;
		while (datapos<p->length)
			if (p->text[datapos]=='\t') {
				new->x=(new->x/ptw->tab+1)*ptw->tab;
				datapos++;
			} else if (datapos+charset_length(p->text[datapos])<=p->length) {
				new->x+=charset_width(ptw->font,
											p->text+datapos,ptw->fontwidth);
				datapos+=charset_length(p->text[datapos]);
			} else {
				new->x++;
				datapos++;
			}
		new->y=put->y+insert;
		if (ptw->limit && p->margin && (ptw->margin<=new->x
				|| (temp!=NULL && ptw->margin<=new->x+charset_width(ptw->font,
													temp,ptw->fontwidth)))) {
			new->x=0;
			new->y++;
		}
	}
	if (temp!=NULL) {
		/* ְʹߤʸ᤹ */
		p->text=g_realloc(p->text,(p->length+temp_leng)*sizeof(gchar));
		memcpy(p->text+p->length,temp,temp_leng*sizeof(gchar));
		p->length+=temp_leng;
		g_free(temp);
	}
	if (ptw->limit)
		/* ޡޤ֤ */
		while (p!=NULL) {
			datapos=screenpos=0;
			while (datapos<p->length)
				if (p->text[datapos]=='\t') {
					screenpos=(screenpos/ptw->tab+1)*ptw->tab;
					if (ptw->margin<screenpos)
						break;
					datapos++;
				} else if (datapos+charset_length(text[datapos])<=length) {
					screenpos+=charset_width(ptw->font,
												text+datapos,ptw->fontwidth);
					if (ptw->margin<screenpos)
						break;
					datapos+=charset_length(text[datapos]);
				} else {
					screenpos++;
					if (ptw->margin<screenpos)
						break;
					datapos++;
				}
			if (ptw->margin<screenpos) {
				/* ޡĶƤȤԤ */
				q=g_malloc(sizeof(LINEBUF));
				q->length=p->length-datapos;
				q->margin=p->margin;
				q->text=g_malloc(q->length*sizeof(gchar));
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				memcpy(q->text,p->text+datapos,q->length*sizeof(gchar));
				p->length=datapos;
				p->margin=TRUE;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				p=q;
				insert++;
			} else if (screenpos<ptw->margin && p->margin && p->next!=NULL) {
				/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
				datapos=p->length;
				q=p->next;
				if (q->next!=NULL)
					q->next->prev=p;
				p->next=q->next;
				p->length+=q->length;
				p->margin=q->margin;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				memcpy(p->text+datapos,q->text,q->length*sizeof(gchar));
				g_free(q->text);
				g_free(q);
				insert--;
			} else {
				break;
			}
		}
	return insert;
}


/*	ϰϤ
	    ptw,TXTɥ
	start_p,ϰ
	  end_p,ϰ
	    RET,줿Կ													*/
gint del_sel_mem(TEXTWND *ptw,GdkPoint *start_p,GdkPoint *end_p)
{
	gint i,stpos,edpos,delete,datapos,screenpos;
	LINEBUF *p,*q,*r;
	GdkPoint st,ed;

	if (start_p->y<end_p->y || (start_p->y==end_p->y && start_p->x<end_p->x)) {
		st=*start_p;
		ed=*end_p;
	} else {
		st=*end_p;
		ed=*start_p;
	}
	stpos=get_data_pos(ptw,st.x,st.y,FALSE);
	edpos=get_data_pos(ptw,ed.x,ed.y,FALSE);
	p=get_line_buf(&ptw->start,&ptw->off,st.y);
	if (st.y==ed.y) {
		/* Ʊ */
		memcpy(p->text+stpos,p->text+edpos,(p->length-edpos)*sizeof(gchar));
		p->length-=edpos-stpos;
		p->text=g_realloc(p->text,p->length);
		delete=0;
	} else {
		/* 㤦 */
		for (i=st.y+1,q=p->next;i<ed.y && q!=NULL;i++,q=r) {
			g_free(q->text);
			r=q->next;
			g_free(q);
		}
		if (q->next!=NULL)
			q->next->prev=p;
		p->next=q->next;
		p->length=stpos+q->length-edpos;
		p->margin=q->margin;
		p->text=g_realloc(p->text,p->length);
		memcpy(p->text+stpos,q->text+edpos,(q->length-edpos)*sizeof(gchar));
		g_free(q->text);
		g_free(q);
		delete=ed.y-st.y;
	}
	q=p->prev;
	if (q!=NULL && q->margin && st.x<=0) {
		/* ιԤԤǺϤƬΤȤ */
		if (p->length>0) {
			datapos=screenpos=0;
			while (datapos<q->length)
				if (q->text[datapos]=='\t') {
					screenpos=(screenpos/ptw->tab+1)*ptw->tab;
					datapos++;
				} else if (datapos+charset_length(q->text[datapos])
																<=q->length) {
					screenpos+=charset_width(ptw->font,
											q->text+datapos,ptw->fontwidth);
					datapos+=charset_length(q->text[datapos]);
				} else {
					screenpos++;
					datapos++;
				}
			if (p->text[0]=='\t')
				screenpos=(screenpos/ptw->tab+1)*ptw->tab;
			else if (charset_length(p->text[0])<=p->length)
				screenpos+=charset_width(ptw->font,p->text,ptw->fontwidth);
			else
				screenpos++;
		} else {
			screenpos=0;
		}
		if (p->length<=0 || screenpos<=ptw->margin) {
			/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
			datapos=q->length;
			if (p->next!=NULL)
				p->next->prev=q;
			q->next=p->next;
			q->length+=p->length;
			q->margin=p->margin;
			q->text=g_realloc(q->text,q->length*sizeof(gchar));
			memcpy(q->text+datapos,p->text,p->length*sizeof(gchar));
			g_free(p->text);
			g_free(p);
			delete++;
			p=q;
			if (start_p->y<end_p->y
							|| (start_p->y==end_p->y && start_p->x<end_p->x)) {
				start_p->x=screenpos;
				start_p->y--;
			} else {
				end_p->x=screenpos;
				end_p->y--;
			}
		}
	}
	if (ptw->limit)/* ޡޤ֤ */
		while (p!=NULL) {
			datapos=screenpos=0;
			while (datapos<p->length)
				if (p->text[datapos]=='\t') {
					screenpos=(screenpos/ptw->tab+1)*ptw->tab;
					if (ptw->margin<screenpos)
						break;
					datapos++;
				} else if (datapos+charset_length(p->text[datapos])
																<=p->length) {
					screenpos+=charset_width(ptw->font,
											p->text+datapos,ptw->fontwidth);
					if (ptw->margin<screenpos)
						break;
					datapos+=charset_length(p->text[datapos]);
				} else {
					screenpos++;
					if (ptw->margin<screenpos)
						break;
					datapos++;
				}
			if (ptw->margin<screenpos) {
				/* ޡĶƤȤԤ */
				q=g_malloc(sizeof(LINEBUF));
				q->length=p->length-datapos;
				q->margin=p->margin;
				q->text=g_malloc(q->length*sizeof(gchar));
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				memcpy(q->text,p->text+datapos,q->length*sizeof(gchar));
				p->length=datapos;
				p->margin=TRUE;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				p=q;
				delete--;
			} else if (screenpos<ptw->margin && p->margin && p->next!=NULL) {
				/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
				datapos=p->length;
				q=p->next;
				if (q->next!=NULL)
					q->next->prev=p;
				p->next=q->next;
				p->length+=q->length;
				p->margin=q->margin;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				memcpy(p->text+datapos,q->text,q->length*sizeof(gchar));
				g_free(q->text);
				g_free(q);
				delete++;
			} else if (!p->margin) {
				break;
			} else {
				p=p->next;
			}
		}
	return delete;
}
