/*
    Text maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "charset.h"
#include "command.h"
#include "edit.h"
#include "find.h"
#include "general.h"
#include "signal.h"
#include "toolbar.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ̴ؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	åȤä
	tmaid,TXTɥ													*/
void hide_caret(TmaidWindow *tmaid)
{
	GdkRectangle rc;

	gtk_timeout_remove(timer_id);
	timer_id=0;
	if (caret) {
		caret=FALSE;
		rc.x=edit_get_align_pos(tmaid,tmaid->cursor.x,tmaid->cursor.y,FALSE);
		rc.y=tmaid->cursor.y;
		rc.x=(rc.x-tmaid->top.x)*tmaid->font_width;
		rc.y=(rc.y-tmaid->top.y)*tmaid->font_height;
		rc.width=tmaid->font_width;
		rc.height=tmaid->font_height;
		gtk_widget_draw(tmaid->drawing,&rc);
	}
}


/*	åȤ
	 tmaid,TXTɥ
	cursor,ŤåȰ												*/
void draw_caret(TmaidWindow *tmaid,GdkPoint *cursor)
{
	gchar *text;
	gint x,y;
	guint context_id;
	GdkRectangle rc;

	if (cursor!=NULL && timer_id!=0
			&& (tmaid->cursor.x!=cursor->x || tmaid->cursor.y!=cursor->y)) {
		/* ޺ */
		gtk_timeout_remove(timer_id);
		timer_id=0;
		/* ŤåȤõ */
		rc.x=edit_get_align_pos(tmaid,cursor->x,cursor->y,FALSE);
		rc.y=cursor->y;
		rc.x=(rc.x-tmaid->top.x)*tmaid->font_width;
		rc.y=(rc.y-tmaid->top.y)*tmaid->font_height;
		rc.width=tmaid->font_width;
		rc.height=tmaid->font_height;
		gtk_widget_draw(tmaid->drawing,&rc);
	}
	/* åȤ */
	if (timer_id==0)
		caret=TRUE;
	x=edit_get_align_pos(tmaid,tmaid->cursor.x,tmaid->cursor.y,FALSE);
	y=tmaid->cursor.y;
	rc.x=(x-tmaid->top.x)*tmaid->font_width;
	rc.y=(y-tmaid->top.y)*tmaid->font_height;
	rc.width=tmaid->font_width;
	rc.height=tmaid->font_height;
	gtk_widget_draw(tmaid->drawing,&rc);
	if (timer_id==0)
		timer_id=gtk_timeout_add(500,signal_timeout,NULL);
	text=g_strdup_printf(tmaid->select.x<0
						?_("%d,%d"):_("%d,%d  Selected(%d,%d)-(%d,%d)"),
						x+1,y+1,tmaid->select.x+1,tmaid->select.y+1,x+1,y+1);
	context_id=gtk_statusbar_get_context_id(GTK_STATUSBAR(status),"Status");
	gtk_statusbar_pop(GTK_STATUSBAR(status),context_id);
	gtk_statusbar_push(GTK_STATUSBAR(status),context_id,text);
	g_free(text);
#ifdef USE_XIM
	if (GTK_WIDGET_HAS_FOCUS(tmaid->drawing)
				&& gdk_im_ready() && tmaid->ic!=NULL
				&& (gdk_ic_get_style(tmaid->ic)&GDK_IM_PREEDIT_POSITION)!=0) {
		tmaid->ic_attr->spot_location.x=rc.x;
		tmaid->ic_attr->spot_location.y=rc.y+tmaid->font_ascent;
		gdk_ic_set_attr(tmaid->ic,tmaid->ic_attr,GDK_IC_SPOT_LOCATION);
	}
#endif
}


/*	˥塼ꤹ
	tmaid,TXTɥ													*/
void set_menu_bar(TmaidWindow *tmaid)
{
	GList *glist;
	GtkWidget *menu;

	if (tmaid!=NULL) {
		gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Edit"))),TRUE);
		gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Search"))),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Close"),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Save"),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Save As..."),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Reload"),!tmaid->create);
#ifdef USE_GDKPIXBUF
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Print..."),TRUE);
#endif
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Properties..."),TRUE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Edit/Undo"),tmaid->undo!=NULL);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Edit/Redo"),tmaid->redo!=NULL);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Edit/Cut"),tmaid->select.x>=0);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Edit/Copy"),tmaid->select.x>=0);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Edit/Delete"),tmaid->select.x>=0);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Search/Next"),find_num>0);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Search/Previous"),find_num>0);
		gtk_widget_set_sensitive(toolbar_items[ 2].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[ 4].item,TRUE);
#ifdef USE_GDKPIXBUF
		gtk_widget_set_sensitive(toolbar_items[ 6].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[ 8].item,tmaid->select.x>=0);
		gtk_widget_set_sensitive(toolbar_items[ 9].item,tmaid->select.x>=0);
		gtk_widget_set_sensitive(toolbar_items[10].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[11].item,tmaid->select.x>=0);
		gtk_widget_set_sensitive(toolbar_items[13].item,tmaid->undo!=NULL);
		gtk_widget_set_sensitive(toolbar_items[14].item,tmaid->redo!=NULL);
		gtk_widget_set_sensitive(toolbar_items[16].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[17].item,TRUE);
#else
		gtk_widget_set_sensitive(toolbar_items[ 6].item,tmaid->select.x>=0);
		gtk_widget_set_sensitive(toolbar_items[ 7].item,tmaid->select.x>=0);
		gtk_widget_set_sensitive(toolbar_items[ 8].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[ 9].item,tmaid->select.x>=0);
		gtk_widget_set_sensitive(toolbar_items[11].item,tmaid->undo!=NULL);
		gtk_widget_set_sensitive(toolbar_items[12].item,tmaid->redo!=NULL);
		gtk_widget_set_sensitive(toolbar_items[14].item,TRUE);
		gtk_widget_set_sensitive(toolbar_items[15].item,TRUE);
#endif
	} else {
		gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Edit"))),FALSE);
		gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(
								gtk_item_factory_get_widget(item_factory_menu,
									"<main>/Search"))),FALSE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Close"),FALSE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Save"),FALSE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Save As..."),FALSE);
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Reload"),FALSE);
#ifdef USE_GDKPIXBUF
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Print..."),FALSE);
#endif
		gtk_widget_set_sensitive(gtk_item_factory_get_widget(item_factory_menu,
									"<main>/File/Properties..."),FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 2].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 4].item,FALSE);
#ifdef USE_GDKPIXBUF
		gtk_widget_set_sensitive(toolbar_items[ 6].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 8].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 9].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[10].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[11].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[13].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[14].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[16].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[17].item,FALSE);
#else
		gtk_widget_set_sensitive(toolbar_items[ 6].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 7].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 8].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[ 9].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[11].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[12].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[14].item,FALSE);
		gtk_widget_set_sensitive(toolbar_items[15].item,FALSE);
#endif
	}
	menu=gtk_item_factory_get_widget(item_factory_menu,"<main>/Window");
	glist=gtk_container_children(GTK_CONTAINER(menu));
	gtk_widget_set_sensitive(gtk_menu_get_attach_widget(GTK_MENU(menu)),
													g_list_length(glist)>0);
	g_list_free(glist);
}


/*	ϰϤ褹
	tmaid,TXTɥ
	start,
	  end,λ																*/
void clear_sel(TmaidWindow *tmaid,GdkPoint *start,GdkPoint *end)
{
	gint st,ed;
	GdkRectangle rc;

	if (start->y==end->y) {
		/* Ʊ */
		st=edit_get_align_pos(tmaid,MIN(start->x,end->x),start->y,FALSE);
		ed=edit_get_align_pos(tmaid,MAX(start->x,end->x),start->y,TRUE);
		rc.x=(st-tmaid->top.x)*tmaid->font_width;
		rc.y=(start->y-tmaid->top.y)*tmaid->font_height;
		rc.width=(ed-st+1)*tmaid->font_width;
		rc.height=tmaid->font_height;
	} else {
		/* 㤦 */
		rc.x=0;
		rc.y=(MIN(start->y,end->y)-tmaid->top.y)*tmaid->font_height;
		rc.width=tmaid->drawing->allocation.width;
		rc.height=(ABS(start->y-end->y)+1)*tmaid->font_height;
	}
	gtk_widget_draw(tmaid->drawing,&rc);
}


/*	ư
	tmaid,TXTɥ
	top,Ťκɸ														*/
void move_edit_window(TmaidWindow *tmaid,GdkPoint *top)
{
	if (tmaid->top.x!=top->x || tmaid->top.y!=top->y)
		misc_scroll_window(tmaid->drawing,
									(top->x-tmaid->top.x)*tmaid->font_width,
									(top->y-tmaid->top.y)*tmaid->font_height,
									0,0,
									tmaid->drawing->allocation.width,
									tmaid->drawing->allocation.height);
}


/*	åȰ֤˥ǡ/񤭤
	 tmaid,TXTɥ
	  text,ǡǼݥ
	length,ǡΥХȿ
	 caret,TRUE:ư,FALSE:ưʤ
	select,TRUE:򤹤,FALSE:򤷤ʤ
	   RET,դԤDOING¤,NULL:顼							*/
TmaidHistory *edit_operation(TmaidWindow *tmaid,
									const gchar *text,const gint length,
									const gboolean caret,const gboolean select)
{
	gint i,j,sx,sy,max,delete,put;
	GdkPoint cursor_old,cursor_new,top;
	GdkRectangle rc;
	LineBuffer *p,*q;
	TmaidHistory *d;

	hide_caret(tmaid);
	tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
	top=tmaid->top;
	sx=MAX(tmaid->drawing->allocation.width/tmaid->font_width,1);
	sy=MAX(tmaid->drawing->allocation.height/tmaid->font_height,1);
	d=g_malloc(sizeof(TmaidHistory));
	if (tmaid->select.x<0) {
		d->text=NULL;
		d->length=0;
		d->caret=FALSE;
	} else {
		/*  */
		d->length=edit_get_sel_bytes(tmaid,&tmaid->cursor,&tmaid->select);
		d->text=g_malloc(d->length*sizeof(gchar));
		edit_cpy_sel_mem(tmaid,&tmaid->cursor,&tmaid->select,d->text);
		delete=edit_del_sel_mem(tmaid,&tmaid->cursor,&tmaid->select);
		tmaid->max-=delete;/* Կ */
		/* ϰϲȥåȰư */
		if (tmaid->select.y<tmaid->cursor.y
										|| (tmaid->select.y==tmaid->cursor.y
										&& tmaid->select.x<tmaid->cursor.x)) {
			tmaid->cursor=tmaid->select;
			d->caret=TRUE;
		} else {
			tmaid->cursor=tmaid->cursor;
			d->caret=FALSE;
		}
		tmaid->select.x=-1;
		/* Ԥκ걦(ޡΤ1¿) */
		rc.x=(tmaid->cursor.x-tmaid->top.x-1)*tmaid->font_width;
		rc.y=(tmaid->cursor.y-tmaid->top.y)*tmaid->font_height;
		rc.width=tmaid->drawing->allocation.width-rc.x;
		rc.height=tmaid->font_height;
		gtk_widget_draw(tmaid->drawing,&rc);
		/* äԿʬ */
		misc_scroll_window(tmaid->drawing,0,-delete*tmaid->font_height,
				0,
				(tmaid->cursor.y-tmaid->top.y+1)*tmaid->font_height,
				tmaid->drawing->allocation.width,
				MAX(tmaid->drawing->allocation.height
					-(tmaid->cursor.y-tmaid->top.y+1)*tmaid->font_height,0));
		/* 򽪤֤鱦ޡαƶΤԿ */
		for (i=0,
				p=edit_get_line_buf(&tmaid->start,&tmaid->off,tmaid->cursor.y);
														p!=NULL;i++,p=p->next)
			if (!p->margin)
				break;
		if (i>0) {
			rc.x=0;
			rc.y=(tmaid->cursor.y-tmaid->top.y+1)*tmaid->font_height;
			rc.width=tmaid->drawing->allocation.width;
			rc.height=i*tmaid->font_height;
			gtk_widget_draw(tmaid->drawing,&rc);
		}
	}
	if (length<=0 || text==NULL) {
		d->cursor=tmaid->cursor;
		d->select.x=-1;
	} else {
		/*  */
		tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
		put=edit_put_mem(tmaid,&tmaid->cursor,&cursor_new,text,length);
		tmaid->max+=put;/* Կ */
		cursor_old=tmaid->cursor;
		if (caret) {
			/* åȰư */
			d->cursor=cursor_new;
			d->select=cursor_old;
			tmaid->cursor=cursor_new;
		} else {
			/* åȰưʤ */
			d->cursor=cursor_old;
			d->select=cursor_new;
		}
		if (select) {
			/* 򤹤 */
			tmaid->select=d->select;
			gtk_selection_owner_set(tmaid->drawing,GDK_SELECTION_PRIMARY,
															GDK_CURRENT_TIME);
		}
		/* Ԥ걦 */
		rc.x=(cursor_old.x-tmaid->top.x)*tmaid->font_width;
		rc.y=(cursor_old.y-tmaid->top.y)*tmaid->font_height;
		rc.width=tmaid->drawing->allocation.width;
		rc.height=tmaid->font_height;
		gtk_widget_draw(tmaid->drawing,&rc);
		/* Կʬ */
		misc_scroll_window(tmaid->drawing,0,put*tmaid->font_height,
					0,
					(cursor_old.y-tmaid->top.y+1)*tmaid->font_height,
					tmaid->drawing->allocation.width,
					MAX(tmaid->drawing->allocation.height
						-(cursor_old.y-tmaid->top.y+1)*tmaid->font_height,0));
		/* 򽪤֤鱦ޡαƶΤԿ */
		p=q=edit_get_line_buf(&tmaid->start,&tmaid->off,cursor_new.y);
		for (i=cursor_new.y,j=0;
						p->prev!=NULL && p->prev->margin && cursor_old.y<i;
															i--,j++,p=p->prev);
		while (q->next!=NULL && q->margin)
			j++,q=q->next;
		if (j>0) {
			rc.x=0;
			rc.y=(i-tmaid->top.y+1)*tmaid->font_height;
			rc.width=tmaid->drawing->allocation.width;
			rc.height=j*tmaid->font_height;
			gtk_widget_draw(tmaid->drawing,&rc);
		}
	}
	if (tmaid->cursor.x<tmaid->top.x)
		tmaid->top.x=tmaid->cursor.x;
	else if (tmaid->cursor.x-sx+1>tmaid->top.x)
		tmaid->top.x=tmaid->cursor.x-sx+1;
	if (tmaid->cursor.y<tmaid->top.y)
		tmaid->top.y=tmaid->cursor.y;
	else if (tmaid->cursor.y-sy+1>tmaid->top.y)
		tmaid->top.y=tmaid->cursor.y-sy+1;
	if (tmaid->top.y>tmaid->max-sy)
		tmaid->top.y=MAX(tmaid->max-sy,0);
	max=edit_get_width_max(tmaid);
	if (tmaid->top.x>max-sx+1)
		tmaid->top.x=MAX(max-sx+1,0);
	move_edit_window(tmaid,&top);
	misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,tmaid,
												0,max+1,sx,tmaid->top.x);
	misc_set_scroll_bar(tmaid->vscroll,signal_value_changed_vscroll,tmaid,
												0,tmaid->max,sy,tmaid->top.y);
	draw_caret(tmaid,NULL);
	return d;
}


/*	ꥹȤ
	  d,ꥹȤƬ
	RET,ꥹȤο													*/
gint delete_list(TmaidHistory **d)
{
	gint count=0;
	TmaidHistory *d0,*d1;

	for (d0=*d;d0!=NULL;d0=d1) {
		g_free(d0->text);
		d1=d0->next;
		g_free(d0);
		count++;
	}
	*d=NULL;
	return count;
}


/*	ޡޤ֤
	tmaid,TXTɥ													*/
void modify_margin(TmaidWindow *tmaid)
{
	gint data_pos,screen_pos;
	LineBuffer *p,*q;

	/* 饤ХåեƬذư */
	while (tmaid->start->prev!=NULL)
		tmaid->start=tmaid->start->prev;
	tmaid->off=0;
	p=tmaid->start;
	if (tmaid->limit)
		/* ޡˤԤ */
		while (p!=NULL) {
			data_pos=screen_pos=0;
			while (data_pos<p->length)
				if (p->text[data_pos]=='\t') {
					screen_pos=(screen_pos/tmaid->tab+1)*tmaid->tab;
					if (tmaid->margin<screen_pos)
						break;
					data_pos++;
				} else if (data_pos+charset_length(p->text[data_pos])
																<=p->length) {
					screen_pos+=charset_width(tmaid->font,
										p->text+data_pos,tmaid->font_width);
					if (tmaid->margin<screen_pos)
						break;
					data_pos+=charset_length(p->text[data_pos]);
				} else {
					screen_pos++;
					if (tmaid->margin<screen_pos)
						break;
					data_pos++;
				}
			if (tmaid->margin<screen_pos) {
				/* ޡĶƤȤԤ */
				q=g_malloc(sizeof(LineBuffer));
				q->length=p->length-data_pos;
				q->margin=p->margin;
				q->text=g_malloc(q->length*sizeof(gchar));
				q->prev=p;
				q->next=p->next;
				p->next=q;
				if (q->next!=NULL)
					q->next->prev=q;
				g_memmove(q->text,p->text+data_pos,q->length*sizeof(gchar));
				p->length=data_pos;
				p->margin=TRUE;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				p=q;
				tmaid->max++;
			} else if (screen_pos<tmaid->margin
											&& p->margin && p->next!=NULL) {
				/* ޡ򲼲굼ԤΤȤιԤȤ碌 */
				data_pos=p->length;
				q=p->next;
				if (q->next!=NULL)
					q->next->prev=p;
				p->next=q->next;
				p->length+=q->length;
				p->margin=q->margin;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				g_memmove(p->text+data_pos,q->text,q->length*sizeof(gchar));
				g_free(q->text);
				g_free(q);
				tmaid->max--;
			} else {
				p=p->next;
			}
		}
	else
		/* ޡˤԤʤ */
		while (p!=NULL)
			if (p->margin) {
				/* ԤΤȤιԤȤ碌 */
				data_pos=p->length;
				q=p->next;
				if (q->next!=NULL)
					q->next->prev=p;
				p->next=q->next;
				p->length+=q->length;
				p->margin=q->margin;
				p->text=g_realloc(p->text,p->length*sizeof(gchar));
				g_memmove(p->text+data_pos,q->text,q->length*sizeof(gchar));
				g_free(q->text);
				g_free(q);
				tmaid->max--;
			} else {
				p=p->next;
			}
}


/*	ե¸䤤碌
	tmaid,TXTɥ
	  RET,TRUE:եĤ,FALSE:եĤʤ					*/
gboolean prompt_close(TmaidWindow *tmaid)
{
	gchar *text;

	if (tmaid->edit) {
		text=g_strdup_printf(_("File %s was edited.\nSave?"),tmaid->file);
		switch (misc_message_box("Text maid",text,0,
										_("_Yes"),_("_No"),_("Cancel"),NULL)) {
			case 0:
				command_save(NULL,0,NULL);
				if (!tmaid->edit)
					break;
			case 2:
			case -1:
				g_free(text);
				return FALSE;
		}
		g_free(text);
	}
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ٥ؿ                                                              *
*                                                                             *
******************************************************************************/
/*	Խ
	tmaid,TXTɥ
	 kind,TRUE:redo,FALSE:undo												*/
void history_operation(TmaidWindow *tmaid,const gboolean kind)
{
	GdkPoint cursor,select;
	TmaidHistory *d0,*d1;

	if (kind) {
		d0=tmaid->redo;
		tmaid->redo=d0->next;
	} else {
		d0=tmaid->undo;
		tmaid->undo=d0->next;
	}
	cursor=tmaid->cursor;
	select=tmaid->select;
	tmaid->cursor=d0->cursor;
	tmaid->select=d0->select;
	if (select.x>=0)
		clear_sel(tmaid,&select,&cursor);
	d1=edit_operation(tmaid,d0->text,d0->length,d0->caret,TRUE);
	if (kind) {
		d1->next=tmaid->undo;
		tmaid->undo=d1;
	} else {
		d1->next=tmaid->redo;
		tmaid->redo=d1;
	}
	g_free(d0->text);
	g_free(d0);
	set_menu_bar(tmaid);
}


/*	ޡǲԤ
	tmaid,TXTɥ													*/
void margin_operation(TmaidWindow *tmaid)
{
	gboolean limit;
	LineBuffer *p;

	delete_list(&tmaid->undo);
	delete_list(&tmaid->redo);
	limit=tmaid->limit;
	tmaid->limit=TRUE;
	modify_margin(tmaid);
	for (p=tmaid->start;p->prev!=NULL;p=p->prev);
	while (p!=NULL) {
		p->margin=FALSE;
		p=p->next;
	}
	tmaid->limit=limit;
	tmaid->edit=TRUE;
	tmaid->cursor.x=tmaid->cursor.y=tmaid->top.x=tmaid->top.y=0;
	tmaid->select.x=-1;
	misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,tmaid,
				0,edit_get_width_max(tmaid)+1,
				MAX(tmaid->drawing->allocation.width/tmaid->font_width,1),
																tmaid->top.x);
	misc_set_scroll_bar(tmaid->vscroll,signal_value_changed_vscroll,tmaid,
				0,tmaid->max,
				MAX(tmaid->drawing->allocation.height/tmaid->font_height,1),
																tmaid->top.y);
	set_menu_bar(tmaid);
	gtk_widget_draw(tmaid->drawing,NULL);
}


/*	֤򥹥ڡѴ
	tmaid,TXTɥ													*/
void tab_operation(TmaidWindow *tmaid)
{
	gchar *temp;
	gint data_pos,screen_pos;
	LineBuffer *p;

	delete_list(&tmaid->undo);
	delete_list(&tmaid->redo);
	for (p=tmaid->start;p->prev!=NULL;p=p->prev);
	while (p!=NULL) {
		data_pos=screen_pos=0;
		while (data_pos<p->length)
			if (p->text[data_pos]=='\t') {
				screen_pos=(screen_pos/tmaid->tab+1)*tmaid->tab;
				data_pos++;
			} else if (data_pos+charset_length(p->text[data_pos])<=p->length) {
				screen_pos+=charset_width(tmaid->font,
										p->text+data_pos,tmaid->font_width);
				data_pos+=charset_length(p->text[data_pos]);
			} else {
				screen_pos++;
				data_pos++;
			}
		if (screen_pos>data_pos) {
			temp=g_malloc(screen_pos*sizeof(gchar));
			g_memset(temp,' ',screen_pos*sizeof(gchar));
			data_pos=screen_pos=0;
			while (data_pos<p->length)
				if (p->text[data_pos]=='\t') {
					screen_pos=(screen_pos/tmaid->tab+1)*tmaid->tab;
					data_pos++;
				} else if (data_pos+charset_length(p->text[data_pos])
																<=p->length) {
					g_memmove(temp+screen_pos,p->text+data_pos,
											charset_length(p->text[data_pos]));
					screen_pos+=charset_width(tmaid->font,
										p->text+data_pos,tmaid->font_width);
					data_pos+=charset_length(p->text[data_pos]);
				} else {
					temp[screen_pos]=p->text[data_pos];
					screen_pos++;
					data_pos++;
				}
			g_free(p->text);
			p->length=screen_pos;
			p->text=temp;
		}
		p=p->next;
	}
	tmaid->edit=TRUE;
	tmaid->select.x=-1;
	set_menu_bar(tmaid);
	gtk_widget_draw(tmaid->drawing,NULL);
}
