/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "argument.h"
#include "charset.h"
#include "edit.h"
#include "file.h"
#include "general.h"
#include "jump.h"
#include "signal.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ()                                             *
*                                                                             *
******************************************************************************/
gboolean signal_timeout(gpointer data)
{
	gint page;
	GdkRectangle rc;
	TmaidWindow *tmaid;

	caret=!caret;
	if ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		tmaid=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
		rc.x=(edit_get_align_pos(tmaid,tmaid->cursor.x,tmaid->cursor.y,FALSE)
											-tmaid->top.x)*tmaid->font_width;
		rc.y=(tmaid->cursor.y-tmaid->top.y)*tmaid->font_height;
		rc.width=tmaid->font_width;
		rc.height=tmaid->font_height;
		gtk_widget_draw(tmaid->drawing,&rc);
	}
	return TRUE;
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ƥ)                                           *
*                                                                             *
******************************************************************************/
gboolean signal_focus_in(GtkWidget *widget,
									GdkEventFocus *event,TmaidWindow *tmaid)
{
	GTK_WIDGET_SET_FLAGS(widget,GTK_HAS_FOCUS);
#ifdef USE_XIM
	if (tmaid->ic!=NULL)
		gdk_im_begin(tmaid->ic,widget->window);
#endif
	draw_caret(tmaid,NULL);
	return FALSE;
}


gboolean signal_focus_out(GtkWidget *widget,
									GdkEventFocus *event,TmaidWindow *tmaid)
{
	GTK_WIDGET_UNSET_FLAGS(widget,GTK_HAS_FOCUS);
#ifdef USE_XIM
	gdk_im_end();
#endif
	draw_caret(tmaid,NULL);
	return FALSE;
}


void signal_realize(GtkWidget *widget,TmaidWindow *tmaid)
{
	/*  */
	gdk_window_set_cursor(tmaid->drawing->window,gdk_cursor_new(GDK_XTERM));
#ifdef USE_XIM
	if (gdk_im_ready() && (tmaid->ic_attr=gdk_ic_attr_new())!=NULL) {
		gint width, height;
		GdkColormap *colormap;
		GdkICAttributesType attrmask=GDK_IC_ALL_REQ
					| GDK_IC_PREEDIT_FOREGROUND | GDK_IC_PREEDIT_BACKGROUND;
		GdkIMStyle supported_style=GDK_IM_PREEDIT_NONE
									| GDK_IM_PREEDIT_NOTHING
									| GDK_IM_STATUS_NONE
									| GDK_IM_STATUS_NOTHING;

		if (tmaid->font->type==GDK_FONT_FONTSET)
			supported_style|=GDK_IM_PREEDIT_POSITION;
		tmaid->ic_attr->style=gdk_im_decide_style(supported_style);
		tmaid->ic_attr->client_window=tmaid->drawing->window;
		if ((colormap=gtk_widget_get_colormap(tmaid->drawing))
										!=gtk_widget_get_default_colormap()) {
			attrmask|=GDK_IC_PREEDIT_COLORMAP;
			tmaid->ic_attr->preedit_colormap=colormap;
		}
		tmaid->ic_attr->preedit_foreground=tmaid->syscol
											?system_color[0]:tmaid->color[0];
		tmaid->ic_attr->preedit_background=tmaid->syscol
											?system_color[1]:tmaid->color[1];
		switch (tmaid->ic_attr->style&GDK_IM_PREEDIT_MASK) {
			case GDK_IM_PREEDIT_POSITION:
				if (tmaid->font->type==GDK_FONT_FONTSET) {
					attrmask|=GDK_IC_PREEDIT_POSITION_REQ;
					gdk_window_get_size(tmaid->drawing->window,&width,&height);
					tmaid->ic_attr->spot_location.x=0;
					tmaid->ic_attr->spot_location.y=0;
					tmaid->ic_attr->preedit_area.x=0;
					tmaid->ic_attr->preedit_area.y=0;
					tmaid->ic_attr->preedit_area.width=width;
					tmaid->ic_attr->preedit_area.height=height;
					tmaid->ic_attr->preedit_fontset=tmaid->font;
				}
				break;
		}
		if ((tmaid->ic=gdk_ic_new(tmaid->ic_attr,attrmask))!=NULL) {
			gtk_widget_add_events(tmaid->drawing,gdk_ic_get_events(tmaid->ic));
			if (GTK_WIDGET_HAS_FOCUS(tmaid->drawing))
				gdk_im_begin(tmaid->ic,tmaid->drawing->window);
		}
	}
#endif
}


void signal_unrealize(GtkWidget *widget,TmaidWindow *tmaid)
{
	if (tmaid->ic!=NULL) {
		gdk_ic_destroy(tmaid->ic);
		tmaid->ic=NULL;
	}
	if (tmaid->ic_attr!=NULL) {
		gdk_ic_attr_destroy(tmaid->ic_attr);
		tmaid->ic_attr=NULL;
	}
}


void signal_value_changed_hscroll(GtkAdjustment *adjust,TmaidWindow *tmaid)
{
	GdkPoint top;

	top=tmaid->top;
	tmaid->top.x=adjust->value;
	move_edit_window(tmaid,&top);
	draw_caret(tmaid,NULL);
}


void signal_value_changed_vscroll(GtkAdjustment *adjust,TmaidWindow *tmaid)
{
	gint max,sx;
	GdkPoint top;

	top=tmaid->top;
	tmaid->top.y=adjust->value+0.5;
	sx=MAX(tmaid->drawing->allocation.width/tmaid->font_width,1);
	max=edit_get_width_max(tmaid);
	if (tmaid->top.x>max-sx+1)
		tmaid->top.x=MAX(max-sx+1,0);
	move_edit_window(tmaid,&top);
	if (tmaid->top.x!=top.x)
		misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,tmaid,
													0,max+1,sx,tmaid->top.x);
	draw_caret(tmaid,NULL);
}


gboolean signal_config(GtkWidget *widget,
								GdkEventConfigure *config,TmaidWindow *tmaid)
{
	gint max,sx,sy;

	sx=MAX(config->width/tmaid->font_width,1);
	sy=MAX(config->height/tmaid->font_height,1);
	if (tmaid->top.y>tmaid->max-sy)
		tmaid->top.y=MAX(tmaid->max-sy,0);
	max=edit_get_width_max(tmaid);
	if (tmaid->top.x>max-sx+1)
		tmaid->top.x=MAX(max-sx+1,0);
	misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,tmaid,
												0,max+1,sx,tmaid->top.x);
	misc_set_scroll_bar(tmaid->vscroll,signal_value_changed_vscroll,tmaid,
												0,tmaid->max,sy,tmaid->top.y);
#ifdef USE_XIM
	if (tmaid->ic!=NULL
				&& (gdk_ic_get_style(tmaid->ic)&GDK_IM_PREEDIT_POSITION)!=0) {
		gint width,height;

		gdk_window_get_size(widget->window,&width,&height);
		tmaid->ic_attr->preedit_area.width=width;
		tmaid->ic_attr->preedit_area.height=height;
		gdk_ic_set_attr(tmaid->ic,tmaid->ic_attr,GDK_IC_PREEDIT_AREA);
	}
#endif
	return TRUE;
}


gboolean signal_expose(GtkWidget *widget,
									GdkEventExpose *event,TmaidWindow *tmaid)
{
	gboolean select,space=FALSE;
	gint i,x,y,data_pos,length,width;
	GdkGC *gc;
	GdkPoint start,end,cursor,pt[4];
	LineBuffer *p;

	gc=gdk_gc_new(widget->window);
	gdk_gc_set_line_attributes(gc,1,
								GDK_LINE_SOLID,GDK_CAP_BUTT,GDK_JOIN_MITER);
	for (i=0;i<10;i++)
		gdk_color_alloc(gdk_colormap_get_system(),
								(tmaid->syscol?system_color:tmaid->color)+i);
	cursor.x=edit_get_align_pos(tmaid,tmaid->cursor.x,tmaid->cursor.y,FALSE);
	cursor.y=tmaid->cursor.y;
	if (tmaid->select.x==-1) {
		/* ϰϤʤȤ */
		start.x=-1;
	} else if (tmaid->select.y<tmaid->cursor.y
										|| (tmaid->select.y==tmaid->cursor.y
										&& tmaid->select.x<tmaid->cursor.x)) {
		/* ϰϤȤ */
		start=tmaid->select;
		end=cursor;
	} else {
		/* ϰϤȤ */
		start=cursor;
		end=tmaid->select;
	}
	/* ط */
	gdk_gc_set_foreground(gc,(tmaid->syscol?system_color:tmaid->color)+1);
	gdk_draw_rectangle(widget->window,gc,TRUE,event->area.x,event->area.y,
										event->area.width,event->area.height);
	if (tmaid->gline) {
		/* å */
		gdk_gc_set_foreground(gc,(tmaid->syscol?system_color:tmaid->color)+7);
		for (x=tmaid->font_width-1;x<widget->allocation.width;
														x+=tmaid->font_width)
			gdk_draw_line(widget->window,gc,x,event->area.y,
										x,event->area.y+event->area.height);
		for (y=tmaid->font_height-1;y<widget->allocation.height;
														y+=tmaid->font_height)
			gdk_draw_line(widget->window,gc,event->area.x,y,
										event->area.x+event->area.width,y);
	}
	if (tmaid->vline) {
		/*  */
		gdk_gc_set_foreground(gc,(tmaid->syscol?system_color:tmaid->color)+7);
		for (x=(tmaid->tab-tmaid->top.x%tmaid->tab)*tmaid->font_width-1;
					x<widget->allocation.width;x+=tmaid->font_width*tmaid->tab)
			gdk_draw_line(widget->window,gc,x,event->area.y,
										x,event->area.y+event->area.height);
	}
	if (tmaid->mline) {
		/* ޡ */
		gdk_gc_set_foreground(gc,(tmaid->syscol?system_color:tmaid->color)+6);
		x=(tmaid->margin-tmaid->top.x)*tmaid->font_width;
		gdk_draw_line(widget->window,gc,x,event->area.y,
										x,event->area.y+event->area.height);
	}

	for (y=0,p=edit_get_line_buf(&tmaid->start,&tmaid->off,tmaid->top.y);
								y<event->area.y+event->area.height && p!=NULL;
											y+=tmaid->font_height,p=p->next) {
		if (y+tmaid->font_height<event->area.y)
			continue;
		x=-tmaid->top.x*tmaid->font_width;
		data_pos=0;
		while (x<=event->area.x+event->area.width && data_pos<p->length) {
			if (x+MAX(tmaid->tab,2)*tmaid->font_width<event->area.x) {
				/* ¦ɽʤʬ׻ */
				if (p->text[data_pos]=='\t') {
					x=(((x/tmaid->font_width+tmaid->top.x)/tmaid->tab+1)
								*tmaid->tab-tmaid->top.x)*tmaid->font_width;
					data_pos++;
				} else if (data_pos+charset_length(p->text[data_pos])
																<=p->length) {
					/* Ⱦ/ */
					x+=tmaid->font_width*charset_width(tmaid->font,
										p->text+data_pos,tmaid->font_width);
					data_pos+=charset_length(p->text[data_pos]);
				} else {
					/* Ⱦ */
					x+=tmaid->font_width;
					data_pos++;
				}
				continue;
			}
			/* ϰ */
			select=start.x!=-1 && (start.y==end.y?
						start.y==tmaid->top.y+y/tmaid->font_height
								&& start.x<=tmaid->top.x+x/tmaid->font_width
								&& tmaid->top.x+x/tmaid->font_width<end.x
						:(start.y<tmaid->top.y+y/tmaid->font_height
							&& tmaid->top.y+y/tmaid->font_height<end.y)
							|| (start.y==tmaid->top.y+y/tmaid->font_height
								&& start.x<=tmaid->top.x+x/tmaid->font_width)
							|| (end.y==tmaid->top.y+y/tmaid->font_height
								&& tmaid->top.x+x/tmaid->font_width<end.x));
			if (p->text[data_pos]=='\t') {
				/*  */
				width=(((x/tmaid->font_width+tmaid->top.x)/tmaid->tab+1)
								*tmaid->tab-tmaid->top.x)*tmaid->font_width-x;
				if (select) {
					/*  */
					gdk_gc_set_foreground(gc,
								(tmaid->syscol?system_color:tmaid->color)+9);
					gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
													width,tmaid->font_height);
				}
				if (tmaid->uline) {
					/*  */
					gdk_gc_set_foreground(gc,
								(tmaid->syscol?system_color:tmaid->color)+5);
					gdk_draw_line(widget->window,gc,x,y+tmaid->font_height-1,
											x+width,y+tmaid->font_height-1);
				}
				if (tmaid->code) {
					/* ʸ */
					gdk_gc_set_foreground(gc,
								(tmaid->syscol?system_color:tmaid->color)+2);
					gdk_draw_rectangle(widget->window,gc,FALSE,
								x+tmaid->font_width/6,y+tmaid->font_height/3,
								tmaid->font_height/3,tmaid->font_height/3);
				}
				data_pos++;
			} else if (data_pos+charset_length(p->text[data_pos])<=p->length) {
				/* Ⱦ/ */
				width=tmaid->font_width*charset_width(tmaid->font,
										p->text+data_pos,tmaid->font_width);
				if (select) {
					/*  */
					gdk_gc_set_foreground(gc,
								(tmaid->syscol?system_color:tmaid->color)+9);
					gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
													width,tmaid->font_height);
					gdk_gc_set_foreground(gc,
								(tmaid->syscol?system_color:tmaid->color)+8);
				} else {
					gdk_gc_set_foreground(gc,
									tmaid->syscol?system_color:tmaid->color);
				}
				if (tmaid->space && charset->space!=NULL) {
					space=FALSE;/* ѥڡȽ */
					for (i=0;charset->space[i]!=0;i+=charset->space[i]+1)
						if (charset_length(p->text[data_pos])
															==charset->space[i]
							&& g_memcmp(p->text+data_pos,charset->space+i+1,
														charset->space[i])==0)
							space=TRUE;
				}
				if (space) {
					/* ѥڡ */
					gdk_gc_set_foreground(gc,
								(tmaid->syscol?system_color:tmaid->color)+3);
					gdk_draw_rectangle(widget->window,gc,TRUE,x+1,y+1,
												width-1,tmaid->font_height-1);
				} else {
					/* ʸ */
					gdk_draw_text(widget->window,tmaid->font,gc,
									x,y+tmaid->font_ascent,p->text+data_pos,
											charset_length(p->text[data_pos]));
				}
				data_pos+=charset_length(p->text[data_pos]);
			} else {
				/* Ⱦ */
				width=tmaid->font_width;
				if (select) {
					/*  */
					gdk_gc_set_foreground(gc,
								(tmaid->syscol?system_color:tmaid->color)+9);
					gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
													width,tmaid->font_height);
					gdk_gc_set_foreground(gc,
								(tmaid->syscol?system_color:tmaid->color)+8);
				} else {
					gdk_gc_set_foreground(gc,
									tmaid->syscol?system_color:tmaid->color);
				}
				gdk_draw_text(widget->window,tmaid->font,gc,
									x,y+tmaid->font_ascent,p->text+data_pos,1);
				data_pos++;
			}
			/* åȤ */
			if (caret && GTK_WIDGET_HAS_FOCUS(widget)
							&& cursor.x==tmaid->top.x+x/tmaid->font_width
							&& cursor.y==tmaid->top.y+y/tmaid->font_height) {
				gdk_gc_set_function(gc,GDK_INVERT);
				gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
								ins?2:tmaid->font_width,tmaid->font_height);
				gdk_gc_set_function(gc,GDK_COPY);
			}
			x+=width;
		}
		if (data_pos==p->length && tmaid->crlf) {
			if (start.x>=0 && start.y<=tmaid->top.y+y/tmaid->font_height
								&& tmaid->top.y+y/tmaid->font_height<end.y) {
				/*  */
				gdk_gc_set_foreground(gc,
								(tmaid->syscol?system_color:tmaid->color)+9);
				gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
										tmaid->font_width,tmaid->font_height);
			}
			gdk_gc_set_foreground(gc,
								(tmaid->syscol?system_color:tmaid->color)+4);
			if (p->next==NULL) {
				/* եκǸ */
				gdk_draw_arc(widget->window,gc,TRUE,
						x+tmaid->font_width/6,y+tmaid->font_height/3,
						tmaid->font_height/3,tmaid->font_height/3,0,360*64);
			} else {
				if (p->margin) {
					/* ޡˤ */
					pt[0].x=pt[3].x=x+tmaid->font_width/6;
					pt[0].y=pt[1].y=y+tmaid->font_height/3;
					pt[1].x=pt[2].x=x+tmaid->font_width*5/6;
					pt[2].y=pt[3].y=y+tmaid->font_height*2/3;
					length=4;
				} else {
					/* ̾β */
					pt[0].x=x+tmaid->font_width/6;
					pt[1].x=x+tmaid->font_width*5/6;
					pt[0].y=pt[1].y=y+tmaid->font_height/3;
					pt[2].x=x+tmaid->font_width/2;
					pt[2].y=y+tmaid->font_height*2/3;
					length=3;
				}
				gdk_draw_polygon(widget->window,gc,TRUE,pt,length);
			}
		}
		/* åȤ */
		if (caret && GTK_WIDGET_HAS_FOCUS(widget)
							&& cursor.x==tmaid->top.x+x/tmaid->font_width
							&& cursor.y==tmaid->top.y+y/tmaid->font_height) {
			gdk_gc_set_function(gc,GDK_INVERT);
			gdk_draw_rectangle(widget->window,gc,TRUE,x,y,
								ins?2:tmaid->font_width,tmaid->font_height);
			gdk_gc_set_function(gc,GDK_COPY);
		}
	}

	gdk_gc_destroy(gc);
	return TRUE;
}


gboolean signal_button_press(GtkWidget *widget,
									GdkEventButton *event,TmaidWindow *tmaid)
{
	if (!GTK_WIDGET_HAS_FOCUS(widget))
		gtk_widget_grab_focus(widget);
	switch (event->type) {
	case GDK_BUTTON_PRESS:
		switch (event->button) {
		case 1:/* å */
			{
				gboolean shift;
				GdkPoint cursor,select;

				cursor=tmaid->cursor;
				select=tmaid->select;
				tmaid->cursor.x=tmaid->top.x+event->x/tmaid->font_width;
				tmaid->cursor.y=tmaid->top.y+event->y/tmaid->font_height;
				shift=(event->state&GDK_SHIFT_MASK)!=0;
				if (tmaid->cursor.y<0)
					tmaid->cursor.y=0;
				else if (tmaid->cursor.y>tmaid->max-1)
					tmaid->cursor.y=tmaid->max-1;
				if (tmaid->cursor.x<edit_get_width(tmaid,tmaid->cursor.y))
					tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
				if (tmaid->select.x>=0
								&& (!shift || (tmaid->cursor.x==tmaid->select.x
									&& tmaid->cursor.y==tmaid->select.y))) {
					/*  */
					tmaid->select.x=-1;
					clear_sel(tmaid,&cursor,&select);
					set_menu_bar(tmaid);
				} else if (shift && (tmaid->cursor.x!=cursor.x
											|| tmaid->cursor.y!=cursor.y)) {
					if (tmaid->select.x<0) {
						/* 򤹤 */
						tmaid->select.x=edit_get_align_pos(tmaid,
													cursor.x,cursor.y,FALSE);
						tmaid->select.y=cursor.y;
						gtk_selection_owner_set(widget,GDK_SELECTION_PRIMARY,
															GDK_CURRENT_TIME);
					}
					clear_sel(tmaid,&cursor,&tmaid->cursor);
					set_menu_bar(tmaid);
				}
				draw_caret(tmaid,&cursor);
			}
			break;
		case 2:/* 楯å */
			{
				gchar *text=NULL;
				gint length;
				GdkPoint cursor,select;
				TmaidHistory *d;

				if (gdk_selection_owner_get(GDK_SELECTION_PRIMARY)
									==widget->window && tmaid->select.x>=0) {
					/* 쥯ΥʡʬΤȤ */
					/* ϰϤ */
					length=edit_get_sel_bytes(tmaid,&tmaid->select,&tmaid->cursor);
					text=g_malloc((length+1)*sizeof(gchar));
					edit_cpy_sel_mem(tmaid,&tmaid->select,&tmaid->cursor,text);
					text[length]='\0';
				}
				/* åȰư */
				cursor=tmaid->cursor;
				select=tmaid->select;
				tmaid->cursor.x=tmaid->top.x+event->x/tmaid->font_width;
				tmaid->cursor.y=tmaid->top.y+event->y/tmaid->font_height;
				if (tmaid->cursor.y<0)
					tmaid->cursor.y=0;
				else if (tmaid->cursor.y>tmaid->max-1)
					tmaid->cursor.y=tmaid->max-1;
				if (tmaid->cursor.x<edit_get_width(tmaid,tmaid->cursor.y))
					tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
				/*  */
				if (tmaid->select.x>=0) {
					tmaid->select.x=-1;
					clear_sel(tmaid,&cursor,&select);
					if (text==NULL)
						set_menu_bar(tmaid);
				}
				/* å */
				draw_caret(tmaid,&cursor);
				if (text!=NULL) {
					/* Žդ */
					d=edit_operation(tmaid,text,g_strlen(text),FALSE,TRUE);
					d->next=tmaid->undo;
					tmaid->undo=d;
					if (delete_list(&tmaid->redo)>0 || d->next==NULL
																|| select.x<0)
						set_menu_bar(tmaid);
					tmaid_change_edit (tmaid, TRUE);
					g_free(text);
				} else {
					/* 쥯ΥʡʬǤϤʤȤ */
					gtk_selection_convert(window,GDK_SELECTION_PRIMARY,
												atom_targets,GDK_CURRENT_TIME);
				}
			}
			break;
		case 3:/* å */
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
					item_factory_popup,"<main>/Undo"),tmaid->undo!=NULL);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
					item_factory_popup,"<main>/Cut"),tmaid->select.x>=0);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
					item_factory_popup,"<main>/Copy"),tmaid->select.x>=0);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
					item_factory_popup,"<main>/Delete"),tmaid->select.x>=0);
			gtk_menu_popup(GTK_MENU(
					gtk_item_factory_get_widget(item_factory_popup,"<main>")),
								NULL,NULL,NULL,NULL,event->button,event->time);
			break;
		case 4:/* ۥ */
		case 5:
			{
				gint max,sx,sy;
				GdkPoint top;

				top=tmaid->top;
				tmaid->top.y+=event->button==4?-4:4;
				sx=MAX(tmaid->drawing->allocation.width/tmaid->font_width,1);
				sy=MAX(tmaid->drawing->allocation.height/tmaid->font_height,1);
				if (tmaid->top.y<0)
					tmaid->top.y=0;
				else if (tmaid->top.y>tmaid->max-sy)
					tmaid->top.y=MAX(tmaid->max-sy,0);
				max=edit_get_width_max(tmaid);
				if (tmaid->top.x>max-sx+1)
					tmaid->top.x=MAX(max-sx+1,0);
				move_edit_window(tmaid,&top);
				if (tmaid->top.x!=top.x)
					misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,
												tmaid,0,max+1,sx,tmaid->top.x);
				if (tmaid->top.y!=top.y)
					misc_set_scroll_bar(tmaid->vscroll,signal_value_changed_vscroll,
										tmaid,0,tmaid->max,sy,tmaid->top.y);
				draw_caret(tmaid,NULL);
			}
		}
		break;
	case GDK_2BUTTON_PRESS:
		{
			gint i,j,k,data_pos,length,ct,ctype,*type;
			GdkPoint cursor;
			LineBuffer *p;

			if (event->button!=1)
				return FALSE;
			/* ֥륯åȤñ򤹤 */
			if (tmaid->select.x>=0)
				break;
			p=edit_get_line_buf(&tmaid->start,&tmaid->off,tmaid->cursor.y);
			if (p->length<=0)
				break;
			cursor=tmaid->cursor;
			i=0;
			j=data_pos=edit_get_data_pos(tmaid,tmaid->cursor.x,tmaid->cursor.y,
																		FALSE);
			if (data_pos>0) {
				type=g_malloc(data_pos*sizeof(gint));
				/* 򳫻ϰ */
				while (i<data_pos)
					if (i+charset_length(p->text[i])<=data_pos) {
						for (k=0;k<charset_length(p->text[i]);k++)
							type[i+k]=k+1;
						i+=charset_length(p->text[i]);
					} else {
						type[i++]=1;
					}
				if (i<p->length) {
					length=i+charset_length(p->text[i])<=p->length
												?charset_length(p->text[i]):1;
					ctype=edit_get_char_type(p->text+i,length);
					j+=length;
				} else {
					length=type[i-1];
					i-=length;
					ctype=edit_get_char_type(p->text+i,length);
				}
				while (i>0 && (i-=(length=type[i-1]))>0) {
					ct=edit_get_char_type(p->text+i,length);
					if (ctype!=ct) {
						i+=length;
						break;
					}
				}
				g_free(type);
			} else {
				length=charset_length(p->text[0])<=p->length
												?charset_length(p->text[0]):1;
				ctype=edit_get_char_type(p->text,length);
				j+=length;
			}
			/* λ */
			while (j<p->length) {
				length=j+charset_length(p->text[j])<=p->length
												?charset_length(p->text[j]):1;
				ct=edit_get_char_type(p->text+j,length);
				if (ctype!=ct)
					break;
				j+=length;
			}
			tmaid->select.x=edit_get_screen_pos(tmaid,i,tmaid->cursor.y);
			tmaid->cursor.x=edit_get_screen_pos(tmaid,j,tmaid->cursor.y);
			tmaid->select.y=tmaid->cursor.y;
			if (tmaid->select.x==tmaid->cursor.x) {
				/*  */
				tmaid->select.x=-1;
			} else {
				/* 򤹤 */
				set_menu_bar(tmaid);
				draw_caret(tmaid,&cursor);
				clear_sel(tmaid,&tmaid->select,&tmaid->cursor);
				gtk_selection_owner_set(widget,GDK_SELECTION_PRIMARY,
															GDK_CURRENT_TIME);
			}
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}


/*	ޥΰư˴ؤ
	tmaid,ƥȾ
	    x,Xɸ
	    y,Yɸ
	state,ơ
	  RET,TRUE:뤢,FALSE:ʤ							*/
static gboolean signal_motion_notify_draw(TmaidWindow *tmaid,
							const gint x,const gint y,GdkModifierType state)
{
	gint s,sx,sy;
	GdkPoint cursor,select,top,ps;

	cursor=tmaid->cursor;
	select=tmaid->select;
	top=tmaid->top;
	sx=MAX(tmaid->drawing->allocation.width/tmaid->font_width,1);
	sy=MAX(tmaid->drawing->allocation.height/tmaid->font_height,1);
	ps.x=x;
	ps.y=y;
	if (ps.x<0)
		ps.x=0;
	else if (ps.x>tmaid->drawing->allocation.width)
		ps.x=tmaid->drawing->allocation.width;
	if (ps.y<0)
		ps.y=0;
	else if (ps.y>tmaid->drawing->allocation.height)
		ps.y=tmaid->drawing->allocation.height;
	/* 뤬ˤȤ뤹 */
	if (sx>1) {
		if (x<0 && tmaid->top.x>0)
			tmaid->top.x--;
		else if (x>tmaid->drawing->allocation.width
					&& tmaid->top.x<edit_get_width(tmaid,tmaid->cursor.y)+1-sx)
			tmaid->top.x++;
	}
	if (sy>1) {
		if (y<0 && tmaid->top.y>0)
			tmaid->top.y--;
		else if (y>tmaid->drawing->allocation.height
												&& tmaid->top.y<tmaid->max-sy)
			tmaid->top.y++;
	}
	s=ps.x-((tmaid->select.x<0?tmaid->cursor.x:tmaid->select.x)
											-tmaid->top.x)*tmaid->font_width;
	if (s<tmaid->font_width/2 || tmaid->font_width<s
					|| (tmaid->select.x<0?tmaid->cursor.y:tmaid->select.y)
									!=ps.y/tmaid->font_height+tmaid->top.y) {
		if (tmaid->select.x<0) {
			/* 򤹤 */
			tmaid->select.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
			tmaid->select.y=tmaid->cursor.y;
		}
		tmaid->cursor.x=ps.x/tmaid->font_width+tmaid->top.x;
		tmaid->cursor.y=ps.y/tmaid->font_height+tmaid->top.y;
		if (tmaid->cursor.y<0)
			tmaid->cursor.y=0;
		else if (tmaid->cursor.y>tmaid->max-1)
			tmaid->cursor.y=tmaid->max-1;
		tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
	} else if (tmaid->select.x>=0) {
		/*  */
		tmaid->cursor=tmaid->select;
		tmaid->select.x=-1;
	}
	if (tmaid->select.x==tmaid->cursor.x && tmaid->select.y==tmaid->cursor.y)
		tmaid->select.x=-1;/* νȽ꤬ƱȤ */
	else if (select.x==-1)/* 򤹤 */
		gtk_selection_owner_set(tmaid->drawing,GDK_SELECTION_PRIMARY,
															GDK_CURRENT_TIME);
	if (tmaid->cursor.x!=cursor.x || tmaid->cursor.y!=cursor.y
							|| tmaid->top.x!=top.x || tmaid->top.y!=top.y) {
		set_menu_bar(tmaid);
		move_edit_window(tmaid,&top);
		if (tmaid->top.x!=top.x)
			misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,tmaid,
								0,edit_get_width_max(tmaid)+1,sx,tmaid->top.x);
		if (tmaid->top.y!=top.y)
			misc_set_scroll_bar(tmaid->vscroll,signal_value_changed_vscroll,tmaid,
								0,tmaid->max,sy,tmaid->top.y);
		draw_caret(tmaid,&cursor);
		clear_sel(tmaid,&tmaid->cursor,&cursor);
	}
	return tmaid->top.x!=top.x || tmaid->top.y!=top.y;
}


static gboolean signal_timeout_draw(TmaidWindow *tmaid)
{
	gboolean result;
	gint x,y;
	GdkModifierType state;

	gdk_window_get_pointer(tmaid->drawing->window,&x,&y,&state);
	if ((state&GDK_BUTTON1_MASK)!=0) {
		result=signal_motion_notify_draw(tmaid,x,y,state);
		if (!result) {
			/* 뤬ä饿ޤϺ */
			gtk_timeout_remove(tmaid->timer_id);
			tmaid->timer_id=0;
		}
	} else {
		result=FALSE;
	}
	return result;
}


gboolean signal_motion_notify(GtkWidget *widget,
									GdkEventMotion *event,TmaidWindow *tmaid)
{
	gint x,y;
	GdkModifierType state;

	if (event->is_hint) {
		gdk_window_get_pointer(event->window,&x,&y,&state);
	} else {
		x=event->x;
		y=event->y;
		state=event->state;
	}
	if ((state&GDK_BUTTON1_MASK)!=0
								&& signal_motion_notify_draw(tmaid,x,y,state)
														&& tmaid->timer_id==0)
		/* Ϥƥ뤷Ȥ */
		tmaid->timer_id=gtk_timeout_add(1,(GtkFunction)signal_timeout_draw,
																		tmaid);
	return TRUE;
}


gboolean signal_button_release(GtkWidget *widget,
									GdkEventButton *event,TmaidWindow *tmaid)
{
	if (tmaid->timer_id!=0) {
		gtk_timeout_remove(tmaid->timer_id);
		tmaid->timer_id=0;
	}
	return TRUE;
}


gboolean signal_key_press(GtkWidget *widget,
										GdkEventKey *event,TmaidWindow *tmaid)
{
	gboolean result=FALSE;/* TRUE:λ,FALSE:³ */

	switch (event->keyval) {
	case GDK_Home:
	case GDK_KP_Home:
	case GDK_End:
	case GDK_KP_End:
	case GDK_H:
	case GDK_h:
	case GDK_Left:
	case GDK_KP_Left:
	case GDK_L:
	case GDK_l:
	case GDK_Right:
	case GDK_KP_Right:
	case GDK_comma:
	case GDK_less:
	case GDK_period:
	case GDK_greater:
	case GDK_K:
	case GDK_k:
	case GDK_Up:
	case GDK_KP_Up:
	case GDK_J:
	case GDK_j:
	case GDK_Down:
	case GDK_KP_Down:
	case GDK_Page_Up:
	case GDK_KP_Page_Up:
	case GDK_Page_Down:
	case GDK_KP_Page_Down:
		{
			gint sx,sy,width;
			gboolean alt,ctrl;
			GdkPoint cursor,top,select;

			cursor=tmaid->cursor;
			top=tmaid->top;
			sx=MAX(tmaid->drawing->allocation.width/tmaid->font_width,1);
			sy=MAX(tmaid->drawing->allocation.height/tmaid->font_height,1);
			alt=(event->state&GDK_MOD1_MASK)!=0;
			ctrl=(event->state&GDK_CONTROL_MASK)!=0;
			switch (event->keyval) {
			case GDK_Home:
			case GDK_KP_Home:
				tmaid->cursor.x=0;
				if (ctrl)
					tmaid->cursor.y=0;
				break;
			case GDK_End:
			case GDK_KP_End:
				tmaid->cursor.x=edit_get_width(tmaid,
							ctrl?tmaid->cursor.y=tmaid->max-1:tmaid->cursor.y);
				break;
			case GDK_H:
			case GDK_h:
				if (!alt)
					goto loop;
			case GDK_Left:
			case GDK_KP_Left:
				tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
				if (tmaid->cursor.x>0) {
					tmaid->cursor.x=ctrl?edit_get_move_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE)
							:edit_get_align_pos(tmaid,
									tmaid->cursor.x-1,tmaid->cursor.y,FALSE);
				} else if (tmaid->cursor.y>0) {
					/* ιԤκǸ */
					tmaid->cursor.y--;
					tmaid->cursor.x=edit_get_width(tmaid,tmaid->cursor.y);
				}
				break;
			case GDK_L:
			case GDK_l:
				if (!alt)
					goto loop;
			case GDK_Right:
			case GDK_KP_Right:
				width=edit_get_width(tmaid,tmaid->cursor.y);
				if (tmaid->cursor.x<width) {
					tmaid->cursor.x=ctrl?edit_get_move_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,TRUE)
							:edit_get_align_pos(tmaid,
									tmaid->cursor.x+1,tmaid->cursor.y,TRUE);
				} else if (tmaid->cursor.y<tmaid->max-1) {
					/* ιԤκǽ */
					tmaid->cursor.x=0;
					tmaid->cursor.y++;
				}
				break;
			case GDK_comma:
			case GDK_less:
				if (!ctrl)
					goto loop;
				tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
				if (tmaid->cursor.x>0) {
					tmaid->cursor.x=edit_get_move_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
				} else if (tmaid->cursor.y>0) {
					/* ιԤκǸ */
					tmaid->cursor.y--;
					tmaid->cursor.x=edit_get_width(tmaid,tmaid->cursor.y);
				}
				break;
			case GDK_period:
			case GDK_greater:
				if (!ctrl)
					goto loop;
				width=edit_get_width(tmaid,tmaid->cursor.y);
				if (tmaid->cursor.x<width) {
					tmaid->cursor.x=edit_get_move_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,TRUE);
				} else if (tmaid->cursor.y<tmaid->max-1) {
					/* ιԤκǽ */
					tmaid->cursor.x=0;
					tmaid->cursor.y++;
				}
				break;
			case GDK_K:
			case GDK_k:
				if (!alt)
					goto loop;
			case GDK_Up:
			case GDK_KP_Up:
				if (!ctrl) {
					tmaid->cursor.y--;
				} else if (tmaid->top.y>0) {
					tmaid->top.y--;
					if (tmaid->cursor.y-sy+1>tmaid->top.y)
						tmaid->cursor.y--;
				}
				break;
			case GDK_J:
			case GDK_j:
				if (!alt)
					goto loop;
			case GDK_Down:
			case GDK_KP_Down:
				if (!ctrl) {
					tmaid->cursor.y++;
				} else if (tmaid->top.y<tmaid->max-sy) {
					tmaid->top.y++;
					if (tmaid->cursor.y<tmaid->top.y)
						tmaid->cursor.y++;
				}
				break;
			case GDK_Page_Up:
			case GDK_KP_Page_Up:
				if (ctrl) {
					tmaid->cursor.y=tmaid->top.y;
				} else {
					tmaid->cursor.y-=sy;
					tmaid->top.y-=sy;
				}
				break;
			case GDK_Page_Down:
			case GDK_KP_Page_Down:
				if (ctrl) {
					tmaid->cursor.y=tmaid->top.y+sy-1;
				} else {
					tmaid->cursor.y+=sy;
					tmaid->top.y+=sy;
				}
			}
			if (tmaid->cursor.y<0)
				tmaid->cursor.y=0;
			else if (tmaid->cursor.y>tmaid->max-1)
				tmaid->cursor.y=tmaid->max-1;
			if (tmaid->top.y<0)
				tmaid->top.y=0;
			else if (tmaid->top.y>tmaid->max-sy)
				tmaid->top.y=MAX(tmaid->max-sy,0);
			if (tmaid->cursor.x<tmaid->top.x)
				tmaid->top.x=tmaid->cursor.x;
			else if (tmaid->cursor.x-sx+1>tmaid->top.x)
				tmaid->top.x=tmaid->cursor.x-sx+1;
			if (tmaid->cursor.y<tmaid->top.y)
				tmaid->top.y=tmaid->cursor.y;
			else if (tmaid->cursor.y-sy+1>tmaid->top.y)
				tmaid->top.y=tmaid->cursor.y-sy+1;
			select=tmaid->select;
			if ((event->state&GDK_SHIFT_MASK)==0) {
				/*  */
				tmaid->select.x=-1;
			} else {
				if (tmaid->select.x<0) {
					/*  */
					tmaid->select.x=edit_get_align_pos(tmaid,
													cursor.x,cursor.y,FALSE);
					tmaid->select.y=cursor.y;
				}
				if (tmaid->select.y==tmaid->cursor.y && tmaid->select.x
									==edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE))
					tmaid->select.x=-1;/* ϰϤƱȤ */
				else
					gtk_selection_owner_set(widget,GDK_SELECTION_PRIMARY,
															GDK_CURRENT_TIME);
			}
			if (tmaid->cursor.x==cursor.x && tmaid->cursor.y==cursor.y
					&& tmaid->top.x==top.x && tmaid->top.y==top.y
					&& tmaid->select.x==select.x && tmaid->select.y==select.y)
				break;
			if (tmaid->select.x!=select.x)
				set_menu_bar(tmaid);
			move_edit_window(tmaid,&top);
			if (tmaid->top.x!=top.x)
				misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,
						tmaid,0,edit_get_width_max(tmaid)+1,sx,tmaid->top.x);
			if (tmaid->top.y!=top.y)
				misc_set_scroll_bar(tmaid->vscroll,signal_value_changed_vscroll,
						tmaid,0,tmaid->max,sy,tmaid->top.y);
			draw_caret(tmaid,&cursor);
			if (select.x>=0 && tmaid->select.x<0)
				clear_sel(tmaid,&select,&cursor);
			else if (tmaid->select.x>=0)
				clear_sel(tmaid,&tmaid->cursor,&cursor);
		}
		result=TRUE;
		break;
	case GDK_BackSpace:
		{
			TmaidHistory *d;
			GdkPoint select;

			select=tmaid->select;
			if (tmaid->select.x<0) {
				tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
				if (tmaid->cursor.x>0) {
					tmaid->select.x=(event->state&GDK_CONTROL_MASK)==0
							?edit_get_align_pos(tmaid,
									tmaid->cursor.x-1,tmaid->cursor.y,FALSE)
							:edit_get_move_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
					tmaid->select.y=tmaid->cursor.y;
				} else if (tmaid->cursor.y>0) {
					/* 2ĤιԤ1Ĥˤ */
					tmaid->select.y=tmaid->cursor.y-1;
					tmaid->select.x=edit_get_width(tmaid,tmaid->select.y);
				} else {
					break;
				}
			}
			d=edit_operation(tmaid,NULL,0,FALSE,FALSE);
			d->next=tmaid->undo;
			tmaid->undo=d;
			if (delete_list(&tmaid->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(tmaid);
			tmaid_change_edit (tmaid, TRUE);
		}
		result=TRUE;
		break;
	case GDK_Return:
	case GDK_KP_Enter:
	case GDK_ISO_Enter:
	case GDK_3270_Enter:
		{
			gchar *text;
			gint i,data_pos;
			TmaidHistory *d;
			GdkPoint select;
			LineBuffer *p;

			select=tmaid->select;
			if (tmaid->autoindent) {
				data_pos=edit_get_data_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
				p=edit_get_line_buf(&tmaid->start,&tmaid->off,tmaid->cursor.y);
				for (i=0;i<data_pos;i++)
					if (p->text[i]!='\t' && p->text[i]!=' ')
						break;
				text=g_malloc((i+1)*sizeof(gchar));
				text[0]='\n';
				g_memmove(text+1,p->text,i*sizeof(gchar));
				d=edit_operation(tmaid,text,i+1,TRUE,FALSE);
				g_free(text);
			} else {
				d=edit_operation(tmaid,"\n",1,TRUE,FALSE);
			}
			d->next=tmaid->undo;
			tmaid->undo=d;
			if (delete_list(&tmaid->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(tmaid);
			tmaid_change_edit (tmaid, TRUE);
		}
		result=TRUE;
		break;
	case GDK_Tab:
	case GDK_KP_Tab:
		{
			TmaidHistory *d;
			GdkPoint select;

			if ((event->state&(GDK_CONTROL_MASK|GDK_MOD1_MASK))==0) {
				select=tmaid->select;
				d=edit_operation(tmaid,"\t",1,TRUE,FALSE);
				d->next=tmaid->undo;
				tmaid->undo=d;
				if (delete_list(&tmaid->redo)>0
											|| d->next==NULL || select.x>=0)
					set_menu_bar(tmaid);
				tmaid_change_edit (tmaid, TRUE);
			} else {
				gint page;
				guint length;
				GList *glist;

				glist=gtk_container_children(GTK_CONTAINER(notebook));
				length=g_list_length(glist);
				g_list_free(glist);
				page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
				if ((event->state&GDK_SHIFT_MASK)==0) {
					if (++page>=length)
						page=0;
				} else {
					if (--page<0)
						page=length-1;
				}
				gtk_notebook_set_page(GTK_NOTEBOOK(notebook),page);
				gtk_widget_grab_focus(((TmaidWindow *)
					gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page))))->
																	drawing);
			}
		}
		result=TRUE;
		break;
	case GDK_Escape:
	case GDK_Cancel:
		{
			gint sx,sy;
			GdkPoint select,top;

			if (tmaid->select.x<0)
				break;
			select=tmaid->select;
			top=tmaid->top;
			sx=MAX(tmaid->drawing->allocation.width/tmaid->font_width,1);
			sy=MAX(tmaid->drawing->allocation.height/tmaid->font_height,1);
			if (tmaid->cursor.x<tmaid->top.x)
				tmaid->top.x=tmaid->cursor.x;
			else if (tmaid->cursor.x-sx+1>tmaid->top.x)
				tmaid->top.x=tmaid->cursor.x-sx+1;
			if (tmaid->cursor.y<tmaid->top.y)
				tmaid->top.y=tmaid->cursor.y;
			else if (tmaid->cursor.y-sy+1>tmaid->top.y)
				tmaid->top.y=tmaid->cursor.y-sy+1;
			tmaid->select.x=-1;
			set_menu_bar(tmaid);
			move_edit_window(tmaid,&top);
			if (tmaid->top.x!=top.x)
				misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,
						tmaid,0,edit_get_width_max(tmaid)+1,sx,tmaid->top.x);
			if (tmaid->top.y!=top.y)
				misc_set_scroll_bar(tmaid->vscroll,signal_value_changed_vscroll,
						tmaid,0,tmaid->max,sy,tmaid->top.y);
			clear_sel(tmaid,&select,&tmaid->cursor);
			draw_caret(tmaid,NULL);
		}
		result=TRUE;
		break;
	case GDK_Delete:
	case GDK_KP_Delete:
	case GDK_3270_DeleteWord:
		{
			gint width;
			TmaidHistory *d;
			GdkPoint select;

			select=tmaid->select;
			if (tmaid->select.x<0) {
				width=edit_get_width(tmaid,tmaid->cursor.y);
				tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
				if (tmaid->cursor.x<width) {
					tmaid->select.x=(event->state&GDK_CONTROL_MASK)==0
						?edit_get_align_pos(tmaid,
										tmaid->cursor.x+1,tmaid->cursor.y,TRUE)
						:edit_get_move_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,TRUE);
					tmaid->select.y=tmaid->cursor.y;
				} else if (tmaid->cursor.y<tmaid->max-1) {
					/* 2ĤιԤ1Ĥˤ */
					tmaid->select.x=0;
					tmaid->select.y=tmaid->cursor.y+1;
				} else {
					break;
				}
			}
			d=edit_operation(tmaid,NULL,0,FALSE,FALSE);
			d->next=tmaid->undo;
			tmaid->undo=d;
			if (delete_list(&tmaid->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(tmaid);
			tmaid_change_edit (tmaid, TRUE);
		}
		result=TRUE;
		break;
	case GDK_Insert:
	case GDK_KP_Insert:
		ins=!ins;
		draw_caret(tmaid,NULL);
		result=TRUE;
		break;
	case GDK_Y:
	case GDK_y:
		{
			TmaidHistory *d;
			GdkPoint select;

			if ((event->state&GDK_CONTROL_MASK)==0)
				goto loop;
			select=tmaid->select;
			if (tmaid->select.x<0) {
				if (tmaid->max-1<=tmaid->cursor.y) {
					tmaid->cursor.x=0;
					tmaid->select.x=edit_get_width(tmaid,tmaid->cursor.y);
					if (tmaid->select.x<=0) {
						if (tmaid->cursor.y<=0) {
							tmaid->select.x=-1;
						return 0;
						}
						tmaid->select.y=tmaid->cursor.y-1;
					} else {
						tmaid->select.y=tmaid->cursor.y;
					}
				} else {
					tmaid->cursor.x=tmaid->select.x=0;
					tmaid->select.y=tmaid->cursor.y+1;
				}
			}
			d=edit_operation(tmaid,NULL,0,FALSE,FALSE);
			d->next=tmaid->undo;
			tmaid->undo=d;
			if (delete_list(&tmaid->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(tmaid);
			tmaid_change_edit (tmaid, TRUE);
		}
		result=TRUE;
		break;
	case GDK_F10:
		{
			gint sx,sy;
			GdkPoint top;

			if ((event->state&GDK_SHIFT_MASK)==0)
				break;
			top=tmaid->top;
			sx=MAX(tmaid->drawing->allocation.width/tmaid->font_width,1);
			sy=MAX(tmaid->drawing->allocation.height/tmaid->font_height,1);
			if (tmaid->cursor.x<tmaid->top.x)
				tmaid->top.x=tmaid->cursor.x;
			else if (tmaid->cursor.x-sx+1>tmaid->top.x)
				tmaid->top.x=tmaid->cursor.x-sx+1;
			if (tmaid->cursor.y<tmaid->top.y)
				tmaid->top.y=tmaid->cursor.y;
			else if (tmaid->cursor.y-sy+1>tmaid->top.y)
				tmaid->top.y=tmaid->cursor.y-sy+1;
			move_edit_window(tmaid,&top);
			if (tmaid->top.x!=top.x)
				misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,
						tmaid,0,edit_get_width_max(tmaid)+1,sx,tmaid->top.x);
			if (tmaid->top.y!=top.y)
				misc_set_scroll_bar(tmaid->vscroll,signal_value_changed_vscroll,
						tmaid,0,tmaid->max,sy,tmaid->top.y);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
					item_factory_popup,"<main>/Undo"),tmaid->undo!=NULL);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
					item_factory_popup,"<main>/Cut"),tmaid->select.x>=0);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
					item_factory_popup,"<main>/Copy"),tmaid->select.x>=0);
			gtk_widget_set_sensitive(gtk_item_factory_get_widget(
					item_factory_popup,"<main>/Delete"),tmaid->select.x>=0);
			gtk_menu_popup(GTK_MENU(
					gtk_item_factory_get_widget(item_factory_popup,"<main>")),
											NULL,NULL,NULL,NULL,3,event->time);
		}
		result=TRUE;
		break;
	default:
		loop:
		if (event->length>0 && (event->state&GDK_MOD1_MASK)==0) {
			gint i,length;
			TmaidHistory *d;
			GdkPoint select;

			for (i=0;i<event->length;i+=length) {
				length=charset_length(event->string[i]);
				if (i+length>event->length)
					length=1;
				if ((charset_type(event->string+i,length)&CS_CONTROL)!=0)
					break;
			}
			if (i>=event->length) {
				select=tmaid->select;
				tmaid->cursor.x=edit_get_align_pos(tmaid,
										tmaid->cursor.x,tmaid->cursor.y,FALSE);
				if (tmaid->select.x<0 && !ins) {
					tmaid->select.x=edit_get_align_pos(tmaid,
									tmaid->cursor.x+1,tmaid->cursor.y,TRUE);
					if (tmaid->select.x<=tmaid->cursor.x)
						tmaid->select.x=-1;
					tmaid->select.y=tmaid->cursor.y;
				}
				d=edit_operation(tmaid,event->string,event->length,TRUE,FALSE);
				d->next=tmaid->undo;
				tmaid->undo=d;
				if (delete_list(&tmaid->redo)>0
											|| d->next==NULL || select.x>=0)
					set_menu_bar(tmaid);
				tmaid_change_edit (tmaid, TRUE);
				result=TRUE;
			}
		}
	}
	return result;
}


void signal_destroy_draw(GtkWidget *widget,TmaidWindow *tmaid)
{
	GList *glist;
	GtkWidget *sub_menu;
	LineBuffer *p;

	/* ե̾Ĵ٤ */
	file_delete_edit(tmaid->file);
	/* ɥ˥塼 */
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,"<main>/Window");
	gtk_container_remove(GTK_CONTAINER(sub_menu),tmaid->menu_item);
	/* ˥塼 */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	if (g_list_length(glist)<=1) {
		set_menu_bar(NULL);
		gtk_statusbar_pop(GTK_STATUSBAR(status),
				gtk_statusbar_get_context_id(GTK_STATUSBAR(status),"Status"));
	}
	g_list_free(glist);
	/*  */
	g_free(tmaid->file);
	gdk_font_unref(tmaid->font);
	if (tmaid->timer_id!=0) {
		gtk_timeout_remove(tmaid->timer_id);
		tmaid->timer_id=0;
	}
	while (tmaid->start->prev!=NULL)
		tmaid->start=tmaid->start->prev;
	while (tmaid->start!=NULL) {
		p=tmaid->start->next;
		if (tmaid->start->text!=NULL)
			g_free(tmaid->start->text);
		g_free(tmaid->start);
		tmaid->start=p;
	}
	delete_list(&tmaid->undo);
	delete_list(&tmaid->redo);
	g_free(tmaid);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ƥ)                                           *
*                                                                             *
******************************************************************************/
void signal_style_set(GtkWidget *widget,GtkStyle *style,gpointer user_data)
{
	gint i;
	GList *glist;
	TmaidWindow *tmaid;

	/* ƥ࿧ */
	style=gtk_widget_get_style(widget);
	system_color[0]=style->text[0];
	system_color[1]=style->base[0];
	system_color[2]=style->dark[0];
	system_color[3]=style->dark[0];
	system_color[4]=style->dark[0];
	system_color[5]=style->dark[0];
	system_color[6]=style->dark[0];
	system_color[7]=style->mid[0];
	system_color[8]=style->fg[3];
	system_color[9]=style->bg[3];
	if (system_font!=NULL)
		gdk_font_unref(system_font);
	/* ƥե */
	system_font=gdk_font_ref(style->font);
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	for (i=g_list_length(glist)-1;i>=0;i--) {
		tmaid=gtk_object_get_user_data(GTK_OBJECT(g_list_nth_data(glist,i)));
		if (tmaid->syscol || tmaid->font_name==NULL) {
			if (tmaid->font_name==NULL) {
				/* եѹ */
				gdk_font_unref(tmaid->font);
				tmaid->font=gdk_font_ref(system_font);
				charset_size(tmaid->font,&tmaid->font_width,
									&tmaid->font_height,&tmaid->font_ascent);
				/* С */
				tmaid->cursor.x=tmaid->cursor.y=tmaid->top.x=tmaid->top.y=0;
				modify_margin(tmaid);
				misc_set_scroll_bar(tmaid->hscroll,signal_value_changed_hscroll,
										tmaid,0,edit_get_width_max(tmaid)+1,
					MAX(tmaid->drawing->allocation.width/tmaid->font_width,1),
																tmaid->top.x);
				misc_set_scroll_bar(tmaid->vscroll,signal_value_changed_vscroll,
										tmaid,0,tmaid->max,
					MAX(tmaid->drawing->allocation.height/tmaid->font_height,
															1),tmaid->top.y);
			}
			gtk_widget_draw(tmaid->drawing,NULL);/*  */
#ifdef USE_XIM
			if (gdk_im_ready() && tmaid->ic!=NULL
				&& (gdk_ic_get_style(tmaid->ic)&GDK_IM_PREEDIT_POSITION)!=0) {
				gdk_ic_get_attr(tmaid->ic,tmaid->ic_attr,
					(tmaid->font_name==NULL?GDK_IC_PREEDIT_FONTSET:0)
					| (tmaid->syscol?GDK_IC_PREEDIT_FOREGROUND
											| GDK_IC_PREEDIT_BACKGROUND:0));
				if (tmaid->syscol) {
					tmaid->ic_attr->preedit_foreground=system_color[0];
					tmaid->ic_attr->preedit_background=system_color[1];
				}
				if (tmaid->font_name==NULL)
					tmaid->ic_attr->preedit_fontset=tmaid->font;
				gdk_ic_set_attr(tmaid->ic,tmaid->ic_attr,
					(tmaid->font_name==NULL?GDK_IC_PREEDIT_FONTSET:0)
					| (tmaid->syscol?GDK_IC_PREEDIT_FOREGROUND
											| GDK_IC_PREEDIT_BACKGROUND:0));
			}
#endif
		}
	}
	g_list_free(glist);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(˥塼)                                           *
*                                                                             *
******************************************************************************/
void signal_activate_menu_window(GtkWidget *widget,GtkWidget *child)
{
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),child));
	gtk_widget_grab_focus(
			((TmaidWindow *)gtk_object_get_user_data(GTK_OBJECT(child)))->drawing);
}


void signal_activate_menu_history(GtkWidget *widget,gchar *file)
{
	file_open_edit(file);
}


void signal_destroy_menu_history(GtkWidget *widget,gchar *file)
{
	g_free(file);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(Ρ)                                             *
*                                                                             *
******************************************************************************/
void signal_clicked(GtkWidget *widget,GtkWidget *child)
{
	if (prompt_close((TmaidWindow *)gtk_object_get_user_data(GTK_OBJECT(child))))
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),child));
}


void signal_switch_page(GtkNotebook *notebook,GtkNotebookPage *page,
											gint page_num,gpointer user_data)
{
	TmaidWindow *tmaid;

	tmaid=gtk_object_get_user_data(GTK_OBJECT(page->child));
	/* ˥塼ɽ */
	set_menu_bar(tmaid);
}


void signal_destroy_notebook(GtkWidget *widget,gpointer user_data)
{
	gtk_timeout_remove(timer_id);
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(쥯)                                       *
*                                                                             *
******************************************************************************/
void signal_drag_data_received(GtkWidget *widget,GdkDragContext *context,
		gint x,gint y,GtkSelectionData *selection_data,guint info,guint time)
{
	gchar **files;
	gint i;

	files=g_strsplit(selection_data->data,"\r\n",G_MAXINT);
	for (i=0;files[i]!=NULL;i++)
		if (g_strncmp(files[i],"file:",5)==0)
			file_open_edit(files[i]+5);
	g_strfreev(files);
}


gboolean signal_selection_clear(GtkWidget *widget,GdkEventSelection *event,
															gpointer user_data)
{
	if (event->selection==atom_clipboard) {
		/* åץܡ */
		g_free(clipboard_text);
		clipboard_text=NULL;
	}
	return TRUE;
}


void signal_selection_get(GtkWidget *widget,GtkSelectionData *data,
									guint info,guint time,TmaidWindow *tmaid)
{
	gchar *text=NULL;
	guchar *compound_text;
	gint length=0,compound_length,format;
	GdkAtom encoding;

	if (data->selection==GDK_SELECTION_PRIMARY) {
		/* ץ饤ޥꥻ쥯 */
		if (tmaid!=NULL && tmaid->select.x>=0) {
			length=edit_get_sel_bytes(tmaid,&tmaid->select,&tmaid->cursor);
			text=g_malloc((length+1)*sizeof(gchar));
			edit_cpy_sel_mem(tmaid,&tmaid->select,&tmaid->cursor,text);
			text[length]='\0';
		}
	} else if (data->selection==atom_clipboard) {
		/* åץܡ */
		if (clipboard_text!=NULL) {
			text=clipboard_text;
			length=g_strlen(clipboard_text);
		}
	} else if (data->selection==atom_textmaid0) {
		/* ץ̿ */
		text="Text maid Selection";
		length=g_strlen(text);
		gtk_selection_convert(window,atom_textmaid1,
								GDK_SELECTION_TYPE_STRING,GDK_CURRENT_TIME);
	} else if (data->selection==atom_textmaid1 && arg_text!=NULL) {
		/* ץ̿ */
		text=arg_text;
		arg_text=NULL;
		length=g_strlen(text);
	}
	if (text!=NULL) {
		if (info==TARGET_STRING) {
			gtk_selection_data_set(data,GDK_SELECTION_TYPE_STRING,8,
														(guchar *)text,length);
		} else if (info==TARGET_TEXT || info==TARGET_COMPOUND_TEXT) {
			gdk_string_to_compound_text(text,&encoding,&format,
											&compound_text,&compound_length);
			gtk_selection_data_set(data,encoding,format,
												compound_text,compound_length);
			gdk_free_compound_text(compound_text);
		}
		if (data->selection==GDK_SELECTION_PRIMARY
											|| data->selection==atom_textmaid1)
			g_free(text);
	}
}


void signal_selection_received(GtkWidget *widget,GtkSelectionData *data,
												guint time,gpointer user_data)
{
	gboolean *arg_files;
	gchar *text=NULL,*tmp,**list,**argv;
	gint i,count;
	TmaidHistory *d;
	TmaidWindow *tmaid;
	GdkAtom *atoms;
	GdkPoint select;

	if (data->selection==GDK_SELECTION_PRIMARY
										|| data->selection==atom_clipboard) {
		/* ץ饤ޥꥻ쥯/åץܡ */
		if (data->length>=0) {
			if (data->type==GDK_SELECTION_TYPE_ATOM) {
				atoms=(GdkAtom *)data->data;
				count=data->length/sizeof(GdkAtom);
				for (i=0;i<count;i++)
					if (atoms[i]==atom_compound || atoms[i]==atom_text)
						break;
				if (i>=count)
					for (i=0;i<count;i++)
						if (atoms[i]==GDK_TARGET_STRING)
							break;
				if (i<count)
					gtk_selection_convert(widget,data->selection,atoms[i],
															GDK_CURRENT_TIME);
			} else if (data->type==GDK_TARGET_STRING) {
				text=g_strdup(data->data);
			} else if (data->type==atom_compound || data->type==atom_text) {
				count=gdk_text_property_to_text_list(data->type,data->format,
												data->data,data->length,&list);
				if (count>0) {
					text=g_strdup(list[0]);
					for (i=1;i<count;i++) {
						tmp=g_strconcat(text,list[i],NULL);
						g_free(text);
						text=tmp;
					}
					gdk_free_text_list(list);
				}
			}
		}
		if (text!=NULL) {
			tmaid=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
			select=tmaid->select;
			d=edit_operation(tmaid,text,g_strlen(text),
										data->selection==atom_clipboard,FALSE);
			d->next=tmaid->undo;
			tmaid->undo=d;
			if (delete_list(&tmaid->redo)>0 || d->next==NULL || select.x>=0)
				set_menu_bar(tmaid);
			tmaid_change_edit (tmaid, TRUE);
			g_free(text);
		}
	} else if (data->selection==atom_textmaid0) {
		/* ץ̿ */
		instance=MAX(data->length,0);
	} else if (data->selection==atom_textmaid1 && data->length>0) {
		/* ץ̿ */
		/* ޥɥ饤β */
		argv=g_strsplit(data->data,"\n",G_MAXINT);
		init_line=0;
		arg_files=arg_analyse(argv,FALSE);
		for (i = 1; argv[i] != NULL; i++)
			if (arg_files[i]) {
				tmaid=file_open_edit(argv[i]);
				if (init_line!=0)	/* Ԥ˰ư */
					jump_operation(tmaid,init_line);
			}
		g_free(arg_files);
		g_strfreev(argv);
	}
}


/******************************************************************************
*                                                                             *
* ʥ/٥ȴؿ(ᥤ)                                             *
*                                                                             *
******************************************************************************/
gboolean signal_delete(GtkWidget *widget,GdkEvent *event,gpointer user_data)
{
	gint page;
	TmaidWindow *tmaid;

	while ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		tmaid=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
		if (!prompt_close(tmaid))
			return TRUE;
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),page);
	}
	return FALSE;
}


void signal_destroy_window(GtkWidget *widget,gpointer user_data)
{
	gint i;
	GList *glist;
	GtkWidget *sub_menu;

	memset(history_files,0,sizeof(gchar *)*10);
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,"<main>/File");
	glist=gtk_container_children(GTK_CONTAINER(sub_menu));
	for (i=0;i<(gint)g_list_length(glist)-MENUFILE-1;i++)
		history_files[i]=g_strdup(gtk_object_get_user_data(
							GTK_OBJECT(g_list_nth_data(glist,i+MENUFILE-1))));
	g_list_free(glist);
	gtk_main_quit();
}
