/*
    misc
    copyright (c) 2002-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "misc.h"
#include <gdk/gdkkeysyms.h>
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/******************************************************************************
*                                                                             *
* åܥåؿ                                                    *
*                                                                             *
******************************************************************************/
/* ܥ󤬲줿 */
static void message_box_clicked(GtkWidget *widget,GtkWidget *dialog)
{
	*(gint *)gtk_object_get_user_data(GTK_OBJECT(dialog))
						=(gint)gtk_object_get_user_data(GTK_OBJECT(widget));
    gtk_widget_destroy(dialog);
}


/* ESC줿 */
static gboolean message_box_dialog_key_press(GtkWidget *widget,
										GdkEventKey *event,gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


/*	åܥåɽ
	title,ȥ
	 text,ʸ
	  def,ǥեȤΥܥ
	  ...,ܥΥ٥
	  RET,줿ܥ(-1:󥻥)										*/
gint misc_message_box(const gchar *title,const gchar *text,const gint def,...)
{
	va_list ap;
	gchar *name;
	gint i=0,result=-1;
	guint key;
	GtkAccelGroup *accel;
	GtkWidget *dialog,*button,*label,*focus=NULL;

	va_start(ap,def);
	/* 򳫤 */
	dialog=gtk_dialog_new();
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
						GTK_SIGNAL_FUNC(message_box_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	gtk_object_set_user_data(GTK_OBJECT(dialog),&result);
	/* å */
	gtk_window_set_title(GTK_WINDOW(dialog),title);
	label=gtk_label_new(text);
	gtk_misc_set_padding(GTK_MISC(label),8,8);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),label,TRUE,TRUE,0);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(dialog),accel);
	/* ܥ */
	while ((name=va_arg(ap,gchar *))!=NULL) {
		button=gtk_button_new_with_label(name);
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button)->child),name);
		gtk_signal_connect(GTK_OBJECT(button),"clicked",
								GTK_SIGNAL_FUNC(message_box_clicked),dialog);
		gtk_object_set_user_data(GTK_OBJECT(button),(gpointer)i);
		GTK_WIDGET_SET_FLAGS(button,GTK_CAN_DEFAULT);
		if (i==def)
			focus=button;
		if (key>0)/* 졼 */
			gtk_widget_add_accelerator(button,"clicked",accel,key,0,0);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
														button,TRUE,FALSE,8);
		i++;
	}
	va_end(ap);

	/* ɽ */
	if (focus!=NULL)
		gtk_widget_grab_focus(focus);

	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return result;
}


/******************************************************************************
*                                                                             *
* ٥ؿ                                                              *
*                                                                             *
******************************************************************************/
/*	ե¸߳ǧ
	file,ե̾
	 RET,TRUE:¸ߤ,FALSE:¸ߤʤ										*/
gboolean misc_isfile(const gchar *file)
{
	struct stat buf;

	return stat(file,&buf)==0;
}


/*	եΥեѥ
	file,ե̾
	 RET,եѥ															*/
gchar *misc_get_full_path(const gchar *file)
{
	gchar *dir,*path;
	gint i,j,leng;

	if (file[0]!='/') {
		dir=g_get_current_dir();
		path=g_strjoin("/",dir,file,NULL);
		g_free(dir);
	} else {
		path=g_strdup(file);
	}
	leng=g_strlen(path);
	i=0;
	while (i<leng)
		if (path[i]=='/' && path[i+1]=='.' && path[i+2]=='/') {
			leng-=2;
			g_memmove(path+i+1,path+i+3,leng-i);
		} else {
			i++;
		}
	i=0;
	while (i<leng)
		if (path[i]=='/' && path[i+1]=='.' && path[i+2]=='.'
														&& path[i+3]=='/') {
			leng-=3;
			g_memmove(path+i+1,path+i+4,leng-i);
			for (j=i-1;j>=0;j--)
				if (path[j]=='/')
					break;
			if (j>=0) {
				g_memmove(path+j+1,path+i+1,leng-i);
				leng-=i-j;
				i=j;
			}
		} else {
			i++;
		}
	return path;
}


/*	Сꤹ
	   scroll,륦å
	     func,ʥؿ
	func_data,ǡ
	      min,Ǿ
	      max,
	     page,ڡ
	      pos,															*/
void
misc_set_scroll_bar (GtkWidget *scroll, GtkSignalFunc func, gpointer func_data,
			const gint min, const gint max, const gint page, const gint pos)
{
	GtkAdjustment *adjust;

	adjust = GTK_ADJUSTMENT (gtk_adjustment_new
											(pos, min, max, 1, page, page));
	gtk_range_set_adjustment (GTK_RANGE (scroll), adjust);
	if (func != NULL)
		gtk_signal_connect (GTK_OBJECT (adjust), "value-changed",
															func, func_data);
}


/*	WindowƤ򥹥뤹
	widget,å
	    dx,Xΰư
	    dy,Yΰư
	     x,뤹ϰϤαXɸ
	     y,뤹ϰϤαYɸ
	 width,뤹ϰϤ
	height,뤹ϰϤι⤵											*/
void misc_scroll_window(GtkWidget *widget,const gint dx,const gint dy,
				const gint x,const gint y,const gint width,const gint height)
{
	GdkGC *gc;
	GdkRectangle rc;

	if (ABS(dx)>width || ABS(dy)>height) {
		rc.x=x;
		rc.y=y;
		rc.width=width;
		rc.height=height;
		gtk_widget_draw(widget,&rc);
	} else if (dx!=0 || dy!=0) {
		gc=gdk_gc_new(widget->window);
		gdk_gc_set_exposures(gc,TRUE);
		gdk_window_copy_area(widget->window,gc,dx>0?x+dx:x,dy>0?y+dy:y,
										widget->window,dx>0?x:x-dx,dy>0?y:y-dy,
												width-ABS(dx),height-ABS(dy));
		gdk_gc_destroy(gc);
		if (dx!=0) {
			rc.x=dx>0?x:x+width+dx;
			rc.y=y;
			rc.width=ABS(dx);
			rc.height=height;
			gtk_widget_draw(widget,&rc);
		}
		if (dy!=0) {
			rc.x=x;
			rc.y=dy>0?y:y+height+dy;
			rc.width=width;
			rc.height=ABS(dy);
			gtk_widget_draw(widget,&rc);
		}
	}
}


/******************************************************************************
*                                                                             *
* ʸؿ                                                            *
*                                                                             *
******************************************************************************/
static gchar hex[16]={	'0','1','2','3','4','5','6','7',
						'8','9','A','B','C','D','E','F'};


/*	͢ʸ
	value,
	radix,
	 wide,
	 flag,TRUE:椢,FALSE:ʤ
	  RET,ʸ															*/
gchar *misc_str_from_val(const gint value,const gint radix,const gint wide,
														const gboolean flag)
{
	gchar c,*str=NULL;
	gint i=0,j,t;

	t=value;
	if (value==0) {
		str=g_malloc(sizeof(gchar));
		str[i++]=hex[0];
	} else {
		if (flag && value<0) {
			while (t!=0) {
				str=g_realloc(str,(i+1)*sizeof(gchar));
				str[i++]=hex[ABS(t%radix)];
				t/=radix;
			}
		} else {
			while (t!=0) {
				str=g_realloc(str,(i+1)*sizeof(gchar));
				str[i++]=hex[(guint)t%radix];
				t=(guint)t/radix;
			}
		}
	}
	str=g_realloc(str,(i+1)*sizeof(gchar));
	str[i]='\0';
	for (j=0;j<i/2;j++) {
		c=str[j];
		str[j]=str[i-j-1];
		str[i-j-1]=c;
	}
	if (flag && value<0) {
		for (j=i;j>=0;j--)
			str[j+1]=str[j];
		str[0]='-';
		i++;
	}
	if (i<ABS(wide)) {
		str=g_realloc(str,(ABS(wide)+1)*sizeof(gchar));
		for (j=i;j>=0;j--)
			str[j+ABS(wide)-i]=str[j];
		if (wide>0) {
			for (j=0;j<wide-i;j++)
				str[j]=' ';
		} else {
			for (j=0;j<-wide-i;j++)
				str[j]=hex[0];
			if (str[j]=='-') {
				str[0]='-';
				str[j]=hex[0];
			}
		}
	}
	return str;
}


/*	ʸ󢪿
	value,
	  str,ʸ
	radix,
	 flag,TRUE:椢,FALSE:ʤ
	  RET,TRUE:ｪλ,FALSE:顼										*/
gboolean misc_str_to_val(gint *value,const gchar *str,const gint radix,
														const gboolean flag)
{
	gchar c;
	gint i,j,t;

	*value=0;
	for (i=0;str[i]!='\0' && str[i]==' ';i++);
	if (str[i]=='\0')
		return FALSE;
	if (flag && str[i]=='-') {
		i++;
		while (str[i]!='\0') {
			t=*value;
			*value*=radix;
			c=g_ascii_toupper(str[i]);
			for (j=0;j<radix;j++)
				if (hex[j]==c)
					break;
			*value+=j;
			if (j==radix || *value<t) {
				*value=t;
				return FALSE;
			}
			i++;
		}
		if (*value<0) {
			*value=0;
			return FALSE;
		}
		*value=-*value;
	} else {
		while (str[i]!='\0') {
			t=*value;
			*value*=radix;
			c=g_ascii_toupper(str[i]);
			for (j=0;j<radix;j++)
				if (hex[j]==c)
					break;
			*value+=j;
			if (j==radix || *value<t) {
				*value=t;
				return FALSE;
			}
			i++;
		}
	}
	return TRUE;
}


/*	͢ʸ
	 value,
	divide,
	   RET,ʸ															*/
gchar *misc_str_from_float(const gint value,const gint divide)
{
	gchar *text=NULL;
	gint i=0,n,t;

	n=t=(gint64)value*100000/divide;
	if (t==0) {
		text=g_malloc(sizeof(gchar)*4);
		text[i++]=hex[0];
	} else {
		t=ABS(t);
		while (t>0) {
			text=g_realloc(text,(i+4)*sizeof(gchar));
			text[i++]=hex[t%10];
			t/=10;
		}
	}
	text[i]='\0';
	g_strreverse(text);
	if (g_strlen(text)<6) {
		g_memmove(text+2,text,(i+1)*sizeof(gchar));
		text[0]='0';
		text[1]='.';
		i++;
	} else {
		g_memmove(text+i-4,text+i-5,sizeof(gchar)*6);
		text[i-5]='.';
	}
	while (text[i]=='0')
		text[i--]='\0';
	if (text[i]=='.')
		text[i--]='\0';
	if (n>=0) {
		text=g_realloc(text,(i+2)*sizeof(gchar));
	} else {
		text=g_realloc(text,(i+3)*sizeof(gchar));
		g_memmove(text+1,text,(i+2)*sizeof(gchar));
		text[0]='-';
	}
	return text;
}


/*	ʸ󢪿
	 value,
	divide,
	  text,ʸ
	   RET,TRUE:ｪλ,FALSE:顼										*/
gboolean misc_str_to_float(gint *value,gint *divide,const gchar *text)
{
	gchar *p;
	gint i,j,t;

	*value=0;
	*divide=1;
	p=g_strdup(text);
	for (i=j=0;p[i]!='\0';i++)
		if (p[i]!=' ')
			p[j++]=p[i];
	if (j<=0)
		return FALSE;
	p[j]='\0';
	for (i=0;p[i]!='\0';i++)
		if (p[i]=='.')
			break;
	if (p[i]!='\0') {
		for (j=g_strlen(p)-1;j>0;j--)
			if (p[j]=='0')
				p[j]='\0';
			else
				break;
		while (p[++i]!='\0') {
			p[i-1]=p[i];
			*divide*=10;
		}
		p[i-1]='\0';
	}
	if (p[0]=='-' && p[1]=='\0') {
		g_free(p);
		return FALSE;
	}
	i=p[0]=='-'?1:0;
	while (p[i]!='\0') {
		t=*value;
		*value*=10;
		for (j=0;j<10;j++)
			if (hex[j]==p[i])
				break;
		*value+=j;
		if (j==10 || *value<t) {
			*value=t;
			g_free(p);
			return FALSE;
		}
		i++;
	}
	while (*value%2==0 && *divide%2==0)
		*value/=2,*divide/=2;
	while (*value%5==0 && *divide%5==0)
		*value/=5,*divide/=5;
	*value*=(p[0]=='-'?-1:1);
	g_free(p);
	return TRUE;
}


/*	ʸ
	array,
	 size,Хȿ
	radix,
	 wide,
	 flag,TRUE:椢,FALSE:ʤ
	  RET,ʸ															*/
gchar *misc_str_from_array(const guint8 *array,const gint size,
						const gint radix,const gint wide,const gboolean flag)
{
	gchar *p,*text=NULL;
	gint i,leng,length=0;

	if (array==NULL || size<=0)
		return NULL;
	for (i=0;i<size;i++) {
		p=flag?misc_str_from_val((gint8)array[i],radix,wide,flag)
								:misc_str_from_val(array[i],radix,wide,flag);
		leng=g_strlen(p);
		text=g_realloc(text,(length+leng+1)*sizeof(gchar));
		g_memmove(text+length,p,g_strlen(p));
		g_free(p);
		length+=leng;
		text[length++]=' ';
	}
	text[length-1]='\0';
	return text;
}


/*	ʸ󢪿
	 size,Хȿ
	 text,ʸ
	radix,
	 flag,TRUE:椢,FALSE:ʤ
	  RET,																*/
guint8 *misc_str_to_array(gint *size,const gchar *text,
										const gint radix,const gboolean flag)
{
	gchar *p;
	guint8 *array=NULL;
	gint i,j,value;

	*size=0;
	if (text==NULL)
		return NULL;
	p=g_malloc((g_strlen(text)+2)*sizeof(gchar));
	g_strcpy(p,text);
	for (i=0;p[i]!='\0';i++) {
		for (j=0;j<radix;j++)
			if (p[i]==hex[j])
				break;
		if (j>=radix)
			p[i]='\0';
	}
	p[i+1]='\0';
	i=0;
	while (p[i]!='\0') {
		if (!misc_str_to_val(&value,p+i,radix,flag)) {
			g_free(p);
			g_free(array);
			*size=0;
			return NULL;
		}
		array=g_realloc(array,*size+1);
		array[(*size)++]=value;
		i+=g_strlen(p+i)+1;
	}
	g_free(p);
	return array;
}


/******************************************************************************
*                                                                             *
* ISO-10646                                                                   *
*                                                                             *
******************************************************************************/
/*	ޥХʸ󢪥磻ʸ
	   src,ޥХʸ
	srclen,ʸ(-1:NULLλ)
	   dst,磻ʸ
	dstlen,ʸ
	   RET,ʸ															*/
gssize misc_multibyte_to_widechar(const gchar *src,const gssize srclen,
											guint16 *dst,const gssize dstlen)
{
#ifdef USE_GTK2
	gssize i,j,leng;

	if (src==NULL)
		return 0;
	leng=srclen<0?g_strlen(src)+1:srclen;
	i=j=0;
	if (dst==NULL || dstlen<=0)	/* ɬפʸ */
		while (i<leng) {
			if (i+1<leng && 0xc0<=(guint8)src[i] && (guint8)src[i]<=0xdf)
				i+=2;
			else if (i+2<leng && 0xe0<=(guint8)src[i])
				i+=3;
			else
				i++;
			j++;
		}
	else						/* Ѵ */
		while (i<leng && j<dstlen) {
			if (i+1<leng && 0xc0<=(guint8)src[i] && (guint8)src[i]<=0xdf) {
				dst[j]=(src[i]&0x1f)<<6|(src[i+1]&0x3f);
				i+=2;
			} else if (i+2<leng && 0xe0<=(guint8)src[i]) {
				dst[j]=(src[i]&0xf)<<12|(src[i+1]&0x3f)<<6|(src[i+2]&0x3f);
				i+=3;
			} else {
				dst[j]=src[i];
				i++;
			}
			j++;
		}
	return j;
#else
	gssize i,leng;

	if (src==NULL)
		return 0;
	leng=srclen<0?g_strlen(src)+1:srclen;
	if (dst==NULL || dstlen<=0)
		return leng;
	if (leng>dstlen)
		leng=dstlen;
	for (i=0;i<leng;i++)
		dst[i]=(src[i]&0x80)==0?src[i]:'?';
	return i;
#endif
}


/*	磻ʸ󢪥ޥХʸ
	   src,磻ʸ
	srclen,ʸ(-1:NULLλ)
	   dst,ޥХʸ
	dstlen,ʸ
	   RET,ʸ															*/
gssize misc_widechar_to_multibyte(const guint16 *src,const gssize srclen,
												gchar *dst,const gssize dstlen)
{
#ifdef USE_GTK2
	gssize i,j,leng;

	if (src==NULL)
		return 0;
	if (srclen<0) {
		for (leng=0;src[leng]>0;leng++);
		leng++;
	} else {
		leng=srclen;
	}
	j=0;
	if (dst==NULL || dstlen<=0)	/* ɬפʸ */
		for (i=0;i<leng;i++)
			if (src[i]<=0x007f)
				j++;
			else if (src[i]<=0x07ff)
				j+=2;
			else
				j+=3;
	else						/* Ѵ */
		for (i=0;i<leng && j<dstlen;i++)
			if (j+1==dstlen || src[i]<=0x007f) {
				dst[j++]=src[i];
			} else if (j+2==dstlen || src[i]<=0x07ff) {
				dst[j++]=0xc0|src[i]>>6;
				dst[j++]=0x80|(src[i]&0x3f);
			} else {
				dst[j++]=0xe0|src[i]>>12;
				dst[j++]=0x80|(src[i]>>6&0x3f);
				dst[j++]=0x80|(src[i]&0x3f);
			}
	return j;
#else
	gssize i,leng;

	if (src==NULL)
		return 0;
	if (srclen<0) {
		for (leng=0;src[leng]>0;leng++);
		leng++;
	} else {
		leng=srclen;
	}
	if (dst==NULL || dstlen<=0)
		return leng;
	if (leng>dstlen)
		leng=dstlen;
	for (i=0;i<leng;i++)
		dst[i]=src[i]<0x80?src[i]:'?';
	return i;
#endif
}


/*	ޥХʸ󢪥磻ʸ
	src,ޥХʸ
	RET,磻ʸ,NULL:顼											*/
guint16 *misc_multistring_to_widestring(const gchar *src)
{
	gssize leng;
	guint16 *dst;

	leng=misc_multibyte_to_widechar(src,-1,NULL,-1);
	dst=g_malloc(leng*sizeof(guint16));
	misc_multibyte_to_widechar(src,-1,dst,leng);
	return dst;
}


/*	磻ʸ󢪥ޥХʸ
	src,磻ʸ
	RET,ޥХʸ,NULL:顼										*/
gchar *misc_widestring_to_multistring(const guint16 *src)
{
	gssize leng;
	gchar *dst;

	leng=misc_widechar_to_multibyte(src,-1,NULL,-1);
	dst=g_malloc(leng*sizeof(gchar));
	misc_widechar_to_multibyte(src,-1,dst,leng);
	return dst;
}
