/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "abort.h"
#include "charset.h"
#include "file.h"
#include "signal.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* եؿ                                                              *
*                                                                             *
******************************************************************************/
/*	ե˲ä
	file,ե̾															*/
void file_set_history(const gchar *file)
{
	gchar *label;
	gint i,count;
	GList *glist;
	GtkWidget *sub_menu,*menu_item;

	sub_menu=gtk_item_factory_get_widget(item_factory_menu,"<main>/File");
	glist=gtk_container_children(GTK_CONTAINER(sub_menu));
	count=g_list_length(glist);
	for (i=0;i<count-MENUFILE-1;i++) {
		menu_item=g_list_nth_data(glist,i+MENUFILE-1);
		label=gtk_object_get_user_data(GTK_OBJECT(menu_item));
		if (g_strcmp(label,file)==0) {
			gtk_container_remove(GTK_CONTAINER(sub_menu),menu_item);
			break;
		}
	}
	g_list_free(glist);
	if (i>=history) {
		glist=gtk_container_children(GTK_CONTAINER(sub_menu));
		gtk_container_remove(GTK_CONTAINER(sub_menu),
								g_list_nth_data(glist,MENUFILE+history+1-3));
		g_list_free(glist);
	}
	if (count<=MENUFILE) {
		menu_item=gtk_menu_item_new();
		gtk_menu_insert(GTK_MENU(sub_menu),menu_item,MENUFILE-2);
		gtk_widget_show(menu_item);
	}
	label=g_strdup(file);
	menu_item=gtk_menu_item_new_with_label(label);
	gtk_signal_connect(GTK_OBJECT(menu_item),"activate",
						GTK_SIGNAL_FUNC(signal_activate_menu_history),label);
	gtk_signal_connect(GTK_OBJECT(menu_item),"destroy",
						GTK_SIGNAL_FUNC(signal_destroy_menu_history),label);
	gtk_object_set_user_data(GTK_OBJECT(menu_item),label);
	gtk_menu_insert(GTK_MENU(sub_menu),menu_item,MENUFILE-1);
	gtk_widget_show(menu_item);
}


/*	եä
	file,ä褦ȤեΥեѥ
	same,եѥ°
	 RET,ä褦ȤեΥ٥										*/
gchar *file_add_edit(const gchar *file,gint *same)
{
	gchar *label,*name0,*name1;
	gint i;
	GList *glist;
	GtkWidget *child;
	TmaidWindow *tmaid;

	*same=-1;
	/* ե̾Ĵ٤ */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	/* Ʊ̾ƱѥĴ٤ */
	for (i=g_list_length(glist)-1;i>=0;i--) {
		child=g_list_nth_data(glist,i);
		tmaid=gtk_object_get_user_data(GTK_OBJECT(child));
		if (g_strcmp(file,tmaid->file)==0) {
			if (tmaid->same<0) {
				tmaid->same=0;
				label=g_strdup_printf("%s:%d",tmaid->file,tmaid->same);
				gtk_label_set_text(GTK_LABEL(tmaid->label),label);
				g_free(label);
			}
			if (*same<=tmaid->same)
				*same=tmaid->same+1;
		}
	}
	if (*same>=0) {
		/* Ʊ̾ƱѥȤ */
		label=g_strdup_printf("%s:%d",file,*same);
	} else {
		/* Ʊ̾ƱѥϤʤȤ */
		/* Ʊ̾ۥѥĴ٤ */
		name0=g_basename(file);
		for (i=g_list_length(glist)-1;i>=0;i--) {
			child=g_list_nth_data(glist,i);
			tmaid=gtk_object_get_user_data(GTK_OBJECT(child));
			name1=g_basename(tmaid->file);
			if (g_strcmp(name0,name1)==0) {
				if (tmaid->same<0)
					gtk_label_set_text(GTK_LABEL(tmaid->label),tmaid->file);
				break;
			}
		}
		label=g_strdup(i>=0?file:name0);
	}
	g_list_free(glist);
	return label;
}


/*	ե
	file,褦ȤեΥեѥ									*/
void file_delete_edit(const gchar *file)
{
	gchar *name0,*name1;
	gint i,count=0;
	GList *glist;
	TmaidWindow *tmaid;
	GtkWidget *child;

	/* ե̾Ĵ٤ */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	/* Ʊ̾ۥѥĴ٤ */
	name0=g_basename(file);
	for (i=g_list_length(glist)-1;i>=0;i--) {
		tmaid=gtk_object_get_user_data(g_list_nth_data(glist,i));
		name1=g_basename(tmaid->file);
		if (g_strcmp(name0,name1)==0)
			count++;
	}
	if (count<=2) {
		/* Ʊ̾ۥѥΥե̾ɽѹ */
		for (i=g_list_length(glist)-1;i>=0;i--) {
			child=g_list_nth_data(glist,i);
			tmaid=gtk_object_get_user_data(GTK_OBJECT(child));
			name1=g_basename(tmaid->file);
			if (g_strcmp(name0,name1)==0)
				gtk_label_set_text(GTK_LABEL(tmaid->label),name1);
		}
	} else {
		/* Ʊ̾ƱѥĴ٤ */
		count=0;
		for (i=g_list_length(glist)-1;i>=0;i--) {
			tmaid=gtk_object_get_user_data(g_list_nth_data(glist,i));
			if (g_strcmp(file,tmaid->file)==0)
				count++;
		}
		if (count<=2)/* Ʊ̾ƱѥΥեեѥɽѹ */
			for (i=g_list_length(glist)-1;i>=0;i--) {
				child=g_list_nth_data(glist,i);
				tmaid=gtk_object_get_user_data(GTK_OBJECT(child));
				if (g_strcmp(file,tmaid->file)==0) {
					tmaid->same=-1;
					gtk_label_set_text(GTK_LABEL(tmaid->label),tmaid->file);
				}
			}
	}
}


/******************************************************************************
*                                                                             *
* եϴؿ                                                          *
*                                                                             *
******************************************************************************/
/*	TXTե򳫤
	tmaid,TXTɥ													*/
void file_open_text(TmaidWindow *tmaid)
{
	int c;
	FILE *fp;
	LineBuffer *p,*q;
	GtkWidget *dialog;

	if ((fp=fopen(tmaid->file,"rt"))==NULL)
		return;
	p=g_malloc(sizeof(LineBuffer));
	p->length=0;
	p->margin=FALSE;
	p->text=NULL;
	p->prev=p->next=NULL;
	tmaid->max=1;
	tmaid->off=0;
	tmaid->start=p;
	/* ܥå */
	userbreak=TRUE;
	dialog=abort_dialog(_("Reading"));
	gtk_grab_add(dialog);
	while ((c=fgetc(fp))!=EOF && userbreak) {
		while (gtk_events_pending())
			gtk_main_iteration();
		if (c=='\n') {
			q=g_malloc(sizeof(LineBuffer));
			q->text=NULL;
			q->length=0;
			q->margin=FALSE;
			q->prev=p;
			q->next=p->next;
			p->next=q;
			p=q;
			tmaid->max++;
		} else {
			p->text=g_realloc(p->text,(p->length+1)*sizeof(gchar));
			p->text[p->length++]=c;
		}
	}
	/* λ */
	gtk_grab_remove(dialog);
    gtk_widget_destroy(dialog);
	fclose(fp);
}


/*	ե򳫤
	file,ե̾
	 RET,TXTɥ													*/
TmaidWindow *file_open_edit(const gchar *file)
{
	gchar *ext,*p,*text;
	gint i,leng0,leng1;
	TmaidWindow *tmaid;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkWidget *table,*sub_menu,*button,*frame,*hbox;
	static gint fcount=0;	/* եο */
	static gchar *xpm[]={
"8 7 2 1",
" 	c None",
".	c #000000",
"..    ..",
" ..  .. ",
"  ....  ",
"   ..   ",
"  ....  ",
" ..  .. ",
"..    .."};

	tmaid=g_malloc0 (sizeof (TmaidWindow));
	tmaid->same=-1;
	tmaid->select.x=-1;
	if (file==NULL) {
		/*  */
		tmaid->file=g_strdup_printf("new%04d",fcount++%1000);
		tmaid->create=TRUE;
		i=0;
		tmaid->ft_id=ftype[0].associate?ftype[0].ft_id:-1;
		tmaid->margin=ftype[0].margin;
		tmaid->tab=ftype[0].tab;
		tmaid->autoindent=ftype[0].autoindent;
		tmaid->code=ftype[0].code;
		tmaid->crlf=ftype[0].crlf;
		tmaid->eof=ftype[0].eof;
		tmaid->limit=ftype[0].limit;
		tmaid->overwrite=ftype[0].overwrite;
		tmaid->space=ftype[0].space;
		tmaid->syscol=ftype[0].syscol;
		tmaid->gline=ftype[0].gline;
		tmaid->mline=ftype[0].mline;
		tmaid->uline=ftype[0].uline;
		tmaid->vline=ftype[0].vline;
		tmaid->font_name=g_strdup(ftype[0].font_name);
		g_memmove(tmaid->color,ftype[0].color,sizeof(GdkColor)*12);
	} else {
		tmaid->file=misc_get_full_path(file);
		leng0=g_strlen(tmaid->file);
		for (i=0;i<ftnum;i++) {
			if (g_strcmp(ftype[i].ext,"*")==0)
				break;
			ext=g_strdup(ftype[i].ext);
			for (p=g_strtok(ext,";");p!=NULL;p=g_strtok(NULL,";")) {
				leng1=g_strlen(p);
				if (leng0>=leng1 && g_strcmp(tmaid->file+leng0-leng1,p)==0)
					goto loop;
			}
			g_free(ext);
		}
		loop:
		if (i>=ftnum)
			i=0;
		tmaid->create=FALSE;
		tmaid->ft_id=ftype[i].associate?ftype[i].ft_id:-1;
		tmaid->margin=ftype[i].margin;
		tmaid->tab=ftype[i].tab;
		tmaid->autoindent=ftype[i].autoindent;
		tmaid->code=ftype[i].code;
		tmaid->crlf=ftype[i].crlf;
		tmaid->eof=ftype[i].eof;
		tmaid->limit=ftype[i].limit;
		tmaid->overwrite=ftype[i].overwrite;
		tmaid->space=ftype[i].space;
		tmaid->syscol=ftype[i].syscol;
		tmaid->gline=ftype[i].gline;
		tmaid->mline=ftype[i].mline;
		tmaid->uline=ftype[i].uline;
		tmaid->vline=ftype[i].vline;
		tmaid->font_name=g_strdup(ftype[i].font_name);
		g_memmove(tmaid->color,ftype[i].color,sizeof(GdkColor)*12);
		file_open_text(tmaid);
	}
	if (tmaid->start==NULL) {
		/* ե뤬0ХȤΤȤ */
		tmaid->off=0;
		tmaid->max=1;
		tmaid->start=g_malloc(sizeof(LineBuffer));
		tmaid->start->length=0;
		tmaid->start->margin=FALSE;
		tmaid->start->text=NULL;
		tmaid->start->prev=tmaid->start->next=NULL;
	}

	/* ե̾Ĵ٤ */
	text=file_add_edit(tmaid->file,&tmaid->same);

	/* ե */
	if (tmaid->font_name==NULL
					|| (tmaid->font=gdk_fontset_load(tmaid->font_name))==NULL)
		tmaid->font=gdk_font_ref(system_font);
	charset_size(tmaid->font,
					&tmaid->font_width,&tmaid->font_height,&tmaid->font_ascent);

	/* ɽꥢ */
	tmaid->drawing=gtk_drawing_area_new();
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"focus-in-event",
								GTK_SIGNAL_FUNC(signal_focus_in),tmaid);
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"focus-out-event",
								GTK_SIGNAL_FUNC(signal_focus_out),tmaid);
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"realize",
								GTK_SIGNAL_FUNC(signal_realize),tmaid);
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"unrealize",
								GTK_SIGNAL_FUNC(signal_unrealize),tmaid);
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"configure-event",
								GTK_SIGNAL_FUNC(signal_config),tmaid);
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"expose-event",
								GTK_SIGNAL_FUNC(signal_expose),tmaid);
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"button-press-event",
								GTK_SIGNAL_FUNC(signal_button_press),tmaid);
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"motion-notify-event",
								GTK_SIGNAL_FUNC(signal_motion_notify),tmaid);
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"button-release-event",
								GTK_SIGNAL_FUNC(signal_button_release),tmaid);
	gtk_signal_connect_after(GTK_OBJECT(tmaid->drawing),"key-press-event",
								GTK_SIGNAL_FUNC(signal_key_press),tmaid);
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"destroy",
								GTK_SIGNAL_FUNC(signal_destroy_draw),tmaid);
	gtk_widget_add_events(tmaid->drawing,
			GDK_FOCUS_CHANGE | GDK_BUTTON_PRESS_MASK | GDK_POINTER_MOTION_MASK
						| GDK_POINTER_MOTION_HINT_MASK | GDK_BUTTON_RELEASE);
	GTK_WIDGET_SET_FLAGS(tmaid->drawing,GTK_CAN_FOCUS);
	/* ץ饤ޥꥻ쥯 */
	gtk_selection_add_targets(tmaid->drawing,GDK_SELECTION_PRIMARY,targets,
									sizeof(targets)/sizeof(GtkTargetEntry));
	gtk_signal_connect(GTK_OBJECT(tmaid->drawing),"selection-get",
												signal_selection_get,tmaid);
	/* С */
	tmaid->hscroll=gtk_hscrollbar_new(
							GTK_ADJUSTMENT(gtk_adjustment_new(0,0,0,1,1,1)));
	tmaid->vscroll=gtk_vscrollbar_new(
							GTK_ADJUSTMENT(gtk_adjustment_new(0,0,0,1,1,1)));
	/* ơ֥ */
	table=gtk_table_new(2,2,FALSE);
	gtk_table_attach(GTK_TABLE(table),tmaid->drawing,0,1,0,1,
									GTK_EXPAND | GTK_SHRINK | GTK_FILL,
									GTK_EXPAND | GTK_SHRINK | GTK_FILL,0,0);
	gtk_table_attach(GTK_TABLE(table),tmaid->hscroll,0,1,1,2,
							GTK_EXPAND | GTK_SHRINK | GTK_FILL,GTK_FILL,0,0);
	gtk_table_attach(GTK_TABLE(table),tmaid->vscroll,1,2,0,1,
							GTK_FILL,GTK_EXPAND | GTK_SHRINK | GTK_FILL,0,0);
	gtk_object_set_user_data(GTK_OBJECT(table),tmaid);
	/* ˥塼 */
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,"<main>/Window");
	tmaid->menu_item=gtk_menu_item_new_with_label(tmaid->file);
	gtk_signal_connect(GTK_OBJECT(tmaid->menu_item),"activate",
						GTK_SIGNAL_FUNC(signal_activate_menu_window),table);
	gtk_menu_append(GTK_MENU(sub_menu),tmaid->menu_item);
	gtk_widget_show(tmaid->menu_item);
	/* ܥ */
	button=gtk_button_new();
	frame=gtk_frame_new(NULL);
	gtk_button_set_relief(GTK_BUTTON(button),GTK_RELIEF_NONE);
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&mask,NULL,xpm);
	gtk_container_add(GTK_CONTAINER(frame),gtk_pixmap_new(pixmap,mask));
	gtk_container_add(GTK_CONTAINER(button),frame);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",signal_clicked,table);
	/* ٥ */
	tmaid->label=gtk_label_new(text);
	g_free(text);
	/* ޡ */
	tmaid->mark = gtk_label_new ("*");
	/* ɽ */
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),tmaid->label,TRUE,TRUE,0);
	gtk_box_pack_start (GTK_BOX (hbox), tmaid->mark, FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(hbox),button,FALSE,FALSE,0);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),table,hbox);
	gtk_widget_show (hbox);
	gtk_widget_show (tmaid->label);
	gtk_widget_show_all (button);
	gtk_widget_show_all(table);
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),table));
	gtk_widget_grab_focus(tmaid->drawing);

	/* ǤϤʤե뤬¸ߤˤ˲ä */
	if (file!=NULL && history>0 && misc_isfile(tmaid->file))
		file_set_history(tmaid->file);

	return tmaid;
}


/******************************************************************************
*                                                                             *
* եϴؿ                                                          *
*                                                                             *
******************************************************************************/
/*	TXTե¸
	 file,ե̾
	tmaid,TXTɥ
	  RET,TRUE:ｪλ,FALSE:顼										*/
gboolean file_save_text(const gchar *file,TmaidWindow *tmaid)
{
	gboolean eof=FALSE;
	FILE *fp;
	LineBuffer *p;
	GtkWidget *dialog;

	p=tmaid->start;
	while (p->prev!=NULL)
		p=p->prev;
	/*  */
	if ((fp=fopen(file,"wt"))==NULL) {
		misc_message_box("Text maid",_("Can not open file"),0,_("OK"),NULL);
		return FALSE;
	}
	/* ܥå */
	userbreak=TRUE;
	dialog=abort_dialog(_("Writing"));
	gtk_grab_add(dialog);
	/*  */
	while (p!=NULL && userbreak) {
		while (gtk_events_pending())
			gtk_main_iteration();
		if (p->length>0 && fwrite(p->text,1,p->length,fp)!=p->length) {
			gtk_grab_remove(dialog);
			gtk_widget_destroy(dialog);
			misc_message_box("Text maid",_("Can not write"),0,_("OK"),NULL);
			fclose(fp);
			return FALSE;
		}
		if (!p->margin && p->next!=NULL) {
			if (fputc('\n',fp)==EOF) {
				gtk_grab_remove(dialog);
				gtk_widget_destroy(dialog);
				misc_message_box("Text maid",_("Can not write"),0,
																_("OK"),NULL);
				fclose(fp);
				return FALSE;
			}
			eof=FALSE;
		} else if (p->length>0) {
			eof=p->text[p->length-1]=='\x1a';
		}
		p=p->next;
	}
	/* Ǹ^Zդä */
	if (userbreak && !eof && tmaid->eof && fputc('\x1a',fp)==EOF) {
		gtk_grab_remove(dialog);
		gtk_widget_destroy(dialog);
		misc_message_box("Text maid",_("Can not write"),0,_("OK"),NULL);
		fclose(fp);
		return FALSE;
	}
	/* λ */
	gtk_grab_remove(dialog);
	gtk_widget_destroy(dialog);
	if (fclose(fp)!=0) {
		misc_message_box("Text maid","fclose",0,_("OK"),NULL);
		return FALSE;
	}
	return TRUE;
}
