/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <locale.h>
#include <unistd.h>
#include "tmaid.h"
#include "argument.h"
#include "charset.h"
#include "command.h"
#include "conf.h"
#include "file.h"
#include "find.h"
#include "format.h"
#include "general.h"
#include "jump.h"
#ifdef USE_GDKPIXBUF
# include "print.h"
#endif
#include "replace.h"
#include "signal.h"
#include "toolbar.h"
#include "version.h"
#include "misc/misc.h"
#include "misc/profile.h"


gboolean caret=FALSE;				/* åȤη */
gboolean ins=TRUE;					/* TRUE:,FALSE: */
gboolean newfile=FALSE;				/* TRUE:ե,FALSE:ʤ */
gboolean second=FALSE;				/* TRUE:,FALSE:¸ */
gchar *history_files[10];			/* ե */
gchar *open_path=NULL;				/* Υѥ */
gchar *save_path=NULL;				/* ̾դ¸Υѥ */
gchar *clipboard_text=NULL;			/* åץܡɤΥƥ */
gchar *arg_text=NULL;				/* ץ̿ѿ */
gint def_width,def_height;			/* ǥեȤΥɥΥ */
gint ftnum=0;						/* ե륿פο */
gint history=4;						/* ե */
gint init_line=0;					/* ΥåȰ */
gint instance=-1;					/* ץ̿ѿ */
gint tcount=0;						/* ե륿פΥ */
guint timer_id=0;					/* ID */
FileType *ftype=NULL;				/* ե륿 */
GdkAtom atom_clipboard;				/* åץܡ */
GdkAtom atom_targets;				/* å */
GdkAtom atom_compound;				/* ѥ */
GdkAtom atom_text;					/* ƥ */
GdkAtom atom_textmaid0;				/* ץ̿ѥȥ */
GdkAtom atom_textmaid1;				/* ץ̿ѥȥ */
GtkWidget *window;					/* ɥ */
GtkWidget *notebook;				/* Ρȥ֥å */
GtkWidget *status;					/* ơɥ */
GtkWidget *label_cursor;			/* ɸ */
GtkPositionType n_pos=GTK_POS_TOP;	/* Ρȥ֥åΰ */
GtkItemFactory *item_factory_menu;	/* ˥塼 */
GtkItemFactory *item_factory_popup;	/* ݥåץå */
GdkFont *system_font=NULL;
GdkColor system_color[12]={	{0,0x0000,0x0000,0x0000},{0,0xffff,0xffff,0xffff},
							{0,0x8000,0x8000,0x8000},{0,0x8000,0x8000,0x8000},
							{0,0x8000,0x8000,0x8000},{0,0x8000,0x8000,0x8000},
							{0,0x8000,0x8000,0x8000},{0,0xa000,0xa000,0xa000},
							{0,0xffff,0xffff,0xffff},{0,0x0000,0x0000,0x8000},
							{0,0x0000,0x0000,0x0000},{0,0xffff,0xffff,0xffff}};
GtkTargetEntry targets[3]={			/* Text maid󶡲ǽʥ쥯 */
	{"STRING",       0,TARGET_STRING},
	{"TEXT",         0,TARGET_TEXT}, 
	{"COMPOUND_TEXT",0,TARGET_COMPOUND_TEXT}};


/******************************************************************************
*                                                                             *
* ᥤؿ                                                                  *
*                                                                             *
******************************************************************************/
static gchar *menu_translate(const gchar *path,gpointer func_data)
{
   return gettext(path);
}


int main(int argc,char *argv[])
{
	gboolean *arg_files;
	gchar *arg,*section,*key;
	gint i,count=0,leng,length=0;
	Profile *profile;
	TmaidWindow *tmaid;
	GdkBitmap *mask;
	GdkPixmap *pixmap;
	GtkAccelGroup *accel_group;
	GtkStyle *style;
	GtkWidget *menubar,*menu_item,*sub_menu;
	GtkWidget *handle,*text,*table,*toolbar,*vbox,*frame;
	GtkItemFactoryEntry menu_items[]={
{N_("/_File"),                       NULL,         NULL,            0,"<Branch>"},
{N_("/File/_New"),                   "<control>N", command_new,     0,"<Item>"},
{N_("/File/_Open..."),               "<control>O", command_open,    0,"<Item>"},
{N_("/File/_Close"),                 "<control>W", command_close,   0,"<Item>"},
{N_("/File/_Save"),                  "<control>S", command_save,    0,"<Item>"},
{N_("/File/Save _As..."),            NULL,         command_saveas,  0,"<Item>"},
{N_("/File/_Reload"),                "<control>R", command_reload,  0,"<Item>"},
{N_("/File/Sep1"),                   NULL,         NULL,            0,"<Separator>"},
#ifdef USE_GDKPIXBUF
{N_("/File/_Print..."),              "<control>P", command_print,   0,"<Item>"},
{N_("/File/Sep2"),                   NULL,         NULL,            0,"<Separator>"},
#endif
{N_("/File/Propert_ies..."),         "<alt>Return",command_property,0,"<Item>"},
{N_("/File/Sep3"),                   NULL,         NULL,            0,"<Separator>"},
{N_("/File/E_xit"),                  "<control>Q", command_exit,    0,"<Item>"},
{N_("/_Edit"),                       NULL,         NULL,            0,"<Branch>"},
{N_("/Edit/_Undo"),                  "<control>Z", command_undo,    0,"<Item>"},
{N_("/Edit/_Redo"),                  "F4",         command_redo,    0,"<Item>"},
{N_("/Edit/Sep1"),                   NULL,         NULL,            0,"<Separator>"},
{N_("/Edit/Cu_t"),                   "<control>X", command_cut,     0,"<Item>"},
{N_("/Edit/_Copy"),                  "<control>C", command_copy,    0,"<Item>"},
{N_("/Edit/_Paste"),                 "<control>V", command_paste,   0,"<Item>"},
{N_("/Edit/De_lete"),                NULL,         command_delete,  0,"<Item>"},
{N_("/Edit/Sep2"),                   NULL,         NULL,            0,"<Separator>"},
{N_("/Edit/Return at Right _Margin"),NULL,         command_margin,  0,"<Item>"},
{N_("/Edit/Convert Ta_b to Space"),  NULL,         command_tab,     0,"<Item>"},
{N_("/Edit/Sep3"),                   NULL,         NULL,            0,"<Separator>"},
{N_("/Edit/_Character by _Value..."),NULL,         command_valchr,  0,"<Item>"},
{N_("/Edit/_Jump..."),               "<control>J", command_jump,    0,"<Item>"},
{N_("/Edit/Sep4"),                   NULL,         NULL,            0,"<Separator>"},
{N_("/Edit/_All"),                   "<control>A", command_all,     0,"<Item>"},
{N_("/_Search"),                     NULL,         NULL,            0,"<Branch>"},
{N_("/Search/_Find..."),             "<control>F", command_find,    0,"<Item>"},
{N_("/Search/_Next"),                "F3",         command_next,    0,"<Item>"},
{N_("/Search/_Previous"),            "<shift>F3",  command_next,    1,"<Item>"},
{N_("/Search/_Replace..."),          "<control>H", command_replace, 0,"<Item>"},
{N_("/_Option"),                     NULL,         NULL,            0,"<Branch>"},
{N_("/Option/_Configuration..."),    NULL,         conf_dialog,     0,"<Item>"},
{N_("/Option/File _Type..."),        NULL,         format_dialog,   0,"<Item>"},
{N_("/_Window"),                     NULL,         NULL,            0,"<Branch>"},
{N_("/_Help"),                       NULL,         NULL,            0,"<Branch>"},
{N_("/Help/_About..."),              NULL,         version_dialog,  0,"<Item>"}};
	GtkItemFactoryEntry popup_items[]={
{N_("/_Undo"),                       "<control>Z", command_undo,    0,"<Item>"},
{"/Sep1",                            NULL,         NULL,            0,"<Separator>"},
{N_("/Cu_t"),                        "<control>X", command_cut,     0,"<Item>"},
{N_("/_Copy"),                       "<control>C", command_copy,    0,"<Item>"},
{N_("/_Paste"),                      "<control>V", command_paste,   0,"<Item>"},
{N_("/De_lete"),                     NULL,         command_delete,  0,"<Item>"},
{"/Sep2",                            NULL,         NULL,            0,"<Separator>"},
{N_("/_All"),                        "<control>A", command_all,     0,"<Item>"}};
	/* Drag&Drop */
	GtkTargetEntry drag_types[1]={{"text/uri-list",0,0}};

	/*  */
	setlocale(LC_ALL,"");
	bindtextdomain(PACKAGE,LOCALEDIR);
	textdomain(PACKAGE);
	gtk_set_locale();
	gtk_init(&argc,&argv);
	charset_init();

	def_width=gdk_screen_width()*2/3;
	def_height=gdk_screen_height()*2/3;
	g_memset(history_files,0,sizeof(gchar *)*10);
	/* 쥸ȥ꤫ɤ߽Ф */
	if ((profile=profile_open(".tmaid"))!=NULL) {
		if (!profile_get_value(profile,"tmaid","ftnum",
						(gpointer)&ftnum,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			ftnum=0;
		if (!profile_get_value(profile,"tmaid","history",
					(gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			history=4;
		if (!profile_get_value(profile,"tmaid","newfile",
				(gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
			newfile=FALSE;
		if (!profile_get_value(profile,"tmaid","second",
				(gpointer)&second,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL))
			second=FALSE;
		if (!profile_get_value(profile,"tmaid","def_width",
					(gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			def_width=gdk_screen_width()*2/3;
		if (!profile_get_value(profile,"tmaid","def_height",
					(gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			def_height=gdk_screen_height()*2/3;
		if (!profile_get_value(profile,"tmaid","n_pos",
						(gpointer)&n_pos,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			n_pos=GTK_POS_TOP;
		open_path=profile_get_string(profile,"tmaid","openpath");
		save_path=profile_get_string(profile,"tmaid","savepath");
		/* ե */
		for (i=0;i<history;i++) {
			key=g_strdup_printf("history%d",i);
			history_files[i]=profile_get_string(profile,"tmaid",key);
			g_free(key);
			if (history_files[i]==NULL)
				break;
			if (*history_files[i]=='\0') {
				g_free(history_files[i]);
				history_files[i]=NULL;
				break;
			}
		}
		/*  */
		if (!profile_get_value(profile,"tmaid","find_arrow",
										(gpointer)&find_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			find_arrow=TRUE;
		if (!profile_get_value(profile,"tmaid","find_ignorecase",
								(gpointer)&find_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			find_ignorecase=FALSE;
		if (!profile_get_value(profile,"tmaid","find_num",
					(gpointer)&find_num,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			find_num=0;
		for (i=0;i<find_num;i++) {
			key=g_strdup_printf("find%02d",i);
			find_text[i]=profile_get_string(profile,"tmaid",key);
			g_free(key);
			if (find_text[i]==NULL)
				break;
		}
		find_num=i;
		/* ִ */
		if (!profile_get_value(profile,"tmaid","replace_arrow",
									(gpointer)&replace_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			replace_arrow=TRUE;
		if (!profile_get_value(profile,"tmaid","replace_ignorecase",
								(gpointer)&replace_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			replace_ignorecase=FALSE;
		if (!profile_get_value(profile,"tmaid","replace_num",
				(gpointer)&replace_num,sizeof(gint),PROFILE_VALUE_TYPE_INT))
			replace_num=0;
		for (i=0;i<replace_num;i++) {
			key=g_strdup_printf("replace%02d",i);
			replace_text[i]=profile_get_string(profile,"tmaid",key);
			g_free(key);
			if (replace_text[i]==NULL)
				break;
		}
		replace_num=i;
#ifdef USE_GDKPIXBUF
		/*  */
		if (!profile_get_value(profile,"printer","mode",
								(gpointer)&printer.mode,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
			printer.mode=TRUE;
		if ((printer.printer=profile_get_string(profile,"printer",
															"printer"))==NULL)
			printer.printer=g_strdup("lpr");
		if ((printer.file=profile_get_string(profile,"printer","file"))==NULL)
			printer.file=g_strdup("tmaid.ps");
		if (!profile_get_value(profile,"printer","width",
										(gpointer)&printer.width,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
			printer.width=594;
		if (!profile_get_value(profile,"printer","height",
										(gpointer)&printer.height,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
			printer.height=840;
		if (!profile_get_value(profile,"printer","left",
										(gpointer)&printer.left,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
			printer.left=20;
		if (!profile_get_value(profile,"printer","top",
										(gpointer)&printer.top,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
			printer.top=20;
		if (!profile_get_value(profile,"printer","right",
										(gpointer)&printer.right,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
			printer.right=20;
		if (!profile_get_value(profile,"printer","bottom",
										(gpointer)&printer.bottom,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
			printer.bottom=20;
#endif
		/* ե륿 */
		if (ftnum>0)
			ftype=g_malloc(ftnum*sizeof(FileType));
		for (i=0;i<ftnum;i++) {
			section=g_strdup_printf("filetype%04d",i);
			ftype[i].ft_id=tcount++;
			if ((ftype[i].text
							=profile_get_string(profile,section,"text"))==NULL)
				ftype[i].text=g_strdup("UNKNOW");
			if ((ftype[i].ext=profile_get_string(profile,section,"ext"))==NULL)
				ftype[i].ext=g_strdup("*");
			if (!profile_get_value(profile,section,"margin",
									(gpointer)&ftype[i].margin,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
				ftype[i].margin=80;
			if (!profile_get_value(profile,section,"tab",
										(gpointer)&ftype[i].tab,sizeof(gint),
													PROFILE_VALUE_TYPE_INT))
				ftype[i].tab=8;
			if (!profile_get_value(profile,section,"associate",
								(gpointer)&ftype[i].associate,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].associate=TRUE;
			if (!profile_get_value(profile,section,"autoindent",
							(gpointer)&ftype[i].autoindent,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].autoindent=FALSE;
			if (!profile_get_value(profile,section,"code",
									(gpointer)&ftype[i].code,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].code=FALSE;
			if (!profile_get_value(profile,section,"crlf",
									(gpointer)&ftype[i].crlf,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].crlf=FALSE;
			if (!profile_get_value(profile,section,"eof",
									(gpointer)&ftype[i].eof,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].eof=FALSE;
			if (!profile_get_value(profile,section,"limit",
									(gpointer)&ftype[i].limit,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].limit=FALSE;
			if (!profile_get_value(profile,section,"overwrite",
								(gpointer)&ftype[i].overwrite,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].overwrite=FALSE;
			if (!profile_get_value(profile,section,"space",
									(gpointer)&ftype[i].space,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].space=FALSE;
			if (!profile_get_value(profile,section,"syscol",
								(gpointer)&ftype[i].syscol,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].syscol=TRUE;
			if (!profile_get_value(profile,section,"gline",
									(gpointer)&ftype[i].gline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].gline=FALSE;
			if (!profile_get_value(profile,section,"mline",
									(gpointer)&ftype[i].mline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].mline=FALSE;
			if (!profile_get_value(profile,section,"uline",
									(gpointer)&ftype[i].uline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].uline=FALSE;
			if (!profile_get_value(profile,section,"vline",
									(gpointer)&ftype[i].vline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL))
				ftype[i].vline=FALSE;
			/* ե */
			if ((ftype[i].font_name
							=profile_get_string(profile,section,"font"))==NULL)
				ftype[i].font_name=NULL;
			/*  */
			if (!profile_get_value(profile,section,"color",
								(gpointer)&ftype[i].color,sizeof(GdkColor)*12,
													PROFILE_VALUE_TYPE_ARRAY))
				g_memmove(ftype[i].color,system_color,sizeof(GdkColor)*12);
			g_free(section);
		}
		profile_close(profile);
#ifdef USE_GDKPIXBUF
	} else {
		printer.mode=TRUE;
		printer.printer=g_strdup("lpr");
		printer.file=g_strdup("tmaid.ps");
		printer.width=594;
		printer.height=840;
		printer.left=printer.top=printer.right=printer.bottom=20;
#endif
	}

	/* ޥɥ饤β */
	arg_files=arg_analyse(argv,TRUE);

	/* ե륿 */
	if (ftnum<=0) {
		ftnum=1;
		ftype=g_malloc(ftnum*sizeof(FileType));
		ftype[0].text=g_strdup(_("All Files"));
		ftype[0].ext=g_strdup("*");
		ftype[0].margin=80;
		ftype[0].tab=8;
		ftype[0].associate=TRUE;
		ftype[0].autoindent=FALSE;
		ftype[0].code=FALSE;
		ftype[0].crlf=FALSE;
		ftype[0].eof=FALSE;
		ftype[0].limit=FALSE;
		ftype[0].overwrite=FALSE;
		ftype[0].space=FALSE;
		ftype[0].syscol=TRUE;
		ftype[0].gline=FALSE;
		ftype[0].mline=FALSE;
		ftype[0].uline=FALSE;
		ftype[0].vline=FALSE;
		/* ե */
		ftype[0].font_name=NULL;
		/*  */
		g_memmove(ftype[0].color,system_color,sizeof(GdkColor)*12);
	}

	/* ᥤ󥦥ɥ */
	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window),"Text maid");
	gtk_window_set_default_size(GTK_WINDOW(window),def_width,def_height);
	gtk_signal_connect(GTK_OBJECT(window),"delete-event",
										GTK_SIGNAL_FUNC(signal_delete),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"destroy",
												signal_destroy_window,NULL);
	gtk_widget_realize(window);
	/* Drag and Drop */
	gtk_drag_dest_set(window,GTK_DEST_DEFAULT_MOTION
						| GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
												drag_types,1,GDK_ACTION_COPY);
	gtk_signal_connect(GTK_OBJECT(window),"drag-data-received",
							GTK_SIGNAL_FUNC(signal_drag_data_received),NULL);
	/* åץܡ/ץ̿ */
	atom_clipboard=gdk_atom_intern("CLIPBOARD",FALSE);
	atom_targets=gdk_atom_intern("TARGETS",FALSE);
	atom_compound=gdk_atom_intern("COMPOUND_TEXT",FALSE);
	atom_text=gdk_atom_intern("TEXT",FALSE);
	atom_textmaid0=gdk_atom_intern("Text maid InterProcess communication 0",
																		FALSE);
	atom_textmaid1=gdk_atom_intern("Text maid InterProcess communication 1",
																		FALSE);
	gtk_selection_add_targets(window,atom_clipboard,
							targets,sizeof(targets)/sizeof(GtkTargetEntry));
	if (!second) {
		gtk_selection_add_targets(window,atom_textmaid0,targets,1);
		gtk_selection_add_targets(window,atom_textmaid1,targets,1);
	}
	gtk_signal_connect(GTK_OBJECT(window),"selection-clear-event",
								GTK_SIGNAL_FUNC(signal_selection_clear),NULL);
	gtk_signal_connect(GTK_OBJECT(window),"selection-get",
											signal_selection_get,NULL);
	gtk_signal_connect(GTK_OBJECT(window),"selection-received",
											signal_selection_received,NULL);
	/* Ρȥ֥å */
	notebook=gtk_notebook_new();
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook),TRUE);
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),n_pos);
	gtk_signal_connect(GTK_OBJECT(notebook),"switch-page",
								GTK_SIGNAL_FUNC(signal_switch_page),NULL);
	gtk_signal_connect(GTK_OBJECT(notebook),"destroy",
								GTK_SIGNAL_FUNC(signal_destroy_notebook),NULL);
	/* ݥåץå */
	accel_group=gtk_accel_group_new();
	item_factory_popup=gtk_item_factory_new(GTK_TYPE_MENU,
														"<main>",accel_group);
	gtk_item_factory_set_translate_func(item_factory_popup,menu_translate,
																	NULL,NULL);
	gtk_item_factory_create_items(item_factory_popup,
			sizeof(popup_items)/sizeof(GtkItemFactoryEntry),popup_items,NULL);
	/* ˥塼 */
	accel_group=gtk_accel_group_new();
	item_factory_menu=gtk_item_factory_new(GTK_TYPE_MENU_BAR,
														"<main>",accel_group);
	gtk_item_factory_set_translate_func(item_factory_menu,menu_translate,
																	NULL,NULL);
	gtk_item_factory_create_items(item_factory_menu,
			sizeof(menu_items)/sizeof(GtkItemFactoryEntry),menu_items,NULL);
	gtk_accel_group_attach(accel_group,GTK_OBJECT(window));
	menubar=gtk_item_factory_get_widget(item_factory_menu,"<main>");
	/* ġС */
	toolbar=gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_ICONS);
	for (i=0;toolbar_items[i].name!=(gpointer)-1;i++)
		if (toolbar_items[i].name==NULL) {
			gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
		} else {
			pixmap=gdk_pixmap_create_from_xpm_d(window->window,
											&mask,NULL,toolbar_items[i].xpm);
			toolbar_items[i].item=gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
						NULL,_(toolbar_items[i].name),NULL,
						gtk_pixmap_new(pixmap,mask),
						toolbar_items[i].callback,toolbar_items[i].user_data);
		}
	/* ơ֥ */
	table = gtk_table_new (1, 5, FALSE);
	/* ơС */
	status=gtk_statusbar_new();
	/* ɸ */
	label_cursor = gtk_label_new (NULL);
	gtk_label_set_justify (GTK_LABEL (label_cursor), GTK_JUSTIFY_CENTER);
	frame = gtk_frame_new(NULL);
	gtk_container_add( GTK_CONTAINER (frame), label_cursor);
	/* ƥ */
	text=gtk_text_new(NULL,NULL);
	gtk_signal_connect(GTK_OBJECT(text),"style-set",signal_style_set,NULL);
	/* ľܥå/ϥɥܥå */
	vbox=gtk_vbox_new(FALSE,0);
	handle=gtk_handle_box_new();
	gtk_container_set_border_width(GTK_CONTAINER(handle),2);
	gtk_container_add(GTK_CONTAINER(handle),menubar);
	gtk_box_pack_start(GTK_BOX(vbox),handle,FALSE,FALSE,0);
	handle=gtk_handle_box_new();
	gtk_container_set_border_width(GTK_CONTAINER(handle),2);
	gtk_container_add(GTK_CONTAINER(handle),toolbar);
	gtk_box_pack_start(GTK_BOX(vbox),handle,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),notebook,TRUE,TRUE,0);
	gtk_table_attach (GTK_TABLE (table), status, 0, 4, 0, 1,
			GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_table_attach (GTK_TABLE (table), frame, 4, 5, 0, 1,
			GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_box_pack_end(GTK_BOX(vbox),table,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(vbox),text,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	/* ե */
	sub_menu=gtk_item_factory_get_widget(item_factory_menu,"<main>/File");
	for (i=0;i<history && history_files[i]!=NULL;i++) {
		menu_item=gtk_menu_item_new_with_label(history_files[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),"activate",
			GTK_SIGNAL_FUNC(signal_activate_menu_history),history_files[i]);
		gtk_signal_connect(GTK_OBJECT(menu_item),"destroy",
			GTK_SIGNAL_FUNC(signal_destroy_menu_history),history_files[i]);
		gtk_object_set_user_data(GTK_OBJECT(menu_item),history_files[i]);
		gtk_menu_insert(GTK_MENU(sub_menu),menu_item,i+MENUFILE-1);
	}
	if (i>0)
		gtk_menu_insert(GTK_MENU(sub_menu),gtk_menu_item_new(),i+MENUFILE-1);
	/*  */
	timer_id=gtk_timeout_add(500,signal_timeout,NULL);

	/* ˥塼ɽ */
	set_menu_bar(NULL);

	/* ˵ưƤ뤫å */
	if (!second) {
		if (argc > 1)
			for (i = 0; i < argc; i++)
			  {
				if (arg_files[i])
				  {
					arg = misc_get_full_path (argv[i]);
					leng = g_strlen (arg) * sizeof (gchar);
					arg_text = g_realloc (arg_text,
											length + leng + sizeof (gchar));
					g_memmove (arg_text + length, arg, leng);
					g_free (arg);
				  }
				else
				  {
					leng = g_strlen (argv[i]) * sizeof (gchar);
					arg_text = g_realloc (arg_text,
											length + leng + sizeof (gchar));
					g_memmove (arg_text + length, argv[i], leng);
				  }
				length += leng;
				arg_text[length++] = '\n';
			  }
		if (length>0) {
			arg_text[length-1]='\0';
			gtk_selection_owner_set(window,atom_textmaid1,GDK_CURRENT_TIME);
		}
		gtk_selection_convert(window,atom_textmaid0,
								GDK_SELECTION_TYPE_STRING,GDK_CURRENT_TIME);
		while (instance<0)
			while (gtk_events_pending())
				gtk_main_iteration();
		if (instance>0) {
			/* ˵ưƤȤ */
			while (arg_text!=NULL)
				while (gtk_events_pending())
					gtk_main_iteration();
			g_free(arg_files);
			gtk_exit(0);
		}
		g_free(arg_text);
		gtk_selection_owner_set(window,atom_textmaid0,GDK_CURRENT_TIME);
	}

	/* ɽ */
	gtk_widget_show_all(window);
	gtk_widget_hide_all(text);
	gtk_window_set_policy(GTK_WINDOW(window),TRUE,TRUE,TRUE);

	/* ƥ࿧ */
	style=gtk_widget_get_style(text);
	system_color[0]=style->text[0];
	system_color[1]=style->base[0];
	system_color[2]=style->dark[0];
	system_color[3]=style->dark[0];
	system_color[4]=style->dark[0];
	system_color[5]=style->dark[0];
	system_color[6]=style->dark[0];
	system_color[7]=style->mid[0];
	system_color[8]=style->fg[3];
	system_color[9]=style->bg[3];
	/* ƥե */
	system_font=gdk_font_ref(style->font);

	/* ɥ */
	for (i=1;i<argc;i++)
		if (arg_files[i]) {
			tmaid=file_open_edit(argv[i]);
			if (init_line!=0)	/* Ԥ˰ư */
				jump_operation(tmaid,init_line);
			count++;
		}
	g_free(arg_files);
	if (newfile && count<=0)
		file_open_edit(NULL);

	gtk_main();

	/* 쥸ȥ˽񤭹 */
	if ((profile=profile_open(".tmaid"))!=NULL) {
		profile_set_value(profile,"tmaid","ftnum",
						(gpointer)&ftnum,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","history",
					(gpointer)&history,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","newfile",
				(gpointer)&newfile,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","second",
				(gpointer)&second,sizeof(gboolean),PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","def_width",
					(gpointer)&def_width,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","def_height",
					(gpointer)&def_height,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"tmaid","n_pos",
						(gpointer)&n_pos,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		if (open_path!=NULL)
			profile_set_value(profile,"tmaid","openpath",(gpointer)open_path,
										(g_strlen(open_path)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
		if (save_path!=NULL)
			profile_set_value(profile,"tmaid","savepath",(gpointer)save_path,
										(g_strlen(save_path)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
		/* ե */
		for (i=0;i<history && history_files[i]!=NULL;i++) {
			key=g_strdup_printf("history%d",i);
			profile_set_value(profile,"tmaid",key,(gpointer)history_files[i],
								(g_strlen(history_files[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<10) {
			key=g_strdup_printf("history%d",i++);
			profile_set_value(profile,"tmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		/*  */
		profile_set_value(profile,"tmaid","find_arrow",
										(gpointer)&find_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","find_ignorecase",
								(gpointer)&find_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","find_num",
					(gpointer)&find_num,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		for (i=0;i<find_num;i++) {
			key=g_strdup_printf("find%02d",i);
			profile_set_value(profile,"tmaid",key,(gpointer)find_text[i],
									(g_strlen(find_text[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<32) {
			key=g_strdup_printf("find%02d",i++);
			profile_set_value(profile,"tmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		/* ִ */
		profile_set_value(profile,"tmaid","replace_arrow",
									(gpointer)&replace_arrow,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","replace_ignorecase",
								(gpointer)&replace_ignorecase,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"tmaid","replace_num",
				(gpointer)&replace_num,sizeof(gint),PROFILE_VALUE_TYPE_INT);
		for (i=0;i<replace_num;i++) {
			key=g_strdup_printf("replace%02d",i);
			profile_set_value(profile,"tmaid",key,(gpointer)replace_text[i],
								(g_strlen(replace_text[i])+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
		while (i<32) {
			key=g_strdup_printf("replace%02d",i++);
			profile_set_value(profile,"tmaid",key,(gpointer)"",sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			g_free(key);
		}
#ifdef USE_GDKPIXBUF
		/*  */
		profile_set_value(profile,"printer","mode",
									(gpointer)&printer.mode,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
		profile_set_value(profile,"printer","printer",
								(gpointer)printer.printer,
								(g_strlen(printer.printer)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
		profile_set_value(profile,"printer","file",(gpointer)printer.file,
									(g_strlen(printer.file)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
		profile_set_value(profile,"printer","width",
										(gpointer)&printer.width,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"printer","height",
										(gpointer)&printer.height,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"printer","left",
										(gpointer)&printer.left,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"printer","top",
										(gpointer)&printer.top,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"printer","right",
										(gpointer)&printer.right,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
		profile_set_value(profile,"printer","bottom",
										(gpointer)&printer.bottom,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
#endif
		/* ե륿 */
		section=NULL;
		for (i=0;i<ftnum;i++) {
			section=g_strdup_printf("filetype%04d",i);
			profile_set_value(profile,section,"text",(gpointer)ftype[i].text,
									(g_strlen(ftype[i].text)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			profile_set_value(profile,section,"ext",(gpointer)ftype[i].ext,
									(g_strlen(ftype[i].ext)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			profile_set_value(profile,section,"margin",
									(gpointer)&ftype[i].margin,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
			profile_set_value(profile,section,"tab",
										(gpointer)&ftype[i].tab,sizeof(gint),
													PROFILE_VALUE_TYPE_INT);
			profile_set_value(profile,section,"associate",
								(gpointer)&ftype[i].associate,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"autoindent",
							(gpointer)&ftype[i].autoindent,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"code",
									(gpointer)&ftype[i].code,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"crlf",
								(gpointer)&ftype[i].crlf,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"eof",
									(gpointer)&ftype[i].eof,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"limit",
									(gpointer)&ftype[i].limit,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"overwrite",
								(gpointer)&ftype[i].overwrite,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"space",
									(gpointer)&ftype[i].space,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"syscol",
								(gpointer)&ftype[i].syscol,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"gline",
									(gpointer)&ftype[i].gline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"mline",
									(gpointer)&ftype[i].mline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"uline",
									(gpointer)&ftype[i].uline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			profile_set_value(profile,section,"vline",
									(gpointer)&ftype[i].vline,sizeof(gboolean),
													PROFILE_VALUE_TYPE_BOOL);
			/* ե */
			if (ftype[i].font_name!=NULL)
				profile_set_value(profile,section,"font",
								(gpointer)ftype[i].font_name,
								(g_strlen(ftype[i].font_name)+1)*sizeof(gchar),
													PROFILE_VALUE_TYPE_STRING);
			/*  */
			profile_set_value(profile,section,"color",
								(gpointer)&ftype[i].color,sizeof(GdkColor)*12,
													PROFILE_VALUE_TYPE_ARRAY);
		}
		do {
			g_free(section);
			section=g_strdup_printf("filetype%04d",i++);
		} while (profile_delete_section(profile,section));
		g_free(section);
		profile_close(profile);
	}
	gdk_font_unref(system_font);
	g_free(open_path);
	g_free(save_path);
	g_free(clipboard_text);
#ifdef USE_GDKPIXBUF
	g_free(printer.printer);
	g_free(printer.file);
#endif
	for (i=0;i<find_num;i++)
		g_free(find_text[i]);
	for (i=0;i<replace_num;i++)
		g_free(replace_text[i]);
	for (i=0;i<history;i++)
		g_free(history_files[i]);
	for (i=0;i<ftnum;i++) {
		g_free(ftype[i].text);
		g_free(ftype[i].ext);
		g_free(ftype[i].font_name);
	}
	g_free(ftype);
	return 0;
}
