/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "charset.h"


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
gsize charset_leng[256] = {
		/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 2 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 4 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 6 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 8 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* A */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* C */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* E */	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,6,6,1,1};
guchar charset_space[] = {3, 0xE3, 0x80, 0x80, 0};


/*	եȤȹ⤵
	  layout,쥤
	   width,
	  height,⤵
	font_buf,Хåե														*/
void
charset_size (PangoLayout *layout, gint *width, gint *height, guint8 *font_buf)
{
	int w, h;
	gint i;

	if (width != NULL)
		*width = 1;
	if (height != NULL)
		*height = 1;
	if (font_buf != NULL)
		g_memset (font_buf, 0, sizeof(guint8) * 65536);
	for (i = 0; i < 128; i++)
		if (charset_length (i) == 1 && g_unichar_isprint ((gunichar)i))
		  {
			pango_layout_set_text (layout, (const char *)&i, 1);
			pango_layout_get_pixel_size (layout, &w, &h);
			if (width != NULL && *width < w)
				*width = w;
			if (height != NULL && *height < h)
				*height = h;
		  }
}


/*	ɽȾñ̤ʸ
	  layout,쥤
	    text,ʸ
	   width,
	font_buf,Хåե
	     RET,Ⱦñ														*/
gint
charset_width (PangoLayout *layout, const gchar *text,
											const gint width, guint8 *font_buf)
{
	int w;
	gint result;
	gsize length;
	gunichar c;

	length = charset_length (*text);
	c = g_utf8_get_char_validated (text, length);
	if (!g_unichar_validate (c))
		return 1;
	if ((guint32)c < 65536)
	  {
		if (length <= 1)
			font_buf[c] = 1;
		if (font_buf[c] != 0)
			return font_buf[c];
	  }
	pango_layout_set_text (layout, text, length);
	pango_layout_get_pixel_size (layout, &w, NULL);
	result = MAX ((w + width - 1) / width, 1);
	if ((guint32)c < 65536)
		font_buf[c] = result;
	return result;
}
