/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "abort.h"
#include "charset.h"
#include "charlist.h"
#include "file.h"
#include "general.h"
#include "prop.h"
#include "sigfile.h"
#include "sigkey.h"
#include "sigmain.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* եؿ                                                              *
*                                                                             *
******************************************************************************/
/*	ե˲ä
	file,ե̾															*/
void file_set_history(const gchar *file)
{
	gchar *label;
	gint i,count;
	GList *glist;
	GtkWidget *menu_shell,*menu_item;

	menu_shell = gtk_item_factory_get_widget (item_factory_menu,
																"<main>/File");
	glist = gtk_container_children (GTK_CONTAINER (menu_shell));
	count=g_list_length(glist);
	for (i=0;i<count-MENUFILE-1;i++) {
		menu_item=g_list_nth_data(glist,i+MENUFILE-1);
		label = g_object_get_data (G_OBJECT (menu_item), "user_data");
		if (g_strcmp(label,file)==0) {
			gtk_container_remove (GTK_CONTAINER (menu_shell), menu_item);
			break;
		}
	}
	g_list_free(glist);
	if (i>=history) {
		glist = gtk_container_children (GTK_CONTAINER (menu_shell));
		gtk_container_remove (GTK_CONTAINER (menu_shell),
						g_list_nth_data (glist, MENUFILE + history + 1 - 3));
		g_list_free(glist);
	}
	if (count<=MENUFILE) {
		menu_item=gtk_menu_item_new();
		gtk_menu_insert (GTK_MENU (menu_shell), menu_item, MENUFILE - 2);
		gtk_widget_show(menu_item);
	}
	label=g_strdup(file);
	menu_item=gtk_menu_item_new_with_label(label);
	g_signal_connect (G_OBJECT (menu_item), "activate",
							G_CALLBACK (signal_activate_menu_history), label);
	g_signal_connect (G_OBJECT (menu_item), "destroy",
							G_CALLBACK (signal_destroy_menu_history), label);
	g_object_set_data (G_OBJECT (menu_item), "user_data", label);
	gtk_menu_insert (GTK_MENU (menu_shell), menu_item, MENUFILE - 1);
	gtk_widget_show(menu_item);
}


/*	եä
	file,ä褦ȤեΥեѥ
	same,եѥ°
	 RET,ä褦ȤեΥ٥										*/
gchar *file_add_edit(const gchar *file,gint *same)
{
	gchar *label;
	const gchar *name0,*name1;
	gint i;
	GList *glist;
	GtkWidget *child;
	TmaidWindow *tmaid;

	*same=-1;
	/* ե̾Ĵ٤ */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	/* Ʊ̾ƱѥĴ٤ */
	for (i=g_list_length(glist)-1;i>=0;i--) {
		child=g_list_nth_data(glist,i);
		tmaid = g_object_get_data (G_OBJECT (child), "user_data");
		if (g_strcmp(file,tmaid->file)==0) {
			if (tmaid->same<0) {
				tmaid->same=0;
				label=g_strdup_printf("%s:%d",tmaid->file,tmaid->same);
				gtk_label_set_text(GTK_LABEL(tmaid->label),label);
				g_free(label);
			}
			if (*same<=tmaid->same)
				*same=tmaid->same+1;
		}
	}
	if (*same>=0) {
		/* Ʊ̾ƱѥȤ */
		label=g_strdup_printf("%s:%d",file,*same);
	} else {
		/* Ʊ̾ƱѥϤʤȤ */
		/* Ʊ̾ۥѥĴ٤ */
		name0=g_basename(file);
		for (i=g_list_length(glist)-1;i>=0;i--) {
			child=g_list_nth_data(glist,i);
			tmaid = g_object_get_data (G_OBJECT (child), "user_data");
			name1=g_basename(tmaid->file);
			if (g_strcmp(name0,name1)==0) {
				if (tmaid->same<0)
					gtk_label_set_text(GTK_LABEL(tmaid->label),tmaid->file);
				break;
			}
		}
		label=g_strdup(i>=0?file:name0);
	}
	g_list_free(glist);
	return label;
}


/*	ե
	file,褦ȤեΥեѥ									*/
void file_delete_edit(const gchar *file)
{
	const gchar *name0,*name1;
	gint i,count=0;
	GList *glist;
	TmaidWindow *tmaid;
	GtkWidget *child;

	/* ե̾Ĵ٤ */
	glist=gtk_container_children(GTK_CONTAINER(notebook));
	/* Ʊ̾ۥѥĴ٤ */
	name0=g_basename(file);
	for (i=g_list_length(glist)-1;i>=0;i--) {
		tmaid = g_object_get_data (g_list_nth_data (glist, i), "user_data");
		name1=g_basename(tmaid->file);
		if (g_strcmp(name0,name1)==0)
			count++;
	}
	if (count<=2) {
		/* Ʊ̾ۥѥΥե̾ɽѹ */
		for (i=g_list_length(glist)-1;i>=0;i--) {
			child=g_list_nth_data(glist,i);
			tmaid = g_object_get_data (G_OBJECT (child), "user_data");
			name1=g_basename(tmaid->file);
			if (g_strcmp(name0,name1)==0)
				gtk_label_set_text(GTK_LABEL(tmaid->label),name1);
		}
	} else {
		/* Ʊ̾ƱѥĴ٤ */
		count=0;
		for (i=g_list_length(glist)-1;i>=0;i--) {
			tmaid = g_object_get_data (g_list_nth_data (glist, i),
																"user_data");
			if (g_strcmp(file,tmaid->file)==0)
				count++;
		}
		if (count<=2)/* Ʊ̾ƱѥΥեեѥɽѹ */
			for (i=g_list_length(glist)-1;i>=0;i--) {
				child=g_list_nth_data(glist,i);
				tmaid = g_object_get_data (G_OBJECT (child), "user_data");
				if (g_strcmp(file,tmaid->file)==0) {
					tmaid->same=-1;
					gtk_label_set_text(GTK_LABEL(tmaid->label),tmaid->file);
				}
			}
	}
}


/******************************************************************************
*                                                                             *
* եϴؿ                                                          *
*                                                                             *
******************************************************************************/
/*	TXTե򳫤
	tmaid,TXTɥ													*/
void file_open_text(TmaidWindow *tmaid)
{
	gchar buf[16384], **charset, *ptr, *tmp, *inbuf = NULL, *outbuf = NULL;
	gssize bytes_read_prev, bytes_read, bytes_written, leng, length = 0;
	gint i, j, crlf[3];
	gunichar c;
	FILE *fp;
	LineBuffer *p, *q;
	GError *error = NULL;
	GtkWidget *dialog;

	charset = g_strsplit (tmaid->ft.charset, ",", G_MAXINT);
	g_free (tmaid->ft.charset);
	p = g_malloc0 (sizeof (LineBuffer));
	tmaid->max = 1;
	tmaid->off = 0;
	tmaid->start = p;
	/* ܥå */
	userbreak = TRUE;
	dialog = abort_dialog (_("Reading"));
	gtk_grab_add (dialog);
	/* ɤ߹ */
	fp = fopen (tmaid->file, "rt");
	if (fp != NULL)
	  {
		while (userbreak
						&& (leng = fread (buf, sizeof (gchar), 16384, fp)) > 0)
		  {
			while (gtk_events_pending ())
				gtk_main_iteration ();
			inbuf = g_realloc (inbuf, length + leng);
			g_memmove (inbuf + length, buf, leng);
			length += leng;
		  }
		fclose (fp);
	  }
	if (inbuf == NULL)
	  {
		/* λ */
		gtk_grab_remove (dialog);
	    gtk_widget_destroy (dialog);
		tmaid->ft.crlf = 2;
		tmaid->ft.charset = g_strdup (charset[0]);
		g_strfreev (charset);
		return;
	  }
	/* 饯åѴ */
	for (i = 0; userbreak && charset[i] != NULL; i++)
	  {
		while (gtk_events_pending ())
			gtk_main_iteration ();
		outbuf = g_convert (inbuf, length, "UTF-8", charset[i],
												NULL, &bytes_written, &error);
		if (error != NULL && g_error_matches (error, G_CONVERT_ERROR,
												G_CONVERT_ERROR_NO_CONVERSION))
		  {
			/* 饯åȤ̵ */
			tmp = g_strdup_printf (_("Conversion from character encoding"
							" '%s' to 'UTF-8' is not supported"), charset[i]);
			misc_message_box ("Text maid", tmp, 0, _("OK"), NULL);
			g_free (tmp);
			for (j = 0; j < ftnum; j++)
			  {
				tmp = charlist_remove (ftype[j].charset, charset[i]);
				g_free (ftype[j].charset);
				ftype[j].charset = tmp != NULL ? tmp : g_strdup ("UTF-8");
			  }
		  }
		g_clear_error (&error);
		if (outbuf != NULL)
			break;
	  }
	/* 饯åѴ򶯹Ԥ */
	if (outbuf == NULL)
		for (i = 0; userbreak && outbuf == NULL && charset[i] != NULL; i++)
		  {
			bytes_read_prev = -1;
			while ((g_clear_error (&error),
				(outbuf = g_convert (inbuf, length, "UTF-8", charset[i],
								&bytes_read, &bytes_written, &error)) == NULL)
							&& bytes_read_prev != bytes_read && error != NULL
							&& g_error_matches (error, G_CONVERT_ERROR,
											G_CONVERT_ERROR_ILLEGAL_SEQUENCE))
			  {
				while (gtk_events_pending ())
					gtk_main_iteration ();
				inbuf[bytes_read] = '?';
				bytes_read_prev = bytes_read;
			  }
			g_clear_error (&error);
			if (outbuf != NULL)
				break;
		  }
	/* ѴǤʤUTF-8Ȥ */
	if (outbuf == NULL)
	  {
		outbuf = inbuf;
		leng = length;
		while (userbreak && leng > 0
					&& !g_utf8_validate (inbuf, leng, (const gchar **)&ptr))
		  {
			while (gtk_events_pending ())
				gtk_main_iteration ();
			*ptr = '?';
			leng -= ptr - inbuf;
			inbuf = ptr;
		  }
		tmaid->ft.charset = g_strdup ("UTF-8");
	  }
	else
	  {
		g_free (inbuf);
		length = bytes_written;
		tmaid->ft.charset = g_strdup (charset[i]);
	  }
	g_strfreev (charset);
	/* ԥȽ */
	if (tmaid->ft.crlf >= 3)
	  {
		crlf[0] = crlf[1] = crlf[2] = 0;
		i = 0;
		while (userbreak && i < length)
			if (i <= length - 2 && outbuf[i] == '\r' && outbuf[i + 1] == '\n')
			  {
				i += 2;
				crlf[0]++;
			  }
			else 
			  {
				if (outbuf[i] == '\r')
					crlf[1]++;
				else if (outbuf[i] == '\n')
					crlf[2]++;
				i++;
			  }
		if (crlf[2] >= crlf[0] && crlf[2] >= crlf[1])
			tmaid->ft.crlf = 2;
		else if (crlf[0] >= crlf[1])
			tmaid->ft.crlf = 0;
		else
			tmaid->ft.crlf = 1;
	  }
	/* 饤ХåեѴ */
	for (i = 0; userbreak && i < length; i = j)
	  {
		while (gtk_events_pending ())
			gtk_main_iteration ();
		switch (tmaid->ft.crlf)
		  {
			case 0:
				for (j = i; j < length; j++)
					if (j <= length - 2
								&& outbuf[j] == '\r' && outbuf[j + 1] == '\n')
						break;
				break;
			case 1:
				for (j = i; j < length; j++)
					if (outbuf[j] == '\r')
						break;
				break;
			default:
				for (j = i; j < length; j++)
					if (outbuf[j] == '\n')
						break;
		  }
		p->length = j - i;
		p->text = g_malloc (p->length * sizeof (gchar));
		g_memmove (p->text, outbuf + i, p->length);
		if (j < length)
		  {
			j += tmaid->ft.crlf == 0 ? 2 : 1;
			q = g_malloc0 (sizeof (LineBuffer));
			q->prev = p;
			q->next = p->next;
			p->next = q;
			p = q;
			tmaid->max++;
		  }
		i = j;
	  }
	g_free (outbuf);
	/* Ѵ */
	if (tmaid->ft.html)
		for (p = tmaid->start; p != NULL; p = p->next)
		  {
			while (gtk_events_pending ())
				gtk_main_iteration ();
			i = 0;
			while (i <= p->length - 4)
				if (p->text[i++] == '&' && p->text[i++] == '#')
				  {
					c = 0;
					if (g_ascii_tolower (p->text[i]) == 'x')
					  {
						/* 16ʿ */
						for (j = i + 1; j < p->length; j++)
							if (g_ascii_isxdigit (p->text[j]))
								c = c * 16 + g_ascii_xdigit_value (p->text[j]);
							else
								break;
					  }
					else
					  {
						/* 10ʿ */
						for (j = i; j < p->length; j++)
							if (g_ascii_isdigit (p->text[j]))
								c = c * 10 + g_ascii_digit_value (p->text[j]);
							else
								break;
					  }
					if (i < j && j < p->length && p->text[j++] == ';')
					  {
						i -= 2;
						leng = g_unichar_to_utf8 (c, buf);
						if (leng > j - i)
							p->text = g_realloc (p->text,
												p->length + leng - (j - i));
						g_memmove (p->text + i + leng, p->text + j,
																p->length - j);
						g_memmove (p->text + i, buf, leng);
						p->length = p->length + leng - (j - i);
						i += leng;
					  }
				  }
		  }
	else if (tmaid->ft.esc)
		for (p = tmaid->start; p != NULL; p = p->next)
		  {
			while (gtk_events_pending ())
				gtk_main_iteration ();
			i = 0;
			while (i <= p->length - 6)
				if (p->text[i++] == '\\' && p->text[i++] == 'u')
				  {
					c = 0;
					for (j = i; j < p->length; j++)
						if (g_ascii_isxdigit (p->text[j]))
							c = c * 16 + g_ascii_xdigit_value (p->text[j]);
						else
							break;
					if (i + 3 == j)
					  {
						i -= 2;
						leng = g_unichar_to_utf8 (c, buf);
						if (leng > j - i)
							p->text = g_realloc (p->text,
												p->length + leng - (j - i));
						g_memmove (p->text + i + leng, p->text + j,
																p->length - j);
						g_memmove (p->text + i, buf, leng);
						p->length = p->length + leng - (j - i);
						i += leng;
					  }
				  }
		  }
	/* λ */
	gtk_grab_remove(dialog);
    gtk_widget_destroy(dialog);
}


/*	ե򳫤
	file,ե̾
	 RET,TXTɥ													*/
TmaidWindow *file_open_edit(const gchar *file)
{
	gchar *ext, *p, *text, **charset;
	gint i,leng0,leng1;
	TmaidWindow *tmaid;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkWidget *preedit, *table, *menu_shell, *button, *frame, *hbox;
	static gint fcount=0;	/* եο */
	static gchar *xpm[]={
"8 7 2 1",
" 	c None",
".	c #000000",
"..    ..",
" ..  .. ",
"  ....  ",
"   ..   ",
"  ....  ",
" ..  .. ",
"..    .."};

	tmaid = g_malloc0 (sizeof (TmaidWindow));
	tmaid->same = -1;
	tmaid->select.x = -1;
	if (file==NULL) {
		/*  */
		tmaid->file=g_strdup_printf("new%04d",fcount++%1000);
		tmaid->create=TRUE;
		property_copy (&tmaid->ft, ftype);
		if (!ftype[0].associate)
			tmaid->ft.ft_id = -1;
		tmaid->ft.crlf = MIN (ftype[0].crlf, 2);
		charset = g_strsplit (ftype[0].charset, ",", G_MAXINT);
		tmaid->ft.charset = g_strdup (charset[0]);
		g_strfreev (charset);
		/* ե뤬0ХȤΤȤ */
		tmaid->max = 1;
		tmaid->start = g_malloc0 (sizeof (LineBuffer));
	} else {
		tmaid->file=misc_get_full_path(file);
		leng0=g_strlen(tmaid->file);
		for (i=0;i<ftnum;i++) {
			if (g_strcmp(ftype[i].ext,"*")==0)
				break;
			ext=g_strdup(ftype[i].ext);
			for (p=g_strtok(ext,";");p!=NULL;p=g_strtok(NULL,";")) {
				leng1=g_strlen(p);
				if (leng0>=leng1 && g_strcmp(tmaid->file+leng0-leng1,p)==0)
					goto loop;
			}
			g_free(ext);
		}
		loop:
		if (i>=ftnum)
			i=0;
		tmaid->create=FALSE;
		property_copy (&tmaid->ft, ftype + i);
		if (!ftype[i].associate)
			tmaid->ft.ft_id = -1;
		tmaid->ft.crlf = ftype[i].crlf;
		tmaid->ft.charset = g_strdup (ftype[i].charset);
		file_open_text(tmaid);
	}

	/* ե̾Ĵ٤ */
	text=file_add_edit(tmaid->file,&tmaid->same);

	/* Input Method */
	tmaid->im_context = gtk_im_multicontext_new ();
	g_signal_connect (tmaid->im_context, "commit",
							G_CALLBACK (signal_commit), tmaid);
	g_signal_connect (tmaid->im_context, "preedit-changed",
							G_CALLBACK (signal_preedit_changed), tmaid);
	g_signal_connect (tmaid->im_context, "retrieve-surrounding",
							G_CALLBACK (signal_retrieve_surrounding), tmaid);
	g_signal_connect (tmaid->im_context, "delete-surrounding",
							G_CALLBACK (signal_delete_surrounding), tmaid);
	preedit = gtk_window_new (GTK_WINDOW_POPUP);
	tmaid->preedit = gtk_drawing_area_new ();
	g_signal_connect (G_OBJECT (tmaid->preedit), "expose-event",
									G_CALLBACK (signal_expose_preedit), tmaid);
	gtk_container_add (GTK_CONTAINER (preedit), tmaid->preedit);
	gtk_widget_show (tmaid->preedit);

	/* ɽꥢ */
	tmaid->drawing=gtk_drawing_area_new();
	g_signal_connect (G_OBJECT (tmaid->drawing), "focus-in-event",
									G_CALLBACK (signal_focus_in), tmaid);
	g_signal_connect (G_OBJECT (tmaid->drawing), "focus-out-event",
									G_CALLBACK (signal_focus_out),tmaid);
	g_signal_connect (G_OBJECT (tmaid->drawing), "realize",
									G_CALLBACK (signal_realize), tmaid);
	g_signal_connect (G_OBJECT (tmaid->drawing), "unrealize",
									G_CALLBACK (signal_unrealize), tmaid);
	g_signal_connect (G_OBJECT (tmaid->drawing), "configure-event",
									G_CALLBACK (signal_config), tmaid);
	g_signal_connect (G_OBJECT (tmaid->drawing), "expose-event",
									G_CALLBACK (signal_expose), tmaid);
	g_signal_connect (G_OBJECT (tmaid->drawing), "button-press-event",
									G_CALLBACK (signal_button_press), tmaid);
	g_signal_connect (G_OBJECT (tmaid->drawing), "motion-notify-event",
									G_CALLBACK (signal_motion_notify), tmaid);
	g_signal_connect (G_OBJECT (tmaid->drawing), "button-release-event",
									G_CALLBACK (signal_button_release), tmaid);
	g_signal_connect (G_OBJECT (tmaid->drawing), "scroll-event",
									G_CALLBACK (signal_scroll), tmaid);
	g_signal_connect_after (G_OBJECT (tmaid->drawing), "key-press-event",
									G_CALLBACK (signal_key_press), tmaid);
	g_signal_connect_after (G_OBJECT (tmaid->drawing), "key-release-event",
									G_CALLBACK (signal_key_release), tmaid);
	g_signal_connect (G_OBJECT (tmaid->drawing), "destroy",
									G_CALLBACK (signal_destroy_draw), tmaid);
	gtk_widget_add_events (tmaid->drawing, GDK_POINTER_MOTION_MASK
							| GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK
							| GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK
							| GDK_FOCUS_CHANGE_MASK);
	GTK_WIDGET_SET_FLAGS(tmaid->drawing,GTK_CAN_FOCUS);
	/* ե */
	gtk_widget_modify_font (window, tmaid->ft.font_name != NULL
					? pango_font_description_from_string (tmaid->ft.font_name)
					: pango_font_description_copy (system_font));
	tmaid->layout = gtk_widget_create_pango_layout (window, NULL);
	charset_size (tmaid->layout, &tmaid->font_width, &tmaid->font_height,
															tmaid->font_buf);
	/* ץ饤ޥꥻ쥯 */
	gtk_selection_add_targets(tmaid->drawing,GDK_SELECTION_PRIMARY,targets,
									sizeof(targets)/sizeof(GtkTargetEntry));
	g_signal_connect (G_OBJECT (tmaid->drawing), "selection-get",
									G_CALLBACK (signal_selection_get), tmaid);
	/* С */
	tmaid->hscroll=gtk_hscrollbar_new(
							GTK_ADJUSTMENT(gtk_adjustment_new(0,0,0,1,1,1)));
	tmaid->vscroll=gtk_vscrollbar_new(
							GTK_ADJUSTMENT(gtk_adjustment_new(0,0,0,1,1,1)));
	/* ơ֥ */
	table=gtk_table_new(2,2,FALSE);
	gtk_table_attach(GTK_TABLE(table),tmaid->drawing,0,1,0,1,
									GTK_EXPAND | GTK_SHRINK | GTK_FILL,
									GTK_EXPAND | GTK_SHRINK | GTK_FILL,0,0);
	gtk_table_attach(GTK_TABLE(table),tmaid->hscroll,0,1,1,2,
							GTK_EXPAND | GTK_SHRINK | GTK_FILL,GTK_FILL,0,0);
	gtk_table_attach(GTK_TABLE(table),tmaid->vscroll,1,2,0,1,
							GTK_FILL,GTK_EXPAND | GTK_SHRINK | GTK_FILL,0,0);
	g_object_set_data (G_OBJECT(table), "user_data", tmaid);
	/* ˥塼 */
	menu_shell = gtk_item_factory_get_widget (item_factory_menu,
															"<main>/Window");
	tmaid->menu_item=gtk_menu_item_new_with_label(tmaid->file);
	g_signal_connect (G_OBJECT (tmaid->menu_item), "activate",
							G_CALLBACK (signal_activate_menu_window), table);
	gtk_menu_append (GTK_MENU (menu_shell), tmaid->menu_item);
	gtk_widget_show(tmaid->menu_item);
	/* ܥ */
	button=gtk_button_new();
	frame=gtk_frame_new(NULL);
	gtk_button_set_relief(GTK_BUTTON(button),GTK_RELIEF_NONE);
	pixmap=gdk_pixmap_create_from_xpm_d(window->window,&mask,NULL,xpm);
	gtk_container_add(GTK_CONTAINER(frame),gtk_pixmap_new(pixmap,mask));
	gtk_container_add(GTK_CONTAINER(button),frame);
	g_signal_connect (G_OBJECT (button), "clicked",
										G_CALLBACK (signal_clicked), table);
	/* ٥ */
	tmaid->label=gtk_label_new(text);
	g_free(text);
	/* ޡ */
	tmaid->mark = gtk_label_new ("*");
	/* ɽ */
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),tmaid->label,TRUE,TRUE,0);
	gtk_box_pack_start (GTK_BOX (hbox), tmaid->mark, FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(hbox),button,FALSE,FALSE,0);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),table,hbox);
	gtk_widget_show (hbox);
	gtk_widget_show (tmaid->label);
	gtk_widget_show_all (button);
	gtk_widget_show_all(table);
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
						gtk_notebook_page_num(GTK_NOTEBOOK(notebook),table));
	gtk_widget_grab_focus(tmaid->drawing);

	/* ǤϤʤե뤬¸ߤˤ˲ä */
	if (file!=NULL && history>0 && misc_isfile(tmaid->file))
		file_set_history(tmaid->file);
	/* ޡ */
	if (tmaid->ft.limit)
		modify_margin (tmaid);

	return tmaid;
}


/******************************************************************************
*                                                                             *
* եϴؿ                                                          *
*                                                                             *
******************************************************************************/
/*	TXTե¸
	 file,ե̾
	tmaid,TXTɥ
	  RET,TRUE:ｪλ,FALSE:顼										*/
gboolean file_save_text(const gchar *file,TmaidWindow *tmaid)
{
	gchar *buf = NULL, crlf[2], *ptr, *text, *outbuf;
	gssize bytes_read_prev, bytes_read, bytes_written;
	gssize crlf_leng, leng, length = 0;
	FILE *fp;
	LineBuffer *p;
	GError *error = NULL;
	GtkWidget *dialog;

	p=tmaid->start;
	while (p->prev!=NULL)
		p=p->prev;
	switch (tmaid->ft.crlf)
	  {
		case  0: crlf[0] = '\r'; crlf[1] = '\n'; crlf_leng = 2; break;
		case  1: crlf[0] = '\r'; crlf_leng = 1; break;
		default: crlf[0] = '\n'; crlf_leng = 1;
	  }
	/* ܥå */
	userbreak = TRUE;
	dialog = abort_dialog (_("Writing"));
	gtk_grab_add (dialog);
	/*  */
	while (userbreak && p != NULL)
	  {
		if (!p->margin && p->next != NULL)
		  {
			leng = p->length + crlf_leng;
			p->text = realloc (p->text, leng);
			g_memmove (p->text + p->length, crlf, crlf_leng);
		  }
		else if (p->next == NULL && tmaid->ft.eof
										&& p->text[p->length - 1] != '\x1a')
		  {
			leng = p->length + 1;
			p->text = realloc (p->text, leng);
			p->text[p->length] = '\x1a';
		  }
		else
		  {
			leng = p->length;
		  }
		ptr = p->text;
		while (userbreak && leng > 0)
		  {
			while (gtk_events_pending ())
				gtk_main_iteration ();
			bytes_read_prev = leng;
			while ((g_clear_error (&error),
							(outbuf =  g_convert (ptr, bytes_read_prev,
								tmaid->ft.charset, "UTF-8",
								&bytes_read, &bytes_written, &error)) == NULL)
							&& bytes_read_prev != bytes_read && bytes_read > 0)
			  {
				;
				bytes_read_prev = bytes_read;
			  }
			if (bytes_read > 0)
			  {
				if (outbuf != NULL && bytes_written > 0)
				  {
					buf = realloc (buf, length + bytes_written);
					g_memmove (buf + length, outbuf, bytes_written);
					length += bytes_written;
				  }
				leng -= bytes_read;
				ptr += bytes_read;
			  }
			g_free (outbuf);
			if (outbuf == NULL && !g_error_matches (error, G_CONVERT_ERROR,
											G_CONVERT_ERROR_ILLEGAL_SEQUENCE)
								&& !g_error_matches (error, G_CONVERT_ERROR,
												G_CONVERT_ERROR_PARTIAL_INPUT))
			  {
				/* 饯åȤ̵ */
				g_clear_error (&error);
				gtk_grab_remove (dialog);
				gtk_widget_destroy (dialog);
				text = g_strdup_printf
					(_("Conversion from character encoding"
					" 'UTF-8' to '%s' is not supported"), tmaid->ft.charset);
				misc_message_box ("Text maid", text, 0, _("OK"), NULL);
				g_free (text);
				g_free (buf);
				return FALSE;
			  }
			if (bytes_read <= 0)
			  {
				switch (tmaid->ft.writemode)
				  {
					case 1:/* '?' */
						outbuf = g_strdup ("?");
						break;
					case 2:/* HTML(10ʿ) */
						outbuf = g_strdup_printf
											("&#%d;", g_utf8_get_char (ptr));
						break;
					case 3:/* HTML(16ʿ) */
						outbuf = g_strdup_printf (tmaid->ft.hexcase
								? "&#x%X;" : "&#x%x;", g_utf8_get_char (ptr));
						break;
					case 4:/* Escape */
						outbuf = g_strdup_printf (tmaid->ft.hexcase
							? "\\u%04X" : "\\u%04x", g_utf8_get_char (ptr));
						break;
					default:
						gtk_grab_remove (dialog);
						gtk_widget_destroy (dialog);
						misc_message_box ("Text maid",
								_("Invalid byte sequence in conversion input"),
															0, _("OK"), NULL);
						g_free (buf);
						return FALSE;
				  }
				bytes_written = g_strlen (outbuf);
				buf = realloc (buf, length + bytes_written);
				g_memmove (buf + length, outbuf, bytes_written);
				length += bytes_written;
				leng -= charset_length (*ptr);
				ptr += charset_length (*ptr);
				g_free (outbuf);
			  }
		  }
		p = p->next;
	  }
	g_clear_error (&error);
	if (userbreak)
	  {
		/*  */
		fp = fopen (file, "wt");
		if (fp == NULL)
		  {
			gtk_grab_remove (dialog);
			gtk_widget_destroy (dialog);
			misc_message_box ("Text maid", _("Can not open file"),
															0, _("OK"), NULL);
			g_free (buf);
			return FALSE;
		  }
		ptr = buf;
		while (userbreak && length > 0)
		  {
			while (gtk_events_pending ())
				gtk_main_iteration ();
			leng = MIN (length, 16384);
			if (fwrite (ptr, 1, leng, fp) != leng)
			  {
				gtk_grab_remove (dialog);
				gtk_widget_destroy (dialog);
				misc_message_box ("Text maid", _("Can not write"),
															0, _("OK"), NULL);
				fclose (fp);
				return FALSE;
			  }
			length -= leng;
			ptr += leng;
		  }
		if (fclose(fp) != 0)
		  {
			gtk_grab_remove (dialog);
			gtk_widget_destroy (dialog);
			misc_message_box ("Text maid", "fclose", 0, _("OK"), NULL);
			g_free (buf);
			return FALSE;
		  }
	  }
	g_free (buf);
	/* λ */
	gtk_grab_remove (dialog);
	gtk_widget_destroy (dialog);
	return userbreak;
}
