/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "edit.h"
#include "general.h"
#include "jump.h"
#include "sigfile.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ״ؿ                                                              *
*                                                                             *
******************************************************************************/
/*	Ԥذư
	tmaid,TXTɥ
	 line,(1...)													*/
void jump_operation(TmaidWindow *tmaid,const gint line)
{
	gint sx,sy;
	GdkPoint cursor,select,top;

	cursor=tmaid->cursor;
	select=tmaid->select;
	top=tmaid->top;
	sx=MAX(tmaid->drawing->allocation.width/tmaid->font_width,1);
	sy=MAX(tmaid->drawing->allocation.height/tmaid->font_height,1);
	tmaid->cursor.y=line<0?tmaid->max+line:line-1;
	if (tmaid->cursor.y<0)
		tmaid->cursor.y=0;
	else if (tmaid->cursor.y>tmaid->max-1)
		tmaid->cursor.y=tmaid->max-1;
	if (tmaid->cursor.x<tmaid->top.x)
		tmaid->top.x=tmaid->cursor.x;
	else if (tmaid->cursor.x-sx+1>tmaid->top.x)
		tmaid->top.x=tmaid->cursor.x-sx+1;
	if (tmaid->cursor.y<tmaid->top.y)
		tmaid->top.y=tmaid->cursor.y;
	else if (tmaid->cursor.y-sy+1>tmaid->top.y)
		tmaid->top.y=tmaid->cursor.y-sy+1;
	move_edit_window(tmaid,&top);
	misc_set_scroll_bar (tmaid->hscroll,
						G_CALLBACK (signal_value_changed_hscroll), tmaid,
						0, edit_get_width_max (tmaid) + 1, sx, tmaid->top.x);
	misc_set_scroll_bar (tmaid->vscroll,
						G_CALLBACK (signal_value_changed_vscroll), tmaid,
						0, tmaid->max, sy, tmaid->top.y);
	if (tmaid->select.x>=0) {
		if (tmaid->select.y==tmaid->cursor.y
								&& tmaid->select.x==edit_get_align_pos(tmaid,
									tmaid->cursor.x,tmaid->cursor.y,FALSE)) {
			tmaid->select.x=-1;
			clear_sel(tmaid,&select,&cursor);
			set_menu_bar(tmaid);
		} else {
			clear_sel(tmaid,&tmaid->cursor,&cursor);
		}
	}
	draw_caret(tmaid,&cursor);
}


/******************************************************************************
*                                                                             *
* ץؿ                                                    *
*                                                                             *
******************************************************************************/
static gboolean jump_clicked_ok;
static GtkWidget *dialog,*button0,*entry;


/* OKܥ󤬲줿 */
static void jump_dialog_clicked(GtkWidget *widget,JumpDialog *jmp)
{
	misc_str_to_val(&jmp->cursor,
								gtk_entry_get_text(GTK_ENTRY(entry)),10,FALSE);
	gtk_widget_destroy(dialog);
	jump_clicked_ok=TRUE;
}


/* ȥ꡼ǥ꥿󤬲줿 */
static void jump_dialog_activate(GtkWidget *widget,JumpDialog *jmp)
{
	gint value;

	if (misc_str_to_val(&value,gtk_entry_get_text(GTK_ENTRY(widget)),10,FALSE)
												&& 1<=value && value<=jmp->max)
		jump_dialog_clicked(widget,jmp);
}


/* ȥ꡼ѹ줿 */
static void jump_dialog_changed(GtkWidget *widget,JumpDialog *jmp)
{
	gint value;

	gtk_widget_set_sensitive(button0,misc_str_to_val(&value,
								gtk_entry_get_text(GTK_ENTRY(widget)),10,FALSE)
											&& 1<=value && value<=jmp->max);
}


/* ESC줿 */
static gboolean jump_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean jump_dialog(JumpDialog *jmp)
{
	gchar *text;
	GtkWidget *button1,*hbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Jump"));
	g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
									G_CALLBACK (jump_dialog_key_press), NULL);
	g_signal_connect (G_OBJECT (dialog), "destroy", 
											G_CALLBACK (gtk_main_quit), NULL);
	/* ܥ */
	button0=gtk_button_new_with_label(_("OK"));
	button1=gtk_button_new_with_label(_("Cancel"));
	g_signal_connect (G_OBJECT (button0), "clicked",
										G_CALLBACK (jump_dialog_clicked), jmp);
	g_signal_connect_swapped (G_OBJECT (button1), "clicked",
						G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* ȥ꡼ */
	entry=gtk_entry_new();
	text=misc_str_from_val(jmp->cursor,10,0,FALSE);
	gtk_entry_set_text(GTK_ENTRY(entry),text);
	g_free(text);
	g_signal_connect (G_OBJECT (entry), "activate",
									G_CALLBACK (jump_dialog_activate), jmp);
	g_signal_connect (G_OBJECT (entry), "changed",
									G_CALLBACK (jump_dialog_changed), jmp);
	gtk_editable_select_region(GTK_EDITABLE(entry),0,-1);
	/* ե졼ȥܥå */
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),entry,TRUE,TRUE,0);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_grab_focus(entry);
	jump_clicked_ok=FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return 	jump_clicked_ok;
}
