/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "find.h"
#include "replace.h"


gboolean replace_arrow=TRUE;				/* ִ */
gboolean replace_ignorecase=FALSE;			/* ִ */
gchar *replace_text[32];					/* ִʸ */
gint replace_num=0;							/* ϿƤִʸ */


/******************************************************************************
*                                                                             *
* ִ                                                            *
*                                                                             *
******************************************************************************/
static gint replace_clicked_button;
static GtkWidget *dialog,*check,*combo0,*combo1,*radio1,*button0,*button1;


/* ִܥ󤬲줿 */
static void replace_dialog_clicked_ok(GtkWidget *widget,ReplaceString *rp)
{
	rp->src=g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo0)->entry)));
	rp->dst=g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)));
	rp->ignorecase=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check));
	rp->arrow=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio1));
	gtk_widget_destroy(dialog);
	replace_clicked_button=REPLACE_OK;
}


/* ٤ִܥ󤬲줿 */
static void replace_dialog_clicked_all(GtkWidget *widget,ReplaceString *rp)
{
	rp->src=g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo0)->entry)));
	rp->dst=g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)));
	rp->ignorecase=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check));
	rp->arrow=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio1));
	gtk_widget_destroy(dialog);
	replace_clicked_button=REPLACE_ALL;
}


/* ȥ꡼ǥ꥿󤬲줿 */
static void replace_dialog_activate(GtkWidget *widget,ReplaceString *rp)
{
	if (g_strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo0)->entry)))>0)
		replace_dialog_clicked_ok(widget,rp);
}


/* ȥ꡼ѹ줿 */
static void replace_dialog_changed(GtkWidget *widget,gpointer user_data)
{
	gtk_widget_set_sensitive(button0,
							g_strlen(gtk_entry_get_text(GTK_ENTRY(widget)))>0);
	gtk_widget_set_sensitive(button1,
							g_strlen(gtk_entry_get_text(GTK_ENTRY(widget)))>0);
}


/* ESC줿 */
static gboolean replace_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gint replace_dialog(ReplaceString *rp)
{
	gint i;
	guint key;
	GList *glist=NULL;
	GtkAccelGroup *accel;
	GtkWidget *radio0,*button2;
	GtkWidget *frame0,*frame1,*hbox,*tbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Replace"));
	g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
								G_CALLBACK (replace_dialog_key_press), NULL);
	g_signal_connect (G_OBJECT (dialog), "destroy",
											G_CALLBACK (gtk_main_quit), NULL);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_window_add_accel_group (GTK_WINDOW (dialog), accel);
	/* ܥ */
	button0 = gtk_button_new_with_label ("");
	button1 = gtk_button_new_with_label ("");
	button2=gtk_button_new_with_label(_("Cancel"));
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button0)->child),
																_("_Replace"));
	gtk_widget_add_accelerator(button0,"clicked",accel,key,GDK_MOD1_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(button1)->child),_("_All"));
	gtk_widget_add_accelerator(button1,"clicked",accel,key,GDK_MOD1_MASK,0);
	g_signal_connect (G_OBJECT (button0), "clicked",
								G_CALLBACK (replace_dialog_clicked_ok), rp);
	g_signal_connect (G_OBJECT (button1), "clicked",
								G_CALLBACK (replace_dialog_clicked_all), rp);
	g_signal_connect_swapped (G_OBJECT (button2), "clicked",
						G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button2,GTK_CAN_DEFAULT);
	/* åܥ */
	check = gtk_check_button_new_with_label ("");
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(check)->child),
															_("Enable _Case"));
	gtk_widget_add_accelerator(check,"clicked",accel,key,GDK_MOD1_MASK,0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),rp->ignorecase);
	/* ܥܥå */
	for (i=0;i<find_num;i++)
		glist=g_list_append(glist,find_text[i]);
	combo0=gtk_combo_new();
	gtk_combo_set_value_in_list (GTK_COMBO (combo0), FALSE, TRUE);
	if (find_num>0) {
		gtk_combo_set_popdown_strings(GTK_COMBO(combo0),glist);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo0)->entry),find_text[0]);
		gtk_editable_select_region(GTK_EDITABLE(GTK_COMBO(combo0)->entry),
																		0,-1);
	}
	g_signal_connect (G_OBJECT (GTK_COMBO (combo0)->entry), "activate",
									G_CALLBACK (replace_dialog_activate), rp);
	g_signal_connect (G_OBJECT (GTK_COMBO(combo0)->entry), "changed",
									G_CALLBACK (replace_dialog_changed), NULL);
	glist=NULL;
	for (i=0;i<replace_num;i++)
		glist=g_list_append(glist,replace_text[i]);
	combo1=gtk_combo_new();
	gtk_combo_set_value_in_list (GTK_COMBO (combo1), FALSE, TRUE);
	if (replace_num>0) {
		gtk_combo_set_popdown_strings(GTK_COMBO(combo1),glist);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry),
															replace_text[0]);
	}
	g_signal_connect (G_OBJECT (GTK_COMBO (combo1)->entry), "activate",
									G_CALLBACK (replace_dialog_activate), rp);
	/* 饸ܥ */
	radio0 = gtk_radio_button_new_with_label (NULL, "");
	radio1 = gtk_radio_button_new_with_label_from_widget (
												GTK_RADIO_BUTTON (radio0), "");
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio0)->child),_("_Up"));
	gtk_widget_add_accelerator(radio0,"clicked",accel,key,GDK_MOD1_MASK,0);
	key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio1)->child),_("_Down"));
	gtk_widget_add_accelerator(radio1,"clicked",accel,key,GDK_MOD1_MASK,0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rp->arrow?radio1:radio0),
																		TRUE);
	/* ե졼ȥܥå */
	tbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(tbox),8);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),
								gtk_label_new(_("Find String")),FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),combo0,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,0);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),
							gtk_label_new(_("Replace String")),FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),combo1,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,FALSE,FALSE,0);

	frame0=gtk_frame_new(_("Option"));
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),check,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(frame0),vbox);

	frame1=gtk_frame_new(_("Direction"));
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);
	gtk_box_pack_start(GTK_BOX(vbox),radio0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),radio1,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(frame1),vbox);

	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_start(GTK_BOX(hbox),frame0,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(hbox),frame1,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(tbox),hbox,TRUE,TRUE,8);
	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button2,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(tbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),tbox);

	/* ɽ */
	gtk_widget_set_sensitive(button0,
		g_strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo0)->entry)))>0);
	gtk_widget_set_sensitive(button1,
		g_strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo0)->entry)))>0);
	gtk_widget_grab_focus(GTK_COMBO(combo0)->entry);
	replace_clicked_button=REPLACE_CANCEL;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return replace_clicked_button;
}
