/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "charset.h"


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
gsize charset_leng[256] = {
		/*  0 1 2 3 4 5 6 7 8 9 A B C D E F 0 1 2 3 4 5 6 7 8 9 A B C D E F */
	/* 0 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 2 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 4 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 6 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* 8 */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* A */	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	/* C */	2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	/* E */	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,6,6,1,1};
guchar charset_space[] = {3, 0xE3, 0x80, 0x80, 0};


/*	եȤȹ⤵
	  layout,쥤
	   width,
	  height,⤵
	font_buf,Хåե														*/
void
charset_size (PangoLayout *layout, gint *width, gint *height, guint8 *font_buf)
{
	int w, h;
	gint i;

	if (width != NULL)
		*width = 1;
	if (height != NULL)
		*height = 1;
	if (font_buf != NULL)
		g_memset (font_buf, 0, sizeof(guint8) * 65536);
	for (i = 0; i < 128; i++)
		if (charset_length (i) == 1 && g_unichar_isprint ((gunichar)i))
		  {
			pango_layout_set_text (layout, (const char *)&i, 1);
			pango_layout_get_pixel_size (layout, &w, &h);
			if (width != NULL && *width < w)
				*width = w;
			if (height != NULL && *height < h)
				*height = h;
		  }
}


/*	ɽȾñ̤ʸ
	  layout,쥤
	    text,ʸ
	   width,
	font_buf,Хåե
	     RET,Ⱦñ														*/
gint
charset_width (PangoLayout *layout, const gchar *text,
											const gint width, guint8 *font_buf)
{
	int w;
	gint result;
	gsize length;
	gunichar c;

	length = charset_length (*text);
	c = g_utf8_get_char_validated (text, length);
	if (!g_unichar_validate (c))
		return 1;
	if ((guint32)c < 65536)
	  {
		if (length <= 1)
			font_buf[c] = 1;
		if (font_buf[c] != 0)
			return font_buf[c];
	  }
	pango_layout_set_text (layout, text, length);
	pango_layout_get_pixel_size (layout, &w, NULL);
	result = MAX ((w + width - 1) / width, 1);
	if ((guint32)c < 65536)
		font_buf[c] = result;
	return result;
}


/*	ʸμ֤
	text,ʸ
	 RET,ʸμ															*/
guint
charset_type (const gchar *text)
{
	gint i;
	gunichar c;
	guint iso646[256] = {
		/*  0 4 8 C         1 5 9 D         2 6 A E         3 7 B F */
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 0 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 1 */	CS_CONTROL,		CS_CONTROL,		CS_CONTROL,		CS_CONTROL,
	/* 2 */	CS_SPACE,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 2 */	CS_PUNCT,		CS_SYMBOL,		CS_PUNCT,		CS_SYMBOL,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_DIGIT,		CS_DIGIT,		CS_DIGIT,
	/* 3 */	CS_DIGIT,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 3 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 4 */	CS_SYMBOL,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 4 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 4 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 4 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 5 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 5 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 5 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_SYMBOL,
	/* 5 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 6 */	CS_ACCENT,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 6 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 6 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 6 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 7 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 7 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* 7 */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_SYMBOL,
	/* 7 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_CONTROL,
	/* 8 */	CS_SYMBOL,		0,				CS_SYMBOL,		CS_LATIN,
	/* 8 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 8 */	CS_ACCENT,		CS_SYMBOL,		CS_LATIN,		CS_SYMBOL,
	/* 8 */	CS_LATIN,		0,				CS_LATIN,		0,
	/* 9 */	0,				CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 9 */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* 9 */	CS_SYMBOL,		CS_SYMBOL,		CS_LATIN,		CS_SYMBOL,
	/* 9 */	CS_LATIN,		0,				CS_LATIN,		CS_LATIN,
	/* A */	CS_SPACE,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* A */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* A */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* A */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* B */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* B */	CS_ACCENT,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* B */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* B */	CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,		CS_SYMBOL,
	/* C */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* C */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* C */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* C */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* D */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* D */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_SYMBOL,
	/* D */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* D */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* E */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* E */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* E */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* E */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* F */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* F */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_SYMBOL,
	/* F */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN,
	/* F */	CS_LATIN,		CS_LATIN,		CS_LATIN,		CS_LATIN};
	struct {
		gunichar min,max;
		guint type;
	} type_range[] = {
		{0x0100, 0x036f, CS_LATIN},
		{0x0370, 0x03ff, CS_GREEK},
		{0x0400, 0x04ff, CS_CYRILLIC},
		{0x0530, 0x058f, CS_ARMENIAN},
		{0x0590, 0x05ff, CS_HEBREW},
		{0x0600, 0x06ff, CS_ARABIC},
		{0x0700, 0x074f, CS_SYRIAC},
		{0x0780, 0x07bf, CS_THAANA},
		{0x0900, 0x097f, CS_DEVANAGARI},
		{0x0980, 0x09ff, CS_BENGALI},
		{0x0a00, 0x0a7f, CS_GURMUKHI},
		{0x0a80, 0x0aff, CS_GUJARATI},
		{0x0b00, 0x0b7f, CS_ORIYA},
		{0x0b80, 0x0bff, CS_TAMIL},
		{0x0c00, 0x0c7f, CS_TELUGU},
		{0x0c80, 0x0cff, CS_KANNADA},
		{0x0d00, 0x0d7f, CS_MALAYALAM},
		{0x0d80, 0x0dff, CS_SINHALA},
		{0x0e00, 0x0e7f, CS_THAI},
		{0x0e80, 0x0eff, CS_LAO},
		{0x0f00, 0x0fff, CS_TIBETAN},
		{0x1000, 0x109f, CS_MYANMAR},
		{0x10a0, 0x10ff, CS_GEORGIAN},
		{0x1100, 0x11ff, CS_HANGUL},
		{0x1200, 0x137f, CS_ETHIOPIC},
		{0x13a0, 0x13ff, CS_CHEROKEE},
		{0x1400, 0x167f, CS_UCAS},
		{0x1680, 0x169f, CS_OGHAM},
		{0x16a0, 0x16ff, CS_RUNIC},
		{0x1780, 0x17ff, CS_KHMER},
		{0x1800, 0x18af, CS_MONGOLIAN},
		{0x1e00, 0x1eff, CS_LATIN},
		{0x1f00, 0x1fff, CS_GREEK},
		{0x2000, 0x206f, CS_PUNCT},
		{0x2070, 0x267f, CS_SYMBOL},
		{0x2700, 0x27bf, CS_SYMBOL},
		{0x2800, 0x28ff, CS_SYMBOL},
		{0x2e80, 0x2fff, CS_CJK},
		{0x3000, 0x3000, CS_SPACE},
		{0x3001, 0x3002, CS_PUNCT},
		{0x3003, 0x303f, CS_SYMBOL},
		{0x3041, 0x3094, CS_HIRAGANA},
		{0x3099, 0x309c, CS_ACCENT},
		{0x309d, 0x309e, CS_HIRAGANA},
		{0x30a1, 0x30fa, CS_KATAKANA},
		{0x30fb, 0x30fb, CS_PUNCT},
		{0x30fc, 0x30fc, CS_ACCENT},
		{0x30fd, 0x30fe, CS_KATAKANA},
		{0x3100, 0x312f, CS_CJK},
		{0x3130, 0x318f, CS_HANGUL},
		{0x3190, 0x319f, CS_ACCENT},
		{0x31a0, 0x31bf, CS_CJK},
		{0x3200, 0x33ff, CS_SYMBOL},
		{0x3400, 0x9fff, CS_CJK},
		{0xa000, 0xa4cf, CS_YI},
		{0xac00, 0xd7af, CS_HANGUL},
		{0xf900, 0xfa5f, CS_CJK},
		{0xfb00, 0xfb4f, CS_LATIN},
		{0xfb50, 0xfdff, CS_ARABIC},
		{0xfe20, 0xfe2f, CS_ACCENT},
		{0xfe30, 0xfe6f, CS_SYMBOL},
		{0xfe70, 0xfeff, CS_ARABIC},
		{0xff01, 0xff0f, CS_SYMBOL},
		{0xfd61, 0xff65, CS_PUNCT},
		{0xff61, 0xff61, CS_PUNCT},
		{0xff62, 0xff63, CS_SYMBOL},
		{0xff64, 0xff65, CS_PUNCT},
		{0xff66, 0xff6f, CS_KATAKANA},
		{0xff70, 0xff70, CS_ACCENT},
		{0xff71, 0xff9d, CS_KATAKANA},
		{0xff9e, 0xff9f, CS_ACCENT},
		{0xffa0, 0xffa0, CS_SPACE},
		{0xffa1, 0xffdc, CS_HANGUL},
		{0xffe0, 0xffef, CS_SYMBOL},
		{0x0000, 0x0000, 0}};

	c = g_utf8_get_char (text);
	if (c < 256)
		return iso646[c];
	if (0xff01 <= c && c <= 0xff5e)
		return iso646[c - 0xff00 + 0x20];
	for (i = 0; type_range[i].type != 0; i++)
		if (type_range[i].min <= c && c <= type_range[i].max)
			return type_range[i].type;
	return 0;
}
