/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __CHARSET_H__
#define __CHARSET_H__


#include "tmaid.h"


#define charset_length(ch) (charset_leng[(gint)(guchar)(ch)])
#define CS_CONTROL		 1
#define CS_SPACE		 2
#define CS_PUNCT		 3
#define CS_SYMBOL		 4
#define CS_ACCENT		 5
#define CS_DIGIT		 6
#define CS_LATIN		 7
#define CS_GREEK		 8
#define CS_CYRILLIC		 9
#define CS_ARMENIAN		10
#define CS_HEBREW		11
#define CS_ARABIC		12
#define CS_SYRIAC		13
#define CS_THAANA		14
#define CS_DEVANAGARI	15
#define CS_BENGALI		16
#define CS_GURMUKHI		17
#define CS_GUJARATI		18
#define CS_ORIYA		19
#define CS_TAMIL		20
#define CS_TELUGU		21
#define CS_KANNADA		22
#define CS_MALAYALAM	23
#define CS_SINHALA		24
#define CS_THAI			25
#define CS_LAO			26
#define CS_TIBETAN		27
#define CS_MYANMAR		28
#define CS_GEORGIAN		29
#define CS_HANGUL		30
#define CS_ETHIOPIC		31
#define CS_CHEROKEE		32
#define CS_UCAS			33
#define CS_OGHAM		34
#define CS_RUNIC		35
#define CS_KHMER		36
#define CS_MONGOLIAN	37
#define CS_CJK			38
#define CS_HIRAGANA		39
#define CS_KATAKANA		40
#define CS_YI			41


extern gsize charset_leng[];
extern guchar charset_space[];


/*	եȤȹ⤵
	  layout,쥤
	   width,
	  height,⤵
	font_buf,Хåե														*/
void
charset_size (PangoLayout *layout, gint *width, gint *height,
															guint8 *font_buf);


/*	ɽȾñ̤ʸ
	  layout,쥤
	    text,ʸ
	   width,
	font_buf,Хåե
	     RET,Ⱦñ														*/
gint
charset_width (PangoLayout *layout, const gchar *text,
										const gint width, guint8 *font_buf);


/*	ʸμ֤
	text,ʸ
	 RET,ʸμ															*/
guint
charset_type (const gchar *text);


#endif
