/*
    Text maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __EDIT_H__
#define __EDIT_H__


#include "tmaid.h"


/*	饤Хåե
	start,饤Хåե
	  off,ߤyɸ
	    y,yɸ
	  RET,饤Хåե													*/
LineBuffer *edit_get_line_buf(LineBuffer **start,gint *off,const gint y);


/*	
	ptw,TXTɥ
	  y,
	RET,																*/
gint edit_get_width(TmaidWindow *tmaid,const gint y);


/*	
	ptw,TXTɥ
	RET,																*/
gint edit_get_width_max(TmaidWindow *tmaid);


/*	åȤΥ饤Ȥ줿xɸ
	  ptw,TXTɥ
	    x,xɸ
	    y,yɸ
	align,TRUE:˴󤻤,FALSE:˴󤻤
	  RET,ɸ																*/
gint edit_get_align_pos(TmaidWindow *tmaid,const gint x,const gint y,
														const gboolean align);


/*	̾κɸ饤ХåեΥɥ쥹
	  ptw,TXTɥ
	    x,xɸ
	    y,yɸ
	align,TRUE:˴󤻤,FALSE:˴󤻤
	  RET,ɥ쥹															*/
gint edit_get_data_pos(TmaidWindow *tmaid,const gint x,const gint y,
														const gboolean align);


/*	饤ХåեΥɥ쥹̾κɸ
	ptw,TXTɥ
	  x,xɸ
	  y,yɸ
	RET,ɸ																*/
gint edit_get_screen_pos(TmaidWindow *tmaid,const gint x,const gint y);


/*	ʸʬ
	  text,ʸ
	length,ʸ
	   RET,ʬ																*/
guint
edit_get_char_type (const gchar *text, const gsize length);


/*	ڤ
	 ptw,TXTɥ
	   x,xɸ
	   y,yɸ
	move,TRUE:˰ư,FALSE:˰ư
	 RET,ɸ																*/
gint edit_get_move_pos(TmaidWindow *tmaid,const gint x,const gint y,
														const gboolean move);


/*	ϰϤΥХȿ
	     ptw,TXTɥ
	 start_p,ϰ
	   end_p,ϰ
	     RET,Хȿ														*/
gint edit_get_sel_bytes(TmaidWindow *tmaid,GdkPoint *start_p,GdkPoint *end_p);


/*	ϰϤ˥ԡ
	    ptw,TXTɥ
	start_p,ϰ
	  end_p,ϰ
	   text,															*/
void edit_cpy_sel_mem(TmaidWindow *tmaid,GdkPoint *start_p,GdkPoint *end_p,
																gchar *text);


/*	ƤŽդ
	   ptw,TXTɥ
	   put,Žդɸ
	   new,ɸ
	  text,
	length,Хȿ
	   RET,줿Կ													*/
gint edit_put_mem(TmaidWindow *tmaid,GdkPoint *put,GdkPoint *new,
										const gchar *text,const gint length);


/*	ϰϤ
	    ptw,TXTɥ
	start_p,ϰ
	  end_p,ϰ
	    RET,줿Կ													*/
gint edit_del_sel_mem(TmaidWindow *tmaid,GdkPoint *start_p,GdkPoint *end_p);


#endif
