/*
    Text maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "abort.h"
#include "charlist.h"
#include "command.h"
#include "edit.h"
#include "file.h"
#include "find.h"
#include "general.h"
#include "jump.h"
#include "print.h"
#include "prop.h"
#include "reload.h"
#include "replace.h"
#include "repinfo.h"
#include "sigfile.h"
#include "valchr.h"
#include "misc/fileio.h"
#include "misc/misc.h"
#ifdef G_OS_WIN32
# include <gdk/gdkwin32.h>
# include <tchar.h>
# include <windows.h>
#endif /* G_OS_WIN32 */


/******************************************************************************
*                                                                             *
* ˥塼ؿ                                                              *
*                                                                             *
******************************************************************************/
void command_new(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	file_open_edit(NULL);
}


#ifndef G_OS_WIN32
static void command_open_ok(GtkWidget *widget,GtkWidget *dialog)
{
	gchar **file;

	file = g_object_get_data (G_OBJECT (dialog), "user_data");
	*file
		=g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog)));
    gtk_widget_destroy(dialog);
}
#endif /* not G_OS_WIN32 */


void command_open(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *file = NULL;
#ifdef G_OS_WIN32
	gchar *path;
	OPENFILENAME ofn;
	TCHAR szFile[MAX_PATH];
# ifdef UNICODE
	gchar *utf8file, *utf16file = NULL;

	utf8file = g_filename_to_utf8 (open_path, -1, NULL, NULL, NULL);
	if (utf8file != NULL)
	  {
		utf16file = g_utf8_to_utf16 (utf8file, -1, NULL, NULL, NULL);
		g_free (utf8file);
	  }
	path = utf16file;
# else /* not UNICODE */
	path = g_strdup (open_path);
# endif /* not UNICODE */
	szFile[0] = '\0';
	ofn.lStructSize = sizeof (OPENFILENAME);
	ofn.hwndOwner = GDK_WINDOW_HWND (window->window);
	ofn.lpstrFilter = NULL;
	ofn.nFilterIndex = 0;
	ofn.lpstrCustomFilter = NULL;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFileTitle = NULL;
	ofn.lpstrInitialDir = path;
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.lpstrDefExt = NULL;
	if (GetOpenFileName (&ofn))
# ifdef UNICODE
	  {
		utf16file = g_utf16_to_utf8 (szFile, -1, NULL, NULL, NULL);
		if (utf16file != NULL)
		  {
			file = g_filename_from_utf8 (utf16file, -1, NULL, NULL, NULL);
			g_free (utf16file);
		  }
	  }
# else /* not UNICODE */
		file = g_strdup (szFile);
# endif /* not UNICODE */
	g_free (path);
#else /* not G_OS_WIN32 */
	GtkWidget *dialog;

	dialog=gtk_file_selection_new(_("Open"));
	g_signal_connect (G_OBJECT (dialog), "destroy",
											G_CALLBACK (gtk_main_quit), NULL);
	g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (dialog)->ok_button),
							"clicked", G_CALLBACK (command_open_ok), dialog);
	g_signal_connect_swapped (
						G_OBJECT (GTK_FILE_SELECTION (dialog)->cancel_button),
			"clicked", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
	g_object_set_data (G_OBJECT (dialog), "user_data", &file);
	if (open_path!=NULL)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(dialog),open_path);
	gtk_widget_show(dialog);
	gtk_grab_add(dialog);
	gtk_main();
#endif /* not G_OS_WIN32 */
	if (file!=NULL) {
		g_free(open_path);
		open_path = fileio_get_full_path (file);
		*(gchar *)g_basename(open_path)='\0';
		file_open_edit(file);
		g_free(file);
	}
}


void command_save(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *text;
	TmaidWindow *tmaid;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	if (tmaid->create) {
		command_saveas(callback_data,callback_action,widget);
	} else {
		text=g_strdup_printf(_("%s\nThis file is existed.\n\nOver write?"),
																tmaid->file);
		if ((!tmaid->ft.overwrite || !fileio_isfile (tmaid->file)
									|| misc_message_box ("Text maid",text, 1,
											_("_Yes"), _("_No"), NULL) == 0)
										&& file_save_text (tmaid->file, tmaid))
		  {
			tmaid_change_edit (tmaid, FALSE);
			if (delete_list(&tmaid->undo)+delete_list(&tmaid->redo)>0)
				set_menu_bar(tmaid);
		  }
	}
}


void command_saveas(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *file = NULL;
#ifdef G_OS_WIN32
	gchar *path;
	OPENFILENAME ofn;
	TCHAR szFile[MAX_PATH];
# ifdef UNICODE
	gchar *utf8file, *utf16file = NULL;

	utf8file = g_filename_to_utf8 (save_path, -1, NULL, NULL, NULL);
	if (utf8file != NULL)
	  {
		utf16file = g_utf8_to_utf16 (utf8file, -1, NULL, NULL, NULL);
		g_free (utf8file);
	  }
	path = utf16file;
# else /* not UNICODE */
	path = g_strdup (save_path);
# endif /* not UNICODE */
	szFile[0] = '\0';
	ofn.lStructSize = sizeof (OPENFILENAME);
	ofn.hwndOwner = GDK_WINDOW_HWND (window->window);
	ofn.lpstrFilter = NULL;
	ofn.nFilterIndex = 0;
	ofn.lpstrCustomFilter = NULL;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFileTitle = NULL;
	ofn.lpstrInitialDir = path;
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_HIDEREADONLY | OFN_NOCHANGEDIR | OFN_PATHMUSTEXIST;
	ofn.lpstrDefExt = NULL;
	if (GetSaveFileName (&ofn))
# ifdef UNICODE
	  {
		utf16file = g_utf16_to_utf8 (szFile, -1, NULL, NULL, NULL);
		if (utf16file != NULL)
		  {
			file = g_filename_from_utf8 (utf16file, -1, NULL, NULL, NULL);
			g_free (utf16file);
		  }
	  }
# else /* not UNICODE */
		file = g_strdup (szFile);
# endif /* not UNICODE */
	g_free (path);
#else /* not G_OS_WIN32 */
	GtkWidget *dialog;

	dialog=gtk_file_selection_new(_("Save As"));
	g_signal_connect (G_OBJECT (dialog), "destroy",
											G_CALLBACK (gtk_main_quit), NULL);
	g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (dialog)->ok_button),
							"clicked", G_CALLBACK (command_open_ok), dialog);
	g_signal_connect_swapped (
						G_OBJECT (GTK_FILE_SELECTION (dialog)->cancel_button),
			"clicked", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
	g_object_set_data (G_OBJECT (dialog), "user_data", &file);
	if (save_path!=NULL)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(dialog),save_path);
	gtk_widget_show(dialog);
	gtk_grab_add(dialog);
	gtk_main();
#endif /* not G_OS_WIN32 */
	if (file!=NULL) {
		gchar *text, *label;
		GtkWidget *child;
		TmaidWindow *tmaid;

		child = gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)));
		tmaid = g_object_get_data (G_OBJECT (child), "user_data");
		text=g_strdup_printf(_("%s\nThis file is existed.\n\nOver write?"),
																		file);
		if ((!tmaid->ft.overwrite || !fileio_isfile (file)
									|| misc_message_box ("Text maid", text, 1,
											_("_Yes"), _("_No"), NULL) == 0)
											&& file_save_text (file, tmaid))
		  {
			g_free(save_path);
			save_path = fileio_get_full_path (file);
			*(gchar *)g_basename(save_path)='\0';
			/* ե̾Ĵ٤ */
			file_delete_edit(tmaid->file);
			tmaid->file[0]='\0';
			label=file_add_edit(file,&tmaid->same);
			gtk_label_set_text(GTK_LABEL(tmaid->label),label);
			g_free(label);
			/* ɥ˥塼 */
			gtk_label_set_text(GTK_LABEL(GTK_BIN(tmaid->menu_item)->child),
																		file);
			/*  */
			tmaid->create = FALSE;
			tmaid_change_edit (tmaid, FALSE);
			g_free(tmaid->file);
			tmaid->file=g_strdup(file);
			delete_list(&tmaid->undo);
			delete_list(&tmaid->redo);
			set_menu_bar(tmaid);
			file_set_history(tmaid->file);
		  }
		g_free(file);
	}
}


void command_reload(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *text;
	gint i;
	GList *glist;
	LineBuffer *p;
	TmaidWindow *tmaid, *tmaid_dst;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	text = tmaid->edit ? g_strdup_printf
						(_("File %s was edited.\nRestore to existed file?"),
														tmaid->file) : NULL;
	if (reload_dialog (&tmaid->ft, text))
	  {
		/* Хåե */
		while (tmaid->start->prev!=NULL)
			tmaid->start=tmaid->start->prev;
		while (tmaid->start!=NULL) {
			p=tmaid->start->next;
			if (tmaid->start->text!=NULL)
				g_free(tmaid->start->text);
			g_free(tmaid->start);
			tmaid->start=p;
		}
		delete_list(&tmaid->undo);
		delete_list(&tmaid->redo);
		tmaid->cursor.x = tmaid->cursor.y = tmaid->top.x = tmaid->top.y = 0;
		tmaid->select.x = -1;
		/* ɤ߹ */
		file_open_text(tmaid);
		/* ޡ */
		if (tmaid->ft.limit)
			modify_margin (tmaid);
		tmaid_change_edit (tmaid, FALSE);
		misc_set_scroll_bar (tmaid->hscroll,
				G_CALLBACK (signal_value_changed_hscroll), tmaid,
				0, edit_get_width_max (tmaid) + 1,
				MAX (tmaid->drawing->allocation.width / tmaid->font_width, 1),
																tmaid->top.x);
		misc_set_scroll_bar (tmaid->vscroll,
			G_CALLBACK (signal_value_changed_vscroll), tmaid,
			0, tmaid->max,
			MAX (tmaid->drawing->allocation.height / tmaid->font_height, 1),
																tmaid->top.y);
		set_menu_bar(tmaid);
		draw_caret(tmaid,NULL);
		gtk_widget_draw(tmaid->drawing,NULL);
		if (tmaid->ft.ft_id >= 0)
		  {
			/* Ʊե륿פ򤹤٤ѹ */
			for (i = 0; i < ftnum; i++)
				if (ftype[i].ft_id == tmaid->ft.ft_id)
				  {
					property_copy (ftype + i, &tmaid->ft);
					break;
				  }
			glist = gtk_container_children (GTK_CONTAINER (notebook));
			for (i = g_list_length (glist) - 1; i >= 0; i--)
			  {
				tmaid_dst = g_object_get_data
						(G_OBJECT (g_list_nth_data (glist, i)), "user_data");
				if (tmaid->ft.ft_id == tmaid_dst->ft.ft_id
														&& tmaid != tmaid_dst)
				  {
					property_copy (&tmaid_dst->ft, &tmaid->ft);
					g_free (tmaid_dst->ft.charset);
					tmaid_dst->ft.charset = g_strdup (tmaid->ft.charset);
				  }
			  }
			g_list_free (glist);
		  }
		charlist_renewal_all (tmaid->ft.charset, tmaid->ft.ft_id);
	  }
	g_free(text);
}


void command_print(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	TmaidWindow *tmaid;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	printer.select=tmaid->select.x>=0;
	printer.column=tmaid->ft.margin;
	printer.font_width=tmaid->font_width;
	printer.font_height=tmaid->font_height;
	if (print_dialog(&printer))
		print_out(tmaid,&printer);
}


void command_property(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint i;
	FileType ft;
	GList *glist;
	TmaidWindow *tmaid;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	g_memset (&ft, 0, sizeof (FileType));
	property_copy (&ft, &tmaid->ft);
	ft.charset = g_strdup (tmaid->ft.charset);
	if (property_dialog(&ft)) {
		if (ft.ft_id<0) {
			/* ̵°ΤȤˤϤΥɥѹ */
			g_free (tmaid->ft.charset);
			tmaid->ft.charset = g_strdup (ft.charset);
			property_change (tmaid,&ft);
		} else {
			/* Ʊե륿פ򤹤٤ѹ */
			tmaid->ft.ft_id=ft.ft_id;
			for (i=0;i<ftnum;i++)
				if (ftype[i].ft_id==ft.ft_id) {
					property_copy (ftype + i, &ft);
					break;
				}
			glist=gtk_container_children(GTK_CONTAINER(notebook));
			for (i=g_list_length(glist)-1;i>=0;i--) {
				tmaid = g_object_get_data
						(G_OBJECT (g_list_nth_data (glist, i)), "user_data");
				if (tmaid->ft.ft_id == ft.ft_id)
				  {
					g_free (tmaid->ft.charset);
					tmaid->ft.charset = g_strdup (ft.charset);
					property_change (tmaid, &ft);
				  }
			}
			g_list_free(glist);
		}
		charlist_renewal_all (ft.charset, ft.ft_id);
	}
	g_free (ft.charset);
	g_free(ft.font_name);
}


void command_close(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint page;
	TmaidWindow *tmaid;

	if ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		tmaid = g_object_get_data (G_OBJECT (gtk_notebook_get_nth_page
								(GTK_NOTEBOOK (notebook), page)), "user_data");
		if (prompt_close(tmaid))
			gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),page);
	}
}


void command_exit(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	GdkEvent event;

	event.any.type=GDK_DELETE;
	event.any.window=window->window;
	event.any.send_event=FALSE;
	gdk_event_put(&event);
}


void command_undo(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	TmaidWindow *tmaid;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	history_operation(tmaid,FALSE);
}


void command_redo(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	TmaidWindow *tmaid;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	history_operation(tmaid,TRUE);
}


void command_cut(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	command_copy(callback_data,callback_action,widget);
	command_delete(callback_data,callback_action,widget);
}


void command_copy(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint length;
	TmaidWindow *tmaid;

	if (gtk_selection_owner_set (window, GDK_SELECTION_CLIPBOARD,
															GDK_CURRENT_TIME))
	  {
		tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
		g_free(clipboard_text);
		length=edit_get_sel_bytes(tmaid,&tmaid->select,&tmaid->cursor);
		clipboard_text=g_malloc((length+1)*sizeof(gchar));
		edit_cpy_sel_mem(tmaid,&tmaid->select,&tmaid->cursor,clipboard_text);
		clipboard_text[length]='\0';
	  }
}


void command_paste(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	/* WindowsΥ쥯μ䤷ΤǻŪ */
#ifdef G_OS_WIN32
	gchar *text = NULL;
	TmaidHistory *d;
	TmaidWindow *tmaid;
	GdkPoint select;
	HGLOBAL hGlobal;
	LPSTR lpszTextA;
	LPWSTR lpszTextW;

	if (OpenClipboard (GDK_WINDOW_HWND (window->window)))
	  {
		if ((hGlobal = GetClipboardData (CF_UNICODETEXT)) != NULL)
		  {
			if ((lpszTextW = GlobalLock (hGlobal)) != NULL)
				text = g_utf16_to_utf8 (lpszTextW, -1, NULL, NULL, NULL);
			GlobalUnlock (hGlobal);
		  }
		if (text == NULL && (hGlobal = GetClipboardData (CF_TEXT)) != NULL)
		  {
			if ((lpszTextA = GlobalLock (hGlobal)) != NULL)
				text = g_locale_to_utf8 (lpszTextA, -1, NULL, NULL, NULL);
			GlobalUnlock (hGlobal);
		  }
		CloseClipboard ();
		if (text != NULL)
		  {
			tmaid = g_object_get_data(G_OBJECT
					(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
			select = tmaid->select;
			d = edit_operation (tmaid, text, g_strlen (text), TRUE, FALSE);
			d->next = tmaid->undo;
			tmaid->undo = d;
			if (delete_list (&tmaid->redo) > 0 || d->next == NULL
															|| select.x >= 0)
				set_menu_bar (tmaid);
			tmaid_change_edit (tmaid, TRUE);
			g_free(text);
		  }
	  }
#else /* not G_OS_WIN32 */
	gtk_selection_convert (window, GDK_SELECTION_CLIPBOARD, atom_targets,
															GDK_CURRENT_TIME);
#endif /* not G_OS_WIN32 */
}


void command_delete(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	TmaidHistory *d;
	TmaidWindow *tmaid;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	d=edit_operation(tmaid,NULL,0,TRUE,FALSE);
	d->next=tmaid->undo;
	tmaid->undo=d;
	set_menu_bar(tmaid);
	tmaid_change_edit (tmaid, TRUE);
}


void command_margin(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	TmaidWindow *tmaid;

	if (misc_message_box("Text maid",_("Return at Right Margin?"),1,
												_("_Yes"),_("_No"),NULL)==0) {
		tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
		margin_operation(tmaid);
	}
}


void command_tab(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	TmaidWindow *tmaid;

	if (misc_message_box("Text maid",_("Convert Tab to Space?"),1,
												_("_Yes"),_("_No"),NULL)==0) {
		tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
		tab_operation(tmaid);
	}
}


void command_valchr(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar valchr;
	TmaidHistory *d;
	TmaidWindow *tmaid;
	GdkPoint select;

	if (valchr_dialog(&valchr)) {
		tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
		select=tmaid->select;
		d=edit_operation(tmaid,&valchr,1,TRUE,FALSE);
		d->next=tmaid->undo;
		tmaid->undo=d;
		if (delete_list(&tmaid->redo)>0 || d->next==NULL || select.x>=0)
			set_menu_bar(tmaid);
		tmaid_change_edit (tmaid, TRUE);
	}
}


void command_jump(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	JumpDialog jmp;
	TmaidWindow *tmaid;

	tmaid = gtk_object_get_data (GTK_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	jmp.max=tmaid->max;
	jmp.cursor=tmaid->cursor.y+1;
	if (jump_dialog(&jmp) && tmaid->cursor.y!=jmp.cursor-1)
		jump_operation(tmaid,jmp.cursor);
}


void command_all(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint sx,sy;
	GdkPoint top;
	TmaidWindow *tmaid;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	if (tmaid->max<=1 && tmaid->start->length<=0)
		return;
	top=tmaid->top;
	sx=MAX(tmaid->drawing->allocation.width/tmaid->font_width,1);
	sy=MAX(tmaid->drawing->allocation.height/tmaid->font_height,1);
	if (tmaid->select.x<0)/* 򤹤 */
		gtk_selection_owner_set(window,GDK_SELECTION_PRIMARY,GDK_CURRENT_TIME);
	tmaid->select.x=tmaid->select.y=0;
	tmaid->cursor.x=edit_get_width(tmaid,tmaid->cursor.y=tmaid->max-1);
	if (tmaid->cursor.x<tmaid->top.x)
		tmaid->top.x=tmaid->cursor.x;
	else if (tmaid->cursor.x-sx+1>tmaid->top.x)
		tmaid->top.x=tmaid->cursor.x-sx+1;
	if (tmaid->cursor.y<tmaid->top.y)
		tmaid->top.y=tmaid->cursor.y;
	else if (tmaid->cursor.y-sy+1>tmaid->top.y)
		tmaid->top.y=tmaid->cursor.y-sy+1;
	set_menu_bar(tmaid);
	if (tmaid->top.x!=top.x)
		misc_set_scroll_bar (tmaid->hscroll,
						G_CALLBACK (signal_value_changed_hscroll), tmaid,
						0, edit_get_width_max (tmaid) + 1, sx, tmaid->top.x);
	if (tmaid->top.y!=top.y)
		misc_set_scroll_bar(tmaid->vscroll,
						G_CALLBACK (signal_value_changed_vscroll), tmaid,
						0, tmaid->max, sy, tmaid->top.y);
	gtk_widget_draw(tmaid->drawing,NULL);
}


void command_find(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *text;
	gint i;
	FindString fd;
	TmaidWindow *tmaid;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	fd.text=NULL;
	fd.arrow=find_arrow;
	fd.ignorecase=find_ignorecase;
	if (tmaid->select.x>=0) {
		if (tmaid->select.y<tmaid->cursor.y
										|| (tmaid->select.y==tmaid->cursor.y
										&& tmaid->select.x<tmaid->cursor.x))
				fd.arrow=FALSE;
			else
				fd.arrow=TRUE;
	}
	if (find_dialog(&fd)) {
		set_menu_bar(tmaid);
		find_arrow=fd.arrow;
		find_ignorecase=fd.ignorecase;
		for (i=0;i<find_num;i++)
			if (g_strcmp(fd.text,find_text[i])==0)
				break;
		if (i==find_num) {
			if (find_num>=32)
				g_free(find_text[31]);
			else
				find_num++;
			g_memmove(find_text+1,find_text,(find_num-1)*sizeof(gchar *));
			find_text[0]=fd.text;
		} else {
			g_free(fd.text);
			if (i>0) {
				text=find_text[i];
				g_memmove(find_text+1,find_text,i*sizeof(gchar *));
				find_text[0]=text;
			}
		}
		command_next(callback_data,callback_action,widget);
	}
}


void command_next(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gchar *text;
	TmaidWindow *tmaid;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	find_operation(tmaid,&tmaid->cursor,&tmaid->select,find_text[0],
					callback_action==0?find_arrow:!find_arrow,find_ignorecase);
	if (userbreak && tmaid->select.x<0) {
		text=g_strdup_printf(_("'%s' was not fount."),find_text[0]);
		misc_message_box("Text maid",text,0,_("OK"),NULL);
		g_free(text);
		set_menu_bar(tmaid);
	}
}


void command_replace(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gboolean replace=FALSE;
	gchar *text;
	gint i,bytes,count=0,data_pos,result;
	GdkPoint select;
	TmaidHistory *d;
	TmaidWindow *tmaid;
	ReplaceInfo ri;
	ReplaceString rp;

	tmaid = g_object_get_data (G_OBJECT
				(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
					gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
																"user_data");
	rp.src=rp.dst=NULL;
	rp.arrow=replace_arrow;
	rp.ignorecase=replace_ignorecase;
	if (tmaid->select.x>=0) {
		if (tmaid->select.y<tmaid->cursor.y
										|| (tmaid->select.y==tmaid->cursor.y
										&& tmaid->select.x<tmaid->cursor.x))
				rp.arrow=FALSE;
			else
				rp.arrow=TRUE;
	}
	result=replace_dialog(&rp);
	if (result!=REPLACE_CANCEL) {
		set_menu_bar(tmaid);
		replace_arrow=rp.arrow;
		replace_ignorecase=rp.ignorecase;
		for (i=0;i<find_num;i++)
			if (g_strcmp(rp.src,find_text[i])==0)
				break;
		if (i==find_num) {
			if (find_num>=32)
				g_free(find_text[31]);
			else
				find_num++;
			g_memmove(find_text+1,find_text,(find_num-1)*sizeof(gchar *));
			find_text[0]=rp.src;
		} else {
			g_free(rp.src);
			text=find_text[i];
			g_memmove(find_text+1,find_text,i*sizeof(gchar *));
			find_text[0]=text;
		}
		if (rp.dst != NULL && rp.dst[0] != '\0')
		  {
			for (i=0;i<replace_num;i++)
				if (g_strcmp(rp.dst,replace_text[i])==0)
						break;
			if (i==replace_num) {
				if (replace_num>=32)
					g_free(replace_text[31]);
				else
					replace_num++;
				g_memmove(replace_text+1,replace_text,
											(replace_num-1)*sizeof(gchar *));
				replace_text[0]=rp.dst;
			} else {
				g_free(rp.dst);
				text=replace_text[i];
				g_memmove(replace_text+1,replace_text,i*sizeof(gchar *));
				replace_text[0]=text;
			}
			ri.dst = replace_text[0];
		  }
		else
		  {
			g_free (rp.dst);
			ri.dst = NULL;
		  }
		select=tmaid->select;
		ri.arrow=replace_arrow;
		ri.ignorecase=replace_ignorecase;
		do {
			find_operation(tmaid,&tmaid->cursor,&select,find_text[0],
											replace_arrow,replace_ignorecase);
			if (tmaid->select.x<0)
				break;
			replace=TRUE;
			bytes=edit_get_sel_bytes(tmaid,&tmaid->select,&tmaid->cursor);
			if (result!=REPLACE_ALL) {
				ri.src=g_malloc(bytes+1);
				edit_cpy_sel_mem(tmaid,&tmaid->select,&tmaid->cursor,ri.src);
				ri.src[bytes]='\0';
				ri.start=tmaid->select;
				ri.end=tmaid->cursor;
				result=repinfo_dialog(&ri);
				g_free(ri.src);
				if (result==REPLACE_CANCEL || result==REPLACE_NEXT)
					continue;
			}
			if (select.x>=0 && tmaid->cursor.y==select.y && replace_arrow)
				data_pos=edit_get_data_pos(tmaid,select.x,select.y,FALSE);
			else
				data_pos=-1;
			d = edit_operation (tmaid, ri.dst, g_strlen (ri.dst),
														replace_arrow, TRUE);
			if (data_pos >= 0)
				select.x = edit_get_screen_pos (tmaid,
							data_pos + g_strlen (ri.dst) - bytes, select.y);
			if (result==REPLACE_OK || result==REPLACE_ALL)
				count++;
			d->next=tmaid->undo;
			tmaid->undo=d;
			if (delete_list(&tmaid->redo)>0 || d->next==NULL)
				set_menu_bar(tmaid);
			tmaid_change_edit (tmaid, TRUE);
		} while (result!=REPLACE_CANCEL);
		if (!replace) {
			text=g_strdup_printf(_("'%s' was not fount."),find_text[0]);
			misc_message_box("Text maid",text,0,_("OK"),NULL);
			g_free(text);
		} else if (result>1) {
			text=g_strdup_printf(_("%d strings were replaced"),count);
			misc_message_box("Text maid",text,0,_("OK"),NULL);
			g_free(text);
		}
		set_menu_bar(tmaid);
	}
}
