/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WISO10646_H__
#define __WISO10646_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:マルチバイト文字列をワイド文字列に変換する
    lpszMultiByte,マルチバイト文字列
     cchMultiByte,文字数(負:NULL終端文字列)
              RET,ワイド文字列                                              */
LPWSTR WINAPI
StringMultiByteToWideCharEx (LPCSTR  lpszMultiByte,
                             SSIZE_T cchMultiByte);


/*  ja:ワイド文字列をマルチバイト文字列に変換する
    lpszWideChar,ワイド文字列
     cchWideChar,文字数(負:NULL終端文字列)
             RET,マルチバイト文字列                                         */
LPSTR WINAPI
StringWideCharToMultiByteEx (LPCWSTR lpszWideChar,
                             SSIZE_T cchWideChar);


/*  ja:マルチバイト文字列をワイド文字列に変換する
    lpszMultiByte,マルチバイト文字列
              RET,ワイド文字列                                              */
LPWSTR WINAPI
StringMultiByteToWideChar (LPCSTR lpszMultiByte);


/*  ja:ワイド文字列をマルチバイト文字列に変換する
    lpszWideChar,ワイド文字列
             RET,マルチバイト文字列                                         */
LPSTR WINAPI
StringWideCharToMultiByte (LPCWSTR lpszWideChar);


/*  ja:ワイド文字列を返す
    lpszWideChar,ワイド文字列
             RET,ワイド文字列                                               */
LPWSTR WINAPI
WideCharW (LPWSTR lpszWideChar);


/*  ja:ワイド文字列を返す
    lpszMultiByte,マルチバイト文字列
              RET,ワイド文字列                                              */
LPWSTR WINAPI
WideCharA (LPSTR lpszMultiByte);


/*  ja:ワイド文字列を返す
    lpszWideChar,ワイド文字列
             RET,マルチバイト文字列                                         */
LPSTR WINAPI
MultiByteW (LPWSTR lpszWideChar);


/*  ja:ワイド文字列を返す
    lpszMultiByte,マルチバイト文字列
              RET,マルチバイト文字列                                        */
LPSTR WINAPI
MultiByteA (LPSTR lpszMultiByte);


#ifdef UNICODE
# define StringFromMultiByteEx StringMultiByteToWideCharEx
# define StringFromMultiByte StringMultiByteToWideChar
# define StringFromWideCharEx StringDuplicateExW
# define StringFromWideChar StringDuplicateW
# define StringToMultiByteEx StringWideCharToMultiByteEx
# define StringToMultiByte StringWideCharToMultiByte
# define StringToWideCharEx StringDuplicateExW
# define StringToWideChar StringDuplicateW
# define WideChar WideCharW
# define MultiByte MultiByteW
#else /* not UNICODE */
# define StringFromMultiByteEx StringDuplicateExA
# define StringFromMultiByte StringDuplicateA
# define StringFromWideCharEx StringWideCharToMultiByteEx
# define StringFromWideChar StringWideCharToMultiByte
# define StringToMultiByteEx StringDuplicateExA
# define StringToMultiByte StringDuplicateA
# define StringToWideCharEx StringMultiByteToWideCharEx
# define StringToWideChar StringMultiByteToWideChar
# define WideChar WideCharA
# define MultiByte MultiByteA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WISO10646_H__ */
