/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "wcommon.h"


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:文字列をデバイスに出力する
    nStdHandle,デバイス
    lpszFormat,書式文字列                                                   */
VOID WINAPI
PrintConsoleW (DWORD   nStdHandle,
               LPCWSTR lpszFormat, ...)
{
  if (lpszFormat)
    {
      va_list arglist;
      DWORD dwWrite;
      LPWSTR lpszText = NULL;

      va_start (arglist, lpszFormat);
      wvasprintfW (&lpszText, lpszFormat, arglist);
      va_end (arglist);
      WriteConsoleW (GetStdHandle (nStdHandle), lpszText,
                                        lstrlenW (lpszText), &dwWrite, NULL);
      MemoryFree (lpszText);
    }
}


/*  ja:文字列をデバイスに出力する
    nStdHandle,デバイス
    lpszFormat,書式文字列                                                   */
VOID WINAPI
PrintConsoleA (DWORD  nStdHandle,
               LPCSTR lpszFormat, ...)
{
  if (lpszFormat)
    {
      va_list arglist;
      DWORD dwWrite;
      LPSTR lpszText;

      va_start (arglist, lpszFormat);
      wvasprintfA (&lpszText, lpszFormat, arglist);
      va_end (arglist);
      WriteConsoleA (GetStdHandle (nStdHandle), lpszText,
                                        lstrlenA (lpszText), &dwWrite, NULL);
      MemoryFree (lpszText);
    }
}
