/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "wcommon.h"
#include <commctrl.h>
#include <windowsx.h>


/******************************************************************************
*                                                                             *
******************************************************************************/
int WINAPI
ComboBox_AddStringW (HWND    hWnd,
                     LPCWSTR lpszString)
{
  return SendMessageW (hWnd, CB_ADDSTRING, 0, (LPARAM)lpszString);
}


int WINAPI
ComboBox_AddStringA (HWND   hWnd,
                     LPCSTR lpszString)
{
  return SendMessageA (hWnd, CB_ADDSTRING, 0, (LPARAM)lpszString);
}


int WINAPI
ComboBoxItem_AddStringW (HWND    hDlg,
                         int     nID,
                         LPCWSTR lpszString)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ComboBox_AddStringW (hWnd, lpszString) : CB_ERR;
}


int WINAPI
ComboBoxItem_AddStringA (HWND   hDlg,
                         int    nID,
                         LPCSTR lpszString)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ComboBox_AddStringA (hWnd, lpszString) : CB_ERR;
}


int WINAPI
ComboBoxItem_GetCurSel (HWND hDlg,
                        int  nID)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ComboBox_GetCurSel (hWnd) : CB_ERR;
}


int WINAPI
ComboBoxItem_SetCurSel (HWND hDlg,
                        int  nID,
                        int  index)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ComboBox_SetCurSel (hWnd, index) : CB_ERR;
}


/******************************************************************************
*                                                                             *
******************************************************************************/
int WINAPI
Edit_GetFirstVisibleLineW (HWND hWnd)
{
  return SendMessageW (hWnd, EM_GETFIRSTVISIBLELINE, 0, 0);
}


int WINAPI
Edit_GetFirstVisibleLineA (HWND hWnd)
{
  return SendMessageA (hWnd, EM_GETFIRSTVISIBLELINE, 0, 0);
}


int WINAPI
EditItem_GetFirstVisibleLineW (HWND hDlg,
                               int  nID)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? Edit_GetFirstVisibleLineW (hWnd) : 0;
}


int WINAPI
EditItem_GetFirstVisibleLineA (HWND hDlg,
                               int  nID)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? Edit_GetFirstVisibleLineA (hWnd) : 0;
}


void WINAPI
EditItem_GetRect (HWND   hDlg,
                  int    nID,
                  LPRECT lpRect)
{
  if (lpRect)
    {
      HWND hWnd;

      hWnd = GetDlgItem (hDlg, nID);
      if (hWnd)
        Edit_GetRect (hWnd, lpRect);
    }
}


int WINAPI
Edit_LineIndexW (HWND hWnd,
                 int  nLine)
{
  return SendMessageW (hWnd, EM_LINEINDEX, nLine, 0);
}


int WINAPI
Edit_LineIndexA (HWND hWnd,
                 int  nLine)
{
  return SendMessageA (hWnd, EM_LINEINDEX, nLine, 0);
}


int WINAPI
EditItem_LineIndexW (HWND hDlg,
                     int  nID,
                     int  nLine)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? Edit_LineIndexW (hWnd, nLine) : -1;
}


int WINAPI
EditItem_LineIndexA (HWND hDlg,
                     int  nID,
                     int  nLine)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? Edit_LineIndexA (hWnd, nLine) : -1;
}


void WINAPI
Edit_PosFromCharW (HWND    hWnd,
                   int     nIndex,
                   LPPOINT lpPoint)
{
  if (hWnd && lpPoint)
    {
      LRESULT lResult;

      lResult = SendMessageW (hWnd, EM_POSFROMCHAR, nIndex, 0);
      lpPoint->x = (SHORT)LOWORD (lResult);
      lpPoint->y = (SHORT)HIWORD (lResult);
    }
}


void WINAPI
Edit_PosFromCharA (HWND    hWnd,
                   int     nIndex,
                   LPPOINT lpPoint)
{
  if (hWnd && lpPoint)
    {
      LRESULT lResult;

      lResult = SendMessageW (hWnd, EM_POSFROMCHAR, nIndex, 0);
      lpPoint->x = (SHORT)LOWORD (lResult);
      lpPoint->y = (SHORT)HIWORD (lResult);
    }
}


void WINAPI
EditItem_PosFromCharW (HWND    hDlg,
                       int     nID,
                       int     nIndex,
                       LPPOINT lpPoint)
{
  Edit_PosFromCharW (GetDlgItem (hDlg, nID), nIndex, lpPoint);
}


void WINAPI
EditItem_PosFromCharA (HWND    hDlg,
                       int     nID,
                       int     nIndex,
                       LPPOINT lpPoint)
{
  Edit_PosFromCharA (GetDlgItem (hDlg, nID), nIndex, lpPoint);
}


/******************************************************************************
*                                                                             *
******************************************************************************/
int WINAPI
ListBox_AddStringW (HWND    hWnd,
                    LPCWSTR lpszString)
{
  return SendMessageW (hWnd, LB_ADDSTRING, 0, (LPARAM)lpszString);
}


int WINAPI
ListBox_AddStringA (HWND   hWnd,
                    LPCSTR lpszString)
{
  return SendMessageA (hWnd, LB_ADDSTRING, 0, (LPARAM)lpszString);
}


int WINAPI
ListBoxItem_AddStringW (HWND    hDlg,
                        int     nID,
                        LPCWSTR lpszString)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_AddStringW (hWnd, lpszString) : LB_ERR;
}


int WINAPI
ListBoxItem_AddStringA (HWND   hDlg,
                        int    nID,
                        LPCSTR lpszString)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_AddStringA (hWnd, lpszString) : LB_ERR;
}


int WINAPI
ListBoxItem_DeleteString (HWND hDlg,
                          int  nID,
                          int  index)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_DeleteString (hWnd, index) : LB_ERR;
}


int WINAPI
ListBoxItem_GetCount (HWND hDlg,
                      int  nID)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_GetCount (hWnd) : LB_ERR;
}


int WINAPI
ListBoxItem_GetCurSel (HWND hDlg,
                       int  nID)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_GetCurSel (hWnd) : LB_ERR;
}


LRESULT WINAPI
ListBoxItem_GetItemData (HWND hDlg,
                         int  nID,
                         int  index)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_GetItemData (hWnd, index) : LB_ERR;
}


int WINAPI
ListBoxItem_GetSelCount (HWND hDlg,
                         int  nID)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_GetSelCount (hWnd) : LB_ERR;
}


int WINAPI
ListBoxItem_GetSelItems (HWND  hDlg,
                         int   nID,
                         int   cItems,
                         int  *lpItems)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_GetSelItems (hWnd, cItems, lpItems) : LB_ERR;
}


int WINAPI
ListBox_GetTextLenW (HWND hWnd,
                     int  index)
{
  return SendMessageW (hWnd, LB_GETTEXTLEN, index, 0);
}


int WINAPI
ListBox_GetTextLenA (HWND hWnd,
                     int  index)
{
  return SendMessageA (hWnd, LB_GETTEXTLEN, index, 0);
}


int WINAPI
ListBoxItem_GetTextLenW (HWND  hDlg,
                         int   nID,
                         int  index)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_GetTextLenW (hWnd, index) : LB_ERR;
}


int WINAPI
ListBoxItem_GetTextLenA (HWND  hDlg,
                         int   nID,
                         int  index)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_GetTextLenA (hWnd, index) : LB_ERR;
}


LPWSTR WINAPI
ListBox_GetTextNewW (HWND hWnd,
                     int  index)
{
  LPWSTR lpszText = NULL;

  if (hWnd)
    {
      int n;

      n = ListBox_GetTextLenW (hWnd, index);
      if (n != LB_ERR)
        {
          lpszText = MemoryAlloc ((n + 1) * sizeof (WCHAR));
          if (SendMessageW (hWnd, LB_GETTEXT,
                                            index, (LPARAM)lpszText) == LB_ERR)
            {
              MemoryFree (lpszText);
              lpszText = NULL;
            }
        }
    }
  return lpszText;
}


LPSTR WINAPI
ListBox_GetTextNewA (HWND hWnd,
                     int  index)
{
  LPSTR lpszText = NULL;

  if (hWnd)
    {
      int n;

      n = ListBox_GetTextLenA (hWnd, index);
      if (n != LB_ERR)
        {
          lpszText = MemoryAlloc ((n + 1) * sizeof (CHAR));
          if (SendMessageA (hWnd, LB_GETTEXT,
                                            index, (LPARAM)lpszText) == LB_ERR)
            {
              MemoryFree (lpszText);
              lpszText = NULL;
            }
        }
    }
  return lpszText;
}


LPWSTR WINAPI
ListBoxItem_GetTextNewW (HWND hDlg,
                         int  nID,
                         int  index)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_GetTextNewW (hWnd, index) : NULL;
}


LPSTR WINAPI
ListBoxItem_GetTextNewA (HWND hDlg,
                         int  nID,
                         int  index)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_GetTextNewA (hWnd, index) : NULL;
}


int WINAPI
ListBox_InsertStringW (HWND    hWnd,
                       int     index,
                       LPCWSTR lpszString)
{
  return SendMessageW (hWnd, LB_INSERTSTRING, index, (LPARAM)lpszString);

}


int WINAPI
ListBox_InsertStringA (HWND   hWnd,
                       int    index,
                       LPCSTR lpszString)
{
  return SendMessageA (hWnd, LB_INSERTSTRING, index, (LPARAM)lpszString);

}


int WINAPI
ListBoxItem_InsertStringW (HWND    hDlg,
                           int     nID,
                           int     index,
                           LPCWSTR lpszString)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_InsertStringW (hWnd, index, lpszString) : LB_ERR;
}


int WINAPI
ListBoxItem_InsertStringA (HWND   hDlg,
                           int    nID,
                           int    index,
                           LPCSTR lpszString)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_InsertStringA (hWnd, index, lpszString) : LB_ERR;
}


void WINAPI
ListBox_ResetContext (HWND hWnd)
{
  SendMessage (hWnd, LB_RESETCONTENT, 0, 0);
}


void WINAPI
ListBoxItem_ResetContext (HWND hDlg,
                          int  nID)
{
  SendDlgItemMessage (hDlg, nID, LB_RESETCONTENT, 0, 0);
}


int WINAPI
ListBoxItem_SetCurSel (HWND hDlg,
                       int  nID,
                       int  index)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_SetCurSel (hWnd, index) : LB_ERR;
}


int WINAPI
ListBoxItem_SetItemData (HWND   hDlg,
                         int    nID,
                         int    index,
                         LPARAM data)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_SetItemData (hWnd, index, data) : LB_ERR;
}


int WINAPI
ListBoxItem_SetSel (HWND hDlg,
                    int  nID,
                    BOOL fSelect,
                    int  index)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ListBox_SetSel (hWnd, fSelect, index) : LB_ERR;
}


/******************************************************************************
*                                                                             *
******************************************************************************/
BOOL WINAPI
StatusBar_SetTextW (HWND    hWnd,
                    USHORT  uPart,
                    USHORT  uType,
                    LPCWSTR lpszString)
{
  return SendMessageW (hWnd, SB_SETTEXT, uPart | uType, (LPARAM)lpszString);
}


BOOL WINAPI
StatusBar_SetTextA (HWND   hWnd,
                    USHORT uPart,
                    USHORT uType,
                    LPCSTR lpszString)
{
  return SendMessageA (hWnd, SB_SETTEXT, uPart | uType, (LPARAM)lpszString);
}


BOOL WINAPI
StatusBarItem_SetTextW (HWND    hDlg,
                        int     nID,
                        USHORT  uPart,
                        USHORT  uType,
                        LPCWSTR lpszString)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? StatusBar_SetTextW (hWnd, uPart, uType, lpszString) : FALSE;
}


BOOL WINAPI
StatusBarItem_SetTextA (HWND   hDlg,
                        int    nID,
                        USHORT uPart,
                        USHORT uType,
                        LPCSTR lpszString)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? StatusBar_SetTextA (hWnd, uPart, uType, lpszString) : FALSE;
}


void WINAPI
StatusBar_Simple (HWND hWnd,
                  BOOL fSimple)
{
  SendMessage (hWnd, SB_SIMPLE, fSimple, 0);
}


void WINAPI
StatusBarItem_Simple (HWND hDlg,
                      int  nID,
                      BOOL fSimple)
{
  SendDlgItemMessage (hDlg, nID, SB_SIMPLE, fSimple, 0);
}


/******************************************************************************
*                                                                             *
******************************************************************************/
void WINAPI
ToolBar_AutoSize (HWND hWnd)
{
  SendMessage (hWnd, TB_AUTOSIZE, 0, 0);
}


void WINAPI
ToolBarItem_AutoSize (HWND hDlg,
                      int  nID)
{
  SendDlgItemMessage (hDlg, nID, TB_AUTOSIZE, 0, 0);
}


BOOL WINAPI
ToolBar_EnableButton (HWND hWnd,
                      UINT uItem,
                      BOOL fEnable)
{
  return SendMessage (hWnd, TB_ENABLEBUTTON, uItem, fEnable);
}


BOOL WINAPI
ToolBarItem_EnableButton (HWND   hDlg,
                          int    nID,
                          UINT uItem,
                          BOOL fEnable)
{
  HWND hWnd;

  hWnd = GetDlgItem (hDlg, nID);
  return hWnd ? ToolBar_EnableButton (hWnd, uItem, fEnable) : FALSE;
}


/******************************************************************************
*                                                                             *
******************************************************************************/
int WINAPI
UpDown_SetPos (HWND  hWnd,
               short sPos)
{
  return SendMessage (hWnd, UDM_SETPOS, 0, MAKELPARAM (sPos, 0));
}


int WINAPI
UpDownItem_SetPos (HWND  hDlg,
                   int   nID,
                   short sPos)
{
  return SendDlgItemMessage (hDlg, nID, UDM_SETPOS, 0, MAKELPARAM (sPos, 0));
}


void WINAPI
UpDown_SetRange (HWND  hWnd,
                 short sMin,
                 short sMax)
{
  SendMessage (hWnd, UDM_SETRANGE, 0, MAKELPARAM (sMax, sMin));
}


void WINAPI
UpDownItem_SetRange (HWND   hDlg,
                     int    nID,
                     short sMin,
                     short sMax)
{
  SendDlgItemMessage (hDlg, nID, UDM_SETRANGE, 0, MAKELPARAM (sMax, sMin));
}
