/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WREGISTRY_H__
#define __WREGISTRY_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:レジストリのキーの値を取得する
             hKey,キーのハンドル
    lpszValueName,キーの名前
           lpData,データを受け取るバッファ
           dwData,データのサイズ
              RET,ERROR_SUCCESS:正常終了                                    */
LONG WINAPI
RegGetValueExW (HKEY   hKey,
                LPWSTR lpszValueName,
                LPVOID lpData,
                DWORD  dwData);


/*  ja:レジストリのキーの値を取得する
             hKey,キーのハンドル
    lpszValueName,キーの名前
           lpData,データを受け取るバッファ
           dwData,データのサイズ
              RET,ERROR_SUCCESS:正常終了                                    */
LONG WINAPI
RegGetValueExA (HKEY   hKey,
                LPSTR  lpszValueName,
                LPVOID lpData,
                DWORD  dwData);


/*  ja:レジストリのDWORD値を取得する
             hKey,キーのハンドル
    lpszValueName,キーの名前
        lpdwValue,DWORD値
              RET,TRUE:正常終了,FALSE:エラー                                */
BOOL WINAPI
RegGetDwordW (HKEY    hKey,
              LPCWSTR lpszValueName,
              LPDWORD lpdwValue);


/*  ja:レジストリのDWORD値を取得する
             hKey,キーのハンドル
    lpszValueName,キーの名前
        lpdwValue,DWORD値
              RET,TRUE:正常終了,FALSE:エラー                                */
BOOL WINAPI
RegGetDwordA (HKEY    hKey,
              LPCSTR  lpszValueName,
              LPDWORD lpdwValue);


/*  ja:レジストリの文字列を取得する
             hKey,キーのハンドル
    lpszValueName,キーの名前
              RET,文字列,NULL:エラー                                        */
LPWSTR WINAPI
RegGetStringW (HKEY    hKey,
               LPCWSTR lpszValueName);


/*  ja:レジストリの文字列を取得する
             hKey,キーのハンドル
    lpszValueName,キーの名前
              RET,文字列,NULL:エラー                                        */
LPSTR WINAPI
RegGetStringA (HKEY   hKey,
               LPCSTR lpszValueName);


/*  ja:レジストリにバイナリを設定する
             hKey,キーのハンドル
    lpszValueName,キーの名前
          lpcData,バイナリ
            nData,バイト数
              RET,TRUE:正常終了,FALSE:エラー                                */
BOOL WINAPI
RegSetBinaryW (HKEY    hKey,
               LPCWSTR lpszValueName,
               LPCVOID lpcData,
               SSIZE_T nData);


/*  ja:レジストリにバイナリを設定する
             hKey,キーのハンドル
    lpszValueName,キーの名前
          lpcData,バイナリ
            nData,バイト数
              RET,TRUE:正常終了,FALSE:エラー                                */
BOOL WINAPI
RegSetBinaryA (HKEY    hKey,
               LPCSTR  lpszValueName,
               LPCVOID lpcData,
               SSIZE_T nData);


/*  ja:レジストリにDWORD値を設定する
             hKey,キーのハンドル
    lpszValueName,キーの名前
          dwValue,DWORD値
              RET,TRUE:正常終了,FALSE:エラー                                */
BOOL WINAPI
RegSetDwordW (HKEY    hKey,
              LPCWSTR lpszValueName,
              DWORD   dwValue);


/*  ja:レジストリにDWORD値を設定する
             hKey,キーのハンドル
    lpszValueName,キーの名前
          dwValue,DWORD値
              RET,TRUE:正常終了,FALSE:エラー                                */
BOOL WINAPI
RegSetDwordA (HKEY   hKey,
              LPCSTR lpszValueName,
              DWORD  dwValue);


/*  ja:レジストリに文字列を設定する
             hKey,キーのハンドル
    lpszValueName,キーの名前
       lpszString,文字列
              RET,TRUE:正常終了,FALSE:エラー                                */
BOOL WINAPI
RegSetStringW (HKEY    hKey,
               LPCWSTR lpszValueName,
               LPCWSTR lpszString);


/*  ja:レジストリに文字列を設定する
             hKey,キーのハンドル
    lpszValueName,キーの名前
       lpszString,文字列
              RET,TRUE:正常終了,FALSE:エラー                                */
BOOL WINAPI
RegSetStringA (HKEY   hKey,
               LPCSTR lpszValueName,
               LPCSTR lpszString);


#ifdef UNICODE
# define RegGetValueEx RegGetValueExW
# define RegGetDword RegGetDwordW
# define RegGetString RegGetStringW
# define RegSetBinary RegSetBinaryW
# define RegSetDword RegSetDwordW
# define RegSetString RegSetStringW
#else /* not UNICODE */
# define RegGetValueEx RegGetValueExA
# define RegGetDword RegGetDwordA
# define RegGetString RegGetStringA
# define RegSetBinary RegSetBinaryA
# define RegSetDword RegSetDwordA
# define RegSetString RegSetStringA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WREGISTRY_H__ */
