/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __FIND_H__
#define __FIND_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


extern int nFind;               /* ja:登録されている検索文字列 */
extern BOOL bFindArrow;         /* ja:TRUE:下へ検索 */
extern BOOL bFindCase;          /* ja:TRUE:大文字小文字を区別する */
extern BOOL bFindWidth;         /* ja:TRUE:全角半角を区別する */
extern LPTSTR ppszFind[FINDNUM];/* ja:検索する文字列 */


/******************************************************************************
*                                                                             *
* ja:検索関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:検索
         hWnd,ウインドウ
    lpptStart,検索範囲
      lpptEnd,検索範囲(x=-1ならば選択範囲なし)
     lpszFind,検索文字列
       bArrow,TRUE:下へ,FALSE:上へ
        bCase,TRUE:大文字小文字を区別する,FALSE:大文字小文字を区別しない
       bWidth,TRUE:全角半角を区別する,FALSE:全角半角を区別しない
          RET,TRUE:正常終了,FALSE:中断                                      */
BOOL
FindOperation (HWND    hWnd,
               LPPOINT lpptStart,
               LPPOINT lpptEnd,
               LPCTSTR lpszFind,
               BOOL    bArrow,
               BOOL    bCase,
               BOOL    bWidth);


/******************************************************************************
*                                                                             *
* ja:検索ダイアログ群                                                         *
*                                                                             *
******************************************************************************/
typedef struct _FINDDLG
{
  BOOL bArrow;                  /* ja:TRUE:下へ検索 */
  BOOL bCase;                   /* ja:TRUE:大文字小文字を区別する */
  BOOL bWidth;                  /* ja:TRUE:全角半角を区別する */
  LPTSTR lpszText;
} FINDDLG, *PFINDDLG, *LPFINDDLG;


BOOL CALLBACK
FindDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __FIND_H__ */
