/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __TMAID_H__
#define __TMAID_H__


#include <windows.h>
#include <tchar.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MAINCLASS _T("Text maid Main Window Class")
#define TEXTCLASS _T("Text maid Text Window Class")
#define APPLICATION _T("Text maid")
#define FINDNUM 32
#define MENUTOP 6
#define MENUFILE 12
#define CP_SJIS 932
#define REG_STAT_READ   1
#define REG_STAT_WRITE  2
#define REG_STAT_CREATE 4


typedef struct _FILETYPE
{
  int nID;                          /* ja:ファイルタイプID(-1:無所属) */
  int nMargin;                      /* ja:右マージン */
  int nTab;                         /* ja:タブの文字数 */
  BOOL fAssociate;                  /* ja:TRUE:関連づける */
  BOOL fAutoIndent;                 /* ja:TRUE:自動字下げ */
  BOOL fCode;                       /* ja:TRUE:タブのコードを表示する */
  BOOL fCRLF;                       /* ja:TRUE:改行コードを表示する */
  BOOL fEOF;                        /* ja:TRUE:1Ahを末尾に書き加える */
  BOOL fLimit;                      /* ja:TRUE:右マージンで折り返す */
  BOOL fOverWrite;                  /* ja:TRUE:ファイルを上書き確認 */
  BOOL fRecycle;                    /* ja:TRUE:ごみ箱を利用する */
  BOOL fSpace;                      /* ja:TRUE:スペースを灰色の四角で表示 */
  BOOL fSysColor;                   /* ja:TRUE:システム色を使う */
  BOOL fTabConv;                    /* ja:TRUE:タブをスペースに変換する */
  BOOL fGline;                      /* ja:TRUE:グリッド線表示 */
  BOOL fMline;                      /* ja:TRUE:右マージンを表示 */
  BOOL fUline;                      /* ja:TRUE:タブ下線表示 */
  BOOL fVline;                      /* ja:TRUE:タブ縦線表示 */
  BOOL fNegotiate;                  /* ja:TRUE:自動改行判別 */
  COLORREF crColor[12];
  DWORD dwCharSet;                  /* ja:キャラクターセット */
  LOGFONT LogFont;
  LPTSTR lpszText, lpszExt;
  UINT uRetCode, uCharSet;          /* ja:改行,キャラクターセット */
} FILETYPE, *PFILETYPE, *LPFILETYPE;
typedef struct _DOING
{
  int nLength;                      /* ja:文字数 */
  BOOL fCaret;
  LPSTR lpszText;
  POINT ptCursor, ptSelect;
  struct _DOING *next;
} DOING, *PDOING, *LPDOING;
typedef struct _LINEBUF
{
  int nLength;                      /* ja:文字数 */
  BOOL fMargin;                     /* ja:TRUE:右マージン,FALSE:通常の改行 */
  LPSTR lpszText;
  struct _LINEBUF *prev, *next;
} LINEBUF, *PLINEBUF, *LPLINEBUF;
typedef struct _TEXTWND
{
  int nID;                          /* ja:ファイルタイプID(-1:無所属) */
  int nFontSize;                    /* ja:フォントの幅 */
  int nMargin;                      /* ja:右マージン */
  int nMax;                         /* ja:行数 */
  int nOff;                         /* ja:現在のy座標 */
  int nSame;                        /* ja:フルパスに付属する数値 */
  int nTab;                         /* ja:タブの文字数 */
  BOOL fAutoIndent;                 /* ja:TRUE:自動字下げ */
  BOOL fCreate;                     /* ja:TRUE:新規作成された,FALSE:既存 */
  BOOL fEdit;                       /* ja:TRUE:編集されている,FALSE:未編集 */
  BOOL fAssociate;                  /* ja:TRUE:関連づける */
  BOOL fCode;                       /* ja:TRUE:タブのコードを表示する */
  BOOL fCRLF;                       /* ja:TRUE:改行コードを表示する */
  BOOL fEOF;                        /* ja:TRUE:1Ahを末尾に書き加える */
  BOOL fLimit;                      /* ja:TRUE:右マージンで折り返す */
  BOOL fOverWrite;                  /* ja:TRUE:ファイルを上書き確認 */
  BOOL fRecycle;                    /* ja:TRUE:ごみ箱を利用する */
  BOOL fSpace;                      /* ja:TRUE:スペースを灰色の四角で表示 */
  BOOL fSysColor;                   /* ja:TRUE:システム色を使う */
  BOOL fTabConv;                    /* ja:TRUE:タブをスペースに変換する */
  BOOL fGline;                      /* ja:TRUE:グリッド線表示 */
  BOOL fMline;                      /* ja:TRUE:右マージンを表示 */
  BOOL fUline;                      /* ja:TRUE:タブ下線表示 */
  BOOL fVline;                      /* ja:TRUE:タブ縦線表示 */
  COLORREF crColor[12];             /* ja:表示色 */
  HBRUSH hBrushWindow;              /* ja:背景 */
  HBRUSH hBrushSpace;               /* ja:全角スペース */
  HBRUSH hBrushCrlf;                /* ja:改行 */
  HBRUSH hBrushHighLight;           /* ja:選択された背景 */
  HFONT hFont, hFontsm;             /* ja:フォント */
  HPEN hPenTab;                     /* ja:タブ下線 */
  HPEN hPenMargin;                  /* ja:右マージン */
  HPEN hPenGrid;                    /* ja:グリット */
  LOGFONT LogFont;                  /* ja:フォント情報 */
  LPDOING lpUndo, lpRedo;           /* ja:編集履歴 */
  LPLINEBUF lpStart;                /* ja:ラインバッファ */
  LPTSTR lpszFile;                  /* ja:ファイル名とフルパス */
  POINT ptCursor, ptTop, ptSelect;  /* ja:キャレット位置,選択状態 */
  SIZE siWnd;                       /* ja:ウインドウのサイズ */
  UINT uRetCode, uCharSet;          /* ja:改行,キャラクターセット */
} TEXTWND, *PTEXTWND, *LPTEXTWND;


/* ja:システム変数 */
extern int nFileCount;          /* ja:新規作成されたファイルの数 */
extern int nTypeCount;          /* ja:新規作成されたファイルタイプの数 */
extern BOOL fClipBoard;         /* ja:TRUE:クリップボードにあり,FALSE:なし */
extern BOOL fZoomed;            /* ja:TRUE:最大化,FALSE:通常 */
extern UINT uDlMsg;             /* ja:ドラッグリストのメッセージ */
extern UINT uIns;               /* ja:キャレットの状態(0:挿入,1:上書き) */


/* ja:ファイルタイプ */
extern int nFileType;           /* ja:登録されているファイルタイプ */
extern LPFILETYPE lpFileType;   /* ja:ファイルタイプ */


/* ja:全体に対する設定(環境ダイアログで変更可能) */
extern int nHistory;                /* ja:ファイルの履歴の最大数(0...9) */
extern int nRegStat;                /* ja:レジストリのread/write */
extern DWORD dwFilter;              /* ja:フィルタ */
extern LPTSTR lpszOpenPath;         /* ja:最後に読み込んだファイルのパス */
extern LPTSTR lpszSavePath;         /* ja:最後に書き込んだファイルのパス */
extern LPTSTR lpszHelpFile;         /* ja:ヘルプのファイル名 */


/* ja:色 */
extern COLORREF crWindowText;   /* ja:ウインドウの文字(標準:黒) */
extern COLORREF crGrayText;     /* ja:灰色の文字(標準:灰色) */
extern COLORREF crHighLightText;/* ja:選択された文字(標準:白) */
extern HBRUSH hBrushWindow;     /* ja:背景 */
extern HBRUSH hBrushGray;       /* ja:全角スペース,改行 */
extern HBRUSH hBrushHighLight;  /* ja:選択された背景 */
extern HPEN hPenGray;           /* ja:タブ下線,右マージン */
extern HPEN hPenGrid;           /* ja:グリット */
extern HPEN hPenNull;           /* ja:空のペン */


extern HACCEL hAccel;           /* ja:アクセラレータキー */
extern HMENU hMenuPopup;
extern HWND hWndMain;           /* ja:メインウインドウ */
extern HWND hWndClient;         /* ja:MDIクライアントウインドウ */
extern HWND hWndTool;           /* ja:メインウインドウのツールバー */
extern HWND hWndStat;           /* ja:メインウインドウのステータスバー */


extern const CHAR cCRLF[2];
extern LPSTR ppszCode[256];


/*
ja:表示色
 0,文字
 1,背景
 2,コントロールコード
 3,全角スペース
 4,改行コード
 5,タブ下線
 6,右マージン
 7,グリッド
 8,選択された文字
 9,選択された背景
10,文字(印刷)
11,コントロールコード(印刷)

表示状態
 0,グリッド
 1,全角スペース
 2,改行コード
 3,右マージン
 4,タブコード
 5,タブ下線
 6,関連付け
 7,1Aコード
 8,ごみ箱
 9,システム色
10,折り返す
11,未使用(単独のCR/LF)
12,上書き
13,縦線
14,0:自動判別,1:CRLF,2:CR,3:LF
15
16,0:自動判別,1:UNICODE(リトルエンディアン),2:UNICODE(ビックエンディアン)
17,3:UTF-7,4:UFT-8,5:ISO-2022-JP,6:EUC-JP,7:SHIFT_JIS
18

検索/置換
0,大文字小文字
1,全角半角
2,0ならば下へ検索
*/


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __TMAID_H__ */
