/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WCONTROL_H__
#define __WCONTROL_H__


#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
int WINAPI
ComboBox_AddStringW (HWND    hWnd,
                     LPCWSTR lpszString);


int WINAPI
ComboBox_AddStringA (HWND   hWnd,
                     LPCSTR lpszString);


int WINAPI
ComboBoxItem_AddStringW (HWND    hDlg,
                         int     nID,
                         LPCWSTR lpszString);


int WINAPI
ComboBoxItem_AddStringA (HWND   hDlg,
                         int    nID,
                         LPCSTR lpszString);


int WINAPI
ComboBoxItem_GetCurSel (HWND hDlg,
                        int  nID);


#define ComboBox_GetTextLengthW GetWindowTextLengthW
#define ComboBox_GetTextLengthA GetWindowTextLengthA
#define ComboBoxItem_GetTextLengthW GetDlgItemTextLengthW
#define ComboBoxItem_GetTextLengthA GetDlgItemTextLengthA
#define ComboBox_GetTextNewW GetWindowTextNewW
#define ComboBox_GetTextNewA GetWindowTextNewA
#define ComboBoxItem_GetTextNewW GetDlgItemTextNewW
#define ComboBoxItem_GetTextNewA GetDlgItemTextNewA


int WINAPI
ComboBoxItem_SetCurSel (HWND hDlg,
                        int  nID,
                        int  index);


#ifdef UNICODE
# define ComboBoxItem_AddString ComboBoxItem_AddStringW
# define ComboBoxItem_GetTextLength GetWindowTextLengthW
# define ComboBox_GetTextNew GetWindowTextNewW
# define ComboBoxItem_GetTextNew GetDlgItemTextNewW
#else /* not UNICODE */
# define ComboBoxItem_AddString ComboBoxItem_AddStringA
# define ComboBoxItem_GetTextLength GetWindowTextLengthA
# define ComboBox_GetTextNew GetWindowTextNewA
# define ComboBoxItem_GetTextNew GetDlgItemTextNewA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
int WINAPI
Edit_GetFirstVisibleLineW (HWND hWnd);


int WINAPI
Edit_GetFirstVisibleLineA (HWND hWnd);


int WINAPI
EditItem_GetFirstVisibleLineW (HWND hDlg,
                               int  nID);


int WINAPI
EditItem_GetFirstVisibleLineA (HWND hDlg,
                               int  nID);


void WINAPI
EditItem_GetRect (HWND   hDlg,
                  int    nID,
                  LPRECT lpRect);


int WINAPI
Edit_LineIndexW (HWND hWnd,
                 int  nLine);


int WINAPI
Edit_LineIndexA (HWND hWnd,
                 int  nLine);


int WINAPI
EditItem_LineIndexW (HWND hDlg,
                     int  nID,
                     int  nLine);


int WINAPI
EditItem_LineIndexA (HWND hDlg,
                     int  nID,
                     int  nLine);


void WINAPI
Edit_PosFromCharW (HWND    hWnd,
                   int     nIndex,
                   LPPOINT lpPoint);


void WINAPI
Edit_PosFromCharA (HWND    hWnd,
                   int     nIndex,
                   LPPOINT lpPoint);


void WINAPI
EditItem_PosFromCharW (HWND    hDlg,
                       int     nID,
                       int     nIndex,
                       LPPOINT lpPoint);


void WINAPI
EditItem_PosFromCharA (HWND    hDlg,
                       int     nID,
                       int     nIndex,
                       LPPOINT lpPoint);


#ifdef UNICODE
# define EditItem_GetFirstVisibleLine EditItem_GetFirstVisibleLineW
# define EditItem_LineIndex EditItem_LineIndexW
# define Edit_PosFromChar Edit_PosFromCharW
# define EditItem_PosFromChar EditItem_PosFromCharW
#else /* not UNICODE */
# define EditItem_GetFirstVisibleLine EditItem_GetFirstVisibleLineA
# define EditItem_LineIndex EditItem_LineIndexA
# define Edit_PosFromChar Edit_PosFromCharA
# define EditItem_PosFromChar EditItem_PosFromCharA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
int WINAPI
ListBox_AddStringW (HWND    hWnd,
                    LPCWSTR lpszString);


int WINAPI
ListBox_AddStringA (HWND   hWnd,
                    LPCSTR lpszString);


int WINAPI
ListBoxItem_AddStringW (HWND    hDlg,
                        int     nID,
                        LPCWSTR lpszString);


int WINAPI
ListBoxItem_AddStringA (HWND   hDlg,
                        int    nID,
                        LPCSTR lpszString);


int WINAPI
ListBoxItem_DeleteString (HWND hDlg,
                          int  nID,
                          int  index);


int WINAPI
ListBoxItem_GetCount (HWND hDlg,
                      int  nID);


int WINAPI
ListBoxItem_GetCurSel (HWND hDlg,
                       int  nID);


LRESULT WINAPI
ListBoxItem_GetItemData (HWND hDlg,
                         int  nID,
                         int  index);


int WINAPI
ListBoxItem_GetSelCount (HWND hDlg,
                         int  nID);


int WINAPI
ListBoxItem_GetSelItems (HWND  hDlg,
                         int   nID,
                         int   cItems,
                         int  *lpItems);


int WINAPI
ListBox_GetTextLenW (HWND hWnd,
                     int  index);


int WINAPI
ListBox_GetTextLenA (HWND hWnd,
                     int  index);


int WINAPI
ListBoxItem_GetTextLenW (HWND  hDlg,
                         int   nID,
                         int  index);


int WINAPI
ListBoxItem_GetTextLenA (HWND  hDlg,
                         int   nID,
                         int  index);


LPWSTR WINAPI
ListBox_GetTextNewW (HWND hWnd,
                     int  index);


LPSTR WINAPI
ListBox_GetTextNewA (HWND hWnd,
                     int  index);


LPWSTR WINAPI
ListBoxItem_GetTextNewW (HWND hDlg,
                         int  nID,
                         int  index);


LPSTR WINAPI
ListBoxItem_GetTextNewA (HWND hDlg,
                         int  nID,
                         int  index);


int WINAPI
ListBox_InsertStringW (HWND    hWnd,
                       int     index,
                       LPCWSTR lpszString);


int WINAPI
ListBox_InsertStringA (HWND   hWnd,
                       int    index,
                       LPCSTR lpszString);


int WINAPI
ListBoxItem_InsertStringW (HWND    hDlg,
                           int     nID,
                           int     index,
                           LPCWSTR lpszString);


int WINAPI
ListBoxItem_InsertStringA (HWND   hDlg,
                           int    nID,
                           int    index,
                           LPCSTR lpszString);


void WINAPI
ListBox_ResetContext (HWND hWnd);


void WINAPI
ListBoxItem_ResetContext (HWND hDlg,
                          int  nID);


int WINAPI
ListBoxItem_SetCurSel (HWND hDlg,
                       int  nID,
                       int  index);


int WINAPI
ListBoxItem_SetItemData (HWND   hDlg,
                         int    nID,
                         int    index,
                         LPARAM data);


int WINAPI
ListBoxItem_SetSel (HWND hDlg,
                    int  nID,
                    BOOL fSelect,
                    int  index);


#ifdef UNICODE
# define ListBoxItem_AddString ListBoxItem_AddStringW
# define ListBoxItem_GetTextLen ListBoxItem_GetTextLenW
# define ListBox_GetTextNew ListBox_GetTextNewW
# define ListBoxItem_GetTextNew ListBoxItem_GetTextNewW
# define ListBoxItem_InsertString ListBoxItem_InsertStringW
#else /* not UNICODE */
# define ListBoxItem_AddString ListBoxItem_AddStringA
# define ListBoxItem_GetTextLen ListBoxItem_GetTextLenA
# define ListBox_GetTextNew ListBox_GetTextNewA
# define ListBoxItem_GetTextNew ListBoxItem_GetTextNewA
# define ListBoxItem_InsertString ListBoxItem_InsertStringA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
BOOL WINAPI
StatusBar_SetTextW (HWND    hWnd,
                    USHORT  uPart,
                    USHORT  uType,
                    LPCWSTR lpszString);


BOOL WINAPI
StatusBar_SetTextA (HWND   hWnd,
                    USHORT uPart,
                    USHORT uType,
                    LPCSTR lpszString);


BOOL WINAPI
StatusBarItem_SetTextW (HWND    hDlg,
                        int     nID,
                        USHORT  uPart,
                        USHORT  uType,
                        LPCWSTR lpszString);


BOOL WINAPI
StatusBarItem_SetTextA (HWND   hDlg,
                        int    nID,
                        USHORT uPart,
                        USHORT uType,
                        LPCSTR lpszString);


void WINAPI
StatusBar_Simple (HWND hWnd,
                  BOOL fSimple);


void WINAPI
StatusBarItem_Simple (HWND hDlg,
                      int  nID,
                      BOOL fSimple);


#ifdef UNICODE
# define StatusBar_SetText StatusBar_SetTextW
# define StatusBarItem_SetText StatusBarItem_SetTextW
#else /* not UNICODE */
# define StatusBar_SetText StatusBar_SetTextA
# define StatusBarItem_SetText StatusBarItem_SetTextA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
void WINAPI
ToolBar_AutoSize (HWND hWnd);


void WINAPI
ToolBarItem_AutoSize (HWND hDlg,
                      int  nID);


BOOL WINAPI
ToolBar_EnableButton (HWND hWnd,
                      UINT uItem,
                      BOOL fEnable);


BOOL WINAPI
ToolBarItem_EnableButton (HWND   hDlg,
                          int    nID,
                          UINT uItem,
                          BOOL fEnable);


/******************************************************************************
*                                                                             *
******************************************************************************/
int WINAPI
UpDown_SetPos (HWND  hWnd,
               short sPos);


int WINAPI
UpDownItem_SetPos (HWND  hDlg,
                   int   nID,
                   short sPos);


void WINAPI
UpDown_SetRange (HWND  hWnd,
                 short sMin,
                 short sMax);


void WINAPI
UpDownItem_SetRange (HWND   hDlg,
                     int    nID,
                     short sMin,
                     short sMax);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WCONTRO_H__ */
