/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "wcommon.h"


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:マルチバイト文字列をワイド文字列に変換する
    lpszMultiByte,マルチバイト文字列
     cchMultiByte,文字数(負:NULL終端文字列)
              RET,ワイド文字列                                              */
LPWSTR WINAPI
StringMultiByteToWideCharEx (LPCSTR  lpszMultiByte,
                             SSIZE_T cchMultiByte)
{
  LPWSTR lpszWideChar = NULL;

  if (lpszMultiByte && cchMultiByte != 0)
    {
      int cchWideChar;

      if (cchMultiByte < 0)
        cchMultiByte = -1;
      cchWideChar = MultiByteToWideChar (CP_ACP, 0,
                                        lpszMultiByte, cchMultiByte, NULL, 0);
      if (cchWideChar > 0)
        {
          lpszWideChar = MemoryAlloc (cchWideChar * sizeof (WCHAR));
          if (MultiByteToWideChar (CP_ACP, 0, lpszMultiByte, cchMultiByte,
                                            lpszWideChar, cchWideChar) <= 0)
            {
              MemoryFree (lpszWideChar);
              lpszWideChar = NULL;
            }
          else if (lpszWideChar[cchWideChar - 1] != '\0')
            {
              lpszWideChar = MemoryReAlloc (lpszWideChar,
                                        (cchWideChar + 1) * sizeof (WCHAR));
            }
        }
    }
  return lpszWideChar;
}


/*  ja:ワイド文字列をマルチバイト文字列に変換する
    lpszWideChar,ワイド文字列
     cchWideChar,文字数(負:NULL終端文字列)
             RET,マルチバイト文字列                                         */
LPSTR WINAPI
StringWideCharToMultiByteEx (LPCWSTR lpszWideChar,
                             SSIZE_T cchWideChar)
{
  LPSTR lpszMultiByte = NULL;

  if (lpszWideChar && cchWideChar != 0)
    {
      int cchMultiByte;

      if (cchWideChar < 0)
        cchWideChar = -1;
      cchMultiByte = WideCharToMultiByte (CP_ACP, 0, lpszWideChar, cchWideChar,
                                                        NULL, 0, NULL, NULL);
      if (cchMultiByte > 0)
        {
          lpszMultiByte = MemoryAlloc (cchMultiByte * sizeof (CHAR));
          if (WideCharToMultiByte (CP_ACP, 0, lpszWideChar, cchWideChar,
                                lpszMultiByte, cchMultiByte, NULL, NULL) <= 0)
            {
              MemoryFree (lpszMultiByte);
              lpszMultiByte = NULL;
            }
          else if (lpszMultiByte[cchMultiByte - 1] != '\0')
            {
              lpszMultiByte = MemoryReAlloc (lpszMultiByte,
                                        (cchMultiByte + 1) * sizeof (CHAR));
            }
        }
    }
  return lpszMultiByte;
}


/*  ja:マルチバイト文字列をワイド文字列に変換する
    lpszMultiByte,マルチバイト文字列
              RET,ワイド文字列                                              */
LPWSTR WINAPI
StringMultiByteToWideChar (LPCSTR lpszMultiByte)
{
  return StringMultiByteToWideCharEx (lpszMultiByte, -1);
}


/*  ja:ワイド文字列をマルチバイト文字列に変換する
    lpszWideChar,ワイド文字列
             RET,マルチバイト文字列                                         */
LPSTR WINAPI
StringWideCharToMultiByte (LPCWSTR lpszWideChar)
{
  return StringWideCharToMultiByteEx (lpszWideChar, -1);
}


/*  ja:ワイド文字列を返す
    lpszWideChar,ワイド文字列
             RET,ワイド文字列                                               */
LPWSTR WINAPI
WideCharW (LPWSTR lpszWideChar)
{
  return lpszWideChar;
}


/*  ja:ワイド文字列を返す
    lpszMultiByte,マルチバイト文字列
              RET,ワイド文字列                                              */
LPWSTR WINAPI
WideCharA (LPSTR lpszMultiByte)
{
  LPWSTR lpszWideChar;

  lpszWideChar = StringMultiByteToWideChar (lpszMultiByte);
  MemoryFree (lpszMultiByte);
  return lpszWideChar;
}


/*  ja:ワイド文字列を返す
    lpszWideChar,ワイド文字列
             RET,マルチバイト文字列                                         */
LPSTR WINAPI
MultiByteW (LPWSTR lpszWideChar)
{
  LPSTR lpszMultiByte;

  lpszMultiByte = StringWideCharToMultiByte (lpszWideChar);
  MemoryFree (lpszWideChar);
  return lpszMultiByte;
}


/*  ja:ワイド文字列を返す
    lpszMultiByte,マルチバイト文字列
              RET,マルチバイト文字列                                        */
LPSTR WINAPI
MultiByteA (LPSTR lpszMultiByte)
{
  return lpszMultiByte;
}
