/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.ui.views.tasklist.TaskList;
import org.eclipse.ui.views.tasklist.TasksFilter;

public class CPTaskListHelper {
    public static final int SEVERITY_MASK_OFF = 0;
    public static final int SEVERITY_MASK_WARNING = 2;
    public static final int SEVERITY_MASK_ERROR = 4;
    public static final int PRIORITY_MASK_OFF = 0;
    public static final int PRIORITY_MASK_NORMAL = 2;
    public static final int PRIORITY_MASK_HIGH = 4;
    public static final String[] TYPES_ALL = TasksFilter.ROOT_TYPES;
    public static final String[] TYPES_PROBLEMS_ONLY = new String[]{"org.eclipse.core.resources.problemmarker"};
    public static final String[] TYPES_TASKS_ONLY = new String[]{"org.eclipse.core.resources.taskmarker"};
    public static final String[] TYPES_JAVA_ONLY = new String[]{"org.eclipse.jdt.core.problem"};
    public static final int RESOURCE_ANY = 0;
    public static final int RESOURCE_SELECTED_ONLY = 1;
    public static final int RESOURCE_SELECTED_AND_CHILDREN = 2;
    public static final int RESOURCE_OF_SAME_PROJECT = 3;

    private CPTaskListHelper() {
    }

    public static int getSeverityFilter(TaskList taskList) {
        TasksFilter filter = taskList.getFilter();
        if (filter.filterOnSeverity) {
            return filter.severityFilter;
        }
        return 0;
    }

    public static void setSeverityFilter(TaskList taskList, int mask) {
        TasksFilter filter = taskList.getFilter();
        if (mask == 0) {
            filter.filterOnSeverity = false;
        } else {
            filter.filterOnSeverity = true;
            filter.severityFilter = mask;
        }
    }

    public static int getPriorityFilter(TaskList taskList) {
        TasksFilter filter = taskList.getFilter();
        if (filter.filterOnPriority) {
            return filter.priorityFilter;
        }
        return 0;
    }

    public static void setPriorityFilter(TaskList taskList, int mask) {
        TasksFilter filter = taskList.getFilter();
        if (mask == 0) {
            filter.filterOnPriority = false;
        } else {
            filter.filterOnPriority = true;
            filter.priorityFilter = mask;
        }
    }

    public static String[] getTypesFilter(TaskList taskList) {
        TasksFilter filter = taskList.getFilter();
        return filter.types;
    }

    public static void setTypesFilter(TaskList taskList, String[] types) {
        TasksFilter filter = taskList.getFilter();
        filter.types = types;
    }

    public static int getResourceFilter(TaskList taskList) {
        TasksFilter filter = taskList.getFilter();
        return filter.onResource;
    }

    public static void setResourceFilter(TaskList taskList, int resourceFilter) {
        TasksFilter filter = taskList.getFilter();
        filter.onResource = resourceFilter;
    }

    public static void filterChanged(TaskList taskList) {
        taskList.filterChanged();
    }
}

