/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.util.List;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.WizardFileSystemResourceExportPage1;
import org.eclipse.ui.wizards.datatransfer.CPFileSystemOp;
import org.eclipse.ui.wizards.datatransfer.CPOpUtils;

public class CPFileSystemOpTypePage
extends WizardFileSystemResourceExportPage1 {
    public static final String PAGE_NAME = "CPFileSystemOpTypePage";
    private static final String STORE_DESTINATION_NAMES_ID = "WizardFileSystemResourceExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILES_ID = "WizardFileSystemResourceExportPage1.STORE_OVERWRITE_EXISTING_FILES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardFileSystemResourceExportPage1.STORE_CREATE_STRUCTURE_ID";
    private final CPFileSystemOp _model;

    public CPFileSystemOpTypePage(CPFileSystemOp model) {
        super((IStructuredSelection)new StructuredSelection(model.getResourcesToExport()));
        this._model = model;
    }

    public CPFileSystemOpTypePage(IStructuredSelection selection) {
        super(selection);
        this._model = null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (this._model == null) {
            return settings;
        }
        if (settings == null) {
            settings = new DialogSettings(PAGE_NAME);
        }
        String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
        directoryNames = CPOpUtils.createArrayWithFirst(directoryNames, this._model.getDestinationPath(), 5);
        settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
        settings.put(STORE_OVERWRITE_EXISTING_FILES_ID, this._model.getOverwriteFiles());
        settings.put(STORE_CREATE_STRUCTURE_ID, this._model.getCreateLeadupStructure());
        return settings;
    }

    protected String getConflictingContainerNameFor(String targetDirectory) {
        return null;
    }

    public boolean finish() {
        if (!super.finish()) {
            return false;
        }
        CPFileSystemOp model = new CPFileSystemOp(this.getWhiteCheckedResources(), this.getDestinationValue(), (IOverwriteQuery)this);
        if (this._model != null) {
            model.setUnknownResources(this._model.getUnknownResources());
        }
        return this.executeExportOperation(model);
    }

    protected boolean ensureTargetIsValid(File targetDirectory) {
        return true;
    }

    protected boolean ensureDirectoryExists(File directory) {
        return true;
    }

    protected boolean ensureResourcesLocal(List resources) {
        return true;
    }
}

