/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.component.SubsetSettingPanel;
import jp.sourceforge.tmdmaker.dialog.model.EditSubsetEntity;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SubsetCreateDialog
extends Dialog {
    private SubsetSettingPanel panel;
    private SubsetType.SubsetTypeValue subsetType;
    private boolean exceptNull;
    private List<IAttribute> attributes;
    private List<EditSubsetEntity> subsetEntities = new ArrayList<EditSubsetEntity>();
    private IAttribute selectedAttribute;
    private SubsetType.SubsetTypeValue editedSubsetType;
    private IAttribute editedPartitionAttribute;
    private List<EditSubsetEntity> editedSubsetEntities;
    private List<EditSubsetEntity> deletedSubsetEntities;
    private boolean editedExceptNull;

    public SubsetCreateDialog(Shell parentShell, SubsetType.SubsetTypeValue subsetType, boolean exceptNull, List<IAttribute> list, List<SubsetEntity> subsetEntities, IAttribute selectedAttribute) {
        super(parentShell);
        this.subsetType = subsetType;
        this.exceptNull = exceptNull;
        this.attributes = list;
        this.selectedAttribute = selectedAttribute;
        for (SubsetEntity se : subsetEntities) {
            this.subsetEntities.add(new EditSubsetEntity(se));
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("\u30b5\u30d6\u30bb\u30c3\u30c8\u7de8\u96c6");
        Composite composite = new Composite(parent, 0);
        this.panel = new SubsetSettingPanel(composite, 0);
        this.panel.initializeValue(this.subsetType.equals((Object)SubsetType.SubsetTypeValue.SAME), this.exceptNull, this.attributes, this.subsetEntities, this.selectedAttribute);
        return composite;
    }

    protected void okPressed() {
        this.editedSubsetType = this.createEditedSubsetType();
        int partitionSelectionIndex = this.panel.getSelectedPartitionAttributeIndex();
        if (partitionSelectionIndex != -1) {
            this.editedPartitionAttribute = this.attributes.get(partitionSelectionIndex);
        }
        this.editedSubsetEntities = this.panel.getSubsetEntityList();
        this.deletedSubsetEntities = this.panel.getDeletedSubsetEntityList();
        this.editedExceptNull = this.panel.isExceptNull();
        super.okPressed();
    }

    private SubsetType.SubsetTypeValue createEditedSubsetType() {
        if (this.panel.isSameTypeSelected()) {
            return SubsetType.SubsetTypeValue.SAME;
        }
        return SubsetType.SubsetTypeValue.DIFFERENT;
    }

    public SubsetType.SubsetTypeValue getEditedSubsetType() {
        return this.editedSubsetType;
    }

    public IAttribute getEditedPartitionAttribute() {
        return this.editedPartitionAttribute;
    }

    public List<EditSubsetEntity> getEditedSubsetEntities() {
        return this.editedSubsetEntities;
    }

    public List<EditSubsetEntity> getDeletedSubsetEntities() {
        return this.deletedSubsetEntities;
    }

    public boolean isEditedExceptNull() {
        return this.editedExceptNull;
    }
}

